.nr % 29
.nr CN 8
.bp 30
.sh 3 "F18:  Block Averages and Statistics " 8 6 18
.pp
Subroutine f18 averages data blocks into single data channels and
computes the statistics (standard deviation of the mean) for each
block.  The size of the block is defined by the user.
.pp
The user is first asked to enter "n" followed by the blocksize.
On the same line, the user can also enter "a" and the new file
number to change the default wavelength file assignment.  No
further user input is required (example n5a3 or a3n5 do the same
thing).  The block size must be less than or equal to the number
of channels.
.pp
The average of a block j is computed from the equation
.EQ
x bar sub j ~=~ {sum from {i=n sub i} to {n sub 2} x sub i
} over { ( n sub 2 - n sub 1 + 1)  }
.EN
.pp
where @(n sub 1 - n sub 2 +1)@ = N if @n sub 2@ is
less than or equal to the number of
channels.
.pp
If errors have been included, the standard deviation is
calculated by the following
.EQ
sigma bar sub j ~=~ { left [ sum from { i=n sub 1} to {n sub 2}
sigma sub i sup 2 right ] sup {1/2} } over { (n sub 2 - n sub 1 + 1) }
.EN
.pp
where @sigma sub j@ is the new standard deviation.  If the errors have not
been read in, the following equation is used:
.EQ
sigma bar sub j ~=~{  left ( sum from {i=n sub 1} to {n sub 2} { (x
sub i - x bar sub j ) sup 2 } over {n sub 2 - n sub 1 + 1} right )
sup {1/2} } over { ( n sub 2 - n sub 1 + 1) sup {1/2} }
.EN
.bp
.sh 3 "F19:  Polynomial Fit (10 Term) "
.pp
Special Function 19 does a least squares fit to the
data with a polynomial of the form:
.EQ
y = a sub 1 + a sub 2 x + a sub 3 x sup 2 + a sub 4 x sup 3 + ...
+ a sub n x sup n-1
.EN
The program requests the number of term to use for the polynomial
fit and will currently handle up to ten terms. To run this
routine type
the file id and record number of the spectrum you wish to fit
followed by f19. The program will allow you to change the
wavelength set if the current set is not the proper one. The
program then
calculates the least squares curve and prints
the polynomial coefficients and the reduced chi square for the
fit.
.bp
.sh 3 "F20:  Text File Input "
.pp
Special Function 20 has two parts to it.  First part reads data
from a text file that was generated by any program or by using the
system editor.The second part writes data from a specpr file into
a text file. With both parts there are options to include errors
or wavelengths or both.

.pp
Data,errors, and wavelengths may be written either in standard
Fortran format 'f' or 'e' , depending on the user's option.

By a text file it is meant that it is ascii text apart from a specpr type
file.  This file contains or can contain a list of real numbers.
In both reading and writing , the format can either be 'f' or
'e'. These numbers can be generated by a program or by using the
system editor. One set of numbers per line i.e. wavelength, data
and errors. Without wavelength option, the order is data ,
errors. And without error option the order is wavelength, data

When writing the data to a specpr record (i.e v123), the
program will put the error values in the next consecutive specpr file
(i.e v124).

.sh 4 "Using Function 20"
.pp
To run function 20, type  f20  from math operations.  The routine
will prompt you for what part (reading or writing) you want to
do.  Type  r  for reading or  w  for writing followed by  e  if
errors are associated with the data.  Then if you are writing
you are given an option for format. Type 'f' for f format or 'e'
for e format. Next if you are writing, you are asked if
wavelengths are to be included. Type 'y' for yes and 'return' or
any other character for no. Then you are instructed to enter the
filename of the text to which you will read or write data.
Be sure that when you are reading, the file is in
your directory, or you must give the full file name (i.e
/we/smith/dataf ).  When reading the program will promt you for
the starting column that the data begins (e.g. col. 1 - 80).
Default is column one(1).
If you are writing data to a text file you
will be asked the file id and record number of the specpr file that
the data is from (v, w, d, u, or y).  When the operation is
finished you have the option to redo the operation or exit.
Type  r to redo the operation  at this point or e or x to exit.
.sh 4 "Setting Up the Text File"
.pp
There are two
ways of setting up a UNIX text file that can be read by f20.
.pp
First, and the easiest is directed output.  Output the data to
the terminal and direct it to a file.  In your program write to
the terminal.

        write(6,10)data
 10     format(1x,1pe15.6)

or with errors

        write(6,10)data,error
 10     format(1x,1pe15.6,1pe15.6)

run program using this method

        progname > filename

where progname is the program executable file and filename is the
file to be read by f20.
.pp
Second, you can write your data directly into a file.  You must
open the file and write to it.  You can open and assign a file
using this statement.

        call setfil (lun,'filename')

where lun is an integer variable for logical unit and filename is
the file to be read by f20.  Write your data using these
statements.

        write(lun,10)data
 10     format(1x,1pe15.6)

or with errors

        write(lun,10)data,error
 10     format(1x,1pe15.6,1pe15.6)

the data and/or errors will be written to the file called
filename assigned to the logical unit lun.  Then you can go to
f20 and when it prompts you for the filename enter the filename
you gave in your program.
.pp
When reading, enter f20 from math operations and when it prompts
you for your input/output filename, type in the filename of that
you assigned to the text file using 'call setfil' or directed
input.  The program will print out the channel number and the
data value of that channel.  The last channel number printed is
the number of channels in the file (or the number of data values
read by f20).
.sh 4 "Example"
.pp
.ip 1)
Operate on data using you own programs:
.ip 2)
Put these values in v1234
        channel 1: 0.99
                2: 0.90
                3: 0.70
                4: 0.40

.ip 3)
Write v1234 to file 'testa' using f20
.ip 4)
Run program 'reftorem <testa >testb'
.ip 5)
Read testb into specpr using f20
.ip 6)
List the 4 channels

See table \*($n.1 for a list of programs which can be used with
F20

.(b
.ce
Table \*($n.1
.TS
center,tab(!),box;
c c c
l l l.
Progs:!Author:!Description:
reftorem!Clark!T{
.na
converts reflectance to
Kubelka-Munk remission data
source: /we/clark/src/refthry/reftorem.f
T}
remtoref!Clark!T{
.na
converts Kubelka-Munk remission
data to reflectance
source: /we/clark/src/refthry/remtoref.f
T}
.TE
.)b
.bp
.sh 3 "F21: Calculate Nth Term Polynomials"
.pp
This routine calculates nth term polynomials where the maximum
number of terms or coefficients is 256.  This routine operates on
the inputed file entered from math operations.  Then it prompts
you for a file of coefficients.  The file of coefficients contain
the values of the coefficients for the polynomial.

.EQ
Y(n) = C(1) + C(2)X(n) + C(3)X(n) sup 2 + C(4)X(n) sup 3 + ...
.EN

Where Y is the output array, X is the input array, C is the
coefficient array.
.pp
To execute the f21 function, in math operations type the file id
and record number of the input file and f21.  After the routine
title is printed type in the file id and record number of the
file containing the coefficient values, then a space, then the
number of terms of the polynomial.  The program will then do the
calculations and return to the math routine prompting you for the
location to put the output file and the title etc.
.pp
You will probably want to edit a file using f14 to enter the
coefficient values in a file.
.bp
.sh 3 "F22: Tablet Graph (TABGRAF)"
.pp
This program asks the user to define a graph by digitizing the
limits.  Then it accepts points from the tablet that are within
the limits of the graph and converts the x and y values into
data values as defined by the value of the limits of the graph.
If a digitized point is outside the bounds of the graph, the
program will say so and ask if you want to redo the point, begin
over, write the data or exit.  If you want to write the data, the
program will prompt you for the file id (v, w, d, u, or y). After
which the program will write in the x data values in the record
equal to the protection plus one (1), and the y values in the
following record after that.  The protection is also updated.
.pp
To execute f22, type f22 from math operations.  The program will
return with the title page of f22.  Press return to continue.
Digitize the upper left bound of the graph, lower left bound
(origin), and the lower right bound of the graph.  The program
will return with the values of the points in tablet coordinates,
the amount that the points are off perpendicular, and the angle
between the two axis. If these values are acceptable type "yes".
The program will rotate the axis should it be not exactly
perpendicular.  Then you must enter the values of the digitized
points starting with the upper left, origin, lower right points.
Then you must enter the limits of the horizontal
axis and the limits of the vertical axis of your graph.
.pp
When the above is finished the program will return with "ENTER
POINTS FROM TABLET". After which you can digitize points from
your graph.
.pp
If you somehow enter a point that is outside the limits of your
graph, the program will return with "POINT OUT OF BOUNDS".
You have various options at this point.  Type  r   to reenter the
point.  This will not affect the data count.  Type b to begin
entering the points again.  This allows you to start over without
having to reenter the limits etc.  Type w when finished entering
points. This will put you in the writing mode to write your data
to a file.  Type x will exit you from the program.
.pp
If you are finished entering points from the tablet, and wish to
write the data, digitize a point outside the graph.  The program
will return with "POINT OUT OF BOUNDS".  Type an w to write the
data.
.pp
To write the data, the program will prompt you to enter the file
id of the file you want the data to be written. (v, w, d, u, or
y) Then you are prompted to type in the title of the record that
will contain the x (horizontal) values, then after that the title
of the record that contains the y (vertical) values. The data is
then written in the record equal to the protection+1, if the file
has the right protection.  If not it will let you know.
.pp
After all that you will be asked if you want to do another graph.
Answer yes or no, if no then the program exits.
