.nr % 0
.nr CN 12
.bp
.sh 1 "EXTINCTION ROUTINES " 12
.sh 2 "Introduction "
.pp
The Extinction analysis is a least squares fit of a straight line
to the base 10 logarithm of the data versus airmass for each
channel.  The intercept and slope of the line, along with a goodness
of fit (correlation coefficient), are stored for later extinction
corrections with objects observed and is called a "starpack".
The Extinction routines are
accessed from Program Operations by typing
.ul
s.
The screen will then list available commands on the CRT.
.sh 2 "Starpack List and Display "
.pp
Type
.ul
d
to list the starpack by title.  You will then be instructed to
input a record number (1 to 50) or type the number 0 to list all
starpacks in the starpack file.  Typing a number (1 to 50) will
read that starpack into memory so that it can be displayed (see
section 12.4).  If zero was typed, the last starpack listed is in
memory (assuming there is no I/O error).  Note:  If you have just
created a new starpack, do not list the starpack file as this
writes over the starpack in memory.  Note that, when reading a
starpack from disk, you cannot do airmass versus log intensity
plots since this information is not stored in the starpack.  It
is only stored in memory after an extinction calculation.  In
order to do these plots or deletion and restoration of runs and
channels (section 12.5), you must recreate the starpack from
scratch using the data indicated in the history.
.sh 2 "Extinction Calculation "
.pp
Type
.ul
c
to perform extinction calculations.  The computer then asks the
user for up to 20 spectra for extinction calculations.  The data
are input by typing in the file ID (v, w, u, y, or d) and the record
numbers.
The program is designed so that the user can type
on one line as in the example:

        w12 13 14 15 16v1 2 3 d4 5 6c.

Typing the file ID and then a string of numbers after the ID
causes the program to store the string of numbers along with that
file ID.  When all files have been typed in, the user types
.ul
c
to indicate the finish.  More than one line (at 80 characters per
line) may be used.  Note:  At the beginning of a new line, a file
ID must be typed; otherwise, erroneous record numbers will be
stored. After typing in the files, the user is asked to type in a 24
character title for the starpack.  After storing the title, the
computer will read in the records and list the titles on the CRT,
then calculate the extinction values (it takes a couple of
minutes), and display the slopes in a CRT plot.  At this point in
extinction calculations, all the data is stored in memory and extinction
coefficients have been calculated, but the starpack has not been
written to the starpack file.  The user should look over the
calculations using the CRT plot and then write the starpack on
disc (see below).
.pp
Possible deviations from normal operation:
.pp
If the revolutions in each data set are not the same, the sets whose
revolutions differ from the first set read in are flagged.  If
a file ID has not been included, a reading error is
encountered, the list of options is displayed, and the user must
begin again.


.sh 2 "Extinction CRT Plot "
.pp
Since the extinction coefficients are in 3 arrays (slopes,
intercepts, and goodness of fit), they are displayed one at a time
on the CRT.  When the plot routine is entered [automatically from
extinction calculation or by typing p (for plot) from extinction
commands], the slopes are displayed.  The scale can be changed by
typing
.ul
c,
the intercepts can be plotted by typing
.ul
i,
and the goodness of fit plotted by typing
.ul
g.
The slopes can then be plotted again by typing
.ul
s.
A lineprinter plot can be made of either slopes, intercepts, or
goodness of fit by typing
.ul
p
(note the lineprinter spooler must be assigned).  To exit the plot
routines, type
.ul
e
or
.ul
x.
Both these exits are the same since there are no pending commands.
.sh 2 "Airmass Versus Log Intensity Plots and Deletion "
.ti 6n
.b "and Restoration of Runs and Channels"
.pp
To investigate the scatter in the data and the fitted line, the
airmass versus log intensity must be plotted.  To improve the fit,
entire runs or single channels must be deleted (and restored).
Typing
.ul
t
will call this routine.  The program will then ask for a channel
number (with which an airmass versus log intensity plot is to be
made) or type
.ul
d
to delete runs and channels or
.ul
r
to restore runs and channels.
.pp
Up to 10 channels in each run can be deleted, or the entire run
can be deleted.  Since up to 20 data sets can be used to calculate
extinction, this routine refers to the sets as run numbers 1 to
20 in the order that they were typed in by the user.  To delete a
run, type the run number and 0.  The system then asks for n channel
numbers to be read in.  The whole procedure can be repeated until
the user has finished deletions.  A least squares fit is done in
this routine, and the routines list of options is displayed upon
completion.  The least squares fit takes a couple of minutes.
.pp
Selecting restoration causes the display of an array of numbers
that is 12 wide and 20 high.  The left-hand column is the run
number, the column next to this gives the number of channels
deleted or, if this number is -1, that run has been deleted.  To
restore a run, type in the run number and zero; to restore a
channel, type in the run number and the channel number.  This
process can be repeated, if necessary, and the array can be plotted
out again showing any changes.  When restoration is complete, a
least squares fit is applied, and the routines list of options is
displayed.  The least squares fit takes a couple of minutes.  To
exit this routine, type e.
.pp
Note that no history is kept of runs and channels that are
deleted or restored.  There is a 592 character manual history
(section 12.6) for any notes or listing runs and channels which
have been deleted.


.sh 2 "Writing a Starpack "
.pp
After extinction calculations are finished, the starpack is
stored in memory but is not written to disc (to the starpack
file).  This is not done automatically because the user must look
over the data and decide whether he wants to delete runs or
channels or whether or not the starpack is any good at all.  Thus,
the user must remember that he has just performed an extinction
analysis and that the starpack must be written to the starpack
file.  (If you have been able to keep the slightest attention
while reading this manual, you will be able to remember when you
have finished an extinction analysis).  To write a starpack to
the starpack file, type
.ul
s.
You will then be asked for the record number (1 to 50).


.sh 2 "Starpack Manual History "
.pp
There is 592 character (8 lines at 74 characters per line) manual
history for special notes or listing runs and channels which have
been deleted.  Type
.ul
m
from the extinction routines section.  You will then be asked to
type in the line number or zero for all lines or
.ul
e
to exit the routine.
