#!/bin/sh
#SBATCH -J ahw20o
#SBATCH -c 4
#SBATCH -a 1-324
#SBATCH -t 6000
#SBATCH --mem 16000M
msg () {
  printf "c array.sh: %-20s %s\n" "$1" "$2"
}
id="$SLURM_ARRAY_JOB_ID"
task="$SLURM_ARRAY_TASK_ID"
msg id "$id"
msg task "$task"
path=$HOME/`awk '$1 == '$task'{print $2}' benchmarks`
name=`awk '$1 == '$task'{print $3}' benchmarks`
msg path "$path"
msg name "$name"
log=$name.log
err=$name.err
rm -f $log $err
exec 1>$log 2>$err
msg host "`hostname`"
msg id "$id"
msg task "$task"
msg path "$path"
msg name "$name"
copy="$TMP/local-copy-${id}-${task}-${name}.aig"
trap "rm -f $copy" 2 3 9 15
msg copying "`date`"
cp -p $path $copy
msg copied "`date`"
runlim \
  --real-time-limit=5000 \
  --space-limit=15000 \
  ./run.sh \
  "$copy"
msg finished "`date`"
rm -f $copy
msg cleaned "`date`"
