function removeErrorBarEnds(hErrBar)
%removeErrorBarEnds
% removeErrorBarEnds(hErrBar) removes the lines
% above/below errorbars
% generated by the matlab function hErrBar = errorbar()
%
% Example:
% x = 1:10;
% y = sin(x);
% e = std(y)*ones(size(x));
% h = errorbar(x,y,e)
% oldAx = axis;
% removeErrorBarEnds(h)
% axis(oldAx)

% david szotten

%use length of xdata to find the right handle
%there may be an easier way to do this
dataLen = length( get(hErrBar, 'xdata') );

%objects to try, one of this is the errorbars
candidateList = findall(hErrBar);

for candidate = candidateList(:)'
    candLen = length( get(candidate, 'xdata') );
    
    %found it
    if candLen == 9 * dataLen
        xOrg = get(candidate, 'xdata');
        yOrg = get(candidate, 'ydata');
        
        %we only want the first 3 out or every 9
        valuesToExtract = find( kron( ones(1,dataLen), [ones(1,3) zeros(1,6)]) );
        xNew = xOrg(valuesToExtract);
        yNew = yOrg(valuesToExtract);
        
        set(candidate, 'xdata', xNew);
        set(candidate, 'ydata', yNew);
    end
end