#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Dec  1 10:58:23 2023

this script will model receiver functions and autocorrelations

@author: ben sadler
"""
import os
from functions_basinhoppingModeling import basinhopping_varyLayers

#change for your computer
d = os.getcwd() + '/bins/'
dOut = os.getcwd() + '/models/'

if os.path.isdir(dOut) == False:
    os.mkdir(dOut)

stations = ["US-NATX"]

nlayers = 3 #number of crustal layers to consider
t = [2, 4, 25] #starting thickness of each layer
tSpread = [1, 2, 7] #range for each thickness will be twice this value
vp = [4, 5, 6.5] #starting Vp values for each layer
vpSpread = [1, 1, .25] #range for each Vp will be twice this value
k = [1.9, 1.8, 1.8] #starting k value (Vp/Vs) for each layer
kSpread = [.2, .15, .15] #range for each k value (Vp/Vs) will be twice this value
rho = [2300, 2500, 2950] #densities to use in kg/m^3
startingModel = [t,tSpread,vp,vpSpread,k,kSpread,rho]

basinhopping_varyLayers(stations,d,dOut,nlayers,startingModel)