#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Nov 17 09:42:07 2023

@author: ben
"""
import numpy as np
import obspy
from obspy.signal import cross_correlation as cc
from telewavesim import utils as ut
#from telewavesim import wiggle as wg

import pickle
import matplotlib.pyplot as plt

import os
import time

import csv
from obspy.clients.fdsn import Client
from multiprocessing import Pool

from obspy.core import Stream, Trace
import glob
from obspy.taup import TauPyModel

#from functions_modifiedWiggle import rf_wiggles_RaS_label_stacked_wide_5layer
#from functions_modifiedWiggle import rf_wiggles_RaS_label_stacked_wide_5layer_withPoints
import pdb as pdb

from matplotlib import cm
from matplotlib.colors import ListedColormap, LinearSegmentedColormap

#from scipy.optimize import basinhopping
from functions_customBasinhopping import basinhopping

from scipy.stats import gaussian_kde
import seaborn as sns

from matplotlib.patches import Ellipse
import matplotlib.transforms as transforms

def basin_func(x, RF, ZC, RC, rho = [], cornersRF = [0.005, 1.5], cornersZR = [0.005, 1.5], dOut=None):
    #print(dOut)
    if len(x) == 15:
        t1,t2,t3,t4,t5,vp1,vp2,vp3,vp4,vp5,k1,k2,k3,k4,k5 = x
        layers = 5
    elif len(x) == 12:
        t1,t2,t3,t4,vp1,vp2,vp3,vp4,k1,k2,k3,k4 = x
        layers = 4
    elif len(x) == 9:
        t1,t2,t3,vp1,vp2,vp3,k1,k2,k3 = x
        layers = 3
    elif len(x) == 6:
        t1,t2,vp1,vp2,k1,k2 = x
        layers = 2
    elif len(x) == 3:
        t1,vp1,k1 = x
        layers = 1
    else:
        print('unsupported layers :(')
    
    #filter
    hcornerRF = cornersRF[1]
    lcornerRF = cornersRF[0]
    
    hcornerZR = cornersZR[1]
    lcornerZR = cornersRF[0]
    
    #relative weighting for rf's and acorr's. change them if you want
    wR = .75 #relative weight for rrf
    wZ = .25 #relative weight for vertical autocorrelations
    wRC = 0 #relative weight for radial autocorrelations
    
    #inputs are parameters used to generate synthetic receiver function over a given ray parameter range
    
    #RF is the input receiver function
    #ZC is the input vertical autocorrelation
    #RC is the input radial autocorrelation
    #corners are the filter corners used for the RFs/autocorrelations
    
    #normalized crosscorrelations of the input and generated RF's (1 would be a perfect match)
    
    #make a model using the input parameters
    corrs = 0.0
    
    if layers == 5:
        thic = [t1,t2,t3,t4,t5]
        vRat = [k1,k2,k3,k4,k5]
        vp = [vp1,vp2,vp3,vp4,vp5]
        if rho == []: #use default density values if undefined
            rho = [2300, 2450, 2600, 2700, 2900, 3300] #density for layers. last is mantle.
    elif layers == 4:
        thic = [t1,t2,t3,t4]
        vRat = [k1,k2,k3,k4]
        vp = [vp1,vp2,vp3,vp4]
        if rho == []: #use default density values if undefined
            rho = [2300, 2550, 2700, 2900, 3300] #density for layers. last is mantle.
    elif layers == 3:
        thic = [t1,t2,t3]
        vRat = [k1,k2,k3]
        vp = [vp1,vp2,vp3]
        if rho == []: #use default density values if undefined
            rho = [2300, 2550, 2800, 3300] #density for layers. last is mantle.
    elif layers == 2:
        thic = [t1,t2]
        vRat = [k1,k2]
        vp = [vp1,vp2]
        if rho == []: #use default density values if undefined
            rho = [2300, 2800, 3300] #density for layers. last is mantle.
    elif layers == 1:
        thic = [t1]
        vRat = [k1]
        vp = [vp1]
        if rho == []: #use default density values if undefined
            rho = [2900, 3300] #density for layers. last is mantle.
        
    vs = []
    for i in range(0,len(vp)):
        vs.append(vp[i]/vRat[i])
    
    #append info for the base layer, which is the top of the mantle.
    thic.append(10)
    vp.append(7.8)
    vs.append(4.48)
    
    model = ut.Model(thic, rho, vp, vs)
    dt = .05
    
    for i in range(len(RF)):
        trR = Stream(); zCorrOut = Stream(); rCorrOut = Stream();
        # Calculate the plane waves seismograms
        trxyz = ut.run_plane(model, RF[i].meta.slow, RF[i].stats.npts, RF[i].stats.delta, 180, wvtype="P", obs=False)
        
        trxyzRaw = trxyz.copy()
        trxyz.filter('bandpass',freqmin=lcornerZR, freqmax=hcornerZR, corners=2, zerophase=True)
        
        #compute synthetic autocorrelations
        xcorr_time = 5/6;
        corrZ = cc.correlate(trxyz[2],trxyz[2],int((xcorr_time*60)/dt),normalize='naive',method='auto')
        corrZ = corrZ[1000:]
        corrR = cc.correlate(trxyz[0],trxyz[0],int((xcorr_time*60)/dt),normalize='naive',method='auto')
        corrR = corrR[1000:]
    
    #now taper.
        nsamp = (2/dt); #start at 2 seconds
        tap = np.hanning(nsamp * 2)
        tap_beg = tap[1:int(nsamp+2)]
        tap_end = tap[int(len(tap)-nsamp - 1):len(tap)]
        
        hann_taper = np.zeros(len(corrZ))+1
        hann_taper[0:int(nsamp+1)] = tap_beg;
        hann_taper[len(hann_taper)-int(nsamp)-1:] = tap_end;
        taper_corrZ = np.array(corrZ) * np.array(hann_taper)
        taper_corrR = np.array(corrR) * np.array(hann_taper)
    #pad
        taper_corrZ = taper_corrZ[:(int(len(taper_corrZ)* (3/5)) + 1)]
        taper_corr_padZ = np.append(np.zeros(int(30/dt)),taper_corrZ)
        taper_corrR = taper_corrR[:(int(len(taper_corrR)* (3/5)) + 1)]
        taper_corr_padR = np.append(np.zeros(int(30/dt)),taper_corrR)
        #tcorr = tcorr[:(int(len(tcorr)* (3/5)) + 1)]
        zAuto = trxyz[2].copy()
        zAuto.data = taper_corr_padZ
        zCorrOut.append(zAuto)
        
        rAuto = trxyz[1].copy()
        rAuto.data = taper_corr_padR
        rCorrOut.append(rAuto)
        
        # Then the transfer functions in Z-R-T coordinate system
        tf = ut.tf_from_xyz(trxyzRaw, pvh=False)
        # Append to streams
        trR.append(tf[0]); #trT.append(tf[1])
        # Filter to get wave-like traces
        trR.filter('bandpass',freqmin=lcornerRF, freqmax=hcornerRF, corners=2, zerophase=True)
        zCorrOut.filter('bandpass',freqmin=lcornerZR, freqmax=hcornerZR, corners=2, zerophase=True)
        rCorrOut.filter('bandpass',freqmin=lcornerZR, freqmax=hcornerZR, corners=2, zerophase=True)
    
        corrRF = cc.correlate(trR[0],RF[i],0,normalize='naive',method='auto')
        corrZ = cc.correlate(zCorrOut[0],ZC[i],0,normalize='naive',method='auto')
        corrR = cc.correlate(rCorrOut[0],RC[i],0,normalize='naive',method='auto')
        corrs = corrs + (corrRF[0]*wR) + (corrZ[0]*wZ) + (corrR[0]*wRC) 
        
    return 1 - (corrs/len(RF))

history = []
histCost = []
def callback(x,f,a): #This function should be called after EVERY local minimum obtained so also after the first local minimum. (This is the minimum obtained at step 0).
    #print('CALLBACK COST: ',f)

    history.append(x)
    histCost.append(f)
    
    #print('CALLBACK COST: ',f)
    #print('Length of histCost: ' + str(len(histCost)))
    '''
 >>> class MyTakeStep:
 ...    def __init__(self, stepsize=0.5):
 ...        self.stepsize = stepsize
 ...        self.rng = np.random.default_rng()
 ...    def __call__(self, x):
 ...        s = self.stepsize
 ...        x[0] += self.rng.uniform(-2.*s, 2.*s)
 ...        x[1:] += self.rng.uniform(-s, s, x[1:].shape)
 ...        return x

 Since ``MyTakeStep.stepsize`` exists basinhopping will adjust the magnitude
 of ``stepsize`` to optimize the search. We'll use the same 2-D function as
 before

 >>> mytakestep = MyTakeStep()
 >>> ret = basinhopping(func2d, x0, minimizer_kwargs=minimizer_kwargs,
 ...                    niter=200, take_step=mytakestep)   
 '''
 
'''
    t1_min = t1 - 2
    t1_max = t1 + 2
    t2_min = t2 - 3
    t2_max = t2 + 3
    t3_min = t3 - 3
    t3_max = t3 + 3
    t4_min = t4 - 3
    t4_max = t4 + 3
    t5_min = t5 - 3.5
    t5_max = t5 + 3.5
    
    vp1_min = vp1 - .5
    vp1_max = vp1 + .5
    vp2_min = vp2 - .75
    vp2_max = vp2 + .75
    vp3_min = vp3 - .75
    vp3_max = vp3 + .75
    vp4_min = vp4 - .75
    vp4_max = vp4 + .75
    vp5_min = vp5 - .5
    vp5_max = vp5 + .5
    
    k1_min = 1.85
    k1_max = 2.1
    k2_min = 1.64
    k2_max = 1.95
    k3_min = 1.64
    k3_max = 1.95
    k4_min = 1.64
    k4_max = 1.95
    k5_min = 1.64
    k5_max = 1.95
 '''
class MyTakeStep:
     def __init__(self, stepsize=0.5):
         self.stepsize = stepsize
         self.rng = np.random.default_rng()
     def __call__(self, x):
         s = self.stepsize
         
         normFactor = 7
         
         #spread is 4
         spread = 4
         x[0] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         #spread is 6
         spread = 6
         x[1] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         x[2] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         x[3] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         #spread is 7
         spread = 7
         x[4] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         
         #spread is 1
         spread = 1
         x[5] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         #spread is 1.5
         spread = 1.5
         x[6] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         x[7] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         x[8] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         #spread is 1
         spread = 1
         x[9] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         
         #spread is ~.3
         spread = .25
         x[10] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         spread = .31
         x[11] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         x[12] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         x[13] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         x[14] += self.rng.uniform(-(spread/normFactor)*s, (spread/normFactor)*s)
         
         return x

#mytakestep = MyTakeStep()
 
def basinhopping_forPool(basin_func, x0, niter, T, stepsize, minimizer_kwargs, take_step, accept_test, callback,stepwise_factor):
    result = basinhopping(basin_func, x0, niter, T, stepsize, minimizer_kwargs, take_step, accept_test, callback,stepwise_factor=stepwise_factor)
    
    #print('histcost in basinhopping_forPool: ' + str(histCost))
    
    return result, history, histCost
    
def pool_basinhopping2(basin_func,x0s, minimizer_kwargs, callback):
    #print(str(len(x0s)) + ' hoppers')
    pool = Pool(processes=len(x0s))

    niter = 100
    T=1.0
    stepsize=0.5 #default is .5
    #take_step=MyTakeStep()
    take_step=None
    accept_test=None
    stepwise_factor = .9 #default is .9
    
    results = pool.starmap(basinhopping_forPool, [(basin_func, x0, niter, T, stepsize, minimizer_kwargs, take_step, accept_test, callback, stepwise_factor) for x0 in x0s])
    
    return results

def plotSol_5layers(d,station,bestCost,bestPos,costs,positions):
    
    '''
    Iterates through search history and plots search positions/costs for analysis.
    Also writes out solutions into a .csv file. Use this function for a searched Vp.
    
    
    d is the input directory
    dOut is the output directory
    stations is the stations list, in format: ['s1','s2']. Should match names of stations in bin folder
    processes is number of processes for parallelization, pick whatever is best for your machine
    '''
    
    client = Client('IRIS')
    
    print('Plotting: ' + station)
    
    #get location of station via IRIS client
    if 'BS.' in station:
        if 'RLOK' in station:
            stn = client.get_stations(network='OK', station='RLOK', format='xml', level='channel')
        elif 'U40' in station:
            stn = client.get_stations(network='TA', station='U40A', format='xml', level='channel')
        elif 'X40' in station:
            stn = client.get_stations(network='TA', station='X40A', format='xml', level='channel')
        elif 'Z38' in station:
            stn = client.get_stations(network='TA', station='Z38A', format='xml', level='channel')
        elif 'U38' in station:
            stn = client.get_stations(network='TA', station='U38A', format='xml', level='channel')
        elif 'X37' in station:
            stn = client.get_stations(network='TA', station='X37A', format='xml', level='channel')
        elif 'Z41' in station:
            stn = client.get_stations(network='TA', station='Z41A', format='xml', level='channel')
        elif '441' in station:
            stn = client.get_stations(network='TA', station='441A', format='xml', level='channel')
        elif 'HNVL' in station:
            stn = client.get_stations(network='TA', station='438A', format='xml', level='channel')
            
    else:    
        stn = client.get_stations(network=station.split('.')[0], station=station.split('.')[1], format='xml', level='channel')
    
    '''
    #load in solutions and search history
    sols = pickle.load(open(d + station + '.p','rb'))
    [pos_history, cost_history, bounds, options, [wR, wZ, wRC]] = pickle.load(open(d + station + '_optimizer.p','rb'))
    kwargs = pickle.load(open(d + station + '_kwargs.p','rb'))
    '''
    
    #best solution for each parameter
    l1 = bestPos[0]
    l2 = bestPos[1]
    l3 = bestPos[2]
    l4 = bestPos[3]
    l5 = bestPos[4]
    k1 = bestPos[10]
    k2 = bestPos[11]
    k3 = bestPos[12]
    k4 = bestPos[13]
    k5 = bestPos[14]
    vp1 = bestPos[5]
    vp2 = bestPos[6]
    vp3 = bestPos[7]
    vp4 = bestPos[8]
    vp5 = bestPos[9]
    
    m = l1 + l2 + l3 + l4 + l5
    bestSol = [station,stn[0][0].latitude,stn[0][0].longitude,str(round(bestCost,2)),str(round(l1,2)),str(round(vp1,2)),str(round(k1,2)),str(round(l2,2)),str(round(vp2,2)),str(round(k2,2)),str(round(l3,2)),str(round(vp3,2)),str(round(k3,2)),str(round(l4,2)),str(round(vp4,2)),str(round(k4,2)),str(round(l4,2)),str(round(vp4,2)),str(round(k4,2)),str(round(m,2))]
    
    with open(d +'bestSols_5layer.csv','a') as f:
        write = csv.writer(f)
        write.writerow(bestSol)       
    
    
    l1s = []
    l2s = []
    l3s = []
    l4s = []
    l5s = []
    vp1s = []
    vp2s = []
    vp3s = []
    vp4s = []
    vp5s = []
    k1s = []
    k2s = []
    k3s = []
    k4s = []
    k5s = []
    
    for p in positions:
        l1s.append(p[0])
        l2s.append(p[1])
        l3s.append(p[2])
        l4s.append(p[3])
        l5s.append(p[4])
        
        vp1s.append(p[5])
        vp2s.append(p[6])
        vp3s.append(p[7])
        vp4s.append(p[8])
        vp5s.append(p[9])
        
        k1s.append(p[10])
        k2s.append(p[11])
        k3s.append(p[12])
        k4s.append(p[13])
        k5s.append(p[14])
    
    #plot up search history with costs on 2D plots
    plt.scatter(l1s,k1s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l1s), max(l1s)])
    plt.ylim([min(k1s), max(k1s)])
    plt.xlabel('Layer 1 Thickness')
    plt.ylabel('Layer 1 Vp/Vs')
    plt.title('Layer 1: Thickness vs Vp/Vs')
    cbar = plt.colorbar()
    cbar.set_label('Misfit')
    plt.scatter(l1,k1,s=5, color='red')
    plt.savefig(d + station + '_l1_k1_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l1s,vp1s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l1s), max(l1s)])
    plt.ylim([min(vp1s), max(vp1s)])
    plt.xlabel('Layer 1 Thickness')
    plt.ylabel('Layer 1 Vp')
    plt.title('Layer 1: Thickness vs Vp')
    cbar = plt.colorbar()
    cbar.set_label('Misfit')
    plt.scatter(l1,vp1,s=5, color='red')
    plt.savefig(d + station + '_l1_v1_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l2s,k2s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l2s), max(l2s)])
    plt.ylim([min(k2s), max(k2s)])
    plt.xlabel('Layer 2 Thickness')
    plt.ylabel('Layer 2 Vp/Vs')
    plt.title('Layer 2: Thickness vs Vp/Vs')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l2,k2,s=5, color='red')
    plt.savefig(d + station + '_l2_h2_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l2s,vp2s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l2s), max(l2s)])
    plt.ylim([min(vp2s), max(vp2s)])
    plt.xlabel('Layer 2 Thickness')
    plt.ylabel('Layer 2 Vp')
    plt.title('Layer 2: Thickness vs Vp')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l2,vp2,s=5, color='red')
    plt.savefig(d + station + '_l2_v2_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l3s,k3s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l3s), max(l3s)])
    plt.ylim([min(k3s), max(k3s)])
    plt.xlabel('Layer 3 Thickness')
    plt.ylabel('Layer 3 Vp/Vs')
    plt.title('Layer 3: Thickness vs Vp/Vs')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l3,k3,s=5, color='red')
    plt.savefig(d + station + '_l3_h3_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l3s,vp3s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l3s), max(l3s)])
    plt.ylim([min(vp3s), max(vp3s)])
    plt.xlabel('Layer 3 Thickness')
    plt.ylabel('Layer 3 Vp')
    plt.title('Layer 3: Thickness vs Vp')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l3,vp3,s=5, color='red')
    plt.savefig(d + station + '_l3_v3_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l4s,k4s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l4s), max(l4s)])
    plt.ylim([min(k4s), max(k4s)])
    plt.xlabel('Layer 4 Thickness')
    plt.ylabel('Layer 4 Vp/Vs')
    plt.title('Layer 4: Thickness vs Vp/Vs')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l4,k4,s=5, color='red')
    plt.savefig(d + station + '_l4_h4_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l4s,vp4s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l4s), max(l4s)])
    plt.ylim([min(vp4s), max(vp4s)])
    plt.xlabel('Layer 4 Thickness')
    plt.ylabel('Layer 4 Vp')
    plt.title('Layer 4: Thickness vs Vp')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l4,vp4,s=5, color='red')
    plt.savefig(d + station + '_l4_v4_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    #plot up search history with costs on 2D plots
    plt.scatter(l5s,k5s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l5s), max(l5s)])
    plt.ylim([min(k5s), max(k5s)])
    plt.xlabel('Layer 5 Thickness')
    plt.ylabel('Layer 5 Vp/Vs')
    plt.title('Layer 5: Thickness vs Vp/Vs')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l5,k5,s=5, color='red')
    plt.savefig(d + station + '_l5_h5_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l5s,vp5s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l5s), max(l5s)])
    plt.ylim([min(vp5s), max(vp5s)])
    plt.xlabel('Layer 5 Thickness')
    plt.ylabel('Layer 5 Vp')
    plt.title('Layer 5: Thickness vs Vp')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l5,vp5,s=5, color='red')
    plt.savefig(d + station + '_l5_v5_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l1s,l2s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l1s), max(l1s)])
    plt.ylim([min(l2s), max(l2s)])
    plt.xlabel('Layer 1 Thickness')
    plt.ylabel('Layer 2 Thickness')
    plt.title('Layer 1 Thickness vs Layer 2 Thickness')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l1,l2,s=5, color='red')
    plt.savefig(d + station + '_layers12_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l2s,l3s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l2s), max(l2s)])
    plt.ylim([min(l3s), max(l3s)])
    plt.xlabel('Layer 2 Thickness')
    plt.ylabel('Layer 3 Thickness')
    plt.title('Layer 2 Thickness vs Layer 3 Thickness')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l2,l3,s=5, color='red')
    plt.savefig(d + station + '_layers23_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l3s,l4s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l3s), max(l3s)])
    plt.ylim([min(l4s), max(l4s)])
    plt.xlabel('Layer 3 Thickness')
    plt.ylabel('Layer 4 Thickness')
    plt.title('Layer 3 Thickness vs Layer 4 Thickness')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l3,l4,s=5, color='red')
    plt.savefig(d + station + '_layers34_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l4s,l5s,s=1, c=costs, cmap='gray')
    plt.xlim([min(l4s), max(l4s)])
    plt.ylim([min(l5s), max(l5s)])
    plt.xlabel('Layer 4 Thickness')
    plt.ylabel('Layer 5 Thickness')
    plt.title('Layer 4 Thickness vs Layer 5 Thickness')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l4,l5,s=5, color='red')
    plt.savefig(d + station + '_layers45_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
def plotSol(d,station,bestCost,bestPos,costs_localMin=[],positions=[],costs=[],nlayers=4,writeCSV=True):
    
    '''
    Iterates through search history and plots search positions/costs for analysis.
    Also writes out solutions into a .csv file. Use this function for a searched Vp.
    
    
    d is the input directory
    dOut is the output directory
    stations is the stations list, in format: ['s1','s2']. Should match names of stations in bin folder
    processes is number of processes for parallelization, pick whatever is best for your machine
    '''
    
    client = Client('IRIS')
    
    print('Plotting Searches: ' + station)
    
    #get location of station via IRIS client
    if 'BS.' in station or 'BS-' in station:
        if 'RLOK' in station:
            stn = client.get_stations(network='OK', station='RLOK', format='xml', level='channel')
        elif 'U40' in station:
            stn = client.get_stations(network='TA', station='U40A', format='xml', level='channel')
        elif 'X40' in station:
            stn = client.get_stations(network='TA', station='X40A', format='xml', level='channel')
        elif 'Z38' in station:
            stn = client.get_stations(network='TA', station='Z38A', format='xml', level='channel')
        elif 'U38' in station:
            stn = client.get_stations(network='TA', station='U38A', format='xml', level='channel')
        elif 'X37' in station:
            stn = client.get_stations(network='TA', station='X37A', format='xml', level='channel')
        elif 'Z41' in station:
            stn = client.get_stations(network='TA', station='Z41A', format='xml', level='channel')
        elif '140' in station:
            stn = client.get_stations(network='TA', station='140A', format='xml', level='channel')
        elif '441' in station:
            stn = client.get_stations(network='TA', station='441A', format='xml', level='channel')
        elif 'HNVL' in station:
            stn = client.get_stations(network='TA', station='438A', format='xml', level='channel')
        elif 'MANK' in station:
            stn = client.get_stations(network='XI', station='MANK', format='xml', level='channel')
        elif 'JAFL' in station:
            stn = client.get_stations(network='XI', station='JAFL', format='xml', level='channel')
        elif 'MPUR' in station:
            stn = client.get_stations(network='XI', station='MPUR', format='xml', level='channel')
            
    else:    
        stn = client.get_stations(network=station.replace('-','.').split('.')[0], station=station.replace('-','.').split('.')[1], format='xml', level='channel')
    
    '''
    #load in solutions and search history
    sols = pickle.load(open(d + station + '.p','rb'))
    [pos_history, cost_history, bounds, options, [wR, wZ, wRC]] = pickle.load(open(d + station + '_optimizer.p','rb'))
    kwargs = pickle.load(open(d + station + '_kwargs.p','rb'))
    '''
    
    #best solution for each parameter
    if nlayers == 5:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = bestPos[3]
        l5 = bestPos[4]
        k1 = bestPos[10]
        k2 = bestPos[11]
        k3 = bestPos[12]
        k4 = bestPos[13]
        k5 = bestPos[14]
        vp1 = bestPos[5]
        vp2 = bestPos[6]
        vp3 = bestPos[7]
        vp4 = bestPos[8]
        vp5 = bestPos[9]
        
    elif nlayers == 4:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = bestPos[3]
        l5 = 0
        k1 = bestPos[8]
        k2 = bestPos[9]
        k3 = bestPos[10]
        k4 = bestPos[11]
        k5 = 0
        vp1 = bestPos[4]
        vp2 = bestPos[5]
        vp3 = bestPos[6]
        vp4 = bestPos[7]
        vp5 = 0
        
    elif nlayers == 3:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = 0
        l5 = 0
        k1 = bestPos[6]
        k2 = bestPos[7]
        k3 = bestPos[8]
        k4 = 0
        k5 = 0
        vp1 = bestPos[3]
        vp2 = bestPos[4]
        vp3 = bestPos[5]
        vp4 = 0
        vp5 = 0
    elif nlayers == 2:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = 0
        l4 = 0
        l5 = 0
        k1 = bestPos[4]
        k2 = bestPos[5]
        k3 = 0
        k4 = 0
        k5 = 0
        vp1 = bestPos[2]
        vp2 = bestPos[3]
        vp3 = 0
        vp4 = 0
        vp5 = 0
    elif nlayers == 1:
        l1 = bestPos[0]
        l2 = 0
        l3 = 0
        l4 = 0
        l5 = 0
        k1 = bestPos[2]
        k2 = 0
        k3 = 0
        k4 = 0
        k5 = 0
        vp1 = bestPos[1]
        vp2 = 0
        vp3 = 0
        vp4 = 0
        vp5 = 0
    
    if writeCSV == True:
        m = l1 + l2 + l3 + l4 + l5
        bestSol = [station,stn[0][0].latitude,stn[0][0].longitude,str(round(bestCost,2)),str(round(l1,2)),str(round(vp1,2)),str(round(k1,2)),str(round(l2,2)),str(round(vp2,2)),str(round(k2,2)),str(round(l3,2)),str(round(vp3,2)),str(round(k3,2)),str(round(l4,2)),str(round(vp4,2)),str(round(k4,2)),str(round(l4,2)),str(round(vp4,2)),str(round(k4,2)),str(round(m,2))]
        
        with open(d +'bestSols.csv','a') as f:
            write = csv.writer(f)
            write.writerow(bestSol)       
    
    theta = []
    l1s = []
    l2s = []
    l3s = []
    l4s = []
    l5s = []
    vp1s = []
    vp2s = []
    vp3s = []
    vp4s = []
    vp5s = []
    k1s = []
    k2s = []
    k3s = []
    k4s = []
    k5s = []
    
    thetas = []
    
    # Using readlines()
    allSearches = d + station.replace('-','.') + '.txt'
    file1 = open(allSearches, 'r')
    Lines = file1.readlines()
 
    linesSorted = [x for y, x in sorted(zip(costs, Lines))]
    costs = sorted(costs)
    
    linesSorted.reverse()
    costs.reverse()
    
    count = 0
    for line in linesSorted:
        count += 1
        #print("Line{}: {}".format(count, line.strip()))
        if nlayers == 5:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),float(thetaStr[3]),float(thetaStr[4]), \
                float(thetaStr[5]),float(thetaStr[6]),float(thetaStr[7]),float(thetaStr[8]),float(thetaStr[9]), \
                    float(thetaStr[10]),float(thetaStr[11]),float(thetaStr[12]),float(thetaStr[13]),float(thetaStr[14])
            
            thetas.append(theta)     
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            l4s.append(theta[3])
            l5s.append(theta[4])
            
            vp1s.append(theta[5])
            vp2s.append(theta[6])
            vp3s.append(theta[7])
            vp4s.append(theta[8])
            vp5s.append(theta[9])
            
            k1s.append(theta[10])
            k2s.append(theta[11])
            k3s.append(theta[12])
            k4s.append(theta[13])
            k5s.append(theta[14])
            
        elif nlayers == 4:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),float(thetaStr[3]),\
                float(thetaStr[4]),float(thetaStr[5]),float(thetaStr[6]),float(thetaStr[7]),\
                    float(thetaStr[8]),float(thetaStr[9]),float(thetaStr[10]),float(thetaStr[11])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            l4s.append(theta[3])
            
            vp1s.append(theta[4])
            vp2s.append(theta[5])
            vp3s.append(theta[6])
            vp4s.append(theta[7])
            
            k1s.append(theta[8])
            k2s.append(theta[9])
            k3s.append(theta[10])
            k4s.append(theta[11])
            
        elif nlayers == 3:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),\
                float(thetaStr[3]),float(thetaStr[4]),float(thetaStr[5]),\
                    float(thetaStr[6]),float(thetaStr[7]),float(thetaStr[8])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            
            vp1s.append(theta[3])
            vp2s.append(theta[4])
            vp3s.append(theta[5])
            
            k1s.append(theta[6])
            k2s.append(theta[7])
            k3s.append(theta[8])
        
        elif nlayers == 2:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),\
                float(thetaStr[2]),float(thetaStr[3]),\
                    float(thetaStr[4]),float(thetaStr[5])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            
            vp1s.append(theta[2])
            vp2s.append(theta[3])
            
            k1s.append(theta[4])
            k2s.append(theta[5])
            
        elif nlayers == 1:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),\
                float(thetaStr[2])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            
            vp1s.append(theta[1])
            
            k1s.append(theta[2])
    
    l1_loc = []
    l2_loc = []
    l3_loc = []
    l4_loc = []
    l5_loc = []
    vp1_loc = []
    vp2_loc = []
    vp3_loc = []
    vp4_loc = []
    vp5_loc = []
    k1_loc = []
    k2_loc = []
    k3_loc = []
    k4_loc = []
    k5_loc = []
    
    for p in positions:
        if nlayers == 5:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            l4_loc.append(p[3])
            l5_loc.append(p[4])
            
            vp1_loc.append(p[5])
            vp2_loc.append(p[6])
            vp3_loc.append(p[7])
            vp4_loc.append(p[8])
            vp5_loc.append(p[9])
            
            k1_loc.append(p[10])
            k2_loc.append(p[11])
            k3_loc.append(p[12])
            k4_loc.append(p[13])
            k5_loc.append(p[14])
            
        elif nlayers == 4:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            l4_loc.append(p[3])
            
            vp1_loc.append(p[4])
            vp2_loc.append(p[5])
            vp3_loc.append(p[6])
            vp4_loc.append(p[7])
            
            k1_loc.append(p[8])
            k2_loc.append(p[9])
            k3_loc.append(p[10])
            k4_loc.append(p[11])
            
        elif nlayers == 3:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            
            vp1_loc.append(p[3])
            vp2_loc.append(p[4])
            vp3_loc.append(p[5])
            
            k1_loc.append(p[6])
            k2_loc.append(p[7])
            k3_loc.append(p[8])
            
        elif nlayers == 2:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            
            vp1_loc.append(p[2])
            vp2_loc.append(p[3])
            
            k1_loc.append(p[4])
            k2_loc.append(p[5])
            
        elif nlayers == 1:
            l1_loc.append(p[0])
            
            vp1_loc.append(p[1])
            
            k1_loc.append(p[2])
            
    
    ninetynine_percent_solution = max(costs)-((max(costs)-min(costs))*.995)
    
    colorRange = max(costs) - min(costs)
    nineEight_color = (ninetynine_percent_solution - min(costs)) / colorRange
    nineFive_color = (ninetynine_percent_solution - min(costs)) / colorRange
    
    
    binary_r = cm.get_cmap('Blues', 256)
    newcolors = binary_r(np.linspace(0, 1, 256))
    
    binary_short = cm.get_cmap('binary_r', 256-round(nineFive_color * 256))
    newcolors[0:256-round(nineFive_color * 256), :] = binary_short(np.linspace(0, 1, 256-round(nineFive_color * 256)))
    
    red = np.array([63/255, 193/255, 232/255, 1])
    newcolors[:round(nineEight_color * 256), :] = red
    newcmp = ListedColormap(newcolors)
    
    #pdb.set_trace()
    #plot up search history with costs on 2D plots
    plt.scatter(l1s,k1s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
    plt.xlim([min(l1s), max(l1s)])
    plt.ylim([min(k1s), max(k1s)])
    plt.xlabel('Layer 1 Thickness')
    plt.ylabel('Layer 1 Vp/Vs')
    plt.title('Layer 1: Thickness vs Vp/Vs')
    cbar = plt.colorbar()
    cbar.set_label('Misfit')
    plt.scatter(l1_loc,k1_loc,s=2, color='deepskyblue')
    plt.scatter(l1,k1,s=7, color='tomato',marker="*")
    plt.savefig(d + station + '_l1_k1_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l1s,vp1s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
    plt.xlim([min(l1s), max(l1s)])
    plt.ylim([min(vp1s), max(vp1s)])
    plt.xlabel('Layer 1 Thickness')
    plt.ylabel('Layer 1 Vp')
    plt.title('Layer 1: Thickness vs Vp')
    cbar = plt.colorbar()
    cbar.set_label('Misfit')
    plt.scatter(l1_loc,vp1_loc,s=2, color='deepskyblue')
    plt.scatter(l1,vp1,s=7, color='tomato',marker="*")
    plt.savefig(d + station + '_l1_v1_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    if nlayers >= 2:
        plt.scatter(l2s,k2s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l2s), max(l2s)])
        plt.ylim([min(k2s), max(k2s)])
        plt.xlabel('Layer 2 Thickness')
        plt.ylabel('Layer 2 Vp/Vs')
        plt.title('Layer 2: Thickness vs Vp/Vs')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l2_loc,k2_loc,s=2, color='deepskyblue')
        plt.scatter(l2,k2,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_l2_h2_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
        plt.scatter(l2s,vp2s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l2s), max(l2s)])
        plt.ylim([min(vp2s), max(vp2s)])
        plt.xlabel('Layer 2 Thickness')
        plt.ylabel('Layer 2 Vp')
        plt.title('Layer 2: Thickness vs Vp')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l2_loc,vp2_loc,s=2, color='deepskyblue')
        plt.scatter(l2,vp2,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_l2_v2_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers >= 3:
        plt.scatter(l3s,k3s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l3s), max(l3s)])
        plt.ylim([min(k3s), max(k3s)])
        plt.xlabel('Layer 3 Thickness')
        plt.ylabel('Layer 3 Vp/Vs')
        plt.title('Layer 3: Thickness vs Vp/Vs')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l3_loc,k3_loc,s=2, color='deepskyblue')
        plt.scatter(l3,k3,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_l3_h3_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
        plt.scatter(l3s,vp3s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l3s), max(l3s)])
        plt.ylim([min(vp3s), max(vp3s)])
        plt.xlabel('Layer 3 Thickness')
        plt.ylabel('Layer 3 Vp')
        plt.title('Layer 3: Thickness vs Vp')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l3_loc,vp3_loc,s=2, color='deepskyblue')
        plt.scatter(l3,vp3,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_l3_v3_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers >= 4:
        plt.scatter(l4s,k4s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l4s), max(l4s)])
        plt.ylim([min(k4s), max(k4s)])
        plt.xlabel('Layer 4 Thickness')
        plt.ylabel('Layer 4 Vp/Vs')
        plt.title('Layer 4: Thickness vs Vp/Vs')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l4_loc,k4_loc,s=2, color='deepskyblue')
        plt.scatter(l4,k4,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_l4_h4_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
        plt.scatter(l4s,vp4s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l4s), max(l4s)])
        plt.ylim([min(vp4s), max(vp4s)])
        plt.xlabel('Layer 4 Thickness')
        plt.ylabel('Layer 4 Vp')
        plt.title('Layer 4: Thickness vs Vp')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l4_loc,vp4_loc,s=2, color='deepskyblue')
        plt.scatter(l4,vp4,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_l4_v4_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers == 5:
        #plot up search history with costs on 2D plots
        plt.scatter(l5s,k5s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l5s), max(l5s)])
        plt.ylim([min(k5s), max(k5s)])
        plt.xlabel('Layer 5 Thickness')
        plt.ylabel('Layer 5 Vp/Vs')
        plt.title('Layer 5: Thickness vs Vp/Vs')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l5_loc,k5_loc,s=2, color='deepskyblue')
        plt.scatter(l5,k5,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_l5_h5_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
        plt.scatter(l5s,vp5s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l5s), max(l5s)])
        plt.ylim([min(vp5s), max(vp5s)])
        plt.xlabel('Layer 5 Thickness')
        plt.ylabel('Layer 5 Vp')
        plt.title('Layer 5: Thickness vs Vp')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l5_loc,vp5_loc,s=2, color='deepskyblue')
        plt.scatter(l5,vp5,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_l5_v5_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers >= 2:
        plt.scatter(l1s,l2s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l1s), max(l1s)])
        plt.ylim([min(l2s), max(l2s)])
        plt.xlabel('Layer 1 Thickness')
        plt.ylabel('Layer 2 Thickness')
        plt.title('Layer 1 Thickness vs Layer 2 Thickness')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l1_loc,l2_loc,s=2, color='deepskyblue')
        plt.scatter(l1,l2,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_layers12_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers >= 3:
        plt.scatter(l2s,l3s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l2s), max(l2s)])
        plt.ylim([min(l3s), max(l3s)])
        plt.xlabel('Layer 2 Thickness')
        plt.ylabel('Layer 3 Thickness')
        plt.title('Layer 2 Thickness vs Layer 3 Thickness')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l2_loc,l3_loc,s=2, color='deepskyblue')
        plt.scatter(l2,l3,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_layers23_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers >= 4:
        plt.scatter(l3s,l4s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l3s), max(l3s)])
        plt.ylim([min(l4s), max(l4s)])
        plt.xlabel('Layer 3 Thickness')
        plt.ylabel('Layer 4 Thickness')
        plt.title('Layer 3 Thickness vs Layer 4 Thickness')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l3_loc,l4_loc,s=2, color='deepskyblue')
        plt.scatter(l3,l4,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_layers34_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers == 5:
        plt.scatter(l4s,l5s,s=1, c=costs, cmap=newcmp, vmin=min(costs), vmax=max(costs))
        plt.xlim([min(l4s), max(l4s)])
        plt.ylim([min(l5s), max(l5s)])
        plt.xlabel('Layer 4 Thickness')
        plt.ylabel('Layer 5 Thickness')
        plt.title('Layer 4 Thickness vs Layer 5 Thickness')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l4_loc,l5_loc,s=2, color='deepskyblue')
        plt.scatter(l4,l5,s=7, color='tomato',marker="*")
        plt.savefig(d + station + '_layers45_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
def plotSol_subset(d,station,bestCost,bestPos,costs_localMin=[],positions=[],costs=[],nlayers=4,plotCutoff=5, writeCSV=True):
    
    '''
    Iterates through search history and plots search positions/costs for analysis.
    Also writes out solutions into a .csv file. Use this function for a searched Vp.
    
    
    d is the input directory
    dOut is the output directory
    stations is the stations list, in format: ['s1','s2']. Should match names of stations in bin folder

    plotCutoff sets the cost value cutoff to plot
    
    '''
    
    client = Client('IRIS')
    
    print('Plotting Searches: ' + station)
    
    #get location of station via IRIS client
    if 'BS.' in station or 'BS-' in station:
        if 'RLOK' in station:
            stn = client.get_stations(network='OK', station='RLOK', format='xml', level='channel')
        elif 'U40' in station:
            stn = client.get_stations(network='TA', station='U40A', format='xml', level='channel')
        elif 'X40' in station:
            stn = client.get_stations(network='TA', station='X40A', format='xml', level='channel')
        elif 'Z38' in station:
            stn = client.get_stations(network='TA', station='Z38A', format='xml', level='channel')
        elif 'U38' in station:
            stn = client.get_stations(network='TA', station='U38A', format='xml', level='channel')
        elif 'X37' in station:
            stn = client.get_stations(network='TA', station='X37A', format='xml', level='channel')
        elif 'Z41' in station:
            stn = client.get_stations(network='TA', station='Z41A', format='xml', level='channel')
        elif '140' in station:
            stn = client.get_stations(network='TA', station='140A', format='xml', level='channel')
        elif '441' in station:
            stn = client.get_stations(network='TA', station='441A', format='xml', level='channel')
        elif 'HNVL' in station:
            stn = client.get_stations(network='TA', station='438A', format='xml', level='channel')
        elif 'MANK' in station:
            stn = client.get_stations(network='XI', station='MANK', format='xml', level='channel')
        elif 'JAFL' in station:
            stn = client.get_stations(network='XI', station='JAFL', format='xml', level='channel')
        elif 'MPUR' in station:
            stn = client.get_stations(network='XI', station='MPUR', format='xml', level='channel')
            
    else:    
        stn = client.get_stations(network=station.replace('-','.').split('.')[0], station=station.replace('-','.').split('.')[1], format='xml', level='channel')
    
    '''
    #load in solutions and search history
    sols = pickle.load(open(d + station + '.p','rb'))
    [pos_history, cost_history, bounds, options, [wR, wZ, wRC]] = pickle.load(open(d + station + '_optimizer.p','rb'))
    kwargs = pickle.load(open(d + station + '_kwargs.p','rb'))
    '''
    
    #best solution for each parameter
    if nlayers == 5:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = bestPos[3]
        l5 = bestPos[4]
        k1 = bestPos[10]
        k2 = bestPos[11]
        k3 = bestPos[12]
        k4 = bestPos[13]
        k5 = bestPos[14]
        vp1 = bestPos[5]
        vp2 = bestPos[6]
        vp3 = bestPos[7]
        vp4 = bestPos[8]
        vp5 = bestPos[9]
        
    elif nlayers == 4:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = bestPos[3]
        l5 = 0
        k1 = bestPos[8]
        k2 = bestPos[9]
        k3 = bestPos[10]
        k4 = bestPos[11]
        k5 = 0
        vp1 = bestPos[4]
        vp2 = bestPos[5]
        vp3 = bestPos[6]
        vp4 = bestPos[7]
        vp5 = 0
        
    elif nlayers == 3:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = 0
        l5 = 0
        k1 = bestPos[6]
        k2 = bestPos[7]
        k3 = bestPos[8]
        k4 = 0
        k5 = 0
        vp1 = bestPos[3]
        vp2 = bestPos[4]
        vp3 = bestPos[5]
        vp4 = 0
        vp5 = 0
    elif nlayers == 2:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = 0
        l4 = 0
        l5 = 0
        k1 = bestPos[4]
        k2 = bestPos[5]
        k3 = 0
        k4 = 0
        k5 = 0
        vp1 = bestPos[2]
        vp2 = bestPos[3]
        vp3 = 0
        vp4 = 0
        vp5 = 0
    
    if writeCSV == True:
        m = l1 + l2 + l3 + l4 + l5
        bestSol = [station,stn[0][0].latitude,stn[0][0].longitude,str(round(bestCost,2)),str(round(l1,2)),str(round(vp1,2)),str(round(k1,2)),str(round(l2,2)),str(round(vp2,2)),str(round(k2,2)),str(round(l3,2)),str(round(vp3,2)),str(round(k3,2)),str(round(l4,2)),str(round(vp4,2)),str(round(k4,2)),str(round(l4,2)),str(round(vp4,2)),str(round(k4,2)),str(round(m,2))]
        
        with open(d +'bestSols.csv','a') as f:
            write = csv.writer(f)
            write.writerow(bestSol)       
    
    theta = []
    l1s = []
    l2s = []
    l3s = []
    l4s = []
    l5s = []
    vp1s = []
    vp2s = []
    vp3s = []
    vp4s = []
    vp5s = []
    k1s = []
    k2s = []
    k3s = []
    k4s = []
    k5s = []
    
    thetas = []
    
    # Using readlines()
    allSearches = d + station.replace('-','.') + '.txt'
    file1 = open(allSearches, 'r')
    Lines = file1.readlines()
 
    linesSorted = [x for y, x in sorted(zip(costs, Lines))]
    costs = sorted(costs)
    
    linesSorted.reverse()
    costs.reverse()
    
    count = 0
    for line in linesSorted:
        count += 1
        #print("Line{}: {}".format(count, line.strip()))
        if nlayers == 5:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),float(thetaStr[3]),float(thetaStr[4]), \
                float(thetaStr[5]),float(thetaStr[6]),float(thetaStr[7]),float(thetaStr[8]),float(thetaStr[9]), \
                    float(thetaStr[10]),float(thetaStr[11]),float(thetaStr[12]),float(thetaStr[13]),float(thetaStr[14])
            
            thetas.append(theta)     
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            l4s.append(theta[3])
            l5s.append(theta[4])
            
            vp1s.append(theta[5])
            vp2s.append(theta[6])
            vp3s.append(theta[7])
            vp4s.append(theta[8])
            vp5s.append(theta[9])
            
            k1s.append(theta[10])
            k2s.append(theta[11])
            k3s.append(theta[12])
            k4s.append(theta[13])
            k5s.append(theta[14])
            
        elif nlayers == 4:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),float(thetaStr[3]),\
                float(thetaStr[4]),float(thetaStr[5]),float(thetaStr[6]),float(thetaStr[7]),\
                    float(thetaStr[8]),float(thetaStr[9]),float(thetaStr[10]),float(thetaStr[11])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            l4s.append(theta[3])
            
            vp1s.append(theta[4])
            vp2s.append(theta[5])
            vp3s.append(theta[6])
            vp4s.append(theta[7])
            
            k1s.append(theta[8])
            k2s.append(theta[9])
            k3s.append(theta[10])
            k4s.append(theta[11])
            
        elif nlayers == 3:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),\
                float(thetaStr[3]),float(thetaStr[4]),float(thetaStr[5]),\
                    float(thetaStr[6]),float(thetaStr[7]),float(thetaStr[8])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            
            vp1s.append(theta[3])
            vp2s.append(theta[4])
            vp3s.append(theta[5])
            
            k1s.append(theta[6])
            k2s.append(theta[7])
            k3s.append(theta[8])
        
        elif nlayers == 2:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),\
                float(thetaStr[2]),float(thetaStr[3]),\
                    float(thetaStr[4]),float(thetaStr[5])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            
            vp1s.append(theta[2])
            vp2s.append(theta[3])
            
            k1s.append(theta[4])
            k2s.append(theta[5])
    
    l1_loc = []
    l2_loc = []
    l3_loc = []
    l4_loc = []
    l5_loc = []
    vp1_loc = []
    vp2_loc = []
    vp3_loc = []
    vp4_loc = []
    vp5_loc = []
    k1_loc = []
    k2_loc = []
    k3_loc = []
    k4_loc = []
    k5_loc = []
    
    for p in positions:
        if nlayers == 5:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            l4_loc.append(p[3])
            l5_loc.append(p[4])
            
            vp1_loc.append(p[5])
            vp2_loc.append(p[6])
            vp3_loc.append(p[7])
            vp4_loc.append(p[8])
            vp5_loc.append(p[9])
            
            k1_loc.append(p[10])
            k2_loc.append(p[11])
            k3_loc.append(p[12])
            k4_loc.append(p[13])
            k5_loc.append(p[14])
            
        elif nlayers == 4:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            l4_loc.append(p[3])
            
            vp1_loc.append(p[4])
            vp2_loc.append(p[5])
            vp3_loc.append(p[6])
            vp4_loc.append(p[7])
            
            k1_loc.append(p[8])
            k2_loc.append(p[9])
            k3_loc.append(p[10])
            k4_loc.append(p[11])
            
        elif nlayers == 3:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            
            vp1_loc.append(p[3])
            vp2_loc.append(p[4])
            vp3_loc.append(p[5])
            
            k1_loc.append(p[6])
            k2_loc.append(p[7])
            k3_loc.append(p[8])
            
        elif nlayers == 2:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            
            vp1_loc.append(p[2])
            vp2_loc.append(p[3])
            
            k1_loc.append(p[4])
            k2_loc.append(p[5])
            
    
    cutoff= max(costs)-((max(costs)-min(costs))*((100-plotCutoff)/100))
    cutIdx = costs.index(costs[min(range(len(costs)), key = lambda i: abs(costs[i]-cutoff))])
    
    #plot up search history with costs on 2D plots
    plt.scatter(l1s[cutIdx:],k1s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
    plt.xlim([min(l1s), max(l1s)])
    plt.ylim([min(k1s), max(k1s)])
    plt.xlabel('Layer 1 Thickness')
    plt.ylabel('Layer 1 Vp/Vs')
    plt.title('Layer 1: Thickness vs Vp/Vs')
    cbar = plt.colorbar()
    cbar.set_label('Misfit')
    plt.scatter(l1,k1,s=25, color='tomato',marker="*")
    plt.savefig(d + station + '_l1_k1_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l1s[cutIdx:],vp1s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
    plt.xlim([min(l1s), max(l1s)])
    plt.ylim([min(vp1s), max(vp1s)])
    plt.xlabel('Layer 1 Thickness')
    plt.ylabel('Layer 1 Vp')
    plt.title('Layer 1: Thickness vs Vp')
    cbar = plt.colorbar()
    cbar.set_label('Misfit')
    plt.scatter(l1,vp1,s=25, color='tomato',marker="*")
    plt.savefig(d + station + '_l1_v1_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l2s[cutIdx:],k2s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
    plt.xlim([min(l2s), max(l2s)])
    plt.ylim([min(k2s), max(k2s)])
    plt.xlabel('Layer 2 Thickness')
    plt.ylabel('Layer 2 Vp/Vs')
    plt.title('Layer 2: Thickness vs Vp/Vs')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l2,k2,s=25, color='tomato',marker="*")
    plt.savefig(d + station + '_l2_h2_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l2s[cutIdx:],vp2s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
    plt.xlim([min(l2s), max(l2s)])
    plt.ylim([min(vp2s), max(vp2s)])
    plt.xlabel('Layer 2 Thickness')
    plt.ylabel('Layer 2 Vp')
    plt.title('Layer 2: Thickness vs Vp')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l2,vp2,s=25, color='tomato',marker="*")
    plt.savefig(d + station + '_l2_v2_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    if nlayers >= 3:
        plt.scatter(l3s[cutIdx:],k3s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
        plt.xlim([min(l3s), max(l3s)])
        plt.ylim([min(k3s), max(k3s)])
        plt.xlabel('Layer 3 Thickness')
        plt.ylabel('Layer 3 Vp/Vs')
        plt.title('Layer 3: Thickness vs Vp/Vs')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l3,k3,s=25, color='tomato',marker="*")
        plt.savefig(d + station + '_l3_h3_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
        plt.scatter(l3s[cutIdx:],vp3s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
        plt.xlim([min(l3s), max(l3s)])
        plt.ylim([min(vp3s), max(vp3s)])
        plt.xlabel('Layer 3 Thickness')
        plt.ylabel('Layer 3 Vp')
        plt.title('Layer 3: Thickness vs Vp')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l3,vp3,s=25, color='tomato',marker="*")
        plt.savefig(d + station + '_l3_v3_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers >= 4:
        plt.scatter(l4s[cutIdx:],k4s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
        plt.xlim([min(l4s), max(l4s)])
        plt.ylim([min(k4s), max(k4s)])
        plt.xlabel('Layer 4 Thickness')
        plt.ylabel('Layer 4 Vp/Vs')
        plt.title('Layer 4: Thickness vs Vp/Vs')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l4,k4,s=25, color='tomato',marker="*")
        plt.savefig(d + station + '_l4_h4_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
        plt.scatter(l4s[cutIdx:],vp4s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
        plt.xlim([min(l4s), max(l4s)])
        plt.ylim([min(vp4s), max(vp4s)])
        plt.xlabel('Layer 4 Thickness')
        plt.ylabel('Layer 4 Vp')
        plt.title('Layer 4: Thickness vs Vp')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l4,vp4,s=25, color='tomato',marker="*")
        plt.savefig(d + station + '_l4_v4_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers == 5:
        #plot up search history with costs on 2D plots
        plt.scatter(l5s[cutIdx:],k5s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
        plt.xlim([min(l5s), max(l5s)])
        plt.ylim([min(k5s), max(k5s)])
        plt.xlabel('Layer 5 Thickness')
        plt.ylabel('Layer 5 Vp/Vs')
        plt.title('Layer 5: Thickness vs Vp/Vs')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l5,k5,s=25, color='tomato',marker="*")
        plt.savefig(d + station + '_l5_h5_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
        plt.scatter(l5s[cutIdx:],vp5s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
        plt.xlim([min(l5s), max(l5s)])
        plt.ylim([min(vp5s), max(vp5s)])
        plt.xlabel('Layer 5 Thickness')
        plt.ylabel('Layer 5 Vp')
        plt.title('Layer 5: Thickness vs Vp')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l5,vp5,s=25, color='tomato',marker="*")
        plt.savefig(d + station + '_l5_v5_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    plt.scatter(l1s[cutIdx:],l2s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
    plt.xlim([min(l1s), max(l1s)])
    plt.ylim([min(l2s), max(l2s)])
    plt.xlabel('Layer 1 Thickness')
    plt.ylabel('Layer 2 Thickness')
    plt.title('Layer 1 Thickness vs Layer 2 Thickness')
    cbar = plt.colorbar()
    #cbar.ax.set_ylim(.4, 1.1)
    cbar.set_label('Misfit')
    plt.scatter(l1,l2,s=25, color='tomato',marker="*")
    plt.savefig(d + station + '_layers12_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    if nlayers >= 3:
        plt.scatter(l2s[cutIdx:],l3s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
        plt.xlim([min(l2s), max(l2s)])
        plt.ylim([min(l3s), max(l3s)])
        plt.xlabel('Layer 2 Thickness')
        plt.ylabel('Layer 3 Thickness')
        plt.title('Layer 2 Thickness vs Layer 3 Thickness')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l2,l3,s=25, color='tomato',marker="*")
        plt.savefig(d + station + '_layers23_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers >= 4:
        plt.scatter(l3s[cutIdx:],l4s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
        plt.xlim([min(l3s), max(l3s)])
        plt.ylim([min(l4s), max(l4s)])
        plt.xlabel('Layer 3 Thickness')
        plt.ylabel('Layer 4 Thickness')
        plt.title('Layer 3 Thickness vs Layer 4 Thickness')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l3,l4,s=25, color='tomato',marker="*")
        plt.savefig(d + station + '_layers34_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers == 5:
        plt.scatter(l4s[cutIdx:],l5s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
        plt.xlim([min(l4s), max(l4s)])
        plt.ylim([min(l5s), max(l5s)])
        plt.xlabel('Layer 4 Thickness')
        plt.ylabel('Layer 5 Thickness')
        plt.title('Layer 4 Thickness vs Layer 5 Thickness')
        cbar = plt.colorbar()
        #cbar.ax.set_ylim(.4, 1.1)
        cbar.set_label('Misfit')
        plt.scatter(l4,l5,s=25, color='tomato',marker="*")
        plt.savefig(d + station + '_layers45_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
def plotSol_subset_density(d,station,bestCost,bestPos,costs_localMin=[],positions=[],costs=[],nlayers=4,plotCutoff=5, writeCSV=True):
    
    '''
    Iterates through search history and plots search positions/costs for analysis.
    Also writes out solutions into a .csv file. Use this function for a searched Vp.
    
    
    d is the input directory
    dOut is the output directory
    stations is the stations list, in format: ['s1','s2']. Should match names of stations in bin folder

    plotCutoff sets the cost value cutoff to plot
    
    '''
    
    client = Client('IRIS')
    
    print('Plotting Searches: ' + station)
    
    #get location of station via IRIS client
    if 'BS.' in station or 'BS-' in station:
        if 'RLOK' in station:
            stn = client.get_stations(network='OK', station='RLOK', format='xml', level='channel')
        elif 'U40' in station:
            stn = client.get_stations(network='TA', station='U40A', format='xml', level='channel')
        elif 'X40' in station:
            stn = client.get_stations(network='TA', station='X40A', format='xml', level='channel')
        elif 'Z38' in station:
            stn = client.get_stations(network='TA', station='Z38A', format='xml', level='channel')
        elif 'U38' in station:
            stn = client.get_stations(network='TA', station='U38A', format='xml', level='channel')
        elif 'X37' in station:
            stn = client.get_stations(network='TA', station='X37A', format='xml', level='channel')
        elif 'Z41' in station:
            stn = client.get_stations(network='TA', station='Z41A', format='xml', level='channel')
        elif '140' in station:
            stn = client.get_stations(network='TA', station='140A', format='xml', level='channel')
        elif '441' in station:
            stn = client.get_stations(network='TA', station='441A', format='xml', level='channel')
        elif 'HNVL' in station:
            stn = client.get_stations(network='TA', station='438A', format='xml', level='channel')
        elif 'MANK' in station:
            stn = client.get_stations(network='XI', station='MANK', format='xml', level='channel')
        elif 'JAFL' in station:
            stn = client.get_stations(network='XI', station='JAFL', format='xml', level='channel')
        elif 'MPUR' in station:
            stn = client.get_stations(network='XI', station='MPUR', format='xml', level='channel')
            
    else:    
        stn = client.get_stations(network=station.replace('-','.').split('.')[0], station=station.replace('-','.').split('.')[1], format='xml', level='channel')
    
    '''
    #load in solutions and search history
    sols = pickle.load(open(d + station + '.p','rb'))
    [pos_history, cost_history, bounds, options, [wR, wZ, wRC]] = pickle.load(open(d + station + '_optimizer.p','rb'))
    kwargs = pickle.load(open(d + station + '_kwargs.p','rb'))
    '''
    
    #best solution for each parameter
    if nlayers == 5:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = bestPos[3]
        l5 = bestPos[4]
        k1 = bestPos[10]
        k2 = bestPos[11]
        k3 = bestPos[12]
        k4 = bestPos[13]
        k5 = bestPos[14]
        vp1 = bestPos[5]
        vp2 = bestPos[6]
        vp3 = bestPos[7]
        vp4 = bestPos[8]
        vp5 = bestPos[9]
        
    elif nlayers == 4:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = bestPos[3]
        l5 = 0
        k1 = bestPos[8]
        k2 = bestPos[9]
        k3 = bestPos[10]
        k4 = bestPos[11]
        k5 = 0
        vp1 = bestPos[4]
        vp2 = bestPos[5]
        vp3 = bestPos[6]
        vp4 = bestPos[7]
        vp5 = 0
        
    elif nlayers == 3:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = 0
        l5 = 0
        k1 = bestPos[6]
        k2 = bestPos[7]
        k3 = bestPos[8]
        k4 = 0
        k5 = 0
        vp1 = bestPos[3]
        vp2 = bestPos[4]
        vp3 = bestPos[5]
        vp4 = 0
        vp5 = 0
    elif nlayers == 2:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = 0
        l4 = 0
        l5 = 0
        k1 = bestPos[4]
        k2 = bestPos[5]
        k3 = 0
        k4 = 0
        k5 = 0
        vp1 = bestPos[2]
        vp2 = bestPos[3]
        vp3 = 0
        vp4 = 0
        vp5 = 0
    
    if writeCSV == True:
        m = l1 + l2 + l3 + l4 + l5
        bestSol = [station,stn[0][0].latitude,stn[0][0].longitude,str(round(bestCost,2)),str(round(l1,2)),str(round(vp1,2)),str(round(k1,2)),str(round(l2,2)),str(round(vp2,2)),str(round(k2,2)),str(round(l3,2)),str(round(vp3,2)),str(round(k3,2)),str(round(l4,2)),str(round(vp4,2)),str(round(k4,2)),str(round(l4,2)),str(round(vp4,2)),str(round(k4,2)),str(round(m,2))]
        
        with open(d +'bestSols.csv','a') as f:
            write = csv.writer(f)
            write.writerow(bestSol)       
    
    theta = []
    l1s = []
    l2s = []
    l3s = []
    l4s = []
    l5s = []
    vp1s = []
    vp2s = []
    vp3s = []
    vp4s = []
    vp5s = []
    k1s = []
    k2s = []
    k3s = []
    k4s = []
    k5s = []
    
    thetas = []
    
    # Using readlines()
    allSearches = d + station.replace('-','.') + '.txt'
    file1 = open(allSearches, 'r')
    Lines = file1.readlines()
 
    linesSorted = [x for y, x in sorted(zip(costs, Lines))]
    costs = sorted(costs)
    
    linesSorted.reverse()
    costs.reverse()
    
    count = 0
    for line in linesSorted:
        count += 1
        #print("Line{}: {}".format(count, line.strip()))
        if nlayers == 5:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),float(thetaStr[3]),float(thetaStr[4]), \
                float(thetaStr[5]),float(thetaStr[6]),float(thetaStr[7]),float(thetaStr[8]),float(thetaStr[9]), \
                    float(thetaStr[10]),float(thetaStr[11]),float(thetaStr[12]),float(thetaStr[13]),float(thetaStr[14])
            
            thetas.append(theta)     
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            l4s.append(theta[3])
            l5s.append(theta[4])
            
            vp1s.append(theta[5])
            vp2s.append(theta[6])
            vp3s.append(theta[7])
            vp4s.append(theta[8])
            vp5s.append(theta[9])
            
            k1s.append(theta[10])
            k2s.append(theta[11])
            k3s.append(theta[12])
            k4s.append(theta[13])
            k5s.append(theta[14])
            
        elif nlayers == 4:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),float(thetaStr[3]),\
                float(thetaStr[4]),float(thetaStr[5]),float(thetaStr[6]),float(thetaStr[7]),\
                    float(thetaStr[8]),float(thetaStr[9]),float(thetaStr[10]),float(thetaStr[11])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            l4s.append(theta[3])
            
            vp1s.append(theta[4])
            vp2s.append(theta[5])
            vp3s.append(theta[6])
            vp4s.append(theta[7])
            
            k1s.append(theta[8])
            k2s.append(theta[9])
            k3s.append(theta[10])
            k4s.append(theta[11])
            
        elif nlayers == 3:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),\
                float(thetaStr[3]),float(thetaStr[4]),float(thetaStr[5]),\
                    float(thetaStr[6]),float(thetaStr[7]),float(thetaStr[8])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            
            vp1s.append(theta[3])
            vp2s.append(theta[4])
            vp3s.append(theta[5])
            
            k1s.append(theta[6])
            k2s.append(theta[7])
            k3s.append(theta[8])
        
        elif nlayers == 2:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),\
                float(thetaStr[2]),float(thetaStr[3]),\
                    float(thetaStr[4]),float(thetaStr[5])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            
            vp1s.append(theta[2])
            vp2s.append(theta[3])
            
            k1s.append(theta[4])
            k2s.append(theta[5])
    
    l1_loc = []
    l2_loc = []
    l3_loc = []
    l4_loc = []
    l5_loc = []
    vp1_loc = []
    vp2_loc = []
    vp3_loc = []
    vp4_loc = []
    vp5_loc = []
    k1_loc = []
    k2_loc = []
    k3_loc = []
    k4_loc = []
    k5_loc = []
    
    for p in positions:
        if nlayers == 5:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            l4_loc.append(p[3])
            l5_loc.append(p[4])
            
            vp1_loc.append(p[5])
            vp2_loc.append(p[6])
            vp3_loc.append(p[7])
            vp4_loc.append(p[8])
            vp5_loc.append(p[9])
            
            k1_loc.append(p[10])
            k2_loc.append(p[11])
            k3_loc.append(p[12])
            k4_loc.append(p[13])
            k5_loc.append(p[14])
            
        elif nlayers == 4:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            l4_loc.append(p[3])
            
            vp1_loc.append(p[4])
            vp2_loc.append(p[5])
            vp3_loc.append(p[6])
            vp4_loc.append(p[7])
            
            k1_loc.append(p[8])
            k2_loc.append(p[9])
            k3_loc.append(p[10])
            k4_loc.append(p[11])
            
        elif nlayers == 3:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            
            vp1_loc.append(p[3])
            vp2_loc.append(p[4])
            vp3_loc.append(p[5])
            
            k1_loc.append(p[6])
            k2_loc.append(p[7])
            k3_loc.append(p[8])
            
        elif nlayers == 2:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            
            vp1_loc.append(p[2])
            vp2_loc.append(p[3])
            
            k1_loc.append(p[4])
            k2_loc.append(p[5])
            
    
    cutoff= max(costs)-((max(costs)-min(costs))*((100-plotCutoff)/100))
    cutIdx = costs.index(costs[min(range(len(costs)), key = lambda i: abs(costs[i]-cutoff))])
    
    #plot up search history with costs on 2D plots
    #pdb.set_trace()
    #xy = np.vstack([l1s[cutIdx:],k1s[cutIdx:]])
    #z = gaussian_kde(xy)(xy)
    
    #plt.scatter(l1s[cutIdx:], k1s[cutIdx:], s=100)
    
    #plt.scatter(l1s[cutIdx:],k1s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
    plt.scatter(l1,k1,s=25, color='tomato',marker="*")
    sns.kdeplot(x=l1s[cutIdx:], y=k1s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
    plt.scatter(l1,k1,s=25, color='tomato',marker="*")
    plt.xlim([min(l1s), max(l1s)])
    plt.ylim([min(k1s), max(k1s)])
    plt.xlabel('Layer 1 Thickness')
    plt.ylabel('Layer 1 Vp/Vs')
    plt.title('Layer 1: Thickness vs Vp/Vs')
    plt.savefig(d + station + '_l1_k1_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    #plt.scatter(l1s[cutIdx:],vp1s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
    plt.scatter(l1,vp1,s=25, color='tomato',marker="*")
    sns.kdeplot(x=l1s[cutIdx:], y=vp1s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
    plt.scatter(l1,vp1,s=25, color='tomato',marker="*")
    plt.xlim([min(l1s), max(l1s)])
    plt.ylim([min(vp1s), max(vp1s)])
    plt.xlabel('Layer 1 Thickness')
    plt.ylabel('Layer 1 Vp')
    plt.title('Layer 1: Thickness vs Vp')
    plt.savefig(d + station + '_l1_v1_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l2,k2,s=25, color='tomato',marker="*")
    sns.kdeplot(x=l2s[cutIdx:], y=k2s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
    plt.scatter(l2,k2,s=25, color='tomato',marker="*")
    plt.xlim([min(l2s), max(l2s)])
    plt.ylim([min(k2s), max(k2s)])
    plt.xlabel('Layer 2 Thickness')
    plt.ylabel('Layer 2 Vp/Vs')
    plt.title('Layer 2: Thickness vs Vp/Vs')
    plt.savefig(d + station + '_l2_h2_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    plt.scatter(l2,vp2,s=25, color='tomato',marker="*")
    sns.kdeplot(x=l2s[cutIdx:], y=vp2s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
    plt.scatter(l2,vp2,s=25, color='tomato',marker="*")
    plt.xlim([min(l2s), max(l2s)])
    plt.ylim([min(vp2s), max(vp2s)])
    plt.xlabel('Layer 2 Thickness')
    plt.ylabel('Layer 2 Vp')
    plt.title('Layer 2: Thickness vs Vp')
    plt.savefig(d + station + '_l2_v2_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    if nlayers >= 3:
        plt.scatter(l3,k3,s=25, color='tomato',marker="*")
        sns.kdeplot(x=l3s[cutIdx:], y=k3s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
        plt.scatter(l3,k3,s=25, color='tomato',marker="*")
        plt.xlim([min(l3s), max(l3s)])
        plt.ylim([min(k3s), max(k3s)])
        plt.xlabel('Layer 3 Thickness')
        plt.ylabel('Layer 3 Vp/Vs')
        plt.title('Layer 3: Thickness vs Vp/Vs')
        plt.savefig(d + station + '_l3_h3_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
        plt.scatter(l3,vp3,s=25, color='tomato',marker="*")
        sns.kdeplot(x=l3s[cutIdx:], y=vp3s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
        plt.scatter(l3,vp3,s=25, color='tomato',marker="*")
        plt.xlim([min(l3s), max(l3s)])
        plt.ylim([min(vp3s), max(vp3s)])
        plt.xlabel('Layer 3 Thickness')
        plt.ylabel('Layer 3 Vp')
        plt.title('Layer 3: Thickness vs Vp')
        plt.savefig(d + station + '_l3_v3_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers >= 4:
        plt.scatter(l4,k4,s=25, color='tomato',marker="*")
        sns.kdeplot(x=l4s[cutIdx:], y=k4s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
        plt.scatter(l4,k4,s=25, color='tomato',marker="*")
        plt.xlim([min(l4s), max(l4s)])
        plt.ylim([min(k4s), max(k4s)])
        plt.xlabel('Layer 4 Thickness')
        plt.ylabel('Layer 4 Vp/Vs')
        plt.title('Layer 4: Thickness vs Vp/Vs')
        plt.savefig(d + station + '_l4_h4_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
        plt.scatter(l4,vp4,s=25, color='tomato',marker="*")
        sns.kdeplot(x=l4s[cutIdx:], y=vp4s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
        plt.scatter(l4,vp4,s=25, color='tomato',marker="*")
        plt.xlim([min(l4s), max(l4s)])
        plt.ylim([min(vp4s), max(vp4s)])
        plt.xlabel('Layer 4 Thickness')
        plt.ylabel('Layer 4 Vp')
        plt.title('Layer 4: Thickness vs Vp')
        plt.savefig(d + station + '_l4_v4_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers == 5:
        #plot up search history with costs on 2D plots
        plt.scatter(l5,k5,s=25, color='tomato',marker="*")
        sns.kdeplot(x=l5s[cutIdx:], y=k5s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
        plt.scatter(l5,k5,s=25, color='tomato',marker="*")
        plt.xlim([min(l5s), max(l5s)])
        plt.ylim([min(k5s), max(k5s)])
        plt.xlabel('Layer 5 Thickness')
        plt.ylabel('Layer 5 Vp/Vs')
        plt.title('Layer 5: Thickness vs Vp/Vs')
        plt.savefig(d + station + '_l5_h5_PSO.png', dpi=300)
        #plt.show()
        plt.close()
        
        plt.scatter(l5,vp5,s=25, color='tomato',marker="*")
        sns.kdeplot(x=l5s[cutIdx:], y=vp5s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
        plt.scatter(l5,vp5,s=25, color='tomato',marker="*")
        plt.xlim([min(l5s), max(l5s)])
        plt.ylim([min(vp5s), max(vp5s)])
        plt.xlabel('Layer 5 Thickness')
        plt.ylabel('Layer 5 Vp')
        plt.title('Layer 5: Thickness vs Vp')
        plt.savefig(d + station + '_l5_v5_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    plt.scatter(l1,l2,s=25, color='tomato',marker="*")
    sns.kdeplot(x=l1s[cutIdx:], y=l2s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
    plt.scatter(l1,l2,s=25, color='tomato',marker="*")
    plt.xlim([min(l1s), max(l1s)])
    plt.ylim([min(l2s), max(l2s)])
    plt.xlabel('Layer 1 Thickness')
    plt.ylabel('Layer 2 Thickness')
    plt.title('Layer 1 Thickness vs Layer 2 Thickness')
    plt.savefig(d + station + '_layers12_PSO.png', dpi=300)
    #plt.show()
    plt.close()
    
    if nlayers >= 3:
        plt.scatter(l2,l3,s=25, color='tomato',marker="*")
        sns.kdeplot(x=l2s[cutIdx:], y=l3s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
        plt.scatter(l2,l3,s=25, color='tomato',marker="*")
        plt.xlim([min(l2s), max(l2s)])
        plt.ylim([min(l3s), max(l3s)])
        plt.xlabel('Layer 2 Thickness')
        plt.ylabel('Layer 3 Thickness')
        plt.title('Layer 2 Thickness vs Layer 3 Thickness')
        plt.savefig(d + station + '_layers23_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers >= 4:
        plt.scatter(l3,l4,s=25, color='tomato',marker="*")
        sns.kdeplot(x=l3s[cutIdx:], y=l4s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
        plt.scatter(l3,l4,s=25, color='tomato',marker="*")
        plt.xlim([min(l3s), max(l3s)])
        plt.ylim([min(l4s), max(l4s)])
        plt.xlabel('Layer 3 Thickness')
        plt.ylabel('Layer 4 Thickness')
        plt.title('Layer 3 Thickness vs Layer 4 Thickness')
        plt.savefig(d + station + '_layers34_PSO.png', dpi=300)
        #plt.show()
        plt.close()
    
    if nlayers == 5:
        plt.scatter(l4,l5,s=25, color='tomato',marker="*")
        sns.kdeplot(x=l4s[cutIdx:], y=l5s[cutIdx:], cmap='Blues', fill=True, levels=4, thresh=0.001, cut=5)
        plt.scatter(l4,l5,s=25, color='tomato',marker="*")
        plt.xlim([min(l4s), max(l4s)])
        plt.ylim([min(l5s), max(l5s)])
        plt.xlabel('Layer 4 Thickness')
        plt.ylabel('Layer 5 Thickness')
        plt.title('Layer 4 Thickness vs Layer 5 Thickness')
        plt.savefig(d + station + '_layers45_PSO.png', dpi=300)
        #plt.show()
        plt.close()

def plotSol_Options(d,station,bestCost,bestPos,costs_localMin=[],positions=[],costs=[],nlayers=4, pointCutoff=5, cloudCutoff=1, writeCSV=True, cloud = False, drawEllipse=False, minMax_ofSubset=False, splitVariable=None, splitValue=0, splitVariable2=None, splitValue2=0, side='greater', plotMinMax=False):
    
    '''
    Iterates through search history and plots search positions/costs for analysis.
    Also writes out solutions into a .csv file. Use this function for a searched Vp.
    
    
    d is the input directory
    dOut is the output directory
    stations is the stations list, in format: ['s1','s2']. Should match names of stations in bin folder

    plotCutoff sets the cost value cutoff to plot
    
    '''
    
    client = Client('IRIS')
    
    print('Plotting Searches: ' + station)
    
    #get location of station via IRIS client
    if 'BS.' in station or 'BS-' in station:
        if 'RLOK' in station:
            stn = client.get_stations(network='OK', station='RLOK', format='xml', level='channel')
        elif 'U40' in station:
            stn = client.get_stations(network='TA', station='U40A', format='xml', level='channel')
        elif 'X40' in station:
            stn = client.get_stations(network='TA', station='X40A', format='xml', level='channel')
        elif 'Z38' in station:
            stn = client.get_stations(network='TA', station='Z38A', format='xml', level='channel')
        elif 'U38' in station:
            stn = client.get_stations(network='TA', station='U38A', format='xml', level='channel')
        elif 'X37' in station:
            stn = client.get_stations(network='TA', station='X37A', format='xml', level='channel')
        elif 'Z41' in station:
            stn = client.get_stations(network='TA', station='Z41A', format='xml', level='channel')
        elif '140' in station:
            stn = client.get_stations(network='TA', station='140A', format='xml', level='channel')
        elif '441' in station:
            stn = client.get_stations(network='TA', station='441A', format='xml', level='channel')
        elif 'HNVL' in station:
            stn = client.get_stations(network='TA', station='438A', format='xml', level='channel')
        elif 'MANK' in station:
            stn = client.get_stations(network='XI', station='MANK', format='xml', level='channel')
        elif 'JAFL' in station:
            stn = client.get_stations(network='XI', station='JAFL', format='xml', level='channel')
        elif 'MPUR' in station:
            stn = client.get_stations(network='XI', station='MPUR', format='xml', level='channel')
            
    else:    
        stn = client.get_stations(network=station.replace('-','.').split('.')[0], station=station.replace('-','.').split('.')[1], format='xml', level='channel')
    
    '''
    #load in solutions and search history
    sols = pickle.load(open(d + station + '.p','rb'))
    [pos_history, cost_history, bounds, options, [wR, wZ, wRC]] = pickle.load(open(d + station + '_optimizer.p','rb'))
    kwargs = pickle.load(open(d + station + '_kwargs.p','rb'))
    '''
    
    #best solution for each parameter
    if nlayers == 5:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = bestPos[3]
        l5 = bestPos[4]
        k1 = bestPos[10]
        k2 = bestPos[11]
        k3 = bestPos[12]
        k4 = bestPos[13]
        k5 = bestPos[14]
        vp1 = bestPos[5]
        vp2 = bestPos[6]
        vp3 = bestPos[7]
        vp4 = bestPos[8]
        vp5 = bestPos[9]
        
    elif nlayers == 4:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = bestPos[3]
        l5 = 0
        k1 = bestPos[8]
        k2 = bestPos[9]
        k3 = bestPos[10]
        k4 = bestPos[11]
        k5 = 0
        vp1 = bestPos[4]
        vp2 = bestPos[5]
        vp3 = bestPos[6]
        vp4 = bestPos[7]
        vp5 = 0
        
    elif nlayers == 3:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = bestPos[2]
        l4 = 0
        l5 = 0
        k1 = bestPos[6]
        k2 = bestPos[7]
        k3 = bestPos[8]
        k4 = 0
        k5 = 0
        vp1 = bestPos[3]
        vp2 = bestPos[4]
        vp3 = bestPos[5]
        vp4 = 0
        vp5 = 0
    elif nlayers == 2:
        l1 = bestPos[0]
        l2 = bestPos[1]
        l3 = 0
        l4 = 0
        l5 = 0
        k1 = bestPos[4]
        k2 = bestPos[5]
        k3 = 0
        k4 = 0
        k5 = 0
        vp1 = bestPos[2]
        vp2 = bestPos[3]
        vp3 = 0
        vp4 = 0
        vp5 = 0
    
    if writeCSV == True:
        m = l1 + l2 + l3 + l4 + l5
        bestSol = [station,stn[0][0].latitude,stn[0][0].longitude,str(round(bestCost,2)),str(round(l1,2)),str(round(vp1,2)),str(round(k1,2)),str(round(l2,2)),str(round(vp2,2)),str(round(k2,2)),str(round(l3,2)),str(round(vp3,2)),str(round(k3,2)),str(round(l4,2)),str(round(vp4,2)),str(round(k4,2)),str(round(l4,2)),str(round(vp4,2)),str(round(k4,2)),str(round(m,2))]
        
        with open(d +'bestSols.csv','a') as f:
            write = csv.writer(f)
            write.writerow(bestSol)       
    
    theta = []
    l1s = []
    l2s = []
    l3s = []
    l4s = []
    l5s = []
    vp1s = []
    vp2s = []
    vp3s = []
    vp4s = []
    vp5s = []
    k1s = []
    k2s = []
    k3s = []
    k4s = []
    k5s = []
    
    thetas = []
    
    # Using readlines()
    allSearches = d + station.replace('-','.') + '.txt'
    file1 = open(allSearches, 'r')
    Lines = file1.readlines()
 
    linesSorted = [x for y, x in sorted(zip(costs, Lines))]
    costs = sorted(costs)
    
    linesSorted.reverse()
    costs.reverse()
    
    count = 0
    for line in linesSorted:
        count += 1
        #print("Line{}: {}".format(count, line.strip()))
        if nlayers == 5:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),float(thetaStr[3]),float(thetaStr[4]), \
                float(thetaStr[5]),float(thetaStr[6]),float(thetaStr[7]),float(thetaStr[8]),float(thetaStr[9]), \
                    float(thetaStr[10]),float(thetaStr[11]),float(thetaStr[12]),float(thetaStr[13]),float(thetaStr[14])
            
            thetas.append(theta)     
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            l4s.append(theta[3])
            l5s.append(theta[4])
            
            vp1s.append(theta[5])
            vp2s.append(theta[6])
            vp3s.append(theta[7])
            vp4s.append(theta[8])
            vp5s.append(theta[9])
            
            k1s.append(theta[10])
            k2s.append(theta[11])
            k3s.append(theta[12])
            k4s.append(theta[13])
            k5s.append(theta[14])
            
        elif nlayers == 4:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),float(thetaStr[3]),\
                float(thetaStr[4]),float(thetaStr[5]),float(thetaStr[6]),float(thetaStr[7]),\
                    float(thetaStr[8]),float(thetaStr[9]),float(thetaStr[10]),float(thetaStr[11])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            l4s.append(theta[3])
            l5s.append(0)
            
            vp1s.append(theta[4])
            vp2s.append(theta[5])
            vp3s.append(theta[6])
            vp4s.append(theta[7])
            vp5s.append(0)
            
            k1s.append(theta[8])
            k2s.append(theta[9])
            k3s.append(theta[10])
            k4s.append(theta[11])
            k5s.append(0)
            
        elif nlayers == 3:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),\
                float(thetaStr[3]),float(thetaStr[4]),float(thetaStr[5]),\
                    float(thetaStr[6]),float(thetaStr[7]),float(thetaStr[8])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(theta[2])
            l4s.append(0)
            l5s.append(0)
            
            vp1s.append(theta[3])
            vp2s.append(theta[4])
            vp3s.append(theta[5])
            vp4s.append(0)
            vp5s.append(0)
            
            k1s.append(theta[6])
            k2s.append(theta[7])
            k3s.append(theta[8])
            k4s.append(0)
            k5s.append(0)
        
        elif nlayers == 2:
            thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
            theta = float(thetaStr[0]),float(thetaStr[1]),\
                float(thetaStr[2]),float(thetaStr[3]),\
                    float(thetaStr[4]),float(thetaStr[5])
                
            thetas.append(theta)           
            l1s.append(theta[0])
            l2s.append(theta[1])
            l3s.append(0)
            l4s.append(0)
            l5s.append(0)
            
            vp1s.append(theta[2])
            vp2s.append(theta[3])
            vp3s.append(0)
            vp4s.append(0)
            vp5s.append(0)
            
            k1s.append(theta[4])
            k2s.append(theta[5])
            k3s.append(0)
            k4s.append(0)
            k5s.append(0)
    
    l1_loc = []
    l2_loc = []
    l3_loc = []
    l4_loc = []
    l5_loc = []
    vp1_loc = []
    vp2_loc = []
    vp3_loc = []
    vp4_loc = []
    vp5_loc = []
    k1_loc = []
    k2_loc = []
    k3_loc = []
    k4_loc = []
    k5_loc = []
    
    for p in positions:
        if nlayers == 5:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            l4_loc.append(p[3])
            l5_loc.append(p[4])
            
            vp1_loc.append(p[5])
            vp2_loc.append(p[6])
            vp3_loc.append(p[7])
            vp4_loc.append(p[8])
            vp5_loc.append(p[9])
            
            k1_loc.append(p[10])
            k2_loc.append(p[11])
            k3_loc.append(p[12])
            k4_loc.append(p[13])
            k5_loc.append(p[14])
            
        elif nlayers == 4:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            l4_loc.append(p[3])
            
            vp1_loc.append(p[4])
            vp2_loc.append(p[5])
            vp3_loc.append(p[6])
            vp4_loc.append(p[7])
            
            k1_loc.append(p[8])
            k2_loc.append(p[9])
            k3_loc.append(p[10])
            k4_loc.append(p[11])
            
        elif nlayers == 3:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            l3_loc.append(p[2])
            
            vp1_loc.append(p[3])
            vp2_loc.append(p[4])
            vp3_loc.append(p[5])
            
            k1_loc.append(p[6])
            k2_loc.append(p[7])
            k3_loc.append(p[8])
            
        elif nlayers == 2:
            l1_loc.append(p[0])
            l2_loc.append(p[1])
            
            vp1_loc.append(p[2])
            vp2_loc.append(p[3])
            
            k1_loc.append(p[4])
            k2_loc.append(p[5])
            
    # old definition for cutoff
    #cutoff= max(costs)-((max(costs)-min(costs))*((100-pointCutoff)/100))
    
    # new definiton for cutoff
    cutoff = min(costs) * (100/(100-pointCutoff))
    
    cutIdx = costs.index(costs[min(range(len(costs)), key = lambda i: abs(costs[i]-cutoff))])
    
    #old definition for cutoff for cutoff
    #cutoff_cloud= max(costs)-((max(costs)-min(costs))*((100-cloudCutoff)/100))
    
    # new definiton for cutoff
    cutoff_cloud = min(costs) * (100/(100-cloudCutoff))
    cutIdx_cloud = costs.index(costs[min(range(len(costs)), key = lambda i: abs(costs[i]-cutoff_cloud))])
    
    l1s_minMax = []
    k1s_minMax = []
    v1s_minMax = []
    
    l2s_minMax = []
    k2s_minMax = []
    v2s_minMax = []
    
    l3s_minMax = []
    k3s_minMax = []
    v3s_minMax = []
    
    l4s_minMax = []
    k4s_minMax = []
    v4s_minMax = []
    
    l5s_minMax = []
    k5s_minMax = []
    v5s_minMax = []
    
    if minMax_ofSubset:
        splitVariable_use = locals()[splitVariable]
        
        if splitVariable2 != None:
            splitVariable2_use = locals()[splitVariable2]
            
        for i in range(len(splitVariable_use[cutIdx_cloud:])):
            
            if splitVariable_use[cutIdx_cloud:][i] < splitValue:
                
                if splitVariable2 != None:
                    if splitVariable2_use[cutIdx_cloud:][i] < splitValue2:
                        check2 = True
                    else:
                        check2 = False
                    
                else:
                    check2 = True
                    
                if check2 == True:
                    l1s_minMax.append(l1s[cutIdx_cloud:][i])
                    k1s_minMax.append(k1s[cutIdx_cloud:][i])
                    v1s_minMax.append(vp1s[cutIdx_cloud:][i])
                    
                    if nlayers >= 2:
                        l2s_minMax.append(l2s[cutIdx_cloud:][i])
                        k2s_minMax.append(k2s[cutIdx_cloud:][i])
                        v2s_minMax.append(vp2s[cutIdx_cloud:][i])
                    else:
                        l2s_minMax.append(0)
                        k2s_minMax.append(0)
                        v2s_minMax.append(0)
                        
                    if nlayers >= 3:
                        l3s_minMax.append(l3s[cutIdx_cloud:][i])
                        k3s_minMax.append(k3s[cutIdx_cloud:][i])
                        v3s_minMax.append(vp3s[cutIdx_cloud:][i])
                    else:
                        l3s_minMax.append(0)
                        k3s_minMax.append(0)
                        v3s_minMax.append(0)
                        
                    if nlayers >= 4:
                        l4s_minMax.append(l4s[cutIdx_cloud:][i])
                        k4s_minMax.append(k4s[cutIdx_cloud:][i])
                        v4s_minMax.append(vp4s[cutIdx_cloud:][i])
                    else:
                        l4s_minMax.append(0)
                        k4s_minMax.append(0)
                        v4s_minMax.append(0)
                        
                    if nlayers >= 5:
                        l5s_minMax.append(l5s[cutIdx_cloud:][i])
                        k5s_minMax.append(k5s[cutIdx_cloud:][i])
                        v5s_minMax.append(vp5s[cutIdx_cloud:][i])
                    else:
                        l5s_minMax.append(0)
                        k5s_minMax.append(0)
                        v5s_minMax.append(0)
    
    #plot up search history with costs on 2D plots
    #pdb.set_trace()
    #xy = np.vstack([l1s[cutIdx:],k1s[cutIdx:]])
    #z = gaussian_kde(xy)(xy)
    
    #plt.scatter(l1s[cutIdx:], k1s[cutIdx:], s=100)
    
    #plt.scatter(l1s[cutIdx:],k1s[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
    l1_std = np.std(l1s[cutIdx_cloud:])
    k1_std = np.std(k1s[cutIdx_cloud:])
    v1_std = np.std(vp1s[cutIdx_cloud:])
    
    #set up dummy values for std so the csv writer doesn't break
    l2_std = 0
    k2_std = 0
    v2_std = 0
    
    l3_std = 0
    k3_std = 0
    v3_std = 0
    
    l4_std = 0
    k4_std = 0
    v4_std = 0
    
    l5_std = 0
    k5_std = 0
    v5_std = 0
    
    plotMisfits(l1s,k1s,l1,k1,costs,cutIdx,cutIdx_cloud,'_l1_k1_BH.png',cloud,drawEllipse,d,station,'Layer 1 Thickness','Layer 1 Vp/Vs','Layer 1: Thickness vs Vp/Vs',plotMinMax,l1s_minMax,k1s_minMax)
    plotMisfits(l1s,vp1s,l1,vp1,costs,cutIdx,cutIdx_cloud,'_l1_v1_BH.png',cloud,drawEllipse,d,station,'Layer 1 Thickness','Layer 1 Vp/Vs','Layer 1: Thickness vs Vp',plotMinMax,l1s_minMax,v1s_minMax)
    
    l2_std = np.std(l2s[cutIdx_cloud:])
    k2_std = np.std(k2s[cutIdx_cloud:])
    v2_std = np.std(vp2s[cutIdx_cloud:])
    
    plotMisfits(l2s,k2s,l2,k2,costs,cutIdx,cutIdx_cloud,'_l2_h2_BH.png',cloud,drawEllipse,d,station,'Layer 2 Thickness','Layer 2 Vp/Vs','Layer 2: Thickness vs Vp/Vs',plotMinMax,l2s_minMax,k2s_minMax)
    plotMisfits(l2s,vp2s,l2,vp2,costs,cutIdx,cutIdx_cloud,'_l2_v2_BH.png',cloud,drawEllipse,d,station,'Layer 2 Thickness','Layer 2 Vp','Layer 2: Thickness vs Vp',plotMinMax,l2s_minMax,v2s_minMax)
    
    if nlayers >= 3:
        l3_std = np.std(l3s[cutIdx_cloud:])
        k3_std = np.std(k3s[cutIdx_cloud:])
        v3_std = np.std(vp3s[cutIdx_cloud:])
        
        plotMisfits(l3s,k3s,l3,k3,costs,cutIdx,cutIdx_cloud,'_l3_h3_BH.png',cloud,drawEllipse,d,station,'Layer 3 Thickness','Layer 3 Vp/Vs','Layer 3: Thickness vs Vp/Vs',plotMinMax,l3s_minMax,k3s_minMax)
        plotMisfits(l3s,vp3s,l3,vp3,costs,cutIdx,cutIdx_cloud,'_l3_v3_BH.png',cloud,drawEllipse,d,station,'Layer 3 Thickness','Layer 3 Vp','Layer 3: Thickness vs Vp',plotMinMax,l3s_minMax,v3s_minMax)
    
    if nlayers >= 4:
        l4_std = np.std(l4s[cutIdx_cloud:])
        k4_std = np.std(k4s[cutIdx_cloud:])
        v4_std = np.std(vp4s[cutIdx_cloud:])
        
        plotMisfits(l4s,k4s,l4,k4,costs,cutIdx,cutIdx_cloud,'_l4_h4_BH.png',cloud,drawEllipse,d,station,'Layer 4 Thickness','Layer 4 Vp/Vs','Layer 4: Thickness vs Vp/Vs',plotMinMax,l4s_minMax,k4s_minMax)
        plotMisfits(l4s,vp4s,l4,vp4,costs,cutIdx,cutIdx_cloud,'_l4_v4_BH.png',cloud,drawEllipse,d,station,'Layer 4 Thickness','Layer 4 Vp','Layer 4: Thickness vs Vp',plotMinMax,l4s_minMax,v4s_minMax)
    
    if nlayers == 5:
        l5_std = np.std(l5s[cutIdx_cloud:])
        k5_std = np.std(k5s[cutIdx_cloud:])
        v5_std = np.std(vp5s[cutIdx_cloud:])
        
        plotMisfits(l5s,k5s,l5,k5,costs,cutIdx,cutIdx_cloud,'_l5_h5_BH.png',cloud,drawEllipse,d,station,'Layer 5 Thickness','Layer 5 Vp/Vs','Layer 5: Thickness vs Vp/Vs',plotMinMax,l5s_minMax,k5s_minMax)
        plotMisfits(l5s,vp5s,l5,vp5,costs,cutIdx,cutIdx_cloud,'_l5_v5_BH.png',cloud,drawEllipse,d,station,'Layer 5 Thickness','Layer 5 Vp','Layer 5: Thickness vs Vp',plotMinMax,l5s_minMax,v5s_minMax)
        
    plotMisfits(l1s,l2s,l1,l2,costs,cutIdx,cutIdx_cloud,'_layers12_BH.png',cloud,drawEllipse,d,station,'Layer 1 Thickness','Layer 2 Thickness','Layer 1 Thickness vs Layer 2 Thickness',plotMinMax,l1s_minMax,l2s_minMax)
    
    if nlayers >= 3:
        plotMisfits(l2s,l3s,l2,l3,costs,cutIdx,cutIdx_cloud,'_layers23_BH.png',cloud,drawEllipse,d,station,'Layer 2 Thickness','Layer 3 Thickness','Layer 2 Thickness vs Layer 3 Thickness',plotMinMax,l2s_minMax,l3s_minMax)
    
    if nlayers >= 4:
        plotMisfits(l3s,l4s,l3,l4,costs,cutIdx,cutIdx_cloud,'_layers34_BH.png',cloud,drawEllipse,d,station,'Layer 3 Thickness','Layer 4 Thickness','Layer 3 Thickness vs Layer 4 Thickness',plotMinMax,l3s_minMax,l4s_minMax)
    
    if nlayers == 5:
        plotMisfits(l4s,l5s,l4,l5,costs,cutIdx,cutIdx_cloud,'_layers45_BH.png',cloud,drawEllipse,d,station,'Layer 4 Thickness','Layer 5 Thickness','Layer 4 Thickness vs Layer 5 Thickness',plotMinMax,l4s_minMax,l5s_minMax)
        
    #pdb.set_trace()
    if writeCSV == True:
        m = l1 + l2 + l3 + l4 + l5
        bestSol_std = [station,stn[0][0].latitude,stn[0][0].longitude,str(round(bestCost,2)),str(round(l1,2)),str(round(l1_std,2)), \
                   str(round(vp1,2)),str(round(v1_std,2)),str(round(k1,2)),str(round(k1_std,2)),str(round(l2,2)),str(round(l2_std,2)), \
                       str(round(vp2,2)),str(round(v2_std,2)),str(round(k2,2)),str(round(k2_std,2)),str(round(l3,2)),str(round(l3_std,2)), \
                           str(round(vp3,2)),str(round(v3_std,2)),str(round(k3,2)),str(round(k3_std,2)),str(round(l4,2)),str(round(l4_std,2)), \
                               str(round(vp4,2)),str(round(v4_std,2)),str(round(k4,2)),str(round(k4_std,2)),str(round(l5,2)),str(round(l5_std,2)), \
                                   str(round(vp5,2)),str(round(v5_std,2)),str(round(k5,2)),str(round(v5_std,2)),str(round(m,2))]
        
        with open(d +'bestSols_std.csv','a') as f:
            write = csv.writer(f)
            write.writerow(bestSol_std)     
        
        if minMax_ofSubset:
            bestSol_minMax = [station,stn[0][0].latitude,stn[0][0].longitude,str(round(bestCost,2)),str(round(l1,2)),str(round(min(l1s_minMax),2)),str(round(max(l1s_minMax),2)), \
                       str(round(vp1,2)),str(round(min(v1s_minMax),2)),str(round(max(v1s_minMax),2)),str(round(k1,2)),str(round(min(k1s_minMax),2)),str(round(max(k1s_minMax),2)), \
                           str(round(l2,2)),str(round(min(l2s_minMax),2)),str(round(max(l2s_minMax),2)), \
                           str(round(vp2,2)),str(round(min(v2s_minMax),2)),str(round(max(v2s_minMax),2)),str(round(k2,2)),str(round(min(k2s_minMax),2)),str(round(max(k2s_minMax),2)), \
                               str(round(l3,2)), str(round(min(l3s_minMax),2)),str(round(max(l3s_minMax),2)), \
                               str(round(vp3,2)),str(round(min(v3s_minMax),2)),str(round(max(v3s_minMax),2)),str(round(k3,2)),str(round(min(k3s_minMax),2)),str(round(max(k3s_minMax),2)), \
                                   str(round(l4,2)),str(round(min(l4s_minMax),2)),str(round(max(l4s_minMax),2)), \
                                   str(round(vp4,2)),str(round(min(v4s_minMax),2)),str(round(max(v4s_minMax),2)),str(round(k4,2)),str(round(min(k4s_minMax),2)),str(round(max(k4s_minMax),2)), \
                                       str(round(l5,2)),str(round(min(l5s_minMax),2)),str(round(max(l5s_minMax),2)), \
                                       str(round(vp5,2)),str(round(min(v5s_minMax),2)),str(round(max(v5s_minMax),2)),str(round(k5,2)),str(round(min(k5s_minMax),2)),str(round(max(k5s_minMax),2)),str(round(m,2))]
        else:
            bestSol_minMax = [station,stn[0][0].latitude,stn[0][0].longitude,str(round(bestCost,2)),str(round(l1,2)),str(round(min(l1s[cutIdx_cloud:]),2)),str(round(max(l1s[cutIdx_cloud:]),2)), \
                       str(round(vp1,2)),str(round(min(vp1s[cutIdx_cloud:]),2)),str(round(max(vp1s[cutIdx_cloud:]),2)),str(round(k1,2)),str(round(min(k1s[cutIdx_cloud:]),2)),str(round(max(k1s[cutIdx_cloud:]),2)), \
                           str(round(l2,2)),str(round(min(l2s[cutIdx_cloud:]),2)),str(round(max(l2s[cutIdx_cloud:]),2)), \
                           str(round(vp2,2)),str(round(min(vp2s[cutIdx_cloud:]),2)),str(round(max(vp2s[cutIdx_cloud:]),2)),str(round(k2,2)),str(round(min(k2s[cutIdx_cloud:]),2)),str(round(max(k2s[cutIdx_cloud:]),2)), \
                               str(round(l3,2)), str(round(min(l3s[cutIdx_cloud:]),2)),str(round(max(l3s[cutIdx_cloud:]),2)), \
                               str(round(vp3,2)),str(round(min(vp3s[cutIdx_cloud:]),2)),str(round(max(vp3s[cutIdx_cloud:]),2)),str(round(k3,2)),str(round(min(k3s[cutIdx_cloud:]),2)),str(round(max(k3s[cutIdx_cloud:]),2)), \
                                   str(round(l4,2)),str(round(min(l4s[cutIdx_cloud:]),2)),str(round(max(l4s[cutIdx_cloud:]),2)), \
                                   str(round(vp4,2)),str(round(min(vp4s[cutIdx_cloud:]),2)),str(round(max(vp4s[cutIdx_cloud:]),2)),str(round(k4,2)),str(round(min(k4s[cutIdx_cloud:]),2)),str(round(max(k4s[cutIdx_cloud:]),2)), \
                                       str(round(l5,2)),str(round(min(l5s[cutIdx_cloud:]),2)),str(round(max(l5s[cutIdx_cloud:]),2)), \
                                       str(round(vp5,2)),str(round(min(vp5s[cutIdx_cloud:]),2)),str(round(max(vp5s[cutIdx_cloud:]),2)),str(round(k5,2)),str(round(min(k5s[cutIdx_cloud:]),2)),str(round(max(k5s[cutIdx_cloud:]),2)),str(round(m,2))]
        
        with open(d +'bestSols_minMax.csv','a') as f:
            write = csv.writer(f)
            write.writerow(bestSol_minMax)   
        
def splitLine_getCost(line, RF, ZC, RC, nlayers = 5):
    #split line
    thetaStr = line.replace('[','').replace(']','').replace('\n','').split()
    if nlayers == 5:
        if len(thetaStr) != 15:
            print('Theta string is wrong length!')
            print(thetaStr)
            print(line)
        theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),float(thetaStr[3]),float(thetaStr[4]), \
            float(thetaStr[5]),float(thetaStr[6]),float(thetaStr[7]),float(thetaStr[8]),float(thetaStr[9]), \
                float(thetaStr[10]),float(thetaStr[11]),float(thetaStr[12]),float(thetaStr[13]),float(thetaStr[14])
        #get cost
        c = basin_func(theta, RF, ZC, RC)
    elif nlayers == 4:
        if len(thetaStr) != 12:
            print('Theta string is wrong length!')
            print(thetaStr)
            print(line)
        theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),float(thetaStr[3]), \
            float(thetaStr[4]),float(thetaStr[5]),float(thetaStr[6]),float(thetaStr[7]), \
                float(thetaStr[8]),float(thetaStr[9]),float(thetaStr[10]),float(thetaStr[11])
        #get cost
        c = basin_func(theta, RF, ZC, RC)
    elif nlayers == 3:
        if len(thetaStr) != 9:
            print('Theta string is wrong length!')
            print(thetaStr)
            print(line)
        theta = float(thetaStr[0]),float(thetaStr[1]),float(thetaStr[2]),\
            float(thetaStr[3]),float(thetaStr[4]),float(thetaStr[5]),\
                float(thetaStr[6]),float(thetaStr[7]),float(thetaStr[8])
        #get cost
        c = basin_func(theta, RF, ZC, RC)
    elif nlayers == 2:
        if len(thetaStr) != 6:
            print('Theta string is wrong length!')
            print(thetaStr)
            print(line)
        theta = float(thetaStr[0]),float(thetaStr[1]),\
            float(thetaStr[2]),float(thetaStr[3]),\
                float(thetaStr[4]),float(thetaStr[5])
        #get cost
        c = basin_func(theta, RF, ZC, RC)
    elif nlayers == 1:
        if len(thetaStr) != 3:
            print('Theta string is wrong length!')
            print(thetaStr)
            print(line)
        theta = float(thetaStr[0]),float(thetaStr[1]),\
            float(thetaStr[2])
        #get cost
        c = basin_func(theta, RF, ZC, RC)
    else:
        print('not configured for this number of layers :(')
        c = 0
    
    return(c)

def plotMisfits(x,y,xMin,yMin,costs,cutIdx,cutIdx_cloud,name,cloud,drawEllipse,d,station,xlabel,ylabel,title, plotSubSplit = False, xSplitMinMax=None, ySplitMinMax=None):
    fig, ax_kwargs = plt.subplots()
    plt.scatter(x[cutIdx:],y[cutIdx:],s=1, c=costs[cutIdx:], cmap='binary_r', vmin=min(costs[cutIdx:]), vmax=max(costs[cutIdx:]))
    cbar = plt.colorbar()
    cbar.set_label('Misfit')
    plt.scatter(x[cutIdx_cloud:],y[cutIdx_cloud:],s=4, color='salmon', alpha=.3)
    if cloud:
        #sns.kdeplot(x=x[cutIdx_cloud:], y=y[cutIdx_cloud:], cmap='Greens', fill=True, levels=7, thresh=0.001, cut=2, alpha=.8)
        sns.kdeplot(x=x[cutIdx_cloud:], y=y[cutIdx_cloud:],fill=True, levels=5, thresh=0.5, cut=0, alpha=.8)
    if plotSubSplit:
        plt.scatter(xSplitMinMax,ySplitMinMax,s=4, color='green', alpha=.3)
        
        if drawEllipse:
            confidence_ellipse(xSplitMinMax, ySplitMinMax, ax_kwargs, n_std=2,label=r'$1\sigma$', edgecolor='orange')  
    
    else:
        if drawEllipse:
            confidence_ellipse(x[cutIdx_cloud:], y[cutIdx_cloud:], ax_kwargs, n_std=2,label=r'$1\sigma$', edgecolor='cornflowerblue')  
        
    plt.scatter(xMin,yMin,s=25, color='salmon',marker="X",edgecolor='black')
    plt.xlim([min(x), max(x)])
    plt.ylim([min(y), max(y)])
    plt.xlabel(xlabel)
    plt.ylabel(ylabel)
    plt.title(title)
    
    plt.savefig(d + station + name, dpi=300)
    #plt.show()
    plt.close()

def confidence_ellipse(x, y, ax, n_std=2.0, facecolor='none', **kwargs):
    """
    Create a plot of the covariance confidence ellipse of *x* and *y*.
    https://matplotlib.org/stable/gallery/statistics/confidence_ellipse.html

    Parameters
    ----------
    x, y : array-like, shape (n, )
        Input data.

    ax : matplotlib.axes.Axes
        The axes object to draw the ellipse into.

    n_std : float
        The number of standard deviations to determine the ellipse's radiuses.

    **kwargs
        Forwarded to `~matplotlib.patches.Ellipse`

    Returns
    -------
    matplotlib.patches.Ellipse
    """
    if len(x) != len(y):
        raise ValueError("x and y must be the same size")

    cov = np.cov(x, y)
    pearson = cov[0, 1]/np.sqrt(cov[0, 0] * cov[1, 1])
    # Using a special case to obtain the eigenvalues of this
    # two-dimensional dataset.
    ell_radius_x = np.sqrt(1 + pearson)
    ell_radius_y = np.sqrt(1 - pearson)
    ellipse = Ellipse((0, 0), width=ell_radius_x * 2, height=ell_radius_y * 2,
                      facecolor=facecolor, **kwargs)

    # Calculating the standard deviation of x from
    # the squareroot of the variance and multiplying
    # with the given number of standard deviations.
    scale_x = np.sqrt(cov[0, 0]) * n_std
    mean_x = np.mean(x)

    # calculating the standard deviation of y ...
    scale_y = np.sqrt(cov[1, 1]) * n_std
    mean_y = np.mean(y)

    transf = transforms.Affine2D() \
        .rotate_deg(45) \
        .scale(scale_x, scale_y) \
        .translate(mean_x, mean_y)

    ellipse.set_transform(transf + ax.transData)
    return ax.add_patch(ellipse)