#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Tue Nov  7 13:26:42 2023

@author: ben
"""

from __future__ import print_function

#import emcee
#import corner
import numpy as np
#import scipy.optimize as op
#import matplotlib.pyplot as pl
#from matplotlib.ticker import MaxNLocator
#from multiprocessing import Pool
from multiprocessing import cpu_count
import pickle
import os

import obspy
from obspy.signal import cross_correlation as cc
from telewavesim import utils as ut
#from telewavesim import wiggle as wg
from obspy.core import Stream
import time

from functions_modifiedWiggle import rf_wiggles_multiLayer

import numpy.random as r

from functions_parallelBasinHopping_custom import *

import pdb as pdb

ncpu = cpu_count()
print("{0} CPUs".format(ncpu) + ' available')

def basinhopping_varyLayers(stations,d,dOut,nlayers, startingModel=[], cornersRF = [0.005, 1.5], cornersZR = [0.005, 1.25]):
    '''
    receiver function and autocorrelation modeling based on the basinhopping minimization algorithm.
    stations is list of stations to be modeled
    d is input directory
    dOut is output directory
    nlayers is the number of layers to be modeled
    startingModel is the initial model considered and parameter ranges
    cornersRF is the corner for the bandpass filter applied to the receiver functions
    cornerZR is the corner for the bandpass filter applied to the autocorrelations
    '''
    for station in stations:
        
        print(station)
        
        allSearches = dOut + station.replace('-','.') + '.txt'
        print(allSearches)
        
        if os.path.isfile(allSearches):
            os.remove(allSearches)
        
        rf = obspy.read(d + station + '.mseed')
        RF = Stream(traces = [rf[0], rf[1], rf[2], rf[3], rf[4], rf[5], rf[6], rf[7], rf[8]])
        RF[0].stats.slow = .04
        RF[1].stats.slow = .045
        RF[2].stats.slow = .05
        RF[3].stats.slow = .055
        RF[4].stats.slow = .06
        RF[5].stats.slow = .065
        RF[6].stats.slow = .07
        RF[7].stats.slow = .075
        RF[8].stats.slow = .08
            
        trT = Stream(traces = [rf[9], rf[10], rf[11], rf[12], rf[13], rf[14], rf[15], rf[16], rf[17]])
        trT[0].stats.slow = .04
        trT[1].stats.slow = .045
        trT[2].stats.slow = .05
        trT[3].stats.slow = .055
        trT[4].stats.slow = .06
        trT[5].stats.slow = .065
        trT[6].stats.slow = .07
        trT[7].stats.slow = .075
        trT[8].stats.slow = .08
        
        ZC = Stream(traces = [rf[18], rf[19], rf[20], rf[21], rf[22], rf[23], rf[24], rf[25], rf[26]])
        ZC[0].stats.slow = .04
        ZC[1].stats.slow = .045
        ZC[2].stats.slow = .05
        ZC[3].stats.slow = .055
        ZC[4].stats.slow = .06
        ZC[5].stats.slow = .065
        ZC[6].stats.slow = .07
        ZC[7].stats.slow = .075
        ZC[8].stats.slow = .08
        
        RC = Stream(traces = [rf[27], rf[28], rf[29], rf[30], rf[31], rf[32], rf[33], rf[34], rf[35]])
        RC[0].stats.slow = .04
        RC[1].stats.slow = .045
        RC[2].stats.slow = .05
        RC[3].stats.slow = .055
        RC[4].stats.slow = .06
        RC[5].stats.slow = .065
        RC[6].stats.slow = .07
        RC[7].stats.slow = .075
        RC[8].stats.slow = .08
        
        # Stack over all traces
        R_stack, Z_stack = ut.stack_all(RF, ZC, pws=True)
        R_stack, RC_stack = ut.stack_all(RF, RC, pws=True)
            
        if startingModel == [] and nlayers == 4:
            # Choose the initial guess parameters.
            t1 = 3.5
            t2 = 8
            t3 = 4
            t4 = 21.5
            
            vp1 = 2.8
            vp2 = 5
            vp3 = 4.75
            vp4 = 6.5
            
            k1 = 2
            k2 = 1.8
            k3 = 1.8
            k4 = 1.8
            
            t1_min = t1 - 2
            t1_max = t1 + 2
            t2_min = t2 - 3
            t2_max = t2 + 3
            t3_min = t3 - 3
            t3_max = t3 + 3
            t4_min = t4 - 3.5
            t4_max = t4 + 3.5
            
            vp1_min = vp1 - .5
            vp1_max = vp1 + .5
            vp2_min = vp2 - .75
            vp2_max = vp2 + .75
            vp3_min = vp3 - .75
            vp3_max = vp3 + .75
            vp4_min = vp4 - .5
            vp4_max = vp4 + .5
            
            k1_min = 1.85
            k1_max = 2.1
            k2_min = 1.64
            k2_max = 1.95
            k3_min = 1.64
            k3_max = 1.95
            k4_min = 1.64
            k4_max = 1.95
            
            vR = [k1, k2, k3, k4]
            vp = [vp1, vp2, vp3, vp4, 7.8]
            vs = [vp[0]/vR[0], vp[1]/vR[1], vp[2]/vR[2], vp[3]/vR[3], 4.48]
            rho = [2300, 2550, 2700, 2900, 3300] 
        
            modOut = ut.Model( [t1, t2, t3, t4, 10], rho, vp, vs)
            
        elif nlayers == 4:
            t1,t2,t3,t4 = startingModel[0]
            vp1,vp2,vp3,vp4 = startingModel[2]
            k1,k2,k3,k4 = startingModel[4]
            
            t1_min = t1 - startingModel[1][0]
            t1_max = t1 + startingModel[1][0]
            t2_min = t2 - startingModel[1][1]
            t2_max = t2 + startingModel[1][1]
            t3_min = t3 - startingModel[1][2]
            t3_max = t3 + startingModel[1][2]
            t4_min = t4 - startingModel[1][3]
            t4_max = t4 + startingModel[1][3]
            
            vp1_min = vp1 - startingModel[3][0]
            vp1_max = vp1 + startingModel[3][0]
            vp2_min = vp2 - startingModel[3][1]
            vp2_max = vp2 + startingModel[3][1]
            vp3_min = vp3 - startingModel[3][2]
            vp3_max = vp3 + startingModel[3][2]
            vp4_min = vp4 - startingModel[3][3]
            vp4_max = vp4 + startingModel[3][3]
            
            k1_min = k1 - startingModel[5][0]
            k1_max = k1 + startingModel[5][0]
            k2_min = k2 - startingModel[5][1]
            k2_max = k2 + startingModel[5][1]
            k3_min = k3 - startingModel[5][2]
            k3_max = k3 + startingModel[5][2]
            k4_min = k4 - startingModel[5][3]
            k4_max = k4 + startingModel[5][3]
            
            vR = [k1, k2, k3, k4]
            vp = [vp1, vp2, vp3, vp4, 7.8]
            vs = [vp[0]/vR[0], vp[1]/vR[1], vp[2]/vR[2], vp[3]/vR[3], 4.48]
            rho = [startingModel[6][0], startingModel[6][1], startingModel[6][2], startingModel[6][3], 3400] 
            modOut = ut.Model( [t1, t2, t3, t4, 10], rho, vp, vs)
            
        elif nlayers == 3:
            t1,t2,t3 = startingModel[0]
            vp1,vp2,vp3= startingModel[2]
            k1,k2,k3 = startingModel[4]
            
            t1_min = t1 - startingModel[1][0]
            t1_max = t1 + startingModel[1][0]
            t2_min = t2 - startingModel[1][1]
            t2_max = t2 + startingModel[1][1]
            t3_min = t3 - startingModel[1][2]
            t3_max = t3 + startingModel[1][2]
            
            vp1_min = vp1 - startingModel[3][0]
            vp1_max = vp1 + startingModel[3][0]
            vp2_min = vp2 - startingModel[3][1]
            vp2_max = vp2 + startingModel[3][1]
            vp3_min = vp3 - startingModel[3][2]
            vp3_max = vp3 + startingModel[3][2]
            
            k1_min = k1 - startingModel[5][0]
            k1_max = k1 + startingModel[5][0]
            k2_min = k2 - startingModel[5][1]
            k2_max = k2 + startingModel[5][1]
            k3_min = k3 - startingModel[5][2]
            k3_max = k3 + startingModel[5][2]
            
            vR = [k1, k2, k3]
            vp = [vp1, vp2, vp3, 7.8]
            vs = [vp[0]/vR[0], vp[1]/vR[1], vp[2]/vR[2], 4.48]
            rho = [startingModel[6][0], startingModel[6][1], startingModel[6][2], 3400] 
            modOut = ut.Model( [t1, t2, t3, 10], rho, vp, vs)
            
        elif nlayers == 2:
            t1,t2 = startingModel[0]
            vp1,vp2= startingModel[2]
            k1,k2 = startingModel[4]
            
            t1_min = t1 - startingModel[1][0]
            t1_max = t1 + startingModel[1][0]
            t2_min = t2 - startingModel[1][1]
            t2_max = t2 + startingModel[1][1]
            
            vp1_min = vp1 - startingModel[3][0]
            vp1_max = vp1 + startingModel[3][0]
            vp2_min = vp2 - startingModel[3][1]
            vp2_max = vp2 + startingModel[3][1]
            
            k1_min = k1 - startingModel[5][0]
            k1_max = k1 + startingModel[5][0]
            k2_min = k2 - startingModel[5][1]
            k2_max = k2 + startingModel[5][1]
            
            vR = [k1, k2]
            vp = [vp1, vp2, 7.8]
            vs = [vp[0]/vR[0], vp[1]/vR[1], 4.48]
            rho = [startingModel[6][0], startingModel[6][1], 3400] 
            modOut = ut.Model( [t1, t2, 10], rho, vp, vs)
                
        trROut = Stream(); trTOut = Stream(); zCorrOut = Stream(); rCorrOut = Stream();
         
        slows = [.04, .045, .05, .055, .06, .065, .07, .075, .08] #ray parameters in s/km
        baz = 180 #doesn't actually matter, not checking anisotropy
        npts = RF[0].stats.npts # Number of samples
        dt = RF[0].stats.delta # Sample distance in seconds
        
        #filter
        hcornerRF = cornersRF[1]
        lcornerRF = cornersRF[0]
        
        hcornerZR = cornersZR[1]
        lcornerZR = cornersRF[0]
         
        # Loop over range of data 
        for slow in slows:
             # Calculate the plane waves seismograms
             trxyzOut = ut.run_plane(modOut, slow, npts, dt, baz, wvtype="P", obs=False)
             
             trxyzRaw = trxyzOut.copy()
             trxyzOut.filter('bandpass',freqmin=lcornerZR, freqmax=hcornerZR, corners=2, zerophase=True)
             
             xcorr_time = 5/6;
             corr = cc.correlate(trxyzOut[2],trxyzOut[2],int((xcorr_time*60)/dt),normalize='naive',method='auto')
             corr = corr[round((len(corr) - 1) / 2):]
             corrR = cc.correlate(trxyzOut[0],trxyzOut[0],int((xcorr_time*60)/dt),normalize='naive',method='auto')
             corrR = corrR[round((len(corrR) - 1) / 2):]
             
             #now taper
             nsamp = (2/dt); #start at 2 seconds
             tap = np.hanning(nsamp * 2)
             tap_beg = tap[1:int(nsamp+2)]
             tap_end = tap[int(len(tap)-nsamp - 1):len(tap)]
             hann_taper = np.zeros(len(corr))+1
             hann_taper[0:int(nsamp+1)] = tap_beg;
             hann_taper[len(hann_taper)-int(nsamp)-1:] = tap_end;
             taper_corr = np.array(corr) * np.array(hann_taper)
             taper_corrR = np.array(corrR) * np.array(hann_taper)
             #pad to same length as synthetics
             taper_corr = taper_corr[:(int(len(taper_corr)* (3/5)) + 1)]
             taper_corr_pad = np.append(np.zeros(int(30/dt)),taper_corr)
             taper_corrR = taper_corrR[:(int(len(taper_corrR)* (3/5)) + 1)]
             taper_corr_padR = np.append(np.zeros(int(30/dt)),taper_corrR)
             zAuto = trxyzOut[2].copy()
             rAuto = trxyzOut[1].copy()
             zAuto.data = taper_corr_pad
             rAuto.data = taper_corr_padR
             zCorrOut.append(zAuto)
             rCorrOut.append(rAuto)
         
             # Then the transfer functions in Z-R-T coordinate system
             tfsOut = ut.tf_from_xyz(trxyzRaw, pvh=False)
             
             # Append to streams
             trROut.append(tfsOut[0]); trTOut.append(tfsOut[1])
         
        
        trROut.filter('bandpass',freqmin=lcornerRF, freqmax=hcornerRF, corners=2, zerophase=True)
        zCorrOut.filter('bandpass',freqmin=lcornerZR, freqmax=hcornerZR, corners=2, zerophase=True)
        rCorrOut.filter('bandpass',freqmin=lcornerZR, freqmax=hcornerZR, corners=2, zerophase=True)
         
        for i in range(9):
            normFactor = max(abs(trROut[i].data))
            trROut[i].data = trROut[i].data / normFactor
             
            normFactorZAuto = max(abs(zCorrOut[i].data))
            zCorrOut[i].data = zCorrOut[i].data / normFactorZAuto
             
            normFactorRAuto = max(abs(rCorrOut[i].data))
            rCorrOut[i].data = rCorrOut[i].data / normFactorRAuto
         
         #stack
        trROut_stack, trZOut_stack = ut.stack_all(trROut, zCorrOut, pws=True)
        if nlayers == 4:
            lb1 = 'Layer 1 - ' + str(t1) + ' km, ' + str(vp1) + ' km/s Vp, ' + str(k1) + ' Vp/Vs'
            lb2 = 'Layer 2 - ' + str(t2) + ' km, ' + str(vp2) + ' km/s Vp, ' + str(k2) + ' Vp/Vs'
            lb3 = 'Layer 3 - ' + str(t3) + ' km, ' + str(vp3) + ' km/s Vp, ' + str(k3) + ' Vp/Vs'
            lb4 = 'Layer 4 - ' + str(t4) + ' km, ' + str(vp4) + ' km/s Vp, ' + str(k4) + ' Vp/Vs'
            l = [lb1, lb2, lb3, lb4]
            t = [t1, t2, t3, t4]
        elif nlayers == 3:
            print('3 Layers')
            lb1 = 'Layer 1 - ' + str(t1) + ' km, ' + str(vp1) + ' km/s Vp, ' + str(k1) + ' Vp/Vs'
            lb2 = 'Layer 2 - ' + str(t2) + ' km, ' + str(vp2) + ' km/s Vp, ' + str(k2) + ' Vp/Vs'
            lb3 = 'Layer 3 - ' + str(t3) + ' km, ' + str(vp3) + ' km/s Vp, ' + str(k3) + ' Vp/Vs'
            l = [lb1, lb2, lb3]
            t = [t1, t2, t3]
        elif nlayers == 2:
            print('2 Layers')
            lb1 = 'Layer 1 - ' + str(t1) + ' km, ' + str(vp1) + ' km/s Vp, ' + str(k1) + ' Vp/Vs'
            lb2 = 'Layer 2 - ' + str(t2) + ' km, ' + str(vp2) + ' km/s Vp, ' + str(k2) + ' Vp/Vs'
            l = [lb1, lb2]
            t = [t1, t2]
            
        #wiggles
        rf_wiggles_multiLayer(RF, trROut, R_stack, trROut_stack, station + ' Radial Receiver Functions', l, t, vp, vR, btyp='slow',
                          scale=.004, tmin=-5., tmax=30., save=True, ftitle=dOut + station + '_initialModel_RF',
                          wvtype='P')
        rf_wiggles_multiLayer(ZC, zCorrOut, trZOut_stack, zCorrOut, station + ' Vertical Autocorrelations', l, t, vp, vR, btyp='slow',scale=.004, tmin=-5., tmax=30., save=True,ftitle=dOut + station + '_initialModel_ZC',wvtype='P',isZ=True)
        
        rf_wiggles_multiLayer(RC, rCorrOut, RC, rCorrOut, station + ' Radial Autocorrelations', l, t, vp, vR, btyp='slow',scale=.004, tmin=-5., tmax=30., save=True,ftitle=dOut + station + '_initialModel_RC',wvtype='P')
    
        if nlayers == 2:
            theta = t1,t2,vp1,vp2,k1,k2
        elif nlayers == 3:
            theta = t1,t2,t3,vp1,vp2,vp3,k1,k2,k3
        elif nlayers == 4:
            theta = t1,t2,t3,t4,vp1,vp2,vp3,vp4,k1,k2,k3,k4
        elif nlayers == 5:
            print('need to set up')
            
        print('Initial model misfit: ' + str(basin_func(theta, RF, ZC, RC, rho=rho)))
        
        nhoppers = 24
            
        if nlayers == 2:
            p0 = np.zeros(shape=(nhoppers,6))
        if nlayers == 3:
            p0 = np.zeros(shape=(nhoppers,9))
        elif nlayers == 4:
            p0 = np.zeros(shape=(nhoppers,12))
        
        for i in range(nhoppers):
            if nlayers == 2:
                p0[i] = [r.uniform(low=t1_min, high=t1_max),r.uniform(low=t2_min, high=t2_max), \
                 r.uniform(low=vp1_min, high=vp1_max),r.uniform(low=vp2_min, high=vp2_max), \
                     r.uniform(low=k1_min, high=k1_max),r.uniform(low=k2_min, high=k2_max)]
            elif nlayers == 3:
                p0[i] = [r.uniform(low=t1_min, high=t1_max),r.uniform(low=t2_min, high=t2_max),r.uniform(low=t3_min, high=t3_max), \
                 r.uniform(low=vp1_min, high=vp1_max),r.uniform(low=vp2_min, high=vp2_max),r.uniform(low=vp3_min, high=vp3_max), \
                     r.uniform(low=k1_min, high=k1_max),r.uniform(low=k2_min, high=k2_max),r.uniform(low=k3_min, high=k3_max)]
            elif nlayers == 4:
                p0[i] = [r.uniform(low=t1_min, high=t1_max),r.uniform(low=t2_min, high=t2_max),r.uniform(low=t3_min, high=t3_max),r.uniform(low=t4_min, high=t4_max), \
                 r.uniform(low=vp1_min, high=vp1_max),r.uniform(low=vp2_min, high=vp2_max),r.uniform(low=vp3_min, high=vp3_max),r.uniform(low=vp4_min, high=vp4_max), \
                     r.uniform(low=k1_min, high=k1_max),r.uniform(low=k2_min, high=k2_max),r.uniform(low=k3_min, high=k3_max),r.uniform(low=k4_min, high=k4_max)]
        if nlayers == 2:
            bnds = ((t1_min, t1_max), (t2_min, t2_max), \
                    (vp1_min, vp1_max), (vp2_min, vp2_max), \
                    (k1_min, k1_max), (k2_min, k2_max))# your bounds
        elif nlayers == 3:
            bnds = ((t1_min, t1_max), (t2_min, t2_max), (t3_min, t3_max), \
                    (vp1_min, vp1_max), (vp2_min, vp2_max), (vp3_min, vp3_max), \
                    (k1_min, k1_max), (k2_min, k2_max), (k3_min, k3_max))# your bounds
        elif nlayers == 4:
            bnds = ((t1_min, t1_max), (t2_min, t2_max), (t3_min, t3_max), (t4_min, t4_max), \
                    (vp1_min, vp1_max), (vp2_min, vp2_max), (vp3_min, vp3_max), (vp4_min, vp4_max),  \
                    (k1_min, k1_max), (k2_min, k2_max), (k3_min, k3_max), (k4_min, k4_max))# your bounds
            
        minimizer_kwargs = {"args": (RF, ZC, RC, rho, cornersRF, cornersZR, dOut),'bounds':bnds}
        
        start = time.time()
        
        history = []
        histCost = []
        
        results = pool_basinhopping2(basin_func, p0, minimizer_kwargs,callback)
        
        bestCost_global = []
        bestPos_global = []
        bestCosts_local = []
        bestPos_local = []
        
        print('histCost length for single run is: ' + str(len(results[0][2])))
        for result in results:
            if bestCost_global == []:
                bestCost_global = result[0].fun
                bestPos_global = result[0].x
            elif bestCost_global > result[0].fun:
                bestCost_global = result[0].fun
                bestPos_global = result[0].x
            #print(result[0].fun)
            
            #bestCosts_local.append(result[2])
            #bestPos_local.append(result[1])
            for i in range(len(result[2])):
                bestCosts_local.append(result[2][i])
                bestPos_local.append(result[1][i])
                
        
        print('Best model cross correlation: ' + str(bestCost_global))
        
        if nlayers == 2:
            vR = [bestPos_global[4], bestPos_global[5]]
            vp = [bestPos_global[2], bestPos_global[3], 7.8]
            vs = [vp[0]/vR[0], vp[1]/vR[1], 4.48]
            #rho = [2300, 2550, 2800, 3400] 
            modBest = ut.Model( [bestPos_global[0], bestPos_global[1], 10], rho, vp, vs)
        elif nlayers == 3:
            vR = [bestPos_global[6], bestPos_global[7], bestPos_global[8]]
            vp = [bestPos_global[3], bestPos_global[4], bestPos_global[5], 7.8]
            vs = [vp[0]/vR[0], vp[1]/vR[1], vp[2]/vR[2], 4.48]
            #rho = [2300, 2550, 2800, 3400] 
            modBest = ut.Model( [bestPos_global[0], bestPos_global[1], bestPos_global[2], 10], rho, vp, vs)
        elif nlayers == 4:
            vR = [bestPos_global[8], bestPos_global[9], bestPos_global[10], bestPos_global[11]]
            vp = [bestPos_global[4], bestPos_global[5], bestPos_global[6], bestPos_global[7], 7.8]
            vs = [vp[0]/vR[0], vp[1]/vR[1], vp[2]/vR[2], vp[3]/vR[3], 4.48]
            #rho = [2300, 2550, 2700, 2900, 3300] 
            modBest = ut.Model( [bestPos_global[0], bestPos_global[1], bestPos_global[2], bestPos_global[3], 10], rho, vp, vs)
            
        trROut = Stream(); trTOut = Stream(); zCorrOut = Stream(); rCorrOut = Stream();
         
        slows = [.04, .045, .05, .055, .06, .065, .07, .075, .08] #ray parameters in s/km
        baz = 180 #doesn't actually matter, not checking anisotropy
        npts = RF[0].stats.npts # Number of samples
        dt = RF[0].stats.delta # Sample distance in seconds
         
        # Loop over range of data 
        for slow in slows:
             # Calculate the plane waves seismograms
             trxyzOut = ut.run_plane(modBest, slow, npts, dt, baz, wvtype="P", obs=False)
             
             trxyzRaw = trxyzOut.copy()
             trxyzOut.filter('bandpass',freqmin=lcornerZR, freqmax=hcornerZR, corners=2, zerophase=True)
             
             xcorr_time = 5/6;
             corr = cc.correlate(trxyzOut[2],trxyzOut[2],int((xcorr_time*60)/dt),normalize='naive',method='auto')
             corr = corr[round((len(corr) - 1) / 2):]
             corrR = cc.correlate(trxyzOut[0],trxyzOut[0],int((xcorr_time*60)/dt),normalize='naive',method='auto')
             corrR = corrR[round((len(corrR) - 1) / 2):]
             
             #now taper
             nsamp = (2/dt); #start at 2 seconds
             tap = np.hanning(nsamp * 2)
             tap_beg = tap[1:int(nsamp+2)]
             tap_end = tap[int(len(tap)-nsamp - 1):len(tap)]
             hann_taper = np.zeros(len(corr))+1
             hann_taper[0:int(nsamp+1)] = tap_beg;
             hann_taper[len(hann_taper)-int(nsamp)-1:] = tap_end;
             taper_corr = np.array(corr) * np.array(hann_taper)
             taper_corrR = np.array(corrR) * np.array(hann_taper)
             #pad to same length as synthetics
             taper_corr = taper_corr[:(int(len(taper_corr)* (3/5)) + 1)]
             taper_corr_pad = np.append(np.zeros(int(30/dt)),taper_corr)
             taper_corrR = taper_corrR[:(int(len(taper_corrR)* (3/5)) + 1)]
             taper_corr_padR = np.append(np.zeros(int(30/dt)),taper_corrR)
             zAuto = trxyzOut[2].copy()
             rAuto = trxyzOut[1].copy()
             zAuto.data = taper_corr_pad
             rAuto.data = taper_corr_padR
             zCorrOut.append(zAuto)
             rCorrOut.append(rAuto)
         
             # Then the transfer functions in Z-R-T coordinate system
             tfsOut = ut.tf_from_xyz(trxyzRaw, pvh=False)
             
             # Append to streams
             trROut.append(tfsOut[0]); trTOut.append(tfsOut[1])
        
        trROut.filter('bandpass',freqmin=lcornerRF, freqmax=hcornerRF, corners=2, zerophase=True)
        zCorrOut.filter('bandpass',freqmin=lcornerZR, freqmax=hcornerZR, corners=2, zerophase=True)
        rCorrOut.filter('bandpass',freqmin=lcornerZR, freqmax=hcornerZR, corners=2, zerophase=True)
         
        for i in range(9):
            normFactor = max(abs(trROut[i].data))
            trROut[i].data = trROut[i].data / normFactor
             
            normFactorZAuto = max(abs(zCorrOut[i].data))
            zCorrOut[i].data = zCorrOut[i].data / normFactorZAuto
             
            normFactorRAuto = max(abs(rCorrOut[i].data))
            rCorrOut[i].data = rCorrOut[i].data / normFactorRAuto
         
         #stack
        trROut_stack, trZOut_stack = ut.stack_all(trROut, zCorrOut, pws=True)
        lb1 = 'Layer 1 - ' + str(round(bestPos_global[0],2)) + ' km, ' + str(round(vp[0],2)) + ' km/s Vp, ' + str(round(vR[0],2)) + ' Vp/Vs'
        lb2 = 'Layer 2 - ' + str(round(bestPos_global[1],2)) + ' km, ' + str(round(vp[1],2)) + ' km/s Vp, ' + str(round(vR[1],2)) + ' Vp/Vs'
        if nlayers == 2:
            lb = [lb1, lb2]
            th = [bestPos_global[0], bestPos_global[1]]
        elif nlayers == 3:
            lb3 = 'Layer 3 - ' + str(round(bestPos_global[2],2)) + ' km, ' + str(round(vp[2],2)) + ' km/s Vp, ' + str(round(vR[2],2)) + ' Vp/Vs'
            lb = [lb1, lb2, lb3]
            th = [bestPos_global[0], bestPos_global[1], bestPos_global[2]]
        elif nlayers == 4:
            lb3 = 'Layer 3 - ' + str(round(bestPos_global[2],2)) + ' km, ' + str(round(vp[2],2)) + ' km/s Vp, ' + str(round(vR[2],2)) + ' Vp/Vs'
            lb4 = 'Layer 4 - ' + str(round(bestPos_global[3],2)) + ' km, ' + str(round(vp[3],2)) + ' km/s Vp, ' + str(round(vR[3],2)) + ' Vp/Vs'
            lb = [lb1, lb2, lb3, lb4]
            th = [bestPos_global[0], bestPos_global[1], bestPos_global[2], bestPos_global[3]]
        
        #wiggles
        rf_wiggles_multiLayer(RF, trROut, R_stack, trROut_stack, station + ' Radial Receiver Functions', lb, th, vp, vR,btyp='slow',
                          scale=.004, tmin=-5., tmax=30., save=True, ftitle=dOut + station + '_bestSol_RF',
                          wvtype='P')
        
        rf_wiggles_multiLayer(ZC, zCorrOut, trZOut_stack, zCorrOut, station + ' Vertical Autocorrelations', lb, th, vp, vR,btyp='slow',scale=.004, tmin=-5., tmax=30., save=True,ftitle=dOut + station + '_bestSol_aZ',wvtype='P',isZ=True)
        rf_wiggles_multiLayer(RC, rCorrOut, RC, rCorrOut, station + ' Radial Autocorrelations', lb, th, vp, vR, btyp='slow',scale=.004, tmin=-5., tmax=30., save=True,ftitle=dOut + station + '_bestSol_aR',wvtype='P')
        
     
        pickle.dump(modBest, open(dOut + station + "_model.p",'wb'))
        pickle.dump(bestCost_global, open(dOut + station + "_minCost.p",'wb'))
        pickle.dump(bestPos_global, open(dOut + station + "_minPos.p",'wb'))
        pickle.dump(bestCosts_local, open(dOut + station + "_minCosts_local.p",'wb'))
        pickle.dump(bestPos_local, open(dOut + station + "_positions.p",'wb'))
        
        #better to have this after the pickle.dump for everything else, in case it breaks
        file1 = open(allSearches, 'r')
        Lines = file1.readlines()
        costs = np.zeros(len(Lines))
        with Pool(processes=ncpu) as pool:
            costs = pool.starmap(splitLine_getCost, [(line, RF, ZC, RC, nlayers) for line in Lines])
        pickle.dump(costs, open(dOut + station + "_costs.p",'wb'))
        
        plotSol(dOut,station,bestCost_global,bestPos_global,bestCosts_local,bestPos_local,costs,nlayers)
        
        end = time.time()
        print(str((end - start)/3600) + ' hours to run')
        
        
        
        