## DodgersLoop dataset
#
#The traffic data are collected with the loop sensor installed on ramp for the 101 North freeway in Los Angeles. This location is close to Dodgers Stadium; therefore the traffic is affected by volumne of visitors to the stadium.
#
#We make three datasets out of these data.
#
### DodgersLoopDay
#
#The classes are days of the week.
#
#- Class 1: Sunday
#- Class 2: Monday
#- Class 3: Tuesday
#- Class 4: Wednesday
#- Class 5: Thursday 
#- Class 6: Friday
#- Class 7: Saturday 
#
#Train size: 78
#
#Test size: 80
#
#Number of classes: 7
#
#Missing value: Yes
#
#Time series length: 288
#
#Missing values are represented with NaN.
#
### DodgersLoopWeekend
#
#- Class 1: Weekday
#- Class 2: Weekend
#
#Train size: 20
#
#Test size: 138
#
#Number of classes: 2
#
#Missing value: Yes
#
#Time series length: 288
#
#Missing values are represented with NaN.
#
### DodgersLoopGame
#
#- Class 1: Normal day
#- Class 2: Game day
#
#Train size: 20
#
#Test size: 138
#
#Number of classes: 2
#
#Missing value: Yes
#
#Time series length: 288
#
#There is nothing to infer from the order of examples in the train and test set.
#
#Missing values are represented with NaN.
#
#Data created by Ihler, Alexander, Jon Hutchins, and Padhraic Smyth (see [1][2][3]). Data edited by Chin-Chia Michael Yeh. 
#
#[1] Ihler, Alexander, Jon Hutchins, and Padhraic Smyth. "Adaptive event detection with time-varying poisson processes." Proceedings of the 12th ACM SIGKDD international conference on Knowledge discovery and data mining. ACM, 2006.
#
#[2] “UCI Machine Learning Repository: Dodgers Loop Sensor Data Set.” UCI Machine Learning Repository, archive.ics.uci.edu/ml/datasets/dodgers+loop+sensor.
#
#[3] “Caltrans PeMS.” Caltrans, pems.dot.ca.gov/.
@problemName DodgerLoopGame
@timeStamps false
@missing true
@univariate true
@equalLength true
@seriesLength 288
@classLabel true 1 2
@data
2.0,8.0,7.0,6.0,2.0,8.0,5.0,10.0,3.0,6.0,4.0,3.0,3.0,2.0,2.0,1.0,5.0,6.0,4.0,4.0,3.0,6.0,8.0,3.0,0.0,2.0,0.0,4.0,3.0,6.0,0.0,3.0,2.0,2.0,1.0,2.0,0.0,2.0,1.0,3.0,1.0,3.0,3.0,2.0,2.0,1.0,1.0,0.0,0.0,3.0,2.0,2.0,1.0,1.0,3.0,4.0,2.0,7.0,4.0,5.0,6.0,5.0,5.0,9.0,3.0,7.0,13.0,3.0,13.0,7.0,16.0,4.0,10.0,8.0,16.0,11.0,12.0,16.0,18.0,14.0,20.0,24.0,20.0,35.0,19.0,35.0,28.0,17.0,21.0,26.0,40.0,37.0,25.0,43.0,22.0,40.0,20.0,31.0,37.0,26.0,31.0,27.0,30.0,37.0,25.0,44.0,27.0,37.0,31.0,24.0,29.0,27.0,19.0,36.0,38.0,22.0,19.0,27.0,31.0,31.0,35.0,21.0,36.0,14.0,33.0,27.0,27.0,34.0,25.0,26.0,26.0,24.0,18.0,14.0,19.0,21.0,21.0,31.0,23.0,17.0,18.0,23.0,16.0,28.0,23.0,22.0,20.0,33.0,19.0,18.0,25.0,28.0,24.0,17.0,26.0,21.0,23.0,23.0,16.0,24.0,36.0,27.0,38.0,22.0,28.0,26.0,32.0,19.0,31.0,23.0,44.0,32.0,13.0,32.0,34.0,29.0,31.0,32.0,40.0,20.0,35.0,20.0,17.0,40.0,40.0,26.0,34.0,28.0,39.0,39.0,30.0,28.0,30.0,24.0,26.0,40.0,31.0,32.0,33.0,45.0,33.0,37.0,38.0,34.0,29.0,24.0,30.0,27.0,15.0,30.0,26.0,29.0,33.0,21.0,25.0,22.0,27.0,8.0,35.0,28.0,24.0,39.0,23.0,29.0,21.0,29.0,32.0,32.0,15.0,21.0,27.0,27.0,18.0,30.0,31.0,18.0,18.0,21.0,22.0,15.0,18.0,18.0,20.0,22.0,20.0,27.0,23.0,21.0,11.0,5.0,15.0,12.0,16.0,15.0,19.0,12.0,21.0,10.0,12.0,5.0,15.0,6.0,10.0,13.0,12.0,8.0,14.0,16.0,10.0,9.0,3.0,3.0,9.0,14.0,8.0,8.0,13.0,13.0,11.0,7.0,12.0,4.0,9.0,13.0,3.0,5.0,5.0,3.0:1
8.0,5.0,10.0,11.0,9.0,10.0,7.0,18.0,11.0,8.0,8.0,8.0,6.0,3.0,7.0,9.0,8.0,7.0,9.0,7.0,4.0,9.0,6.0,5.0,13.0,5.0,11.0,7.0,7.0,8.0,8.0,7.0,3.0,3.0,4.0,11.0,6.0,3.0,5.0,4.0,6.0,7.0,0.0,4.0,2.0,2.0,4.0,4.0,4.0,2.0,3.0,2.0,3.0,4.0,1.0,7.0,4.0,6.0,4.0,2.0,5.0,4.0,2.0,1.0,2.0,3.0,4.0,3.0,4.0,3.0,4.0,6.0,5.0,3.0,6.0,4.0,3.0,6.0,4.0,4.0,5.0,6.0,6.0,7.0,6.0,4.0,6.0,7.0,7.0,6.0,4.0,12.0,7.0,9.0,5.0,9.0,6.0,11.0,17.0,9.0,12.0,7.0,18.0,15.0,15.0,10.0,13.0,17.0,16.0,14.0,14.0,16.0,16.0,20.0,9.0,26.0,17.0,16.0,16.0,22.0,23.0,16.0,13.0,21.0,23.0,22.0,28.0,31.0,21.0,16.0,22.0,25.0,25.0,15.0,27.0,27.0,24.0,22.0,24.0,21.0,23.0,32.0,18.0,30.0,27.0,30.0,31.0,33.0,36.0,21.0,37.0,18.0,19.0,18.0,21.0,29.0,23.0,17.0,24.0,21.0,33.0,27.0,33.0,26.0,29.0,26.0,32.0,32.0,22.0,34.0,38.0,33.0,29.0,42.0,41.0,30.0,19.0,31.0,28.0,24.0,23.0,22.0,19.0,32.0,28.0,23.0,22.0,16.0,30.0,16.0,24.0,22.0,20.0,25.0,22.0,16.0,27.0,26.0,22.0,27.0,33.0,29.0,23.0,24.0,15.0,33.0,23.0,21.0,23.0,23.0,24.0,31.0,33.0,30.0,35.0,24.0,17.0,27.0,33.0,28.0,21.0,25.0,20.0,22.0,32.0,25.0,21.0,26.0,20.0,21.0,24.0,27.0,29.0,26.0,22.0,27.0,24.0,14.0,21.0,16.0,16.0,20.0,25.0,15.0,19.0,17.0,18.0,23.0,24.0,22.0,23.0,15.0,24.0,17.0,9.0,13.0,15.0,17.0,13.0,16.0,17.0,20.0,14.0,21.0,16.0,21.0,19.0,8.0,8.0,23.0,9.0,12.0,9.0,10.0,11.0,6.0,6.0,11.0,13.0,7.0,6.0,7.0,1.0,2.0,6.0,7.0,8.0,6.0:1
1.0,9.0,5.0,2.0,5.0,5.0,5.0,13.0,6.0,4.0,5.0,4.0,5.0,9.0,4.0,3.0,8.0,6.0,3.0,5.0,1.0,3.0,4.0,4.0,6.0,1.0,5.0,2.0,2.0,3.0,1.0,2.0,3.0,2.0,0.0,4.0,1.0,2.0,2.0,1.0,1.0,4.0,3.0,2.0,2.0,3.0,2.0,0.0,3.0,1.0,0.0,1.0,2.0,1.0,2.0,2.0,4.0,6.0,3.0,5.0,10.0,2.0,10.0,2.0,8.0,5.0,13.0,16.0,17.0,9.0,10.0,12.0,16.0,14.0,16.0,17.0,15.0,27.0,18.0,24.0,23.0,20.0,22.0,27.0,22.0,39.0,33.0,37.0,37.0,41.0,41.0,35.0,42.0,39.0,40.0,44.0,27.0,37.0,30.0,39.0,41.0,31.0,34.0,32.0,38.0,31.0,36.0,35.0,38.0,30.0,34.0,39.0,25.0,33.0,29.0,18.0,41.0,35.0,34.0,23.0,28.0,19.0,29.0,16.0,14.0,17.0,27.0,24.0,25.0,35.0,39.0,24.0,24.0,21.0,20.0,24.0,29.0,26.0,23.0,21.0,30.0,36.0,31.0,28.0,31.0,21.0,32.0,31.0,27.0,33.0,31.0,29.0,30.0,16.0,27.0,18.0,22.0,27.0,18.0,29.0,22.0,29.0,20.0,21.0,41.0,23.0,22.0,36.0,27.0,30.0,23.0,26.0,28.0,22.0,32.0,29.0,46.0,32.0,30.0,45.0,39.0,42.0,41.0,34.0,51.0,37.0,48.0,48.0,32.0,43.0,36.0,31.0,34.0,33.0,36.0,42.0,25.0,37.0,41.0,35.0,37.0,42.0,27.0,38.0,44.0,41.0,34.0,33.0,26.0,30.0,39.0,34.0,33.0,31.0,34.0,38.0,23.0,25.0,35.0,34.0,23.0,29.0,30.0,31.0,30.0,21.0,30.0,34.0,25.0,31.0,29.0,39.0,35.0,25.0,21.0,31.0,29.0,28.0,24.0,29.0,22.0,20.0,23.0,24.0,11.0,27.0,19.0,25.0,17.0,26.0,19.0,19.0,20.0,18.0,17.0,22.0,12.0,17.0,16.0,12.0,21.0,16.0,20.0,14.0,12.0,11.0,10.0,12.0,14.0,15.0,11.0,14.0,11.0,12.0,4.0,10.0,8.0,10.0,10.0,5.0,14.0,9.0,13.0,10.0,9.0,5.0,11.0,6.0:1
2.0,6.0,6.0,3.0,8.0,6.0,3.0,4.0,3.0,4.0,3.0,2.0,3.0,2.0,0.0,3.0,3.0,3.0,3.0,3.0,4.0,3.0,3.0,2.0,1.0,2.0,2.0,3.0,1.0,1.0,0.0,0.0,3.0,0.0,0.0,1.0,0.0,0.0,3.0,2.0,2.0,3.0,0.0,3.0,2.0,3.0,1.0,1.0,4.0,4.0,1.0,4.0,2.0,3.0,4.0,4.0,6.0,6.0,3.0,6.0,8.0,10.0,4.0,6.0,5.0,8.0,8.0,13.0,15.0,6.0,6.0,7.0,14.0,28.0,18.0,9.0,20.0,15.0,25.0,27.0,27.0,23.0,18.0,33.0,23.0,35.0,40.0,45.0,45.0,38.0,39.0,42.0,39.0,41.0,41.0,28.0,36.0,25.0,27.0,40.0,36.0,26.0,28.0,37.0,30.0,43.0,46.0,31.0,23.0,25.0,43.0,30.0,32.0,24.0,33.0,45.0,39.0,45.0,28.0,34.0,41.0,36.0,25.0,16.0,21.0,29.0,24.0,30.0,25.0,25.0,31.0,14.0,17.0,26.0,20.0,20.0,24.0,38.0,22.0,27.0,24.0,27.0,35.0,23.0,33.0,28.0,26.0,30.0,32.0,30.0,28.0,41.0,33.0,34.0,30.0,28.0,31.0,20.0,18.0,24.0,23.0,31.0,18.0,32.0,44.0,27.0,21.0,31.0,18.0,30.0,27.0,30.0,23.0,37.0,34.0,32.0,40.0,35.0,27.0,31.0,29.0,38.0,42.0,30.0,32.0,45.0,35.0,50.0,41.0,36.0,29.0,25.0,33.0,25.0,24.0,37.0,27.0,25.0,25.0,30.0,23.0,21.0,30.0,27.0,27.0,20.0,32.0,30.0,21.0,36.0,30.0,29.0,34.0,33.0,29.0,34.0,32.0,37.0,34.0,40.0,39.0,44.0,42.0,33.0,39.0,39.0,43.0,25.0,31.0,33.0,30.0,14.0,25.0,24.0,27.0,19.0,25.0,22.0,24.0,25.0,17.0,29.0,28.0,14.0,24.0,19.0,22.0,13.0,13.0,11.0,10.0,19.0,12.0,17.0,17.0,20.0,19.0,14.0,15.0,13.0,9.0,12.0,15.0,18.0,19.0,14.0,12.0,17.0,14.0,11.0,12.0,13.0,12.0,7.0,7.0,13.0,10.0,10.0,8.0,13.0,9.0,11.0,10.0,4.0,6.0,6.0,3.0,10.0:1
8.0,6.0,5.0,11.0,7.0,4.0,10.0,8.0,8.0,4.0,7.0,3.0,3.0,9.0,4.0,2.0,9.0,6.0,4.0,4.0,4.0,7.0,7.0,6.0,4.0,12.0,4.0,10.0,6.0,5.0,12.0,4.0,5.0,6.0,6.0,2.0,3.0,1.0,8.0,2.0,8.0,3.0,2.0,4.0,4.0,4.0,5.0,0.0,3.0,1.0,0.0,5.0,2.0,2.0,3.0,6.0,5.0,1.0,2.0,2.0,4.0,2.0,3.0,4.0,3.0,3.0,4.0,2.0,2.0,2.0,6.0,3.0,3.0,2.0,7.0,5.0,8.0,3.0,4.0,10.0,6.0,10.0,5.0,7.0,4.0,6.0,6.0,9.0,8.0,2.0,5.0,9.0,5.0,8.0,9.0,4.0,4.0,9.0,12.0,7.0,11.0,20.0,13.0,10.0,17.0,12.0,8.0,15.0,10.0,13.0,13.0,12.0,14.0,11.0,16.0,10.0,11.0,16.0,17.0,16.0,16.0,16.0,17.0,17.0,25.0,23.0,22.0,24.0,17.0,15.0,12.0,24.0,12.0,13.0,12.0,14.0,10.0,25.0,12.0,21.0,37.0,32.0,30.0,23.0,30.0,18.0,22.0,31.0,17.0,19.0,19.0,26.0,22.0,24.0,12.0,21.0,29.0,23.0,21.0,30.0,26.0,15.0,28.0,14.0,26.0,25.0,32.0,17.0,20.0,21.0,23.0,27.0,29.0,16.0,30.0,16.0,27.0,22.0,21.0,25.0,14.0,22.0,17.0,19.0,28.0,32.0,26.0,18.0,25.0,24.0,33.0,18.0,22.0,23.0,22.0,29.0,16.0,27.0,14.0,19.0,24.0,26.0,26.0,24.0,15.0,18.0,20.0,27.0,15.0,11.0,19.0,21.0,19.0,14.0,14.0,28.0,19.0,16.0,19.0,21.0,21.0,13.0,18.0,23.0,18.0,13.0,18.0,16.0,12.0,17.0,22.0,16.0,10.0,24.0,14.0,22.0,22.0,22.0,16.0,24.0,15.0,13.0,23.0,14.0,14.0,18.0,24.0,22.0,23.0,24.0,14.0,22.0,17.0,21.0,18.0,13.0,13.0,16.0,29.0,15.0,13.0,15.0,25.0,9.0,22.0,12.0,16.0,11.0,16.0,26.0,21.0,24.0,20.0,16.0,13.0,16.0,11.0,13.0,19.0,13.0,15.0,17.0,10.0,8.0,12.0,16.0,15.0,13.0:1
12.0,16.0,17.0,9.0,13.0,7.0,17.0,4.0,6.0,10.0,7.0,14.0,10.0,13.0,7.0,9.0,7.0,10.0,3.0,7.0,12.0,12.0,9.0,9.0,5.0,7.0,10.0,8.0,9.0,5.0,7.0,5.0,5.0,8.0,9.0,4.0,4.0,3.0,3.0,2.0,5.0,4.0,4.0,6.0,6.0,4.0,5.0,6.0,5.0,4.0,2.0,3.0,3.0,1.0,0.0,4.0,3.0,3.0,4.0,0.0,4.0,3.0,7.0,3.0,4.0,6.0,3.0,2.0,5.0,10.0,7.0,4.0,4.0,6.0,3.0,1.0,6.0,4.0,9.0,8.0,7.0,6.0,8.0,11.0,7.0,4.0,5.0,6.0,8.0,4.0,4.0,4.0,9.0,13.0,13.0,8.0,15.0,11.0,19.0,17.0,15.0,11.0,16.0,12.0,26.0,17.0,11.0,18.0,13.0,14.0,15.0,12.0,15.0,16.0,17.0,17.0,20.0,14.0,19.0,16.0,14.0,13.0,24.0,18.0,16.0,26.0,22.0,20.0,21.0,25.0,23.0,24.0,23.0,20.0,27.0,29.0,26.0,17.0,26.0,39.0,33.0,36.0,36.0,27.0,33.0,30.0,19.0,24.0,28.0,18.0,27.0,19.0,8.0,20.0,19.0,30.0,24.0,31.0,23.0,32.0,24.0,25.0,31.0,30.0,32.0,28.0,23.0,30.0,27.0,30.0,31.0,34.0,23.0,38.0,26.0,24.0,32.0,24.0,30.0,33.0,23.0,26.0,26.0,36.0,23.0,21.0,28.0,23.0,24.0,29.0,36.0,37.0,27.0,30.0,26.0,35.0,32.0,23.0,42.0,27.0,26.0,22.0,30.0,31.0,20.0,23.0,33.0,25.0,33.0,33.0,26.0,28.0,26.0,32.0,28.0,29.0,16.0,34.0,25.0,27.0,30.0,20.0,38.0,37.0,32.0,19.0,16.0,24.0,40.0,26.0,31.0,25.0,25.0,21.0,13.0,26.0,13.0,20.0,26.0,22.0,23.0,17.0,13.0,12.0,21.0,12.0,10.0,19.0,17.0,17.0,14.0,18.0,14.0,15.0,8.0,21.0,19.0,7.0,8.0,10.0,7.0,16.0,17.0,11.0,16.0,8.0,15.0,11.0,12.0,9.0,10.0,13.0,14.0,9.0,7.0,3.0,6.0,5.0,4.0,8.0,8.0,10.0,17.0,4.0,6.0,3.0,4.0,6.0:1
5.0,9.0,9.0,4.0,3.0,2.0,6.0,4.0,5.0,4.0,3.0,4.0,4.0,3.0,2.0,4.0,5.0,1.0,3.0,4.0,4.0,4.0,4.0,10.0,5.0,6.0,2.0,2.0,3.0,4.0,3.0,6.0,3.0,2.0,3.0,3.0,2.0,3.0,1.0,3.0,0.0,3.0,1.0,0.0,5.0,1.0,3.0,2.0,6.0,5.0,3.0,5.0,2.0,2.0,2.0,2.0,2.0,5.0,8.0,5.0,3.0,6.0,12.0,8.0,5.0,7.0,9.0,16.0,9.0,13.0,10.0,13.0,19.0,22.0,14.0,11.0,22.0,19.0,27.0,27.0,33.0,27.0,32.0,33.0,35.0,32.0,34.0,46.0,35.0,43.0,41.0,44.0,35.0,31.0,36.0,25.0,41.0,37.0,34.0,39.0,34.0,28.0,33.0,41.0,39.0,50.0,40.0,48.0,43.0,37.0,39.0,38.0,45.0,41.0,38.0,39.0,38.0,37.0,40.0,38.0,42.0,36.0,48.0,37.0,22.0,41.0,14.0,27.0,35.0,24.0,22.0,21.0,28.0,25.0,28.0,28.0,20.0,27.0,33.0,25.0,40.0,38.0,28.0,24.0,32.0,35.0,44.0,35.0,32.0,47.0,40.0,31.0,42.0,38.0,39.0,26.0,30.0,33.0,31.0,30.0,38.0,41.0,31.0,19.0,28.0,32.0,35.0,38.0,38.0,21.0,22.0,40.0,36.0,27.0,33.0,44.0,33.0,31.0,46.0,39.0,38.0,34.0,49.0,50.0,36.0,36.0,37.0,42.0,40.0,38.0,32.0,33.0,30.0,44.0,40.0,37.0,29.0,41.0,33.0,35.0,37.0,35.0,34.0,41.0,36.0,43.0,32.0,44.0,40.0,42.0,27.0,40.0,35.0,33.0,43.0,41.0,41.0,24.0,27.0,36.0,31.0,34.0,37.0,25.0,33.0,35.0,32.0,38.0,23.0,23.0,48.0,36.0,41.0,30.0,34.0,27.0,29.0,34.0,20.0,37.0,36.0,20.0,26.0,20.0,23.0,34.0,20.0,29.0,25.0,15.0,28.0,24.0,30.0,22.0,26.0,20.0,23.0,22.0,26.0,28.0,29.0,16.0,14.0,12.0,28.0,19.0,11.0,17.0,18.0,16.0,21.0,27.0,20.0,23.0,10.0,15.0,9.0,13.0,18.0,21.0,12.0,19.0,12.0,9.0,13.0,12.0,13.0,12.0:1
6.0,9.0,2.0,2.0,3.0,10.0,7.0,7.0,3.0,8.0,5.0,4.0,4.0,8.0,6.0,3.0,5.0,2.0,5.0,3.0,4.0,6.0,1.0,2.0,7.0,7.0,7.0,7.0,4.0,3.0,4.0,2.0,3.0,3.0,3.0,1.0,2.0,0.0,0.0,2.0,0.0,2.0,7.0,2.0,1.0,2.0,0.0,3.0,4.0,4.0,3.0,7.0,0.0,1.0,2.0,3.0,4.0,4.0,4.0,7.0,9.0,10.0,3.0,4.0,8.0,7.0,12.0,9.0,11.0,9.0,9.0,11.0,16.0,13.0,16.0,15.0,15.0,16.0,18.0,29.0,20.0,24.0,40.0,25.0,35.0,36.0,41.0,44.0,44.0,30.0,38.0,43.0,51.0,36.0,40.0,42.0,38.0,38.0,49.0,43.0,40.0,41.0,34.0,52.0,47.0,50.0,54.0,47.0,43.0,41.0,40.0,38.0,33.0,36.0,44.0,36.0,37.0,50.0,38.0,36.0,35.0,33.0,26.0,35.0,37.0,29.0,23.0,33.0,40.0,34.0,29.0,26.0,34.0,28.0,25.0,23.0,30.0,31.0,31.0,19.0,26.0,19.0,36.0,28.0,26.0,28.0,17.0,15.0,28.0,33.0,34.0,38.0,23.0,44.0,36.0,33.0,25.0,26.0,27.0,30.0,35.0,24.0,33.0,21.0,25.0,?,?,?,?,21.0,31.0,28.0,37.0,38.0,34.0,37.0,41.0,41.0,45.0,50.0,37.0,33.0,49.0,34.0,45.0,45.0,52.0,53.0,39.0,29.0,42.0,34.0,41.0,42.0,39.0,42.0,37.0,28.0,27.0,33.0,43.0,33.0,37.0,36.0,49.0,38.0,37.0,25.0,41.0,43.0,25.0,35.0,38.0,46.0,35.0,30.0,37.0,23.0,37.0,35.0,44.0,41.0,29.0,27.0,36.0,37.0,23.0,36.0,40.0,33.0,36.0,29.0,25.0,35.0,27.0,31.0,28.0,29.0,25.0,22.0,34.0,16.0,26.0,17.0,13.0,18.0,15.0,27.0,17.0,26.0,24.0,10.0,23.0,14.0,14.0,29.0,22.0,21.0,13.0,21.0,23.0,15.0,13.0,20.0,12.0,16.0,8.0,17.0,21.0,16.0,21.0,33.0,20.0,26.0,12.0,16.0,14.0,12.0,8.0,12.0,10.0,14.0,11.0,6.0,8.0,7.0,12.0,7.0:1
5.0,8.0,8.0,8.0,7.0,4.0,4.0,2.0,5.0,2.0,4.0,2.0,8.0,3.0,3.0,5.0,2.0,6.0,6.0,3.0,8.0,7.0,8.0,4.0,1.0,1.0,6.0,2.0,1.0,1.0,5.0,0.0,3.0,1.0,5.0,4.0,2.0,3.0,6.0,3.0,7.0,7.0,3.0,2.0,1.0,4.0,2.0,0.0,1.0,3.0,3.0,1.0,2.0,5.0,3.0,2.0,6.0,5.0,6.0,5.0,6.0,4.0,6.0,6.0,4.0,6.0,6.0,12.0,10.0,15.0,9.0,15.0,10.0,13.0,14.0,20.0,16.0,14.0,27.0,24.0,23.0,22.0,17.0,20.0,30.0,24.0,20.0,33.0,38.0,38.0,20.0,25.0,35.0,32.0,27.0,26.0,25.0,44.0,31.0,31.0,19.0,38.0,29.0,35.0,29.0,48.0,20.0,38.0,34.0,36.0,42.0,24.0,28.0,18.0,33.0,30.0,26.0,33.0,21.0,25.0,32.0,23.0,39.0,25.0,20.0,37.0,36.0,35.0,39.0,25.0,22.0,32.0,35.0,23.0,29.0,30.0,29.0,17.0,26.0,21.0,23.0,13.0,29.0,26.0,14.0,19.0,22.0,15.0,32.0,30.0,35.0,25.0,22.0,23.0,30.0,21.0,20.0,32.0,38.0,27.0,24.0,37.0,26.0,23.0,27.0,19.0,26.0,28.0,30.0,28.0,25.0,36.0,19.0,31.0,20.0,34.0,42.0,31.0,19.0,30.0,43.0,43.0,33.0,36.0,42.0,43.0,44.0,32.0,38.0,34.0,21.0,36.0,35.0,29.0,16.0,38.0,31.0,30.0,32.0,35.0,28.0,33.0,35.0,30.0,32.0,37.0,39.0,28.0,24.0,16.0,23.0,27.0,33.0,37.0,24.0,27.0,35.0,41.0,33.0,30.0,37.0,38.0,36.0,33.0,33.0,26.0,37.0,32.0,19.0,13.0,26.0,30.0,25.0,22.0,18.0,30.0,23.0,31.0,20.0,18.0,22.0,11.0,19.0,12.0,24.0,17.0,17.0,26.0,16.0,21.0,13.0,9.0,19.0,14.0,14.0,8.0,8.0,22.0,17.0,10.0,16.0,12.0,12.0,15.0,12.0,13.0,10.0,16.0,8.0,9.0,11.0,7.0,7.0,12.0,5.0,5.0,15.0,13.0,10.0,7.0,10.0,9.0,11.0,1.0,9.0,2.0,8.0,4.0:1
13.0,7.0,10.0,6.0,12.0,4.0,12.0,9.0,7.0,7.0,7.0,4.0,2.0,11.0,0.0,4.0,7.0,8.0,9.0,6.0,16.0,7.0,14.0,4.0,3.0,7.0,9.0,5.0,5.0,4.0,6.0,6.0,4.0,7.0,8.0,5.0,2.0,7.0,3.0,4.0,6.0,3.0,1.0,1.0,2.0,1.0,0.0,5.0,0.0,5.0,2.0,1.0,2.0,3.0,1.0,1.0,3.0,4.0,4.0,4.0,3.0,3.0,2.0,6.0,3.0,5.0,4.0,7.0,4.0,8.0,6.0,3.0,4.0,9.0,10.0,8.0,4.0,4.0,17.0,11.0,9.0,7.0,11.0,15.0,15.0,8.0,12.0,15.0,12.0,12.0,20.0,15.0,13.0,16.0,17.0,11.0,21.0,10.0,18.0,11.0,11.0,15.0,15.0,13.0,17.0,21.0,32.0,18.0,23.0,12.0,23.0,27.0,14.0,23.0,21.0,20.0,27.0,30.0,21.0,29.0,24.0,17.0,18.0,22.0,23.0,35.0,23.0,27.0,26.0,11.0,11.0,22.0,17.0,26.0,16.0,19.0,19.0,17.0,17.0,30.0,34.0,35.0,26.0,24.0,16.0,28.0,23.0,27.0,17.0,33.0,19.0,16.0,27.0,26.0,23.0,32.0,26.0,23.0,27.0,21.0,19.0,22.0,25.0,41.0,28.0,29.0,27.0,21.0,27.0,21.0,26.0,27.0,23.0,40.0,30.0,32.0,23.0,20.0,26.0,32.0,17.0,29.0,24.0,27.0,11.0,18.0,24.0,21.0,14.0,15.0,17.0,13.0,28.0,33.0,40.0,25.0,23.0,21.0,27.0,22.0,30.0,22.0,27.0,10.0,35.0,27.0,19.0,33.0,23.0,33.0,22.0,27.0,25.0,19.0,22.0,25.0,26.0,16.0,28.0,29.0,23.0,30.0,32.0,25.0,36.0,17.0,32.0,20.0,15.0,38.0,18.0,24.0,31.0,23.0,26.0,30.0,22.0,23.0,29.0,28.0,18.0,18.0,29.0,12.0,13.0,35.0,24.0,20.0,20.0,18.0,19.0,19.0,24.0,13.0,10.0,22.0,33.0,18.0,18.0,8.0,25.0,12.0,19.0,21.0,17.0,11.0,30.0,23.0,19.0,12.0,22.0,14.0,15.0,10.0,14.0,16.0,17.0,17.0,14.0,23.0,11.0,9.0,16.0,20.0,13.0,10.0,7.0,16.0:1
10.0,11.0,5.0,6.0,7.0,9.0,9.0,5.0,10.0,4.0,2.0,7.0,2.0,1.0,4.0,4.0,8.0,11.0,3.0,3.0,7.0,6.0,5.0,5.0,9.0,4.0,5.0,1.0,6.0,5.0,5.0,4.0,3.0,4.0,2.0,3.0,3.0,2.0,3.0,3.0,3.0,2.0,0.0,3.0,1.0,1.0,4.0,3.0,5.0,6.0,1.0,3.0,4.0,2.0,2.0,2.0,0.0,1.0,4.0,3.0,2.0,3.0,3.0,8.0,3.0,2.0,3.0,1.0,7.0,11.0,5.0,5.0,6.0,9.0,7.0,7.0,1.0,12.0,8.0,13.0,10.0,13.0,5.0,14.0,8.0,7.0,6.0,6.0,9.0,14.0,17.0,16.0,17.0,25.0,25.0,16.0,22.0,18.0,15.0,11.0,15.0,15.0,25.0,24.0,23.0,23.0,20.0,27.0,24.0,20.0,20.0,11.0,21.0,30.0,23.0,22.0,22.0,25.0,27.0,14.0,22.0,21.0,25.0,22.0,25.0,27.0,33.0,25.0,27.0,15.0,13.0,22.0,16.0,22.0,28.0,28.0,24.0,21.0,20.0,32.0,21.0,24.0,28.0,35.0,34.0,36.0,34.0,30.0,30.0,31.0,25.0,29.0,28.0,28.0,33.0,28.0,30.0,19.0,15.0,21.0,26.0,21.0,20.0,30.0,21.0,27.0,19.0,24.0,27.0,21.0,26.0,25.0,26.0,34.0,23.0,24.0,31.0,22.0,22.0,22.0,19.0,22.0,20.0,22.0,33.0,23.0,29.0,22.0,32.0,22.0,27.0,23.0,22.0,22.0,26.0,21.0,29.0,35.0,20.0,30.0,30.0,13.0,15.0,24.0,29.0,27.0,20.0,23.0,28.0,26.0,18.0,25.0,23.0,24.0,24.0,42.0,34.0,36.0,34.0,29.0,27.0,25.0,33.0,27.0,26.0,28.0,28.0,23.0,27.0,36.0,29.0,30.0,22.0,25.0,27.0,29.0,22.0,20.0,28.0,19.0,15.0,15.0,14.0,9.0,18.0,21.0,15.0,26.0,17.0,31.0,31.0,22.0,29.0,23.0,29.0,30.0,31.0,17.0,16.0,23.0,23.0,26.0,25.0,18.0,27.0,17.0,23.0,13.0,27.0,16.0,35.0,19.0,23.0,13.0,16.0,15.0,23.0,23.0,18.0,19.0,19.0,16.0,16.0,16.0,7.0,16.0,9.0,12.0:1
13.0,14.0,18.0,11.0,11.0,13.0,13.0,2.0,8.0,10.0,5.0,13.0,3.0,5.0,3.0,8.0,2.0,3.0,3.0,9.0,8.0,3.0,4.0,4.0,8.0,12.0,11.0,7.0,10.0,11.0,4.0,1.0,2.0,5.0,4.0,9.0,4.0,2.0,3.0,4.0,6.0,3.0,4.0,3.0,5.0,3.0,6.0,8.0,4.0,2.0,3.0,3.0,5.0,4.0,2.0,4.0,7.0,3.0,1.0,5.0,3.0,3.0,1.0,0.0,4.0,2.0,5.0,2.0,5.0,5.0,10.0,3.0,6.0,4.0,2.0,7.0,3.0,9.0,9.0,3.0,8.0,4.0,3.0,3.0,9.0,6.0,10.0,2.0,4.0,10.0,7.0,11.0,18.0,13.0,8.0,8.0,8.0,18.0,8.0,12.0,12.0,13.0,16.0,19.0,14.0,11.0,16.0,17.0,9.0,5.0,21.0,18.0,6.0,8.0,18.0,19.0,15.0,16.0,19.0,16.0,17.0,19.0,14.0,19.0,24.0,17.0,20.0,18.0,15.0,20.0,20.0,14.0,22.0,17.0,24.0,18.0,14.0,30.0,23.0,24.0,21.0,26.0,32.0,24.0,21.0,29.0,22.0,23.0,25.0,24.0,21.0,26.0,28.0,22.0,19.0,23.0,25.0,32.0,28.0,23.0,33.0,13.0,28.0,33.0,30.0,21.0,27.0,31.0,34.0,28.0,29.0,17.0,17.0,18.0,26.0,31.0,25.0,32.0,26.0,22.0,23.0,25.0,20.0,22.0,22.0,27.0,28.0,21.0,35.0,21.0,29.0,22.0,23.0,20.0,34.0,40.0,23.0,30.0,22.0,32.0,30.0,22.0,30.0,30.0,30.0,32.0,39.0,29.0,20.0,27.0,33.0,25.0,24.0,24.0,32.0,36.0,38.0,27.0,19.0,29.0,27.0,21.0,20.0,24.0,26.0,10.0,20.0,21.0,35.0,24.0,15.0,17.0,19.0,19.0,15.0,18.0,16.0,21.0,15.0,28.0,18.0,17.0,18.0,19.0,8.0,9.0,17.0,21.0,11.0,14.0,18.0,18.0,23.0,19.0,28.0,20.0,15.0,13.0,22.0,20.0,19.0,7.0,12.0,19.0,9.0,11.0,13.0,6.0,10.0,19.0,20.0,8.0,10.0,11.0,14.0,20.0,18.0,14.0,4.0,11.0,9.0,1.0,0.0,0.0,0.0,1.0,0.0,0.0:1
4.0,6.0,9.0,5.0,8.0,6.0,4.0,5.0,3.0,1.0,6.0,1.0,4.0,3.0,2.0,0.0,3.0,0.0,1.0,4.0,4.0,3.0,1.0,1.0,4.0,4.0,2.0,3.0,4.0,3.0,3.0,0.0,1.0,0.0,2.0,1.0,2.0,0.0,0.0,2.0,3.0,0.0,1.0,1.0,0.0,2.0,2.0,3.0,2.0,0.0,3.0,3.0,0.0,5.0,1.0,3.0,6.0,4.0,8.0,5.0,6.0,4.0,8.0,4.0,5.0,5.0,11.0,9.0,9.0,11.0,16.0,19.0,15.0,16.0,17.0,18.0,19.0,24.0,25.0,30.0,38.0,16.0,27.0,41.0,31.0,43.0,35.0,45.0,26.0,41.0,39.0,36.0,49.0,41.0,35.0,24.0,29.0,34.0,34.0,33.0,32.0,38.0,32.0,43.0,38.0,41.0,33.0,38.0,36.0,32.0,27.0,31.0,36.0,33.0,34.0,35.0,47.0,34.0,34.0,22.0,29.0,40.0,29.0,29.0,31.0,33.0,24.0,26.0,24.0,16.0,18.0,25.0,25.0,21.0,23.0,22.0,17.0,25.0,20.0,18.0,21.0,15.0,26.0,24.0,24.0,35.0,39.0,30.0,29.0,25.0,41.0,37.0,35.0,27.0,37.0,18.0,25.0,19.0,36.0,29.0,33.0,37.0,24.0,27.0,25.0,23.0,27.0,33.0,17.0,22.0,27.0,29.0,22.0,13.0,31.0,26.0,43.0,31.0,27.0,43.0,29.0,26.0,25.0,42.0,50.0,27.0,35.0,32.0,38.0,41.0,46.0,45.0,44.0,41.0,37.0,44.0,37.0,37.0,30.0,39.0,29.0,34.0,32.0,24.0,35.0,34.0,32.0,24.0,30.0,24.0,31.0,41.0,30.0,34.0,31.0,30.0,28.0,26.0,29.0,17.0,39.0,31.0,40.0,42.0,35.0,41.0,35.0,27.0,20.0,16.0,26.0,23.0,30.0,22.0,26.0,25.0,32.0,26.0,18.0,34.0,25.0,30.0,13.0,23.0,26.0,23.0,16.0,24.0,13.0,22.0,15.0,15.0,20.0,13.0,17.0,18.0,10.0,22.0,23.0,10.0,19.0,16.0,10.0,18.0,19.0,12.0,21.0,17.0,16.0,7.0,8.0,11.0,13.0,9.0,14.0,8.0,6.0,7.0,7.0,8.0,11.0,7.0,1.0,8.0,5.0,7.0,8.0,6.0:1
4.0,6.0,8.0,4.0,2.0,4.0,1.0,10.0,5.0,2.0,1.0,3.0,3.0,3.0,1.0,1.0,2.0,5.0,0.0,2.0,4.0,5.0,4.0,1.0,3.0,1.0,3.0,5.0,2.0,0.0,1.0,3.0,3.0,2.0,0.0,8.0,0.0,1.0,3.0,4.0,1.0,2.0,3.0,2.0,2.0,2.0,1.0,1.0,2.0,2.0,3.0,2.0,1.0,6.0,4.0,2.0,7.0,2.0,3.0,5.0,5.0,3.0,4.0,2.0,8.0,6.0,5.0,15.0,6.0,7.0,9.0,10.0,12.0,11.0,8.0,12.0,18.0,12.0,28.0,17.0,23.0,29.0,30.0,20.0,16.0,31.0,37.0,43.0,40.0,25.0,25.0,25.0,28.0,37.0,30.0,40.0,44.0,35.0,28.0,37.0,29.0,35.0,43.0,43.0,36.0,34.0,38.0,37.0,32.0,32.0,37.0,36.0,34.0,43.0,21.0,35.0,28.0,30.0,26.0,26.0,35.0,29.0,31.0,23.0,20.0,21.0,24.0,22.0,32.0,4.0,20.0,20.0,23.0,20.0,20.0,25.0,15.0,23.0,28.0,30.0,22.0,16.0,25.0,36.0,37.0,26.0,24.0,29.0,23.0,24.0,27.0,21.0,21.0,30.0,31.0,24.0,24.0,31.0,27.0,19.0,19.0,31.0,?,25.0,29.0,40.0,20.0,34.0,34.0,22.0,28.0,29.0,31.0,26.0,31.0,26.0,40.0,37.0,43.0,40.0,29.0,30.0,43.0,35.0,26.0,34.0,42.0,44.0,41.0,32.0,31.0,40.0,22.0,30.0,31.0,36.0,27.0,39.0,28.0,36.0,19.0,31.0,37.0,38.0,23.0,33.0,35.0,36.0,35.0,40.0,35.0,33.0,27.0,23.0,31.0,30.0,22.0,26.0,41.0,22.0,27.0,23.0,26.0,27.0,29.0,35.0,21.0,29.0,25.0,22.0,29.0,21.0,24.0,26.0,24.0,20.0,16.0,19.0,15.0,16.0,13.0,20.0,9.0,23.0,16.0,14.0,20.0,14.0,19.0,15.0,16.0,14.0,11.0,18.0,19.0,19.0,17.0,12.0,14.0,28.0,10.0,9.0,20.0,15.0,9.0,12.0,14.0,14.0,10.0,12.0,9.0,13.0,10.0,8.0,13.0,11.0,6.0,9.0,15.0,6.0,3.0,11.0,7.0,7.0,4.0,2.0,4.0,4.0:1
19.0,13.0,9.0,14.0,14.0,13.0,4.0,10.0,9.0,7.0,9.0,6.0,8.0,3.0,4.0,3.0,7.0,7.0,4.0,6.0,8.0,9.0,5.0,7.0,7.0,9.0,3.0,9.0,9.0,2.0,4.0,7.0,4.0,11.0,10.0,1.0,9.0,5.0,7.0,13.0,11.0,8.0,13.0,17.0,9.0,5.0,7.0,3.0,6.0,4.0,3.0,1.0,5.0,2.0,4.0,1.0,2.0,2.0,4.0,4.0,4.0,3.0,4.0,2.0,2.0,3.0,0.0,0.0,3.0,1.0,7.0,6.0,6.0,1.0,2.0,5.0,9.0,8.0,6.0,6.0,9.0,8.0,5.0,9.0,3.0,7.0,5.0,4.0,7.0,9.0,7.0,6.0,10.0,7.0,10.0,14.0,7.0,10.0,13.0,13.0,11.0,9.0,11.0,14.0,13.0,11.0,15.0,16.0,15.0,27.0,23.0,12.0,20.0,23.0,10.0,12.0,18.0,28.0,11.0,21.0,11.0,18.0,12.0,12.0,21.0,22.0,28.0,24.0,20.0,25.0,23.0,19.0,21.0,27.0,15.0,21.0,27.0,19.0,33.0,15.0,23.0,24.0,26.0,18.0,14.0,20.0,24.0,14.0,21.0,15.0,25.0,15.0,26.0,14.0,15.0,20.0,15.0,12.0,38.0,28.0,21.0,23.0,21.0,25.0,24.0,28.0,23.0,21.0,30.0,26.0,20.0,36.0,29.0,34.0,37.0,38.0,28.0,29.0,21.0,25.0,25.0,22.0,16.0,34.0,20.0,30.0,18.0,32.0,27.0,23.0,17.0,29.0,25.0,30.0,18.0,29.0,39.0,29.0,28.0,25.0,16.0,19.0,16.0,20.0,14.0,25.0,24.0,26.0,28.0,29.0,31.0,17.0,27.0,21.0,21.0,28.0,26.0,22.0,29.0,29.0,20.0,21.0,13.0,27.0,26.0,29.0,18.0,18.0,24.0,17.0,21.0,16.0,18.0,27.0,29.0,21.0,19.0,14.0,18.0,18.0,22.0,16.0,12.0,17.0,14.0,16.0,16.0,23.0,19.0,11.0,9.0,19.0,17.0,9.0,12.0,16.0,14.0,20.0,16.0,10.0,9.0,17.0,13.0,9.0,17.0,17.0,18.0,18.0,8.0,12.0,8.0,15.0,5.0,5.0,13.0,16.0,10.0,6.0,7.0,6.0,6.0,4.0,8.0,5.0,6.0,9.0,3.0,4.0:1
3.0,5.0,2.0,10.0,3.0,5.0,1.0,3.0,4.0,8.0,6.0,1.0,4.0,6.0,4.0,3.0,3.0,5.0,3.0,4.0,4.0,4.0,1.0,8.0,2.0,4.0,2.0,2.0,2.0,1.0,3.0,0.0,4.0,2.0,1.0,1.0,4.0,1.0,2.0,0.0,4.0,1.0,2.0,1.0,0.0,1.0,3.0,3.0,4.0,6.0,4.0,1.0,3.0,3.0,0.0,4.0,4.0,7.0,6.0,7.0,3.0,6.0,9.0,6.0,9.0,8.0,6.0,11.0,8.0,17.0,10.0,13.0,12.0,12.0,21.0,15.0,17.0,18.0,20.0,22.0,19.0,26.0,26.0,28.0,24.0,43.0,36.0,35.0,43.0,39.0,45.0,46.0,43.0,34.0,43.0,40.0,47.0,27.0,25.0,42.0,40.0,41.0,38.0,31.0,38.0,39.0,51.0,40.0,28.0,48.0,37.0,30.0,35.0,35.0,37.0,29.0,34.0,33.0,35.0,21.0,35.0,36.0,33.0,28.0,14.0,27.0,26.0,23.0,27.0,27.0,18.0,23.0,13.0,22.0,24.0,21.0,38.0,32.0,21.0,18.0,24.0,30.0,20.0,23.0,22.0,24.0,29.0,19.0,22.0,33.0,20.0,29.0,29.0,30.0,29.0,27.0,22.0,35.0,22.0,33.0,37.0,25.0,21.0,18.0,25.0,19.0,29.0,17.0,21.0,24.0,27.0,28.0,40.0,35.0,33.0,32.0,46.0,44.0,40.0,23.0,35.0,37.0,43.0,37.0,43.0,39.0,32.0,42.0,43.0,47.0,29.0,39.0,37.0,41.0,45.0,43.0,37.0,40.0,39.0,38.0,41.0,41.0,45.0,30.0,39.0,39.0,44.0,53.0,27.0,34.0,42.0,41.0,31.0,32.0,38.0,33.0,31.0,34.0,35.0,36.0,47.0,32.0,38.0,47.0,37.0,36.0,32.0,22.0,20.0,20.0,29.0,27.0,34.0,21.0,24.0,25.0,29.0,27.0,26.0,19.0,14.0,20.0,15.0,15.0,18.0,17.0,20.0,22.0,10.0,18.0,10.0,13.0,14.0,12.0,20.0,17.0,13.0,7.0,19.0,15.0,21.0,13.0,12.0,10.0,4.0,10.0,9.0,11.0,10.0,13.0,13.0,17.0,10.0,8.0,10.0,8.0,8.0,12.0,8.0,11.0,6.0,9.0,4.0,8.0,5.0,6.0,10.0,4.0:1
5.0,9.0,8.0,4.0,7.0,2.0,9.0,2.0,5.0,5.0,4.0,4.0,6.0,3.0,3.0,3.0,1.0,4.0,4.0,3.0,2.0,3.0,0.0,0.0,0.0,2.0,4.0,2.0,2.0,0.0,1.0,3.0,2.0,3.0,2.0,1.0,1.0,2.0,1.0,3.0,4.0,1.0,3.0,2.0,3.0,3.0,4.0,3.0,2.0,2.0,3.0,3.0,3.0,0.0,3.0,2.0,2.0,8.0,8.0,6.0,3.0,5.0,7.0,4.0,11.0,6.0,12.0,8.0,11.0,7.0,11.0,9.0,9.0,12.0,16.0,13.0,14.0,21.0,16.0,19.0,28.0,28.0,24.0,22.0,12.0,37.0,29.0,36.0,40.0,40.0,28.0,41.0,27.0,38.0,27.0,43.0,42.0,40.0,32.0,48.0,31.0,29.0,40.0,54.0,51.0,34.0,50.0,42.0,0.0,3.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,1.0,0.0,0.0,2.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,1.0,1.0,34.0,25.0,24.0,28.0,31.0,30.0,35.0,23.0,26.0,20.0,35.0,30.0,37.0,32.0,36.0,28.0,36.0,26.0,33.0,42.0,33.0,34.0,28.0,37.0,45.0,44.0,39.0,36.0,42.0,34.0,36.0,31.0,47.0,25.0,25.0,34.0,29.0,44.0,36.0,35.0,34.0,26.0,35.0,29.0,36.0,34.0,39.0,38.0,31.0,30.0,26.0,35.0,31.0,23.0,31.0,28.0,28.0,37.0,32.0,37.0,42.0,28.0,24.0,39.0,26.0,34.0,20.0,31.0,30.0,32.0,24.0,27.0,26.0,34.0,29.0,23.0,25.0,21.0,16.0,26.0,10.0,19.0,23.0,16.0,25.0,13.0,12.0,21.0,14.0,22.0,8.0,13.0,11.0,10.0,16.0,14.0,13.0,25.0,19.0,8.0,15.0,8.0,14.0,11.0,19.0,12.0,16.0,12.0,11.0,11.0,17.0,6.0,14.0,7.0,8.0,9.0,9.0,18.0,6.0,7.0,4.0,8.0,8.0,12.0,9.0:1
14.0,4.0,5.0,3.0,9.0,7.0,3.0,10.0,8.0,7.0,5.0,3.0,5.0,6.0,6.0,2.0,3.0,4.0,5.0,2.0,5.0,7.0,6.0,6.0,14.0,3.0,2.0,3.0,6.0,6.0,4.0,5.0,3.0,2.0,4.0,3.0,3.0,2.0,1.0,1.0,1.0,3.0,3.0,2.0,1.0,2.0,3.0,0.0,0.0,2.0,3.0,1.0,0.0,4.0,3.0,5.0,9.0,6.0,11.0,0.0,7.0,7.0,6.0,5.0,3.0,7.0,17.0,8.0,11.0,8.0,9.0,11.0,9.0,11.0,18.0,13.0,10.0,9.0,16.0,19.0,29.0,30.0,18.0,23.0,32.0,33.0,26.0,36.0,40.0,24.0,37.0,15.0,37.0,33.0,33.0,33.0,26.0,23.0,33.0,22.0,21.0,25.0,27.0,27.0,23.0,34.0,28.0,38.0,44.0,42.0,45.0,45.0,27.0,40.0,40.0,37.0,45.0,43.0,30.0,36.0,37.0,31.0,32.0,29.0,33.0,32.0,25.0,21.0,29.0,23.0,16.0,30.0,29.0,23.0,25.0,32.0,21.0,27.0,12.0,23.0,19.0,29.0,30.0,30.0,27.0,11.0,34.0,35.0,32.0,21.0,36.0,29.0,31.0,30.0,35.0,24.0,39.0,34.0,37.0,27.0,34.0,26.0,32.0,22.0,30.0,14.0,16.0,20.0,29.0,19.0,30.0,27.0,22.0,33.0,40.0,28.0,36.0,38.0,40.0,31.0,47.0,34.0,47.0,44.0,47.0,41.0,47.0,40.0,39.0,46.0,46.0,49.0,35.0,32.0,32.0,22.0,28.0,25.0,10.0,27.0,27.0,38.0,31.0,30.0,31.0,27.0,28.0,35.0,36.0,29.0,28.0,28.0,28.0,33.0,26.0,24.0,22.0,31.0,25.0,21.0,21.0,32.0,38.0,32.0,40.0,46.0,38.0,28.0,24.0,25.0,27.0,24.0,24.0,29.0,25.0,24.0,26.0,20.0,25.0,23.0,23.0,21.0,20.0,18.0,20.0,31.0,29.0,23.0,21.0,14.0,35.0,25.0,22.0,14.0,20.0,21.0,17.0,17.0,23.0,18.0,19.0,7.0,21.0,17.0,19.0,19.0,23.0,17.0,24.0,26.0,22.0,22.0,22.0,19.0,18.0,20.0,12.0,18.0,20.0,17.0,22.0,14.0,11.0,15.0,9.0,18.0,4.0,9.0:1
7.0,9.0,8.0,4.0,4.0,3.0,6.0,2.0,3.0,7.0,4.0,10.0,4.0,4.0,4.0,6.0,1.0,6.0,4.0,4.0,3.0,1.0,2.0,0.0,8.0,6.0,5.0,2.0,4.0,2.0,2.0,5.0,0.0,2.0,2.0,2.0,2.0,2.0,2.0,0.0,2.0,3.0,2.0,4.0,1.0,0.0,4.0,3.0,2.0,1.0,4.0,7.0,3.0,1.0,2.0,5.0,6.0,6.0,4.0,6.0,3.0,12.0,7.0,8.0,7.0,7.0,9.0,13.0,6.0,7.0,16.0,9.0,6.0,13.0,14.0,17.0,13.0,16.0,27.0,22.0,22.0,35.0,27.0,25.0,39.0,30.0,39.0,38.0,40.0,27.0,39.0,42.0,41.0,33.0,29.0,47.0,41.0,32.0,28.0,41.0,42.0,37.0,26.0,33.0,39.0,35.0,48.0,39.0,44.0,34.0,26.0,31.0,34.0,29.0,42.0,36.0,26.0,38.0,27.0,38.0,24.0,17.0,39.0,15.0,21.0,34.0,30.0,32.0,23.0,32.0,31.0,29.0,20.0,36.0,29.0,20.0,27.0,27.0,23.0,19.0,21.0,27.0,36.0,33.0,24.0,22.0,21.0,26.0,30.0,24.0,28.0,25.0,27.0,27.0,35.0,27.0,28.0,25.0,18.0,28.0,26.0,34.0,27.0,30.0,26.0,30.0,18.0,20.0,23.0,36.0,27.0,40.0,30.0,32.0,35.0,28.0,32.0,43.0,31.0,37.0,31.0,30.0,45.0,42.0,31.0,47.0,45.0,37.0,35.0,29.0,43.0,35.0,30.0,39.0,41.0,42.0,35.0,29.0,27.0,38.0,32.0,40.0,34.0,31.0,46.0,38.0,36.0,44.0,38.0,50.0,40.0,32.0,42.0,34.0,36.0,27.0,40.0,32.0,25.0,36.0,46.0,43.0,30.0,28.0,31.0,32.0,28.0,29.0,28.0,22.0,16.0,38.0,31.0,33.0,20.0,29.0,22.0,36.0,24.0,17.0,20.0,14.0,19.0,24.0,20.0,27.0,16.0,24.0,14.0,20.0,19.0,17.0,26.0,26.0,18.0,22.0,6.0,10.0,18.0,21.0,12.0,17.0,13.0,16.0,11.0,11.0,10.0,17.0,12.0,14.0,13.0,15.0,7.0,11.0,15.0,6.0,15.0,4.0,11.0,13.0,9.0,7.0,10.0,2.0,4.0,5.0,5.0,6.0:1
6.0,5.0,8.0,5.0,4.0,7.0,4.0,4.0,7.0,1.0,1.0,2.0,6.0,2.0,3.0,2.0,2.0,4.0,2.0,1.0,5.0,2.0,2.0,1.0,1.0,3.0,2.0,1.0,1.0,0.0,3.0,2.0,2.0,2.0,1.0,1.0,2.0,1.0,3.0,1.0,2.0,1.0,1.0,2.0,1.0,0.0,2.0,1.0,1.0,3.0,7.0,0.0,2.0,1.0,0.0,4.0,5.0,4.0,3.0,6.0,5.0,3.0,4.0,4.0,7.0,4.0,8.0,11.0,8.0,15.0,11.0,14.0,11.0,24.0,15.0,14.0,16.0,19.0,31.0,24.0,31.0,28.0,23.0,24.0,28.0,36.0,40.0,49.0,32.0,33.0,36.0,32.0,32.0,36.0,29.0,35.0,29.0,27.0,32.0,26.0,31.0,29.0,28.0,34.0,38.0,57.0,33.0,40.0,43.0,28.0,34.0,29.0,29.0,33.0,32.0,37.0,25.0,16.0,28.0,39.0,36.0,35.0,32.0,33.0,27.0,32.0,28.0,30.0,34.0,26.0,28.0,27.0,20.0,18.0,33.0,35.0,22.0,26.0,24.0,22.0,34.0,36.0,24.0,26.0,27.0,19.0,20.0,15.0,19.0,30.0,31.0,30.0,34.0,37.0,31.0,37.0,22.0,30.0,19.0,30.0,12.0,25.0,32.0,39.0,26.0,25.0,25.0,31.0,29.0,32.0,40.0,30.0,31.0,28.0,20.0,48.0,47.0,38.0,33.0,34.0,37.0,29.0,55.0,50.0,41.0,48.0,40.0,33.0,36.0,47.0,49.0,43.0,47.0,43.0,51.0,38.0,43.0,45.0,44.0,39.0,37.0,33.0,25.0,38.0,39.0,37.0,27.0,29.0,29.0,32.0,34.0,28.0,25.0,24.0,30.0,18.0,26.0,29.0,32.0,27.0,20.0,25.0,22.0,29.0,31.0,34.0,20.0,34.0,12.0,23.0,25.0,24.0,19.0,28.0,18.0,19.0,26.0,27.0,22.0,33.0,22.0,19.0,20.0,14.0,14.0,28.0,12.0,17.0,13.0,24.0,11.0,22.0,23.0,18.0,23.0,24.0,18.0,15.0,20.0,11.0,15.0,16.0,11.0,10.0,17.0,13.0,13.0,18.0,18.0,13.0,10.0,12.0,17.0,8.0,6.0,7.0,8.0,12.0,3.0,3.0,10.0,7.0,5.0,6.0,9.0,5.0,2.0,8.0:1
3.0,4.0,5.0,7.0,4.0,4.0,8.0,10.0,8.0,5.0,9.0,3.0,2.0,2.0,4.0,3.0,9.0,3.0,5.0,2.0,1.0,1.0,3.0,3.0,5.0,4.0,4.0,5.0,2.0,1.0,0.0,3.0,1.0,1.0,2.0,4.0,1.0,1.0,0.0,3.0,0.0,4.0,2.0,1.0,0.0,2.0,2.0,2.0,0.0,2.0,5.0,1.0,3.0,1.0,1.0,4.0,2.0,9.0,9.0,4.0,5.0,2.0,6.0,7.0,6.0,8.0,9.0,9.0,8.0,13.0,8.0,8.0,13.0,22.0,13.0,16.0,16.0,26.0,14.0,25.0,30.0,32.0,33.0,30.0,27.0,37.0,46.0,26.0,26.0,20.0,33.0,36.0,41.0,44.0,36.0,27.0,33.0,35.0,34.0,32.0,37.0,47.0,44.0,42.0,55.0,41.0,46.0,42.0,30.0,36.0,33.0,30.0,35.0,41.0,33.0,35.0,34.0,35.0,33.0,34.0,32.0,22.0,29.0,27.0,31.0,23.0,23.0,17.0,23.0,37.0,21.0,17.0,10.0,28.0,28.0,18.0,28.0,28.0,27.0,11.0,18.0,37.0,23.0,30.0,37.0,18.0,24.0,31.0,27.0,25.0,21.0,33.0,17.0,22.0,21.0,23.0,28.0,29.0,22.0,17.0,25.0,26.0,11.0,20.0,24.0,23.0,26.0,19.0,27.0,13.0,22.0,26.0,29.0,15.0,22.0,14.0,27.0,23.0,21.0,27.0,27.0,25.0,39.0,32.0,23.0,35.0,39.0,33.0,29.0,40.0,43.0,28.0,30.0,30.0,45.0,32.0,35.0,25.0,27.0,22.0,34.0,28.0,36.0,40.0,29.0,22.0,31.0,35.0,35.0,29.0,24.0,25.0,29.0,28.0,26.0,36.0,27.0,38.0,35.0,29.0,38.0,33.0,37.0,33.0,31.0,30.0,23.0,34.0,30.0,27.0,36.0,27.0,34.0,27.0,30.0,25.0,32.0,25.0,32.0,27.0,16.0,19.0,15.0,15.0,22.0,19.0,17.0,12.0,22.0,13.0,13.0,20.0,15.0,30.0,27.0,24.0,14.0,17.0,30.0,13.0,10.0,16.0,15.0,15.0,18.0,14.0,18.0,8.0,10.0,12.0,8.0,10.0,10.0,4.0,18.0,8.0,10.0,10.0,7.0,4.0,7.0,7.0,11.0,6.0,10.0,5.0,5.0,0.0:1
?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,18.0,19.0,16.0,17.0,22.0,9.0,28.0,23.0,30.0,30.0,21.0,39.0,31.0,24.0,36.0,48.0,36.0,40.0,31.0,25.0,45.0,42.0,39.0,41.0,37.0,26.0,45.0,38.0,32.0,33.0,30.0,50.0,43.0,45.0,48.0,44.0,36.0,38.0,40.0,27.0,39.0,31.0,29.0,25.0,26.0,30.0,29.0,23.0,19.0,30.0,27.0,34.0,24.0,21.0,17.0,18.0,39.0,21.0,39.0,24.0,29.0,14.0,28.0,26.0,37.0,37.0,20.0,28.0,32.0,20.0,22.0,27.0,40.0,20.0,29.0,27.0,33.0,27.0,21.0,24.0,35.0,22.0,19.0,12.0,34.0,22.0,37.0,27.0,17.0,19.0,23.0,29.0,32.0,15.0,32.0,31.0,23.0,27.0,23.0,14.0,27.0,21.0,28.0,33.0,28.0,31.0,46.0,21.0,27.0,15.0,46.0,38.0,35.0,39.0,30.0,34.0,29.0,30.0,40.0,36.0,29.0,46.0,23.0,37.0,33.0,25.0,43.0,39.0,23.0,33.0,31.0,23.0,32.0,40.0,32.0,32.0,32.0,38.0,38.0,22.0,37.0,32.0,40.0,26.0,33.0,33.0,38.0,25.0,17.0,24.0,18.0,22.0,20.0,29.0,10.0,22.0,16.0,17.0,23.0,26.0,30.0,26.0,40.0,22.0,28.0,19.0,24.0,22.0,13.0,19.0,18.0,14.0,19.0,19.0,15.0,25.0,21.0,30.0,8.0,22.0,23.0,24.0,26.0,28.0,14.0,26.0,20.0,15.0,17.0,10.0,8.0,10.0,16.0,11.0,16.0,12.0,16.0,10.0,6.0,11.0,11.0,12.0,9.0,11.0,14.0,16.0,13.0,14.0,9.0,19.0,9.0,4.0,11.0,5.0,13.0:1
5.0,4.0,6.0,6.0,5.0,6.0,4.0,10.0,11.0,3.0,7.0,3.0,5.0,3.0,2.0,10.0,1.0,4.0,3.0,3.0,4.0,2.0,3.0,2.0,2.0,6.0,2.0,4.0,3.0,2.0,4.0,0.0,0.0,3.0,2.0,0.0,2.0,1.0,1.0,2.0,2.0,1.0,3.0,0.0,2.0,0.0,1.0,3.0,3.0,1.0,1.0,3.0,3.0,4.0,0.0,4.0,2.0,3.0,7.0,7.0,3.0,2.0,11.0,10.0,11.0,7.0,9.0,10.0,13.0,15.0,9.0,13.0,12.0,18.0,26.0,21.0,15.0,19.0,26.0,26.0,35.0,37.0,22.0,29.0,39.0,46.0,39.0,34.0,31.0,44.0,28.0,37.0,47.0,47.0,37.0,38.0,37.0,36.0,23.0,32.0,47.0,36.0,31.0,45.0,49.0,44.0,48.0,36.0,30.0,33.0,26.0,33.0,22.0,37.0,39.0,10.0,41.0,54.0,29.0,46.0,41.0,34.0,36.0,23.0,21.0,30.0,35.0,29.0,29.0,24.0,30.0,28.0,25.0,21.0,24.0,34.0,24.0,31.0,27.0,20.0,36.0,24.0,33.0,23.0,32.0,25.0,30.0,31.0,18.0,24.0,26.0,25.0,27.0,23.0,27.0,23.0,28.0,27.0,30.0,25.0,27.0,44.0,27.0,0.0,21.0,31.0,24.0,33.0,23.0,26.0,43.0,32.0,39.0,40.0,36.0,39.0,43.0,43.0,39.0,38.0,43.0,36.0,36.0,38.0,47.0,41.0,26.0,?,?,?,?,31.0,31.0,45.0,45.0,32.0,36.0,36.0,27.0,32.0,30.0,38.0,32.0,46.0,36.0,31.0,28.0,30.0,26.0,38.0,39.0,28.0,29.0,40.0,39.0,29.0,34.0,31.0,29.0,38.0,32.0,37.0,39.0,36.0,35.0,30.0,50.0,40.0,35.0,36.0,44.0,39.0,29.0,34.0,22.0,21.0,28.0,28.0,35.0,34.0,25.0,33.0,20.0,32.0,17.0,18.0,16.0,34.0,13.0,23.0,19.0,24.0,23.0,20.0,31.0,20.0,25.0,26.0,20.0,14.0,26.0,13.0,16.0,26.0,24.0,20.0,19.0,21.0,16.0,14.0,16.0,17.0,12.0,18.0,11.0,7.0,6.0,14.0,12.0,20.0,16.0,17.0,12.0,6.0,12.0,14.0,11.0,12.0:1
9.0,9.0,11.0,12.0,1.0,3.0,6.0,5.0,5.0,1.0,5.0,4.0,7.0,2.0,1.0,6.0,3.0,1.0,1.0,1.0,4.0,3.0,1.0,0.0,2.0,3.0,9.0,1.0,3.0,3.0,3.0,3.0,1.0,0.0,3.0,1.0,0.0,2.0,1.0,3.0,2.0,2.0,3.0,0.0,2.0,0.0,2.0,1.0,1.0,0.0,1.0,5.0,2.0,5.0,4.0,1.0,8.0,7.0,4.0,7.0,3.0,5.0,6.0,5.0,6.0,7.0,11.0,12.0,13.0,16.0,6.0,14.0,13.0,18.0,19.0,15.0,16.0,17.0,24.0,27.0,30.0,27.0,20.0,27.0,29.0,33.0,46.0,41.0,40.0,40.0,30.0,30.0,30.0,42.0,37.0,37.0,38.0,31.0,31.0,28.0,37.0,38.0,40.0,34.0,50.0,31.0,43.0,32.0,29.0,39.0,35.0,25.0,34.0,43.0,30.0,28.0,38.0,31.0,37.0,29.0,31.0,25.0,33.0,25.0,24.0,24.0,29.0,25.0,30.0,30.0,21.0,27.0,28.0,21.0,17.0,27.0,27.0,29.0,26.0,18.0,27.0,39.0,38.0,20.0,23.0,27.0,21.0,25.0,24.0,22.0,32.0,34.0,30.0,28.0,29.0,27.0,29.0,30.0,29.0,35.0,24.0,20.0,28.0,17.0,41.0,35.0,18.0,32.0,23.0,20.0,24.0,36.0,32.0,32.0,33.0,26.0,41.0,33.0,32.0,23.0,38.0,36.0,32.0,32.0,39.0,47.0,46.0,43.0,51.0,46.0,40.0,34.0,44.0,45.0,34.0,40.0,30.0,25.0,33.0,37.0,42.0,37.0,41.0,34.0,30.0,32.0,43.0,47.0,45.0,34.0,32.0,39.0,36.0,38.0,31.0,27.0,34.0,26.0,21.0,26.0,34.0,32.0,23.0,30.0,28.0,29.0,27.0,34.0,15.0,25.0,24.0,28.0,30.0,23.0,27.0,27.0,27.0,23.0,18.0,23.0,15.0,19.0,24.0,16.0,19.0,24.0,16.0,10.0,13.0,13.0,15.0,21.0,19.0,25.0,21.0,20.0,29.0,19.0,17.0,19.0,15.0,13.0,18.0,13.0,19.0,16.0,16.0,9.0,16.0,13.0,11.0,8.0,15.0,15.0,9.0,15.0,12.0,11.0,14.0,10.0,8.0,2.0,8.0,10.0,3.0,7.0,8.0,9.0:1
4.0,9.0,5.0,11.0,1.0,3.0,6.0,5.0,6.0,5.0,7.0,1.0,12.0,1.0,3.0,1.0,8.0,4.0,3.0,5.0,6.0,3.0,3.0,5.0,1.0,4.0,3.0,1.0,4.0,3.0,1.0,2.0,2.0,3.0,1.0,5.0,1.0,1.0,0.0,0.0,2.0,2.0,1.0,2.0,0.0,1.0,3.0,2.0,1.0,1.0,3.0,0.0,3.0,1.0,4.0,5.0,3.0,6.0,10.0,5.0,5.0,3.0,8.0,4.0,7.0,12.0,13.0,5.0,3.0,15.0,6.0,9.0,14.0,15.0,20.0,20.0,20.0,23.0,21.0,16.0,23.0,29.0,16.0,25.0,19.0,24.0,32.0,32.0,36.0,32.0,32.0,47.0,39.0,41.0,40.0,29.0,25.0,32.0,30.0,17.0,26.0,37.0,32.0,18.0,37.0,24.0,42.0,25.0,23.0,26.0,34.0,29.0,27.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.0,1.0,20.0,27.0,20.0,20.0,23.0,18.0,21.0,24.0,31.0,24.0,28.0,28.0,19.0,24.0,34.0,27.0,24.0,25.0,26.0,20.0,19.0,20.0,22.0,24.0,15.0,23.0,19.0,15.0,27.0,17.0,26.0,33.0,36.0,35.0,28.0,26.0,37.0,30.0,32.0,33.0,39.0,35.0,33.0,34.0,33.0,46.0,45.0,43.0,39.0,32.0,44.0,42.0,39.0,32.0,29.0,36.0,39.0,43.0,40.0,41.0,26.0,38.0,38.0,35.0,40.0,44.0,39.0,40.0,47.0,44.0,40.0,33.0,34.0,39.0,40.0,35.0,32.0,31.0,33.0,29.0,39.0,33.0,39.0,37.0,24.0,26.0,32.0,21.0,24.0,27.0,21.0,26.0,36.0,23.0,26.0,27.0,35.0,32.0,30.0,24.0,23.0,34.0,37.0,36.0,26.0,25.0,26.0,29.0,13.0,20.0,22.0,22.0,20.0,22.0,10.0,18.0,27.0,21.0,22.0,23.0,27.0,16.0,21.0,19.0,21.0,17.0,15.0,22.0,16.0,15.0,11.0,16.0,12.0,11.0,10.0,19.0,13.0,18.0,14.0,8.0,18.0,7.0,16.0,12.0,13.0,6.0,6.0,9.0,10.0,13.0,13.0,11.0,11.0,5.0,6.0,7.0:1
11.0,9.0,7.0,5.0,5.0,4.0,3.0,6.0,2.0,8.0,5.0,1.0,4.0,4.0,8.0,6.0,3.0,2.0,3.0,3.0,3.0,4.0,6.0,5.0,2.0,3.0,2.0,4.0,3.0,3.0,2.0,3.0,2.0,3.0,0.0,3.0,1.0,2.0,3.0,2.0,1.0,2.0,1.0,0.0,1.0,1.0,2.0,0.0,2.0,2.0,1.0,2.0,1.0,1.0,2.0,4.0,6.0,5.0,6.0,5.0,5.0,2.0,8.0,3.0,8.0,5.0,12.0,11.0,12.0,16.0,15.0,15.0,19.0,17.0,19.0,13.0,21.0,27.0,21.0,20.0,20.0,18.0,11.0,33.0,21.0,42.0,36.0,34.0,33.0,26.0,28.0,28.0,30.0,28.0,33.0,28.0,32.0,32.0,42.0,40.0,37.0,45.0,41.0,36.0,34.0,39.0,43.0,32.0,22.0,38.0,30.0,23.0,34.0,30.0,27.0,34.0,21.0,27.0,32.0,32.0,36.0,32.0,29.0,22.0,16.0,28.0,37.0,22.0,27.0,22.0,19.0,19.0,17.0,29.0,24.0,20.0,23.0,28.0,24.0,23.0,28.0,24.0,24.0,29.0,17.0,28.0,36.0,32.0,38.0,44.0,21.0,21.0,34.0,17.0,29.0,30.0,24.0,27.0,32.0,32.0,34.0,41.0,28.0,24.0,39.0,24.0,30.0,32.0,27.0,24.0,29.0,26.0,30.0,36.0,41.0,46.0,48.0,33.0,43.0,24.0,39.0,27.0,48.0,39.0,25.0,27.0,32.0,35.0,38.0,40.0,37.0,33.0,26.0,30.0,38.0,35.0,27.0,33.0,40.0,28.0,32.0,21.0,25.0,32.0,34.0,21.0,42.0,29.0,22.0,27.0,31.0,32.0,39.0,34.0,34.0,24.0,41.0,46.0,47.0,43.0,51.0,47.0,31.0,30.0,34.0,36.0,27.0,28.0,37.0,28.0,38.0,34.0,27.0,21.0,32.0,27.0,33.0,33.0,12.0,25.0,27.0,31.0,22.0,14.0,26.0,18.0,26.0,25.0,22.0,15.0,19.0,19.0,23.0,24.0,18.0,20.0,19.0,14.0,24.0,19.0,8.0,16.0,12.0,16.0,16.0,9.0,13.0,18.0,16.0,12.0,8.0,13.0,11.0,17.0,21.0,17.0,14.0,12.0,16.0,16.0,17.0,11.0,12.0,18.0,13.0,10.0,14.0,13.0:1
3.0,5.0,7.0,7.0,9.0,5.0,8.0,5.0,5.0,5.0,4.0,6.0,2.0,6.0,3.0,4.0,2.0,2.0,3.0,3.0,2.0,0.0,3.0,0.0,4.0,0.0,4.0,2.0,4.0,1.0,2.0,2.0,0.0,1.0,3.0,2.0,1.0,2.0,1.0,2.0,2.0,1.0,2.0,4.0,3.0,3.0,1.0,1.0,2.0,2.0,1.0,2.0,0.0,0.0,1.0,2.0,5.0,1.0,4.0,3.0,2.0,3.0,6.0,3.0,8.0,6.0,5.0,6.0,3.0,8.0,11.0,8.0,13.0,13.0,12.0,19.0,22.0,22.0,18.0,24.0,29.0,26.0,38.0,30.0,22.0,35.0,38.0,46.0,37.0,28.0,39.0,40.0,39.0,41.0,40.0,36.0,41.0,30.0,40.0,29.0,40.0,44.0,31.0,34.0,40.0,33.0,42.0,44.0,28.0,36.0,37.0,36.0,26.0,33.0,30.0,33.0,35.0,25.0,29.0,23.0,25.0,34.0,20.0,25.0,20.0,29.0,32.0,33.0,21.0,24.0,18.0,21.0,18.0,24.0,22.0,34.0,32.0,29.0,30.0,26.0,38.0,27.0,19.0,20.0,28.0,24.0,19.0,23.0,24.0,22.0,24.0,31.0,30.0,23.0,29.0,21.0,30.0,19.0,28.0,18.0,25.0,20.0,33.0,25.0,26.0,40.0,34.0,27.0,27.0,28.0,35.0,24.0,30.0,37.0,38.0,40.0,40.0,24.0,33.0,33.0,26.0,21.0,44.0,45.0,36.0,53.0,31.0,43.0,40.0,34.0,28.0,25.0,32.0,41.0,27.0,31.0,32.0,26.0,28.0,30.0,25.0,25.0,27.0,38.0,26.0,33.0,28.0,37.0,36.0,22.0,37.0,34.0,30.0,32.0,30.0,27.0,34.0,24.0,29.0,27.0,16.0,38.0,36.0,37.0,26.0,33.0,22.0,21.0,21.0,27.0,26.0,36.0,16.0,30.0,29.0,21.0,15.0,27.0,28.0,17.0,20.0,22.0,17.0,17.0,16.0,17.0,16.0,22.0,28.0,22.0,19.0,25.0,19.0,22.0,27.0,25.0,19.0,34.0,18.0,30.0,13.0,7.0,13.0,12.0,28.0,16.0,20.0,14.0,8.0,23.0,13.0,17.0,9.0,7.0,4.0,3.0,7.0,10.0,10.0,11.0,10.0,11.0,9.0,13.0,13.0,4.0,5.0,9.0:1
8.0,5.0,4.0,6.0,7.0,4.0,5.0,3.0,3.0,2.0,1.0,5.0,6.0,2.0,5.0,1.0,5.0,1.0,3.0,1.0,2.0,4.0,4.0,4.0,8.0,4.0,1.0,6.0,5.0,0.0,2.0,1.0,3.0,1.0,1.0,0.0,1.0,1.0,1.0,2.0,0.0,1.0,2.0,5.0,3.0,1.0,0.0,4.0,2.0,3.0,4.0,1.0,1.0,3.0,3.0,5.0,9.0,4.0,4.0,4.0,4.0,10.0,1.0,6.0,6.0,9.0,9.0,8.0,12.0,6.0,11.0,12.0,23.0,14.0,21.0,14.0,25.0,15.0,25.0,29.0,31.0,20.0,29.0,27.0,31.0,34.0,45.0,39.0,38.0,36.0,35.0,32.0,31.0,28.0,39.0,37.0,32.0,33.0,31.0,31.0,40.0,23.0,33.0,42.0,37.0,37.0,39.0,28.0,34.0,29.0,28.0,37.0,34.0,25.0,40.0,25.0,17.0,27.0,26.0,35.0,36.0,24.0,30.0,18.0,21.0,24.0,25.0,28.0,23.0,20.0,21.0,23.0,13.0,21.0,23.0,13.0,21.0,22.0,14.0,23.0,24.0,27.0,28.0,23.0,22.0,20.0,31.0,27.0,22.0,32.0,36.0,23.0,30.0,33.0,29.0,28.0,22.0,29.0,26.0,35.0,30.0,30.0,38.0,21.0,34.0,28.0,36.0,25.0,34.0,35.0,28.0,35.0,28.0,33.0,38.0,43.0,41.0,43.0,42.0,35.0,41.0,27.0,41.0,43.0,40.0,39.0,43.0,37.0,36.0,44.0,30.0,42.0,24.0,24.0,27.0,28.0,26.0,30.0,18.0,15.0,24.0,20.0,13.0,19.0,22.0,26.0,26.0,38.0,26.0,34.0,23.0,33.0,31.0,34.0,32.0,33.0,33.0,24.0,33.0,32.0,28.0,32.0,38.0,30.0,21.0,27.0,22.0,28.0,29.0,20.0,28.0,24.0,29.0,22.0,20.0,37.0,25.0,38.0,28.0,22.0,26.0,27.0,33.0,20.0,27.0,24.0,29.0,23.0,19.0,22.0,20.0,15.0,21.0,26.0,20.0,22.0,21.0,23.0,12.0,30.0,16.0,19.0,23.0,21.0,14.0,17.0,12.0,23.0,21.0,21.0,10.0,13.0,11.0,18.0,18.0,12.0,11.0,14.0,17.0,17.0,10.0,13.0,8.0,19.0,10.0,5.0,12.0,5.0:1
24.0,17.0,16.0,11.0,11.0,10.0,11.0,12.0,7.0,7.0,5.0,7.0,3.0,11.0,8.0,6.0,10.0,9.0,8.0,3.0,8.0,8.0,11.0,8.0,6.0,2.0,12.0,11.0,11.0,3.0,1.0,7.0,7.0,9.0,4.0,3.0,9.0,9.0,6.0,4.0,4.0,8.0,2.0,7.0,5.0,4.0,3.0,1.0,5.0,6.0,1.0,2.0,6.0,4.0,3.0,3.0,3.0,2.0,3.0,1.0,4.0,3.0,2.0,3.0,5.0,4.0,2.0,2.0,6.0,8.0,3.0,6.0,2.0,3.0,3.0,7.0,6.0,7.0,1.0,11.0,10.0,4.0,6.0,5.0,3.0,7.0,9.0,5.0,6.0,10.0,17.0,13.0,12.0,12.0,19.0,19.0,10.0,14.0,11.0,10.0,8.0,13.0,13.0,17.0,14.0,16.0,21.0,11.0,18.0,18.0,12.0,21.0,19.0,17.0,16.0,20.0,13.0,22.0,33.0,21.0,24.0,25.0,16.0,20.0,30.0,28.0,22.0,24.0,22.0,21.0,19.0,26.0,21.0,29.0,26.0,21.0,23.0,33.0,27.0,34.0,38.0,29.0,33.0,42.0,20.0,27.0,29.0,27.0,24.0,19.0,25.0,25.0,21.0,40.0,19.0,17.0,21.0,15.0,23.0,24.0,30.0,34.0,27.0,29.0,23.0,22.0,25.0,27.0,40.0,27.0,32.0,23.0,33.0,30.0,29.0,24.0,24.0,26.0,26.0,23.0,37.0,38.0,37.0,38.0,36.0,27.0,29.0,28.0,24.0,34.0,33.0,21.0,24.0,18.0,26.0,13.0,23.0,22.0,27.0,32.0,28.0,17.0,21.0,26.0,33.0,28.0,28.0,29.0,31.0,27.0,31.0,22.0,25.0,33.0,26.0,20.0,23.0,33.0,29.0,28.0,18.0,32.0,16.0,23.0,14.0,30.0,24.0,39.0,28.0,36.0,30.0,21.0,30.0,30.0,22.0,26.0,27.0,21.0,27.0,25.0,23.0,19.0,22.0,21.0,19.0,15.0,25.0,27.0,24.0,17.0,22.0,26.0,18.0,14.0,15.0,17.0,14.0,21.0,19.0,17.0,20.0,16.0,21.0,17.0,14.0,14.0,17.0,11.0,16.0,12.0,16.0,13.0,13.0,10.0,9.0,11.0,8.0,9.0,13.0,11.0,10.0,10.0,13.0,5.0,9.0,9.0,8.0,10.0:1
4.0,8.0,8.0,9.0,4.0,3.0,3.0,4.0,1.0,2.0,2.0,4.0,1.0,3.0,5.0,3.0,2.0,2.0,5.0,0.0,2.0,1.0,2.0,2.0,1.0,4.0,3.0,1.0,4.0,2.0,3.0,1.0,1.0,2.0,2.0,5.0,2.0,1.0,2.0,1.0,4.0,2.0,3.0,4.0,1.0,3.0,0.0,2.0,1.0,2.0,1.0,3.0,1.0,0.0,4.0,2.0,5.0,4.0,8.0,9.0,1.0,4.0,7.0,6.0,7.0,9.0,15.0,13.0,15.0,19.0,10.0,11.0,14.0,9.0,13.0,7.0,23.0,15.0,19.0,19.0,30.0,33.0,26.0,20.0,35.0,31.0,37.0,36.0,35.0,37.0,39.0,32.0,32.0,40.0,21.0,40.0,32.0,32.0,30.0,32.0,33.0,32.0,31.0,36.0,31.0,21.0,35.0,21.0,23.0,27.0,30.0,34.0,28.0,30.0,33.0,20.0,31.0,35.0,39.0,36.0,38.0,29.0,39.0,29.0,16.0,26.0,22.0,33.0,25.0,26.0,16.0,28.0,24.0,28.0,21.0,20.0,21.0,14.0,16.0,25.0,24.0,28.0,22.0,28.0,18.0,44.0,36.0,46.0,24.0,29.0,21.0,26.0,32.0,30.0,20.0,17.0,29.0,19.0,24.0,20.0,26.0,27.0,24.0,24.0,32.0,21.0,26.0,28.0,14.0,31.0,28.0,23.0,30.0,29.0,28.0,37.0,34.0,34.0,30.0,29.0,36.0,33.0,34.0,31.0,22.0,27.0,36.0,31.0,38.0,19.0,31.0,28.0,34.0,46.0,35.0,39.0,31.0,42.0,32.0,40.0,40.0,32.0,22.0,23.0,25.0,18.0,41.0,28.0,29.0,34.0,32.0,29.0,22.0,26.0,34.0,27.0,36.0,30.0,41.0,33.0,39.0,38.0,33.0,29.0,24.0,34.0,37.0,27.0,34.0,32.0,24.0,19.0,22.0,29.0,32.0,24.0,20.0,25.0,14.0,21.0,20.0,22.0,15.0,15.0,18.0,23.0,14.0,16.0,16.0,19.0,18.0,20.0,39.0,31.0,18.0,21.0,27.0,17.0,14.0,16.0,10.0,15.0,15.0,9.0,12.0,16.0,17.0,5.0,15.0,4.0,6.0,13.0,8.0,11.0,11.0,9.0,8.0,8.0,6.0,9.0,13.0,18.0,9.0,11.0,4.0,5.0,5.0,10.0:1
6.0,4.0,8.0,8.0,6.0,0.0,6.0,7.0,6.0,5.0,2.0,4.0,5.0,0.0,2.0,7.0,3.0,6.0,6.0,3.0,1.0,4.0,6.0,3.0,6.0,2.0,2.0,6.0,2.0,1.0,1.0,0.0,0.0,3.0,2.0,2.0,3.0,1.0,2.0,0.0,1.0,1.0,3.0,0.0,4.0,0.0,1.0,0.0,1.0,2.0,3.0,1.0,3.0,1.0,3.0,4.0,3.0,8.0,5.0,6.0,6.0,6.0,8.0,6.0,7.0,9.0,7.0,19.0,7.0,18.0,13.0,13.0,13.0,13.0,19.0,12.0,21.0,18.0,23.0,28.0,41.0,24.0,25.0,41.0,32.0,36.0,36.0,52.0,32.0,36.0,38.0,36.0,44.0,48.0,20.0,29.0,26.0,29.0,31.0,31.0,36.0,32.0,41.0,53.0,45.0,41.0,29.0,52.0,50.0,40.0,38.0,47.0,34.0,44.0,35.0,35.0,36.0,40.0,42.0,25.0,43.0,22.0,28.0,26.0,33.0,26.0,41.0,31.0,40.0,20.0,17.0,28.0,25.0,25.0,27.0,31.0,33.0,28.0,28.0,26.0,28.0,30.0,39.0,25.0,31.0,30.0,31.0,38.0,36.0,41.0,37.0,27.0,38.0,28.0,32.0,38.0,35.0,30.0,34.0,14.0,28.0,28.0,38.0,33.0,37.0,29.0,25.0,25.0,39.0,23.0,30.0,40.0,41.0,27.0,39.0,37.0,38.0,35.0,24.0,34.0,27.0,44.0,37.0,42.0,47.0,33.0,37.0,28.0,37.0,44.0,42.0,41.0,37.0,41.0,32.0,41.0,48.0,38.0,32.0,45.0,30.0,38.0,43.0,35.0,35.0,37.0,40.0,34.0,29.0,33.0,29.0,27.0,34.0,28.0,41.0,39.0,36.0,33.0,38.0,34.0,44.0,38.0,33.0,33.0,42.0,27.0,36.0,36.0,33.0,37.0,29.0,36.0,25.0,18.0,27.0,14.0,38.0,23.0,32.0,27.0,25.0,26.0,19.0,21.0,26.0,18.0,21.0,14.0,14.0,27.0,20.0,16.0,17.0,28.0,23.0,21.0,19.0,18.0,21.0,18.0,17.0,19.0,18.0,21.0,10.0,10.0,16.0,14.0,16.0,11.0,16.0,15.0,13.0,16.0,6.0,9.0,9.0,13.0,8.0,12.0,10.0,5.0,14.0,10.0,7.0,6.0,4.0,9.0:1
18.0,13.0,7.0,9.0,11.0,11.0,8.0,9.0,11.0,8.0,6.0,11.0,11.0,7.0,11.0,5.0,10.0,10.0,7.0,9.0,9.0,7.0,8.0,6.0,6.0,5.0,13.0,11.0,11.0,10.0,11.0,4.0,1.0,6.0,9.0,11.0,5.0,3.0,4.0,3.0,6.0,4.0,3.0,2.0,5.0,4.0,0.0,0.0,2.0,4.0,4.0,5.0,2.0,1.0,0.0,5.0,1.0,2.0,2.0,2.0,3.0,3.0,1.0,5.0,2.0,3.0,1.0,1.0,5.0,6.0,4.0,4.0,6.0,5.0,5.0,7.0,3.0,13.0,4.0,7.0,12.0,7.0,2.0,7.0,6.0,3.0,9.0,8.0,6.0,7.0,16.0,5.0,9.0,11.0,9.0,9.0,6.0,9.0,3.0,10.0,12.0,10.0,11.0,20.0,13.0,12.0,26.0,9.0,19.0,16.0,9.0,11.0,12.0,15.0,16.0,10.0,20.0,24.0,16.0,15.0,15.0,24.0,11.0,11.0,20.0,21.0,29.0,23.0,17.0,30.0,29.0,17.0,24.0,25.0,31.0,21.0,34.0,27.0,27.0,32.0,23.0,20.0,28.0,23.0,37.0,22.0,28.0,30.0,26.0,14.0,20.0,19.0,23.0,12.0,24.0,29.0,17.0,14.0,30.0,24.0,19.0,16.0,29.0,21.0,24.0,28.0,24.0,19.0,24.0,42.0,34.0,23.0,21.0,20.0,26.0,22.0,21.0,21.0,35.0,33.0,18.0,30.0,24.0,18.0,29.0,19.0,20.0,18.0,33.0,19.0,25.0,25.0,18.0,17.0,33.0,23.0,17.0,20.0,21.0,20.0,25.0,21.0,30.0,25.0,33.0,26.0,23.0,14.0,10.0,12.0,21.0,22.0,24.0,14.0,18.0,21.0,32.0,14.0,26.0,36.0,23.0,23.0,30.0,27.0,40.0,27.0,25.0,18.0,24.0,19.0,25.0,30.0,13.0,19.0,19.0,14.0,19.0,24.0,15.0,17.0,23.0,16.0,8.0,21.0,32.0,20.0,24.0,26.0,27.0,12.0,14.0,13.0,17.0,20.0,20.0,14.0,23.0,17.0,24.0,15.0,22.0,17.0,22.0,24.0,25.0,18.0,22.0,17.0,20.0,13.0,8.0,14.0,12.0,8.0,18.0,14.0,11.0,8.0,9.0,13.0,6.0,8.0,3.0,11.0,6.0,7.0,6.0,10.0:1
8.0,3.0,11.0,7.0,9.0,7.0,7.0,1.0,4.0,3.0,8.0,0.0,2.0,1.0,5.0,5.0,3.0,2.0,4.0,6.0,5.0,4.0,4.0,6.0,3.0,3.0,4.0,2.0,3.0,2.0,1.0,2.0,7.0,6.0,6.0,6.0,5.0,6.0,0.0,2.0,3.0,2.0,8.0,8.0,1.0,3.0,1.0,3.0,2.0,1.0,2.0,1.0,1.0,0.0,5.0,2.0,5.0,6.0,2.0,2.0,4.0,7.0,7.0,1.0,8.0,5.0,5.0,10.0,10.0,6.0,14.0,5.0,10.0,12.0,23.0,17.0,23.0,18.0,22.0,23.0,30.0,30.0,32.0,33.0,28.0,47.0,35.0,34.0,43.0,39.0,34.0,26.0,38.0,48.0,29.0,46.0,31.0,34.0,34.0,32.0,36.0,28.0,33.0,35.0,39.0,60.0,?,?,?,?,?,?,?,?,?,42.0,34.0,29.0,35.0,33.0,35.0,26.0,32.0,23.0,25.0,24.0,20.0,24.0,24.0,32.0,24.0,32.0,32.0,18.0,26.0,31.0,29.0,23.0,29.0,33.0,38.0,29.0,29.0,28.0,32.0,30.0,29.0,24.0,26.0,31.0,29.0,30.0,33.0,32.0,29.0,30.0,25.0,20.0,34.0,28.0,29.0,33.0,19.0,34.0,33.0,28.0,30.0,24.0,28.0,22.0,27.0,30.0,29.0,25.0,39.0,39.0,39.0,37.0,39.0,34.0,33.0,32.0,40.0,31.0,35.0,50.0,48.0,37.0,39.0,36.0,37.0,32.0,38.0,26.0,29.0,31.0,43.0,28.0,26.0,38.0,34.0,37.0,40.0,27.0,33.0,42.0,40.0,39.0,37.0,29.0,30.0,33.0,32.0,46.0,26.0,31.0,32.0,23.0,33.0,40.0,25.0,24.0,38.0,36.0,40.0,27.0,20.0,32.0,27.0,25.0,22.0,25.0,20.0,32.0,35.0,22.0,23.0,23.0,33.0,18.0,20.0,18.0,31.0,17.0,18.0,13.0,15.0,19.0,21.0,16.0,28.0,19.0,19.0,35.0,28.0,19.0,18.0,25.0,22.0,16.0,18.0,14.0,16.0,11.0,10.0,9.0,18.0,11.0,16.0,16.0,11.0,15.0,9.0,15.0,15.0,12.0,17.0,11.0,8.0,10.0,11.0,10.0,6.0,5.0,5.0,9.0,4.0,3.0:1
3.0,9.0,8.0,6.0,5.0,4.0,7.0,5.0,2.0,2.0,7.0,5.0,3.0,0.0,2.0,2.0,1.0,2.0,5.0,3.0,2.0,4.0,4.0,4.0,1.0,2.0,5.0,3.0,3.0,0.0,1.0,4.0,1.0,2.0,4.0,2.0,1.0,1.0,1.0,4.0,1.0,4.0,0.0,1.0,1.0,1.0,0.0,2.0,0.0,4.0,3.0,1.0,1.0,2.0,1.0,7.0,4.0,9.0,4.0,7.0,8.0,2.0,9.0,8.0,10.0,7.0,9.0,14.0,13.0,15.0,11.0,20.0,15.0,13.0,20.0,13.0,22.0,21.0,23.0,33.0,35.0,30.0,19.0,36.0,39.0,35.0,39.0,35.0,31.0,41.0,51.0,40.0,31.0,40.0,35.0,38.0,39.0,42.0,27.0,32.0,33.0,34.0,36.0,35.0,48.0,43.0,49.0,55.0,33.0,39.0,26.0,42.0,40.0,34.0,41.0,35.0,50.0,42.0,51.0,37.0,35.0,42.0,26.0,41.0,25.0,26.0,30.0,27.0,33.0,31.0,29.0,30.0,28.0,17.0,24.0,32.0,29.0,21.0,22.0,36.0,18.0,25.0,27.0,26.0,18.0,26.0,28.0,26.0,20.0,27.0,40.0,32.0,36.0,30.0,29.0,21.0,22.0,16.0,30.0,25.0,29.0,21.0,35.0,27.0,25.0,30.0,27.0,29.0,37.0,24.0,34.0,19.0,40.0,27.0,30.0,35.0,38.0,38.0,32.0,44.0,33.0,42.0,41.0,43.0,32.0,32.0,31.0,38.0,46.0,49.0,34.0,37.0,43.0,45.0,33.0,34.0,30.0,42.0,28.0,40.0,34.0,46.0,29.0,27.0,32.0,32.0,36.0,40.0,38.0,31.0,28.0,33.0,46.0,35.0,36.0,34.0,36.0,39.0,40.0,49.0,36.0,42.0,42.0,41.0,29.0,37.0,20.0,28.0,34.0,23.0,27.0,33.0,33.0,35.0,23.0,35.0,28.0,28.0,27.0,23.0,17.0,25.0,25.0,26.0,19.0,24.0,17.0,15.0,16.0,13.0,18.0,22.0,19.0,21.0,28.0,17.0,19.0,19.0,20.0,17.0,24.0,25.0,20.0,18.0,18.0,16.0,18.0,14.0,6.0,15.0,12.0,12.0,17.0,21.0,12.0,12.0,12.0,6.0,11.0,14.0,13.0,3.0,14.0,10.0,8.0,7.0,6.0,7.0:1
11.0,4.0,4.0,12.0,4.0,4.0,3.0,7.0,6.0,3.0,9.0,2.0,3.0,2.0,12.0,2.0,3.0,4.0,7.0,3.0,2.0,0.0,3.0,5.0,5.0,3.0,0.0,3.0,5.0,6.0,1.0,1.0,2.0,1.0,2.0,3.0,2.0,5.0,2.0,1.0,5.0,2.0,3.0,3.0,2.0,2.0,1.0,4.0,1.0,2.0,0.0,2.0,0.0,1.0,1.0,5.0,1.0,9.0,7.0,2.0,5.0,9.0,7.0,6.0,7.0,9.0,9.0,10.0,6.0,14.0,19.0,10.0,14.0,14.0,15.0,19.0,13.0,22.0,17.0,27.0,21.0,26.0,31.0,13.0,36.0,39.0,35.0,37.0,37.0,31.0,30.0,43.0,32.0,42.0,39.0,48.0,36.0,30.0,35.0,42.0,32.0,29.0,34.0,50.0,37.0,22.0,36.0,37.0,30.0,34.0,32.0,33.0,32.0,26.0,28.0,22.0,34.0,37.0,27.0,22.0,37.0,29.0,27.0,27.0,35.0,18.0,24.0,34.0,33.0,29.0,28.0,20.0,23.0,25.0,28.0,37.0,19.0,27.0,27.0,33.0,29.0,26.0,26.0,29.0,26.0,23.0,33.0,22.0,27.0,33.0,20.0,21.0,29.0,30.0,28.0,23.0,27.0,31.0,31.0,33.0,32.0,30.0,37.0,37.0,17.0,24.0,22.0,42.0,38.0,24.0,35.0,38.0,32.0,28.0,33.0,30.0,45.0,30.0,23.0,41.0,34.0,13.0,43.0,33.0,36.0,37.0,40.0,38.0,38.0,44.0,44.0,30.0,30.0,33.0,44.0,30.0,39.0,33.0,35.0,32.0,35.0,37.0,31.0,28.0,32.0,36.0,33.0,31.0,37.0,33.0,27.0,33.0,35.0,22.0,33.0,24.0,28.0,31.0,31.0,40.0,44.0,38.0,26.0,21.0,36.0,35.0,34.0,34.0,22.0,26.0,37.0,34.0,27.0,24.0,28.0,36.0,31.0,26.0,32.0,20.0,27.0,18.0,27.0,19.0,22.0,17.0,28.0,21.0,19.0,22.0,33.0,18.0,20.0,21.0,25.0,23.0,15.0,18.0,8.0,13.0,24.0,21.0,18.0,26.0,18.0,24.0,21.0,17.0,25.0,18.0,10.0,24.0,14.0,21.0,14.0,18.0,12.0,8.0,19.0,8.0,19.0,13.0,13.0,6.0,13.0,11.0,17.0,14.0:1
7.0,6.0,7.0,12.0,9.0,12.0,11.0,13.0,6.0,3.0,12.0,14.0,10.0,6.0,11.0,4.0,9.0,4.0,4.0,7.0,3.0,5.0,4.0,5.0,8.0,5.0,4.0,4.0,4.0,5.0,1.0,0.0,5.0,1.0,6.0,1.0,1.0,2.0,3.0,5.0,5.0,1.0,3.0,4.0,2.0,4.0,2.0,1.0,3.0,2.0,1.0,3.0,3.0,2.0,3.0,2.0,7.0,5.0,4.0,4.0,5.0,1.0,7.0,5.0,5.0,15.0,10.0,10.0,12.0,13.0,8.0,16.0,8.0,12.0,17.0,14.0,12.0,26.0,23.0,25.0,36.0,21.0,22.0,34.0,37.0,36.0,40.0,45.0,41.0,45.0,38.0,43.0,50.0,44.0,44.0,48.0,40.0,41.0,42.0,46.0,49.0,34.0,31.0,45.0,45.0,51.0,39.0,29.0,31.0,39.0,43.0,42.0,35.0,37.0,35.0,35.0,40.0,33.0,51.0,29.0,36.0,28.0,28.0,27.0,25.0,16.0,22.0,34.0,25.0,30.0,21.0,27.0,36.0,25.0,23.0,29.0,29.0,23.0,23.0,30.0,30.0,28.0,23.0,29.0,31.0,34.0,28.0,29.0,30.0,31.0,26.0,32.0,25.0,29.0,27.0,31.0,22.0,31.0,32.0,29.0,21.0,14.0,22.0,10.0,21.0,21.0,43.0,43.0,40.0,37.0,32.0,32.0,46.0,30.0,37.0,41.0,50.0,41.0,49.0,41.0,31.0,36.0,37.0,44.0,42.0,27.0,44.0,37.0,47.0,42.0,25.0,34.0,29.0,31.0,34.0,40.0,38.0,21.0,25.0,34.0,30.0,39.0,41.0,28.0,30.0,38.0,40.0,43.0,33.0,33.0,41.0,33.0,30.0,37.0,34.0,25.0,24.0,24.0,27.0,43.0,39.0,44.0,39.0,44.0,54.0,50.0,44.0,44.0,38.0,43.0,37.0,46.0,49.0,42.0,47.0,35.0,40.0,31.0,43.0,24.0,27.0,20.0,10.0,29.0,29.0,25.0,28.0,13.0,13.0,25.0,24.0,17.0,16.0,18.0,19.0,26.0,23.0,27.0,26.0,33.0,23.0,19.0,19.0,16.0,27.0,25.0,24.0,23.0,18.0,25.0,17.0,15.0,20.0,28.0,18.0,36.0,21.0,27.0,15.0,13.0,14.0,15.0,9.0,15.0,16.0,14.0,12.0,8.0:1
7.0,6.0,4.0,6.0,4.0,3.0,5.0,7.0,9.0,6.0,7.0,3.0,2.0,3.0,4.0,4.0,1.0,4.0,3.0,0.0,3.0,4.0,3.0,4.0,5.0,1.0,4.0,3.0,3.0,2.0,0.0,1.0,3.0,3.0,0.0,2.0,2.0,1.0,1.0,3.0,2.0,0.0,0.0,3.0,4.0,4.0,1.0,2.0,2.0,4.0,1.0,3.0,1.0,1.0,2.0,3.0,4.0,6.0,6.0,4.0,2.0,3.0,13.0,7.0,5.0,4.0,9.0,12.0,12.0,15.0,8.0,18.0,7.0,13.0,17.0,10.0,21.0,22.0,17.0,24.0,32.0,34.0,23.0,26.0,24.0,38.0,45.0,36.0,36.0,38.0,49.0,35.0,38.0,43.0,38.0,36.0,39.0,35.0,37.0,26.0,39.0,33.0,25.0,33.0,26.0,33.0,41.0,35.0,34.0,33.0,36.0,30.0,29.0,47.0,24.0,30.0,29.0,32.0,43.0,23.0,34.0,31.0,29.0,27.0,37.0,28.0,30.0,23.0,24.0,29.0,13.0,26.0,22.0,22.0,18.0,24.0,25.0,25.0,19.0,13.0,27.0,32.0,16.0,39.0,27.0,17.0,35.0,39.0,20.0,19.0,25.0,17.0,23.0,25.0,27.0,17.0,23.0,14.0,18.0,28.0,22.0,34.0,28.0,14.0,29.0,38.0,32.0,31.0,32.0,24.0,29.0,34.0,22.0,25.0,25.0,25.0,31.0,32.0,28.0,25.0,35.0,31.0,24.0,40.0,24.0,33.0,32.0,36.0,33.0,31.0,21.0,26.0,34.0,37.0,28.0,44.0,35.0,38.0,37.0,41.0,36.0,32.0,49.0,41.0,38.0,41.0,39.0,34.0,28.0,31.0,26.0,27.0,34.0,35.0,28.0,44.0,44.0,31.0,33.0,37.0,38.0,43.0,29.0,28.0,24.0,31.0,41.0,23.0,32.0,27.0,32.0,39.0,33.0,27.0,25.0,23.0,20.0,18.0,15.0,30.0,24.0,20.0,14.0,14.0,19.0,22.0,21.0,16.0,19.0,12.0,13.0,16.0,14.0,22.0,26.0,16.0,17.0,18.0,14.0,11.0,13.0,20.0,11.0,15.0,15.0,15.0,19.0,8.0,14.0,16.0,8.0,6.0,12.0,17.0,14.0,10.0,6.0,9.0,11.0,6.0,14.0,9.0,5.0,9.0,3.0,5.0,8.0,2.0:1
16.0,11.0,3.0,10.0,11.0,3.0,6.0,6.0,2.0,4.0,5.0,6.0,6.0,4.0,5.0,2.0,3.0,5.0,7.0,8.0,8.0,4.0,3.0,4.0,2.0,5.0,5.0,2.0,1.0,1.0,3.0,2.0,2.0,4.0,1.0,2.0,2.0,4.0,1.0,3.0,2.0,3.0,1.0,2.0,5.0,2.0,2.0,2.0,3.0,2.0,2.0,4.0,2.0,3.0,1.0,6.0,11.0,6.0,9.0,2.0,3.0,1.0,5.0,8.0,8.0,10.0,11.0,14.0,22.0,10.0,7.0,7.0,12.0,22.0,11.0,13.0,20.0,13.0,26.0,25.0,34.0,22.0,30.0,18.0,23.0,22.0,23.0,30.0,32.0,25.0,28.0,35.0,37.0,41.0,50.0,43.0,41.0,40.0,44.0,37.0,41.0,33.0,17.0,32.0,38.0,27.0,35.0,36.0,36.0,23.0,37.0,33.0,23.0,33.0,37.0,22.0,39.0,38.0,24.0,31.0,39.0,38.0,27.0,29.0,30.0,32.0,27.0,19.0,25.0,36.0,39.0,29.0,22.0,23.0,39.0,22.0,21.0,38.0,24.0,27.0,22.0,41.0,37.0,24.0,25.0,24.0,32.0,37.0,37.0,20.0,33.0,39.0,32.0,29.0,30.0,20.0,35.0,36.0,24.0,21.0,21.0,27.0,32.0,22.0,27.0,23.0,26.0,?,?,?,?,?,?,60.0,25.0,29.0,38.0,39.0,38.0,37.0,38.0,37.0,52.0,43.0,47.0,40.0,34.0,39.0,46.0,40.0,49.0,47.0,31.0,33.0,20.0,27.0,37.0,28.0,37.0,39.0,29.0,30.0,33.0,36.0,23.0,15.0,17.0,24.0,22.0,28.0,24.0,24.0,33.0,22.0,29.0,43.0,26.0,33.0,31.0,26.0,24.0,19.0,32.0,30.0,34.0,36.0,35.0,40.0,25.0,30.0,25.0,31.0,25.0,27.0,22.0,35.0,25.0,18.0,25.0,20.0,19.0,21.0,20.0,25.0,5.0,24.0,19.0,17.0,18.0,21.0,22.0,18.0,13.0,23.0,22.0,23.0,12.0,20.0,8.0,13.0,11.0,19.0,13.0,15.0,18.0,17.0,6.0,14.0,7.0,15.0,12.0,16.0,11.0,12.0,12.0,8.0,16.0,6.0,8.0,14.0,9.0,12.0,8.0,7.0,8.0,10.0,2.0,11.0:1
4.0,10.0,4.0,10.0,7.0,5.0,8.0,7.0,4.0,4.0,3.0,3.0,4.0,4.0,5.0,9.0,1.0,2.0,0.0,6.0,7.0,3.0,2.0,0.0,4.0,3.0,3.0,2.0,3.0,2.0,0.0,3.0,1.0,0.0,4.0,3.0,1.0,1.0,2.0,1.0,0.0,2.0,3.0,0.0,1.0,3.0,2.0,2.0,0.0,0.0,0.0,4.0,3.0,3.0,3.0,2.0,2.0,1.0,7.0,6.0,4.0,7.0,6.0,3.0,11.0,10.0,12.0,13.0,15.0,9.0,11.0,14.0,19.0,17.0,18.0,13.0,22.0,28.0,17.0,25.0,37.0,40.0,22.0,26.0,37.0,35.0,42.0,42.0,37.0,41.0,43.0,40.0,40.0,43.0,34.0,31.0,35.0,38.0,37.0,38.0,33.0,39.0,39.0,45.0,37.0,39.0,54.0,43.0,39.0,37.0,46.0,31.0,46.0,33.0,44.0,43.0,42.0,32.0,40.0,32.0,27.0,28.0,26.0,31.0,30.0,28.0,37.0,45.0,29.0,20.0,29.0,26.0,22.0,28.0,19.0,33.0,26.0,22.0,33.0,31.0,21.0,27.0,22.0,20.0,13.0,14.0,34.0,21.0,32.0,30.0,29.0,30.0,24.0,23.0,30.0,30.0,18.0,41.0,40.0,30.0,27.0,30.0,22.0,26.0,36.0,25.0,27.0,29.0,29.0,23.0,34.0,23.0,20.0,35.0,25.0,40.0,39.0,44.0,37.0,27.0,36.0,24.0,40.0,33.0,44.0,40.0,34.0,47.0,39.0,43.0,45.0,31.0,40.0,38.0,50.0,31.0,36.0,37.0,37.0,31.0,44.0,36.0,38.0,40.0,39.0,31.0,47.0,44.0,32.0,33.0,33.0,43.0,40.0,39.0,38.0,40.0,38.0,39.0,46.0,32.0,36.0,27.0,48.0,43.0,27.0,22.0,34.0,26.0,36.0,34.0,27.0,43.0,15.0,29.0,29.0,26.0,36.0,23.0,22.0,21.0,17.0,19.0,27.0,25.0,17.0,26.0,28.0,21.0,21.0,15.0,20.0,20.0,24.0,30.0,27.0,16.0,13.0,23.0,20.0,16.0,15.0,14.0,20.0,23.0,10.0,17.0,20.0,11.0,7.0,13.0,14.0,11.0,9.0,11.0,16.0,15.0,8.0,9.0,3.0,6.0,11.0,13.0,6.0,3.0,9.0,13.0,10.0,10.0:1
9.0,11.0,13.0,11.0,8.0,6.0,7.0,12.0,4.0,9.0,5.0,7.0,5.0,6.0,6.0,6.0,10.0,10.0,10.0,7.0,5.0,5.0,5.0,4.0,3.0,5.0,10.0,9.0,7.0,3.0,9.0,10.0,7.0,4.0,5.0,4.0,3.0,4.0,1.0,8.0,3.0,1.0,2.0,8.0,2.0,1.0,6.0,4.0,0.0,1.0,4.0,0.0,4.0,6.0,2.0,1.0,8.0,1.0,3.0,2.0,4.0,4.0,4.0,4.0,4.0,5.0,2.0,7.0,11.0,7.0,6.0,7.0,6.0,2.0,16.0,8.0,11.0,9.0,8.0,13.0,9.0,10.0,13.0,14.0,11.0,10.0,9.0,13.0,6.0,17.0,11.0,15.0,29.0,25.0,20.0,20.0,16.0,22.0,15.0,12.0,18.0,21.0,17.0,23.0,31.0,23.0,24.0,13.0,13.0,23.0,13.0,16.0,23.0,27.0,27.0,25.0,24.0,29.0,31.0,27.0,23.0,27.0,24.0,17.0,27.0,17.0,33.0,24.0,15.0,25.0,22.0,23.0,22.0,33.0,17.0,18.0,26.0,24.0,25.0,24.0,20.0,29.0,28.0,28.0,24.0,30.0,27.0,21.0,27.0,32.0,35.0,26.0,35.0,28.0,35.0,23.0,32.0,26.0,27.0,26.0,34.0,27.0,29.0,34.0,32.0,32.0,29.0,20.0,44.0,36.0,30.0,19.0,22.0,22.0,22.0,35.0,34.0,26.0,26.0,21.0,30.0,25.0,18.0,30.0,24.0,39.0,38.0,36.0,34.0,27.0,33.0,32.0,33.0,13.0,21.0,26.0,30.0,37.0,35.0,27.0,18.0,20.0,27.0,26.0,25.0,24.0,30.0,18.0,31.0,40.0,27.0,34.0,25.0,27.0,25.0,30.0,29.0,20.0,33.0,29.0,20.0,26.0,20.0,28.0,24.0,32.0,24.0,33.0,35.0,17.0,24.0,38.0,40.0,25.0,36.0,30.0,30.0,23.0,26.0,18.0,27.0,17.0,28.0,16.0,23.0,14.0,31.0,15.0,16.0,20.0,34.0,16.0,17.0,24.0,16.0,22.0,18.0,20.0,26.0,24.0,35.0,25.0,23.0,28.0,28.0,32.0,32.0,23.0,19.0,30.0,27.0,18.0,21.0,25.0,21.0,17.0,14.0,19.0,18.0,16.0,17.0,15.0,29.0,23.0,18.0,12.0,16.0,10.0:1
12.0,8.0,3.0,7.0,4.0,6.0,7.0,5.0,6.0,5.0,7.0,5.0,7.0,7.0,11.0,7.0,6.0,9.0,10.0,9.0,10.0,7.0,7.0,5.0,6.0,10.0,3.0,6.0,1.0,5.0,3.0,6.0,12.0,11.0,6.0,4.0,7.0,6.0,1.0,5.0,4.0,4.0,0.0,0.0,11.0,0.0,1.0,2.0,1.0,4.0,5.0,2.0,2.0,1.0,2.0,2.0,8.0,9.0,3.0,1.0,5.0,0.0,0.0,3.0,1.0,2.0,4.0,4.0,2.0,4.0,3.0,4.0,4.0,3.0,5.0,6.0,4.0,4.0,12.0,5.0,12.0,5.0,6.0,9.0,4.0,15.0,10.0,5.0,12.0,10.0,7.0,2.0,8.0,6.0,9.0,10.0,2.0,14.0,11.0,13.0,13.0,10.0,7.0,17.0,11.0,9.0,13.0,8.0,16.0,16.0,11.0,8.0,16.0,14.0,13.0,14.0,15.0,16.0,13.0,8.0,12.0,11.0,19.0,14.0,14.0,12.0,21.0,9.0,11.0,8.0,17.0,12.0,16.0,16.0,16.0,24.0,24.0,15.0,15.0,20.0,22.0,18.0,22.0,10.0,15.0,15.0,12.0,11.0,10.0,14.0,19.0,11.0,21.0,19.0,20.0,15.0,13.0,14.0,18.0,15.0,14.0,9.0,17.0,13.0,17.0,8.0,24.0,21.0,12.0,15.0,27.0,9.0,13.0,28.0,23.0,24.0,20.0,12.0,26.0,28.0,11.0,16.0,22.0,17.0,22.0,25.0,22.0,14.0,9.0,14.0,15.0,10.0,16.0,19.0,22.0,21.0,15.0,17.0,20.0,23.0,19.0,14.0,18.0,18.0,16.0,23.0,19.0,12.0,24.0,18.0,26.0,24.0,17.0,18.0,21.0,17.0,24.0,19.0,20.0,23.0,35.0,19.0,11.0,17.0,22.0,19.0,15.0,31.0,17.0,30.0,18.0,19.0,18.0,12.0,20.0,18.0,15.0,14.0,15.0,20.0,13.0,16.0,13.0,16.0,19.0,12.0,22.0,25.0,13.0,11.0,22.0,18.0,17.0,13.0,11.0,10.0,19.0,23.0,19.0,18.0,16.0,12.0,10.0,3.0,15.0,14.0,8.0,12.0,11.0,12.0,15.0,10.0,10.0,10.0,10.0,8.0,10.0,8.0,15.0,9.0,9.0,3.0,7.0,4.0,7.0,6.0,5.0,7.0:1
6.0,10.0,7.0,10.0,4.0,5.0,3.0,4.0,3.0,6.0,3.0,6.0,0.0,3.0,4.0,2.0,4.0,2.0,1.0,1.0,5.0,3.0,1.0,4.0,6.0,1.0,5.0,1.0,2.0,1.0,2.0,1.0,5.0,1.0,2.0,2.0,3.0,0.0,0.0,0.0,3.0,4.0,1.0,1.0,1.0,1.0,3.0,1.0,1.0,3.0,5.0,6.0,3.0,4.0,6.0,3.0,5.0,5.0,8.0,5.0,3.0,6.0,2.0,9.0,7.0,7.0,6.0,4.0,12.0,12.0,12.0,9.0,16.0,9.0,21.0,16.0,22.0,10.0,23.0,9.0,23.0,14.0,15.0,22.0,37.0,40.0,33.0,30.0,22.0,32.0,31.0,38.0,33.0,37.0,22.0,37.0,29.0,32.0,29.0,33.0,23.0,30.0,46.0,39.0,34.0,24.0,37.0,40.0,45.0,43.0,29.0,33.0,34.0,27.0,14.0,27.0,20.0,27.0,36.0,29.0,29.0,26.0,31.0,28.0,26.0,30.0,31.0,26.0,40.0,34.0,30.0,28.0,25.0,34.0,20.0,21.0,22.0,26.0,23.0,24.0,33.0,27.0,30.0,31.0,24.0,29.0,22.0,33.0,28.0,23.0,28.0,22.0,23.0,23.0,21.0,26.0,26.0,31.0,29.0,33.0,25.0,38.0,34.0,27.0,26.0,32.0,34.0,26.0,24.0,24.0,35.0,32.0,40.0,32.0,27.0,30.0,37.0,36.0,33.0,37.0,39.0,21.0,32.0,34.0,35.0,31.0,37.0,30.0,34.0,40.0,40.0,39.0,24.0,36.0,40.0,40.0,30.0,45.0,39.0,40.0,36.0,34.0,37.0,37.0,28.0,38.0,33.0,34.0,45.0,42.0,34.0,41.0,30.0,30.0,32.0,33.0,32.0,28.0,41.0,29.0,32.0,42.0,34.0,31.0,29.0,26.0,36.0,30.0,29.0,33.0,28.0,42.0,25.0,25.0,21.0,20.0,28.0,28.0,37.0,32.0,17.0,21.0,26.0,13.0,19.0,19.0,16.0,22.0,17.0,12.0,22.0,14.0,24.0,17.0,9.0,22.0,17.0,19.0,12.0,16.0,12.0,4.0,13.0,10.0,10.0,14.0,12.0,14.0,14.0,19.0,8.0,12.0,8.0,6.0,9.0,11.0,6.0,11.0,10.0,11.0,10.0,7.0,11.0,6.0,5.0,2.0,4.0,9.0:1
6.0,8.0,4.0,6.0,3.0,6.0,5.0,4.0,6.0,4.0,4.0,6.0,4.0,6.0,2.0,3.0,7.0,6.0,4.0,3.0,4.0,4.0,2.0,3.0,3.0,1.0,0.0,6.0,2.0,3.0,4.0,3.0,1.0,1.0,2.0,1.0,1.0,2.0,2.0,2.0,1.0,2.0,3.0,0.0,1.0,1.0,2.0,1.0,0.0,2.0,3.0,0.0,2.0,2.0,3.0,5.0,3.0,10.0,6.0,8.0,4.0,6.0,2.0,8.0,7.0,5.0,16.0,11.0,16.0,10.0,12.0,12.0,15.0,20.0,18.0,18.0,23.0,10.0,22.0,21.0,22.0,23.0,24.0,25.0,29.0,22.0,34.0,33.0,42.0,36.0,31.0,38.0,38.0,41.0,36.0,44.0,29.0,34.0,21.0,33.0,30.0,24.0,32.0,23.0,32.0,32.0,30.0,34.0,34.0,30.0,30.0,42.0,24.0,27.0,26.0,27.0,36.0,26.0,30.0,22.0,38.0,33.0,24.0,37.0,20.0,25.0,33.0,25.0,31.0,30.0,30.0,28.0,20.0,17.0,36.0,21.0,16.0,26.0,16.0,24.0,24.0,25.0,22.0,28.0,18.0,25.0,27.0,33.0,29.0,21.0,28.0,38.0,32.0,27.0,25.0,29.0,27.0,21.0,32.0,23.0,28.0,23.0,37.0,27.0,25.0,33.0,27.0,28.0,24.0,27.0,21.0,23.0,34.0,17.0,27.0,34.0,34.0,22.0,31.0,31.0,36.0,39.0,37.0,43.0,48.0,43.0,34.0,39.0,46.0,41.0,33.0,40.0,26.0,33.0,35.0,31.0,35.0,18.0,37.0,25.0,31.0,27.0,25.0,23.0,18.0,22.0,33.0,22.0,28.0,31.0,32.0,29.0,20.0,28.0,23.0,33.0,18.0,19.0,19.0,18.0,21.0,14.0,19.0,24.0,21.0,22.0,29.0,21.0,16.0,22.0,17.0,25.0,29.0,22.0,23.0,30.0,16.0,15.0,21.0,17.0,27.0,30.0,24.0,12.0,11.0,23.0,28.0,26.0,8.0,23.0,20.0,9.0,15.0,24.0,27.0,20.0,22.0,14.0,15.0,28.0,22.0,16.0,19.0,11.0,19.0,16.0,5.0,15.0,11.0,10.0,8.0,8.0,11.0,12.0,17.0,12.0,12.0,5.0,8.0,6.0,5.0,9.0,6.0,6.0,8.0,7.0,3.0,3.0:1
16.0,8.0,9.0,9.0,11.0,7.0,7.0,2.0,3.0,8.0,5.0,13.0,5.0,5.0,6.0,5.0,2.0,8.0,11.0,4.0,9.0,5.0,10.0,12.0,10.0,12.0,10.0,6.0,5.0,5.0,9.0,10.0,4.0,10.0,4.0,5.0,5.0,2.0,3.0,2.0,4.0,0.0,4.0,3.0,4.0,1.0,4.0,2.0,3.0,3.0,2.0,2.0,4.0,3.0,3.0,2.0,4.0,5.0,4.0,3.0,1.0,7.0,2.0,3.0,4.0,3.0,1.0,2.0,2.0,10.0,3.0,5.0,3.0,11.0,5.0,6.0,12.0,6.0,6.0,10.0,19.0,7.0,9.0,10.0,16.0,8.0,10.0,11.0,13.0,17.0,16.0,13.0,12.0,16.0,19.0,25.0,23.0,17.0,14.0,13.0,13.0,16.0,23.0,25.0,13.0,24.0,29.0,17.0,29.0,29.0,25.0,18.0,26.0,23.0,22.0,30.0,20.0,35.0,26.0,36.0,25.0,22.0,23.0,25.0,21.0,26.0,26.0,19.0,30.0,36.0,21.0,20.0,28.0,15.0,34.0,17.0,27.0,22.0,20.0,25.0,27.0,31.0,31.0,23.0,35.0,27.0,32.0,18.0,42.0,27.0,22.0,29.0,24.0,25.0,14.0,36.0,21.0,36.0,36.0,18.0,15.0,27.0,26.0,24.0,28.0,30.0,35.0,24.0,34.0,40.0,39.0,35.0,37.0,26.0,37.0,32.0,41.0,37.0,24.0,36.0,29.0,39.0,30.0,47.0,25.0,30.0,29.0,31.0,33.0,30.0,36.0,22.0,25.0,34.0,27.0,36.0,37.0,29.0,20.0,26.0,32.0,26.0,18.0,35.0,22.0,28.0,30.0,39.0,33.0,30.0,27.0,24.0,36.0,31.0,26.0,30.0,25.0,32.0,33.0,25.0,26.0,30.0,29.0,25.0,32.0,34.0,21.0,19.0,21.0,32.0,30.0,21.0,28.0,18.0,24.0,23.0,23.0,18.0,20.0,29.0,17.0,30.0,23.0,19.0,11.0,20.0,13.0,11.0,6.0,16.0,11.0,26.0,20.0,21.0,13.0,25.0,12.0,12.0,17.0,12.0,24.0,23.0,15.0,14.0,12.0,16.0,10.0,16.0,9.0,11.0,19.0,28.0,17.0,23.0,25.0,18.0,28.0,23.0,14.0,20.0,5.0,18.0,7.0,17.0,4.0,11.0,16.0,14.0:1
6.0,12.0,4.0,5.0,9.0,4.0,7.0,3.0,5.0,7.0,3.0,0.0,5.0,3.0,2.0,1.0,4.0,5.0,3.0,5.0,2.0,2.0,5.0,5.0,9.0,10.0,1.0,5.0,5.0,4.0,2.0,1.0,2.0,2.0,3.0,2.0,0.0,1.0,1.0,6.0,3.0,1.0,2.0,2.0,2.0,1.0,2.0,2.0,2.0,3.0,3.0,2.0,0.0,1.0,3.0,6.0,5.0,8.0,5.0,2.0,7.0,6.0,5.0,5.0,8.0,9.0,10.0,12.0,10.0,6.0,12.0,10.0,13.0,19.0,12.0,30.0,19.0,19.0,18.0,26.0,28.0,28.0,35.0,35.0,31.0,35.0,43.0,34.0,40.0,38.0,36.0,43.0,42.0,28.0,34.0,42.0,42.0,30.0,32.0,30.0,37.0,36.0,34.0,36.0,32.0,44.0,31.0,39.0,38.0,37.0,41.0,29.0,35.0,24.0,38.0,30.0,30.0,33.0,33.0,31.0,22.0,33.0,30.0,22.0,27.0,23.0,31.0,35.0,29.0,38.0,28.0,20.0,26.0,25.0,26.0,24.0,22.0,26.0,35.0,34.0,21.0,33.0,17.0,32.0,21.0,25.0,28.0,23.0,17.0,28.0,20.0,29.0,14.0,20.0,26.0,36.0,34.0,22.0,23.0,31.0,30.0,24.0,24.0,28.0,30.0,24.0,34.0,41.0,33.0,23.0,27.0,25.0,29.0,44.0,37.0,30.0,39.0,34.0,30.0,38.0,26.0,42.0,34.0,36.0,33.0,36.0,24.0,41.0,37.0,32.0,35.0,38.0,32.0,40.0,27.0,30.0,37.0,22.0,37.0,21.0,35.0,37.0,34.0,32.0,21.0,21.0,22.0,19.0,40.0,29.0,30.0,22.0,20.0,21.0,27.0,34.0,16.0,27.0,15.0,19.0,36.0,22.0,26.0,30.0,34.0,35.0,37.0,23.0,22.0,31.0,39.0,27.0,31.0,21.0,19.0,24.0,23.0,28.0,28.0,25.0,22.0,24.0,21.0,20.0,15.0,15.0,22.0,15.0,20.0,19.0,19.0,28.0,15.0,21.0,22.0,20.0,15.0,16.0,22.0,12.0,17.0,15.0,16.0,11.0,20.0,14.0,13.0,13.0,15.0,15.0,7.0,21.0,5.0,8.0,20.0,7.0,8.0,10.0,6.0,17.0,14.0,3.0,6.0,5.0,8.0,5.0,6.0,9.0:1
7.0,4.0,5.0,10.0,7.0,4.0,7.0,5.0,3.0,3.0,3.0,3.0,4.0,2.0,4.0,5.0,3.0,0.0,5.0,1.0,4.0,3.0,1.0,1.0,5.0,5.0,9.0,6.0,2.0,3.0,1.0,1.0,6.0,0.0,1.0,4.0,4.0,2.0,2.0,4.0,1.0,3.0,0.0,2.0,1.0,1.0,3.0,2.0,0.0,1.0,0.0,3.0,3.0,1.0,2.0,3.0,6.0,3.0,6.0,2.0,6.0,3.0,5.0,7.0,4.0,10.0,8.0,11.0,8.0,10.0,22.0,11.0,7.0,8.0,14.0,16.0,21.0,21.0,14.0,30.0,19.0,20.0,27.0,22.0,22.0,25.0,25.0,30.0,51.0,41.0,27.0,34.0,48.0,40.0,30.0,38.0,38.0,30.0,40.0,31.0,40.0,37.0,34.0,33.0,42.0,50.0,47.0,29.0,38.0,34.0,23.0,31.0,34.0,25.0,21.0,42.0,32.0,24.0,29.0,28.0,31.0,32.0,30.0,23.0,28.0,27.0,38.0,22.0,27.0,29.0,22.0,23.0,20.0,30.0,19.0,35.0,19.0,33.0,27.0,25.0,41.0,35.0,23.0,30.0,12.0,33.0,27.0,33.0,28.0,35.0,34.0,26.0,38.0,31.0,20.0,32.0,34.0,28.0,31.0,14.0,21.0,12.0,19.0,20.0,32.0,20.0,28.0,22.0,17.0,30.0,25.0,31.0,38.0,33.0,19.0,29.0,35.0,36.0,27.0,32.0,35.0,28.0,32.0,36.0,29.0,27.0,40.0,36.0,32.0,46.0,30.0,31.0,38.0,26.0,26.0,26.0,32.0,33.0,29.0,34.0,21.0,22.0,28.0,34.0,24.0,22.0,21.0,27.0,26.0,25.0,34.0,28.0,18.0,31.0,24.0,28.0,32.0,32.0,37.0,32.0,28.0,28.0,30.0,33.0,24.0,22.0,22.0,20.0,17.0,31.0,34.0,29.0,23.0,30.0,36.0,34.0,19.0,27.0,27.0,18.0,28.0,21.0,22.0,20.0,17.0,18.0,14.0,17.0,21.0,11.0,18.0,13.0,23.0,26.0,21.0,13.0,20.0,21.0,11.0,17.0,13.0,16.0,7.0,14.0,17.0,10.0,10.0,13.0,17.0,20.0,7.0,10.0,14.0,11.0,7.0,11.0,6.0,8.0,7.0,4.0,12.0,10.0,4.0,6.0,9.0,11.0,5.0,5.0:1
5.0,8.0,11.0,2.0,2.0,10.0,6.0,8.0,1.0,6.0,2.0,2.0,3.0,4.0,1.0,2.0,1.0,2.0,4.0,2.0,4.0,5.0,4.0,7.0,3.0,7.0,3.0,5.0,3.0,2.0,3.0,2.0,2.0,1.0,2.0,3.0,3.0,2.0,1.0,3.0,2.0,0.0,5.0,1.0,5.0,1.0,4.0,1.0,0.0,1.0,2.0,3.0,0.0,0.0,2.0,5.0,6.0,4.0,6.0,5.0,8.0,5.0,8.0,3.0,9.0,4.0,9.0,7.0,14.0,9.0,12.0,13.0,15.0,11.0,15.0,10.0,10.0,22.0,21.0,23.0,25.0,15.0,24.0,14.0,28.0,33.0,32.0,40.0,33.0,35.0,34.0,46.0,33.0,46.0,31.0,25.0,33.0,32.0,24.0,32.0,29.0,44.0,20.0,33.0,43.0,28.0,30.0,32.0,31.0,34.0,29.0,31.0,32.0,28.0,34.0,22.0,34.0,32.0,30.0,24.0,25.0,36.0,28.0,29.0,27.0,26.0,35.0,35.0,35.0,26.0,13.0,31.0,30.0,27.0,28.0,22.0,31.0,18.0,18.0,24.0,31.0,28.0,32.0,22.0,31.0,18.0,37.0,17.0,21.0,24.0,12.0,19.0,23.0,30.0,26.0,31.0,19.0,26.0,33.0,33.0,32.0,15.0,32.0,26.0,35.0,30.0,22.0,31.0,33.0,41.0,35.0,23.0,24.0,37.0,33.0,36.0,41.0,44.0,37.0,36.0,29.0,35.0,41.0,38.0,40.0,33.0,41.0,41.0,44.0,38.0,42.0,49.0,44.0,28.0,37.0,26.0,38.0,39.0,35.0,32.0,35.0,42.0,35.0,39.0,30.0,28.0,49.0,33.0,28.0,41.0,29.0,32.0,32.0,28.0,22.0,18.0,37.0,37.0,30.0,26.0,27.0,42.0,35.0,15.0,16.0,37.0,31.0,36.0,39.0,28.0,30.0,21.0,26.0,31.0,28.0,23.0,20.0,19.0,32.0,20.0,17.0,22.0,18.0,19.0,23.0,20.0,18.0,12.0,21.0,18.0,22.0,21.0,18.0,30.0,15.0,23.0,23.0,12.0,18.0,11.0,23.0,9.0,13.0,10.0,11.0,14.0,6.0,3.0,11.0,6.0,12.0,16.0,5.0,14.0,13.0,12.0,10.0,13.0,11.0,12.0,8.0,12.0,7.0,6.0,6.0,3.0,2.0,5.0:1
4.0,8.0,3.0,6.0,7.0,2.0,5.0,3.0,8.0,1.0,2.0,4.0,2.0,2.0,3.0,4.0,9.0,2.0,4.0,2.0,3.0,5.0,2.0,6.0,4.0,4.0,2.0,3.0,0.0,0.0,2.0,4.0,2.0,3.0,6.0,0.0,1.0,5.0,2.0,1.0,3.0,4.0,1.0,5.0,2.0,1.0,0.0,2.0,3.0,1.0,2.0,3.0,5.0,2.0,2.0,2.0,5.0,4.0,9.0,1.0,2.0,6.0,6.0,6.0,8.0,3.0,12.0,9.0,10.0,13.0,9.0,12.0,10.0,17.0,15.0,14.0,25.0,13.0,22.0,19.0,14.0,13.0,29.0,27.0,24.0,22.0,28.0,19.0,40.0,35.0,34.0,13.0,29.0,22.0,41.0,32.0,24.0,37.0,41.0,32.0,26.0,35.0,29.0,49.0,39.0,33.0,44.0,35.0,29.0,28.0,31.0,33.0,25.0,22.0,33.0,28.0,29.0,25.0,26.0,25.0,31.0,32.0,30.0,39.0,32.0,25.0,28.0,21.0,30.0,31.0,19.0,22.0,12.0,22.0,21.0,28.0,29.0,27.0,32.0,16.0,36.0,28.0,24.0,25.0,33.0,23.0,31.0,34.0,30.0,29.0,27.0,27.0,28.0,30.0,27.0,34.0,30.0,20.0,21.0,33.0,30.0,33.0,30.0,29.0,39.0,29.0,19.0,25.0,31.0,29.0,24.0,38.0,34.0,40.0,32.0,30.0,40.0,23.0,34.0,34.0,34.0,40.0,35.0,19.0,31.0,30.0,31.0,32.0,27.0,32.0,32.0,34.0,31.0,36.0,30.0,38.0,36.0,21.0,37.0,27.0,26.0,26.0,29.0,20.0,22.0,37.0,24.0,24.0,30.0,27.0,39.0,30.0,25.0,44.0,33.0,23.0,30.0,27.0,46.0,33.0,41.0,32.0,34.0,31.0,34.0,37.0,35.0,25.0,23.0,30.0,18.0,29.0,29.0,36.0,33.0,30.0,39.0,20.0,31.0,39.0,40.0,23.0,23.0,30.0,17.0,26.0,31.0,21.0,21.0,22.0,10.0,24.0,20.0,18.0,16.0,24.0,14.0,26.0,26.0,37.0,26.0,21.0,22.0,20.0,18.0,16.0,23.0,18.0,23.0,20.0,25.0,18.0,25.0,25.0,18.0,16.0,9.0,24.0,8.0,13.0,14.0,8.0,11.0,6.0,16.0,11.0,10.0,11.0:1
2.0,4.0,4.0,4.0,4.0,4.0,6.0,6.0,2.0,3.0,4.0,6.0,2.0,3.0,0.0,1.0,2.0,0.0,3.0,4.0,1.0,0.0,1.0,4.0,0.0,2.0,3.0,4.0,1.0,2.0,3.0,3.0,4.0,1.0,4.0,2.0,1.0,0.0,0.0,6.0,2.0,4.0,2.0,0.0,2.0,1.0,2.0,0.0,3.0,3.0,1.0,2.0,3.0,3.0,4.0,4.0,1.0,6.0,6.0,6.0,2.0,3.0,8.0,8.0,8.0,10.0,10.0,11.0,19.0,13.0,9.0,10.0,11.0,23.0,16.0,15.0,27.0,17.0,16.0,28.0,26.0,31.0,30.0,32.0,32.0,28.0,39.0,41.0,36.0,33.0,46.0,40.0,38.0,39.0,44.0,35.0,36.0,24.0,29.0,38.0,38.0,35.0,38.0,43.0,35.0,40.0,45.0,38.0,33.0,36.0,48.0,29.0,23.0,37.0,37.0,31.0,23.0,23.0,26.0,30.0,40.0,30.0,38.0,26.0,23.0,28.0,20.0,25.0,14.0,17.0,21.0,16.0,19.0,25.0,15.0,24.0,31.0,22.0,23.0,23.0,30.0,33.0,29.0,26.0,15.0,24.0,27.0,22.0,32.0,28.0,33.0,30.0,25.0,18.0,26.0,25.0,19.0,24.0,30.0,32.0,36.0,24.0,25.0,25.0,27.0,29.0,31.0,32.0,27.0,28.0,25.0,36.0,26.0,39.0,23.0,37.0,43.0,38.0,28.0,41.0,40.0,37.0,49.0,34.0,38.0,33.0,36.0,32.0,38.0,32.0,43.0,38.0,26.0,33.0,36.0,42.0,30.0,38.0,22.0,43.0,41.0,49.0,37.0,32.0,27.0,40.0,46.0,48.0,48.0,37.0,48.0,39.0,36.0,42.0,31.0,41.0,35.0,38.0,20.0,34.0,20.0,28.0,33.0,38.0,20.0,18.0,33.0,27.0,39.0,34.0,34.0,33.0,25.0,34.0,31.0,30.0,29.0,15.0,17.0,33.0,19.0,15.0,25.0,17.0,22.0,26.0,20.0,15.0,17.0,24.0,16.0,19.0,11.0,23.0,13.0,12.0,21.0,17.0,17.0,9.0,11.0,21.0,14.0,10.0,12.0,15.0,21.0,16.0,11.0,8.0,10.0,15.0,12.0,17.0,12.0,9.0,8.0,11.0,8.0,8.0,4.0,7.0,2.0,5.0,7.0,8.0,7.0,5.0:1
8.0,4.0,6.0,9.0,8.0,4.0,5.0,9.0,5.0,2.0,3.0,3.0,7.0,4.0,3.0,4.0,5.0,2.0,3.0,3.0,2.0,2.0,3.0,3.0,5.0,4.0,3.0,5.0,8.0,1.0,3.0,3.0,5.0,4.0,2.0,5.0,0.0,5.0,5.0,1.0,1.0,4.0,1.0,2.0,1.0,2.0,1.0,2.0,1.0,8.0,1.0,7.0,0.0,3.0,1.0,1.0,4.0,3.0,5.0,2.0,8.0,2.0,6.0,2.0,8.0,7.0,14.0,8.0,8.0,12.0,13.0,6.0,15.0,17.0,13.0,18.0,18.0,23.0,20.0,31.0,36.0,33.0,26.0,29.0,25.0,44.0,33.0,36.0,27.0,39.0,42.0,22.0,39.0,22.0,39.0,34.0,29.0,35.0,46.0,18.0,40.0,30.0,36.0,47.0,32.0,36.0,31.0,44.0,36.0,25.0,38.0,25.0,33.0,29.0,36.0,42.0,43.0,31.0,33.0,24.0,32.0,34.0,19.0,29.0,17.0,46.0,27.0,28.0,35.0,33.0,41.0,35.0,22.0,25.0,23.0,25.0,30.0,34.0,34.0,33.0,27.0,28.0,29.0,27.0,27.0,24.0,24.0,30.0,32.0,38.0,27.0,43.0,18.0,29.0,40.0,27.0,20.0,29.0,35.0,28.0,34.0,37.0,25.0,31.0,36.0,27.0,30.0,30.0,28.0,33.0,47.0,33.0,35.0,38.0,44.0,38.0,49.0,33.0,35.0,42.0,37.0,46.0,42.0,40.0,29.0,31.0,25.0,31.0,25.0,43.0,27.0,29.0,34.0,37.0,39.0,39.0,32.0,37.0,39.0,28.0,22.0,25.0,21.0,36.0,18.0,17.0,20.0,36.0,23.0,33.0,23.0,36.0,34.0,33.0,25.0,37.0,35.0,50.0,39.0,39.0,42.0,33.0,36.0,37.0,28.0,35.0,30.0,37.0,25.0,33.0,36.0,39.0,38.0,28.0,39.0,25.0,24.0,26.0,33.0,24.0,26.0,13.0,24.0,30.0,30.0,24.0,16.0,25.0,29.0,34.0,18.0,19.0,17.0,16.0,25.0,23.0,20.0,27.0,27.0,6.0,21.0,22.0,15.0,20.0,17.0,24.0,17.0,19.0,14.0,25.0,20.0,18.0,12.0,32.0,16.0,16.0,12.0,18.0,15.0,11.0,17.0,12.0,11.0,25.0,14.0,6.0,14.0,12.0:1
8.0,5.0,4.0,4.0,5.0,7.0,6.0,12.0,5.0,7.0,7.0,3.0,6.0,4.0,5.0,4.0,2.0,2.0,5.0,4.0,2.0,6.0,2.0,6.0,5.0,1.0,5.0,2.0,2.0,3.0,1.0,3.0,1.0,4.0,3.0,2.0,4.0,1.0,2.0,2.0,1.0,2.0,3.0,1.0,2.0,1.0,3.0,2.0,2.0,0.0,3.0,3.0,2.0,0.0,3.0,5.0,1.0,3.0,5.0,2.0,4.0,5.0,8.0,3.0,8.0,5.0,8.0,7.0,10.0,10.0,11.0,20.0,15.0,13.0,14.0,12.0,17.0,24.0,20.0,33.0,28.0,22.0,21.0,28.0,32.0,40.0,33.0,37.0,43.0,24.0,24.0,44.0,30.0,36.0,37.0,19.0,20.0,30.0,26.0,32.0,28.0,32.0,35.0,33.0,35.0,29.0,36.0,29.0,33.0,39.0,27.0,41.0,36.0,37.0,30.0,39.0,38.0,43.0,40.0,29.0,33.0,30.0,35.0,39.0,28.0,29.0,25.0,31.0,45.0,27.0,22.0,26.0,20.0,17.0,17.0,24.0,19.0,18.0,28.0,28.0,25.0,33.0,29.0,9.0,26.0,32.0,24.0,32.0,21.0,21.0,23.0,19.0,21.0,31.0,16.0,28.0,31.0,29.0,26.0,24.0,27.0,18.0,19.0,21.0,35.0,27.0,21.0,23.0,39.0,29.0,30.0,25.0,22.0,30.0,27.0,28.0,34.0,33.0,31.0,25.0,26.0,23.0,40.0,28.0,39.0,42.0,35.0,40.0,30.0,34.0,41.0,32.0,33.0,43.0,29.0,38.0,27.0,34.0,29.0,31.0,27.0,30.0,29.0,43.0,34.0,33.0,27.0,20.0,19.0,24.0,23.0,18.0,22.0,19.0,33.0,26.0,38.0,26.0,33.0,34.0,36.0,28.0,29.0,38.0,45.0,41.0,36.0,31.0,32.0,31.0,27.0,29.0,22.0,39.0,24.0,17.0,23.0,14.0,13.0,24.0,27.0,21.0,20.0,14.0,14.0,18.0,22.0,19.0,19.0,25.0,16.0,28.0,13.0,19.0,16.0,21.0,20.0,17.0,20.0,22.0,22.0,17.0,23.0,27.0,12.0,19.0,12.0,12.0,12.0,19.0,11.0,13.0,16.0,11.0,8.0,8.0,7.0,17.0,10.0,6.0,8.0,5.0,4.0,5.0,8.0,7.0,6.0,7.0:1
3.0,3.0,2.0,6.0,7.0,6.0,7.0,4.0,5.0,5.0,3.0,1.0,0.0,4.0,3.0,6.0,6.0,7.0,6.0,3.0,6.0,1.0,3.0,2.0,3.0,2.0,7.0,3.0,1.0,0.0,1.0,1.0,1.0,3.0,2.0,2.0,1.0,1.0,1.0,1.0,1.0,2.0,2.0,1.0,1.0,0.0,1.0,0.0,5.0,4.0,1.0,4.0,1.0,2.0,2.0,5.0,1.0,5.0,7.0,4.0,5.0,3.0,8.0,5.0,7.0,8.0,11.0,11.0,7.0,8.0,8.0,10.0,4.0,15.0,16.0,21.0,18.0,15.0,34.0,28.0,34.0,27.0,33.0,20.0,24.0,43.0,43.0,27.0,42.0,48.0,40.0,25.0,36.0,46.0,37.0,29.0,27.0,26.0,36.0,32.0,43.0,29.0,42.0,28.0,35.0,40.0,45.0,50.0,36.0,31.0,25.0,43.0,22.0,36.0,19.0,35.0,23.0,38.0,32.0,28.0,28.0,21.0,30.0,29.0,37.0,32.0,24.0,31.0,23.0,23.0,18.0,16.0,23.0,26.0,25.0,19.0,26.0,29.0,33.0,21.0,37.0,28.0,25.0,30.0,24.0,22.0,32.0,32.0,26.0,21.0,33.0,39.0,39.0,29.0,28.0,40.0,25.0,33.0,36.0,26.0,28.0,31.0,25.0,27.0,37.0,20.0,43.0,26.0,18.0,25.0,34.0,33.0,37.0,46.0,32.0,38.0,42.0,37.0,38.0,39.0,34.0,29.0,37.0,47.0,31.0,41.0,37.0,31.0,42.0,38.0,44.0,33.0,37.0,41.0,32.0,34.0,31.0,28.0,33.0,47.0,37.0,22.0,41.0,37.0,32.0,30.0,43.0,34.0,36.0,29.0,34.0,34.0,31.0,40.0,32.0,35.0,39.0,33.0,32.0,43.0,35.0,32.0,35.0,31.0,23.0,28.0,27.0,21.0,33.0,22.0,30.0,29.0,31.0,29.0,31.0,23.0,19.0,23.0,24.0,16.0,27.0,19.0,23.0,20.0,26.0,18.0,21.0,18.0,32.0,26.0,21.0,21.0,22.0,26.0,27.0,20.0,26.0,20.0,21.0,19.0,13.0,18.0,10.0,11.0,16.0,19.0,11.0,16.0,11.0,20.0,12.0,15.0,12.0,12.0,10.0,12.0,9.0,17.0,21.0,9.0,13.0,9.0,6.0,4.0,3.0,8.0,12.0,6.0:1
1.0,9.0,2.0,1.0,7.0,4.0,3.0,5.0,6.0,7.0,1.0,2.0,3.0,2.0,2.0,3.0,5.0,3.0,4.0,3.0,2.0,8.0,3.0,4.0,4.0,6.0,4.0,1.0,1.0,3.0,5.0,0.0,0.0,5.0,1.0,3.0,3.0,0.0,1.0,0.0,1.0,0.0,1.0,1.0,1.0,4.0,2.0,1.0,4.0,0.0,0.0,3.0,1.0,0.0,1.0,5.0,7.0,1.0,6.0,7.0,4.0,6.0,5.0,7.0,4.0,9.0,7.0,5.0,8.0,8.0,10.0,12.0,8.0,16.0,10.0,22.0,14.0,23.0,23.0,29.0,26.0,26.0,26.0,33.0,32.0,34.0,44.0,44.0,35.0,37.0,44.0,34.0,43.0,22.0,38.0,35.0,25.0,34.0,31.0,33.0,29.0,39.0,36.0,35.0,37.0,42.0,40.0,28.0,30.0,30.0,31.0,45.0,30.0,19.0,31.0,33.0,21.0,18.0,44.0,33.0,15.0,27.0,21.0,13.0,27.0,29.0,23.0,15.0,18.0,22.0,26.0,8.0,14.0,24.0,32.0,24.0,26.0,30.0,30.0,20.0,16.0,21.0,28.0,29.0,25.0,28.0,30.0,26.0,29.0,29.0,36.0,22.0,27.0,10.0,11.0,14.0,26.0,16.0,27.0,19.0,30.0,21.0,22.0,20.0,30.0,30.0,19.0,26.0,35.0,29.0,20.0,25.0,22.0,30.0,23.0,27.0,29.0,35.0,26.0,31.0,25.0,37.0,40.0,37.0,34.0,26.0,23.0,31.0,33.0,38.0,31.0,32.0,33.0,28.0,33.0,27.0,44.0,23.0,26.0,20.0,19.0,17.0,33.0,31.0,30.0,35.0,42.0,28.0,29.0,31.0,30.0,25.0,24.0,21.0,34.0,9.0,27.0,36.0,28.0,35.0,31.0,37.0,26.0,28.0,31.0,25.0,35.0,17.0,18.0,28.0,15.0,18.0,18.0,30.0,17.0,25.0,31.0,18.0,14.0,16.0,16.0,22.0,30.0,14.0,19.0,13.0,8.0,18.0,19.0,14.0,18.0,16.0,14.0,18.0,11.0,24.0,12.0,6.0,14.0,15.0,24.0,10.0,10.0,9.0,12.0,8.0,14.0,12.0,19.0,9.0,9.0,11.0,13.0,4.0,8.0,4.0,8.0,7.0,10.0,7.0,11.0,10.0,6.0,4.0,5.0,2.0,11.0,7.0:1
5.0,8.0,5.0,5.0,4.0,5.0,5.0,6.0,9.0,5.0,3.0,3.0,2.0,5.0,3.0,3.0,6.0,6.0,7.0,2.0,2.0,2.0,0.0,4.0,3.0,3.0,1.0,2.0,4.0,2.0,0.0,4.0,4.0,6.0,3.0,2.0,1.0,1.0,0.0,1.0,1.0,1.0,1.0,2.0,2.0,5.0,2.0,2.0,1.0,2.0,2.0,3.0,6.0,1.0,1.0,6.0,4.0,6.0,9.0,6.0,4.0,6.0,7.0,6.0,6.0,8.0,15.0,11.0,9.0,12.0,20.0,8.0,9.0,12.0,8.0,28.0,16.0,16.0,24.0,30.0,25.0,27.0,24.0,37.0,29.0,31.0,43.0,44.0,39.0,38.0,37.0,31.0,35.0,43.0,31.0,33.0,35.0,33.0,33.0,50.0,35.0,42.0,46.0,33.0,43.0,49.0,40.0,48.0,36.0,36.0,43.0,33.0,44.0,36.0,42.0,47.0,33.0,35.0,37.0,39.0,29.0,37.0,40.0,25.0,25.0,32.0,35.0,32.0,41.0,20.0,15.0,22.0,26.0,19.0,20.0,30.0,29.0,16.0,17.0,24.0,34.0,19.0,28.0,36.0,16.0,26.0,23.0,38.0,23.0,23.0,22.0,35.0,25.0,29.0,26.0,30.0,22.0,34.0,32.0,23.0,35.0,36.0,23.0,25.0,29.0,26.0,32.0,37.0,28.0,23.0,32.0,37.0,24.0,29.0,27.0,48.0,41.0,46.0,43.0,34.0,37.0,41.0,50.0,44.0,26.0,37.0,31.0,47.0,30.0,39.0,46.0,35.0,35.0,38.0,36.0,35.0,41.0,44.0,40.0,40.0,35.0,45.0,42.0,40.0,33.0,46.0,50.0,50.0,35.0,32.0,36.0,43.0,33.0,42.0,38.0,43.0,38.0,30.0,29.0,30.0,19.0,30.0,34.0,43.0,39.0,22.0,35.0,30.0,35.0,31.0,35.0,37.0,30.0,30.0,26.0,30.0,25.0,32.0,20.0,23.0,25.0,16.0,20.0,23.0,24.0,29.0,18.0,25.0,36.0,16.0,19.0,20.0,22.0,24.0,23.0,19.0,25.0,21.0,15.0,18.0,22.0,21.0,28.0,17.0,17.0,14.0,26.0,19.0,16.0,10.0,8.0,11.0,18.0,14.0,12.0,19.0,13.0,14.0,9.0,12.0,9.0,14.0,6.0,11.0,13.0,9.0,9.0,8.0:1
12.0,6.0,8.0,4.0,5.0,6.0,3.0,2.0,8.0,3.0,6.0,6.0,1.0,0.0,7.0,7.0,2.0,4.0,1.0,4.0,2.0,1.0,1.0,3.0,6.0,0.0,2.0,0.0,0.0,3.0,0.0,0.0,0.0,1.0,2.0,2.0,1.0,1.0,1.0,0.0,2.0,6.0,2.0,1.0,4.0,4.0,6.0,2.0,4.0,0.0,4.0,1.0,3.0,1.0,3.0,7.0,8.0,5.0,3.0,4.0,3.0,4.0,4.0,7.0,7.0,8.0,14.0,14.0,13.0,5.0,9.0,13.0,12.0,16.0,12.0,14.0,12.0,24.0,12.0,15.0,26.0,19.0,20.0,20.0,20.0,37.0,41.0,27.0,38.0,38.0,45.0,33.0,32.0,34.0,40.0,32.0,33.0,30.0,36.0,26.0,29.0,37.0,31.0,35.0,27.0,44.0,51.0,45.0,41.0,18.0,31.0,26.0,46.0,42.0,22.0,38.0,39.0,39.0,29.0,40.0,35.0,26.0,23.0,27.0,21.0,30.0,29.0,32.0,29.0,38.0,23.0,19.0,30.0,23.0,23.0,33.0,33.0,33.0,33.0,23.0,36.0,31.0,34.0,38.0,30.0,33.0,36.0,29.0,30.0,40.0,49.0,22.0,34.0,33.0,19.0,21.0,26.0,21.0,28.0,38.0,32.0,37.0,47.0,31.0,33.0,39.0,27.0,38.0,28.0,32.0,39.0,38.0,30.0,35.0,38.0,26.0,26.0,42.0,30.0,32.0,45.0,26.0,41.0,37.0,30.0,36.0,41.0,36.0,44.0,54.0,49.0,48.0,40.0,37.0,51.0,39.0,41.0,29.0,40.0,38.0,35.0,33.0,34.0,31.0,40.0,25.0,28.0,30.0,33.0,33.0,35.0,35.0,34.0,40.0,43.0,38.0,26.0,32.0,44.0,44.0,41.0,39.0,36.0,36.0,39.0,36.0,39.0,25.0,33.0,31.0,44.0,39.0,35.0,37.0,32.0,36.0,36.0,41.0,35.0,24.0,38.0,39.0,28.0,51.0,34.0,31.0,28.0,31.0,20.0,15.0,21.0,31.0,25.0,29.0,12.0,12.0,17.0,11.0,18.0,19.0,26.0,21.0,15.0,16.0,9.0,13.0,14.0,15.0,10.0,14.0,8.0,13.0,16.0,14.0,11.0,14.0,15.0,8.0,8.0,11.0,8.0,7.0,6.0,8.0,5.0,10.0,7.0,6.0:1
5.0,10.0,10.0,12.0,7.0,8.0,3.0,7.0,2.0,7.0,2.0,4.0,2.0,7.0,8.0,6.0,1.0,3.0,4.0,8.0,8.0,2.0,8.0,1.0,4.0,11.0,15.0,8.0,9.0,4.0,3.0,4.0,7.0,7.0,1.0,1.0,3.0,5.0,3.0,3.0,4.0,3.0,4.0,2.0,1.0,1.0,2.0,3.0,5.0,4.0,4.0,4.0,1.0,5.0,2.0,2.0,3.0,0.0,3.0,4.0,7.0,6.0,2.0,4.0,6.0,5.0,3.0,5.0,12.0,6.0,6.0,6.0,16.0,9.0,8.0,6.0,12.0,8.0,9.0,12.0,9.0,10.0,13.0,13.0,7.0,7.0,10.0,10.0,4.0,6.0,7.0,11.0,11.0,16.0,14.0,10.0,17.0,14.0,25.0,16.0,15.0,20.0,16.0,13.0,17.0,16.0,14.0,18.0,21.0,6.0,15.0,16.0,17.0,20.0,21.0,21.0,23.0,25.0,11.0,14.0,27.0,25.0,18.0,19.0,16.0,22.0,25.0,15.0,19.0,21.0,21.0,25.0,17.0,19.0,22.0,22.0,19.0,17.0,14.0,23.0,21.0,17.0,25.0,20.0,30.0,27.0,20.0,15.0,18.0,18.0,26.0,25.0,30.0,17.0,21.0,25.0,19.0,19.0,18.0,32.0,28.0,18.0,30.0,23.0,27.0,33.0,22.0,20.0,25.0,11.0,18.0,28.0,31.0,22.0,23.0,19.0,30.0,29.0,37.0,24.0,26.0,16.0,31.0,27.0,35.0,23.0,18.0,21.0,17.0,22.0,22.0,23.0,24.0,24.0,23.0,25.0,22.0,23.0,21.0,24.0,19.0,18.0,32.0,31.0,31.0,32.0,29.0,24.0,24.0,28.0,20.0,33.0,21.0,24.0,27.0,18.0,29.0,49.0,56.0,44.0,52.0,34.0,44.0,34.0,32.0,32.0,30.0,20.0,25.0,19.0,19.0,24.0,22.0,27.0,18.0,22.0,20.0,22.0,14.0,26.0,34.0,13.0,10.0,20.0,14.0,36.0,17.0,12.0,21.0,14.0,23.0,26.0,22.0,21.0,16.0,21.0,29.0,22.0,17.0,23.0,18.0,20.0,29.0,22.0,23.0,28.0,17.0,25.0,33.0,33.0,24.0,29.0,27.0,25.0,19.0,20.0,24.0,21.0,20.0,19.0,15.0,11.0,21.0,6.0,24.0,7.0,16.0,15.0:1
12.0,5.0,8.0,4.0,7.0,4.0,4.0,1.0,7.0,5.0,8.0,9.0,6.0,7.0,5.0,7.0,10.0,6.0,6.0,6.0,3.0,5.0,5.0,6.0,5.0,6.0,11.0,5.0,4.0,5.0,4.0,4.0,4.0,8.0,4.0,1.0,3.0,3.0,5.0,6.0,6.0,0.0,7.0,3.0,3.0,1.0,0.0,3.0,7.0,3.0,4.0,2.0,3.0,2.0,1.0,6.0,5.0,4.0,5.0,3.0,4.0,9.0,4.0,1.0,4.0,2.0,5.0,7.0,8.0,4.0,10.0,4.0,7.0,6.0,6.0,7.0,5.0,4.0,3.0,10.0,5.0,2.0,10.0,11.0,8.0,5.0,9.0,5.0,5.0,8.0,6.0,6.0,16.0,3.0,11.0,4.0,11.0,13.0,11.0,8.0,13.0,12.0,12.0,16.0,22.0,23.0,8.0,21.0,14.0,11.0,16.0,13.0,19.0,23.0,17.0,18.0,14.0,19.0,20.0,24.0,18.0,25.0,15.0,12.0,20.0,17.0,20.0,17.0,20.0,24.0,23.0,17.0,23.0,18.0,21.0,23.0,16.0,12.0,23.0,27.0,35.0,24.0,29.0,26.0,18.0,16.0,18.0,20.0,18.0,16.0,21.0,21.0,25.0,16.0,24.0,27.0,23.0,24.0,23.0,21.0,24.0,22.0,36.0,20.0,29.0,28.0,22.0,36.0,17.0,24.0,28.0,17.0,39.0,35.0,15.0,32.0,33.0,26.0,17.0,26.0,20.0,24.0,24.0,26.0,19.0,12.0,21.0,23.0,21.0,19.0,27.0,23.0,20.0,19.0,22.0,18.0,17.0,21.0,17.0,14.0,20.0,24.0,27.0,19.0,24.0,26.0,14.0,19.0,19.0,29.0,20.0,24.0,29.0,22.0,17.0,27.0,13.0,16.0,26.0,22.0,24.0,28.0,21.0,24.0,20.0,21.0,19.0,24.0,15.0,31.0,19.0,16.0,19.0,22.0,24.0,27.0,25.0,27.0,17.0,22.0,25.0,24.0,22.0,24.0,15.0,26.0,20.0,18.0,11.0,16.0,18.0,19.0,29.0,12.0,13.0,13.0,10.0,16.0,17.0,16.0,19.0,16.0,15.0,19.0,13.0,21.0,20.0,20.0,22.0,14.0,24.0,18.0,22.0,17.0,19.0,10.0,20.0,17.0,20.0,12.0,12.0,14.0,11.0,16.0,12.0,8.0,7.0,12.0:1
9.0,5.0,7.0,3.0,6.0,1.0,6.0,6.0,1.0,8.0,1.0,4.0,4.0,3.0,4.0,4.0,4.0,6.0,4.0,5.0,6.0,1.0,4.0,1.0,8.0,9.0,3.0,1.0,5.0,1.0,4.0,3.0,2.0,0.0,2.0,1.0,1.0,3.0,1.0,2.0,4.0,0.0,0.0,6.0,1.0,1.0,2.0,0.0,1.0,0.0,1.0,6.0,1.0,3.0,3.0,5.0,6.0,3.0,7.0,2.0,4.0,2.0,4.0,7.0,9.0,5.0,11.0,12.0,14.0,22.0,12.0,4.0,15.0,11.0,15.0,20.0,22.0,27.0,23.0,27.0,35.0,26.0,29.0,32.0,29.0,30.0,25.0,28.0,22.0,28.0,33.0,36.0,45.0,37.0,34.0,42.0,50.0,26.0,38.0,39.0,45.0,33.0,42.0,47.0,39.0,47.0,30.0,46.0,38.0,44.0,31.0,36.0,36.0,26.0,31.0,44.0,32.0,36.0,49.0,36.0,38.0,26.0,40.0,23.0,36.0,27.0,42.0,36.0,29.0,23.0,18.0,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,24.0,39.0,26.0,27.0,38.0,29.0,28.0,22.0,30.0,33.0,31.0,33.0,38.0,21.0,29.0,30.0,24.0,38.0,37.0,39.0,25.0,46.0,48.0,30.0,37.0,24.0,29.0,39.0,43.0,42.0,34.0,38.0,33.0,44.0,46.0,40.0,35.0,30.0,24.0,46.0,38.0,40.0,38.0,36.0,31.0,24.0,37.0,31.0,14.0,50.0,?,14.0,24.0,23.0,42.0,30.0,36.0,41.0,28.0,31.0,23.0,33.0,27.0,28.0,34.0,37.0,18.0,36.0,20.0,17.0,35.0,41.0,25.0,14.0,26.0,37.0,24.0,34.0,16.0,19.0,18.0,27.0,18.0,22.0,24.0,23.0,14.0,29.0,20.0,13.0,10.0,10.0,13.0,26.0,18.0,27.0,16.0,29.0,27.0,16.0,27.0,16.0,18.0,10.0,21.0,17.0,12.0,17.0,16.0,20.0,19.0,8.0,17.0,13.0,17.0,16.0,15.0,20.0,12.0,7.0,15.0,11.0,12.0,6.0,19.0,9.0,13.0,8.0,9.0,7.0,8.0,6.0,8.0,7.0:1
7.0,9.0,10.0,6.0,6.0,4.0,5.0,9.0,5.0,5.0,4.0,4.0,2.0,7.0,4.0,5.0,2.0,4.0,3.0,4.0,4.0,4.0,2.0,7.0,3.0,3.0,2.0,1.0,2.0,3.0,4.0,0.0,2.0,2.0,4.0,4.0,0.0,0.0,1.0,4.0,1.0,4.0,5.0,1.0,3.0,2.0,3.0,4.0,2.0,0.0,0.0,2.0,2.0,2.0,1.0,1.0,6.0,6.0,3.0,6.0,5.0,3.0,8.0,9.0,7.0,4.0,18.0,8.0,12.0,12.0,10.0,23.0,20.0,13.0,20.0,14.0,6.0,22.0,29.0,39.0,20.0,33.0,28.0,29.0,24.0,42.0,24.0,33.0,41.0,38.0,39.0,36.0,46.0,34.0,47.0,36.0,38.0,42.0,40.0,35.0,35.0,36.0,29.0,27.0,43.0,29.0,41.0,36.0,32.0,30.0,33.0,37.0,40.0,20.0,33.0,21.0,36.0,29.0,21.0,31.0,29.0,30.0,35.0,29.0,18.0,20.0,28.0,23.0,21.0,23.0,16.0,27.0,18.0,13.0,16.0,24.0,12.0,20.0,25.0,28.0,35.0,26.0,27.0,26.0,39.0,27.0,25.0,25.0,25.0,44.0,24.0,19.0,26.0,24.0,27.0,33.0,29.0,39.0,40.0,21.0,38.0,33.0,33.0,36.0,28.0,29.0,30.0,35.0,30.0,17.0,28.0,25.0,34.0,33.0,41.0,33.0,38.0,37.0,31.0,30.0,29.0,31.0,45.0,46.0,32.0,36.0,35.0,40.0,43.0,44.0,38.0,43.0,42.0,31.0,38.0,26.0,33.0,15.0,23.0,21.0,41.0,34.0,35.0,23.0,22.0,34.0,21.0,33.0,27.0,25.0,24.0,20.0,25.0,24.0,35.0,31.0,34.0,26.0,34.0,36.0,42.0,31.0,38.0,34.0,32.0,40.0,27.0,22.0,26.0,19.0,27.0,27.0,16.0,27.0,21.0,18.0,19.0,18.0,28.0,29.0,16.0,19.0,24.0,23.0,21.0,19.0,17.0,18.0,26.0,15.0,18.0,16.0,22.0,23.0,23.0,22.0,15.0,21.0,13.0,18.0,27.0,19.0,21.0,18.0,21.0,21.0,17.0,15.0,18.0,17.0,20.0,15.0,13.0,23.0,19.0,13.0,3.0,8.0,19.0,9.0,13.0,7.0,15.0,5.0,9.0,13.0,19.0,11.0:1
12.0,14.0,9.0,6.0,15.0,6.0,10.0,7.0,8.0,8.0,7.0,12.0,2.0,8.0,4.0,6.0,6.0,3.0,4.0,9.0,4.0,12.0,9.0,4.0,4.0,4.0,7.0,1.0,9.0,3.0,8.0,3.0,2.0,3.0,1.0,3.0,1.0,0.0,1.0,0.0,2.0,3.0,1.0,4.0,4.0,0.0,4.0,1.0,2.0,2.0,3.0,5.0,1.0,1.0,1.0,6.0,4.0,6.0,7.0,4.0,5.0,6.0,6.0,6.0,7.0,6.0,20.0,9.0,14.0,16.0,8.0,12.0,11.0,17.0,17.0,16.0,19.0,14.0,23.0,24.0,29.0,30.0,31.0,34.0,24.0,39.0,42.0,38.0,40.0,41.0,39.0,45.0,40.0,47.0,51.0,51.0,44.0,44.0,38.0,48.0,35.0,40.0,41.0,39.0,40.0,48.0,32.0,53.0,39.0,48.0,24.0,31.0,20.0,44.0,32.0,38.0,29.0,37.0,45.0,27.0,40.0,41.0,30.0,33.0,32.0,36.0,31.0,37.0,33.0,26.0,39.0,26.0,35.0,24.0,28.0,25.0,28.0,21.0,25.0,24.0,39.0,28.0,17.0,26.0,30.0,24.0,32.0,29.0,28.0,37.0,31.0,31.0,28.0,41.0,29.0,26.0,22.0,26.0,24.0,29.0,37.0,29.0,30.0,28.0,23.0,35.0,32.0,30.0,35.0,31.0,30.0,30.0,37.0,34.0,40.0,24.0,38.0,36.0,37.0,36.0,36.0,30.0,48.0,52.0,47.0,28.0,48.0,39.0,50.0,35.0,47.0,47.0,44.0,43.0,44.0,40.0,38.0,32.0,44.0,36.0,42.0,39.0,36.0,41.0,42.0,30.0,37.0,44.0,40.0,30.0,34.0,28.0,33.0,47.0,35.0,44.0,30.0,41.0,43.0,26.0,37.0,35.0,32.0,43.0,38.0,41.0,44.0,33.0,36.0,33.0,44.0,29.0,26.0,33.0,18.0,27.0,33.0,37.0,34.0,32.0,36.0,23.0,26.0,26.0,22.0,20.0,23.0,22.0,23.0,18.0,24.0,15.0,22.0,26.0,21.0,21.0,13.0,33.0,23.0,24.0,19.0,18.0,12.0,24.0,20.0,21.0,19.0,19.0,17.0,11.0,19.0,21.0,14.0,14.0,15.0,21.0,22.0,21.0,15.0,15.0,16.0,16.0,14.0,10.0,17.0,10.0,8.0,11.0:1
4.0,7.0,6.0,3.0,3.0,3.0,4.0,8.0,6.0,2.0,5.0,2.0,5.0,4.0,5.0,5.0,4.0,3.0,1.0,5.0,5.0,2.0,5.0,4.0,4.0,4.0,3.0,1.0,2.0,6.0,2.0,3.0,5.0,2.0,3.0,2.0,2.0,1.0,1.0,4.0,2.0,4.0,4.0,4.0,3.0,3.0,1.0,4.0,1.0,0.0,2.0,6.0,2.0,4.0,2.0,6.0,4.0,3.0,6.0,0.0,3.0,8.0,4.0,5.0,5.0,9.0,8.0,5.0,14.0,13.0,13.0,13.0,13.0,21.0,19.0,22.0,19.0,20.0,19.0,27.0,23.0,25.0,24.0,26.0,35.0,30.0,34.0,37.0,36.0,43.0,36.0,33.0,40.0,43.0,40.0,36.0,39.0,26.0,37.0,42.0,37.0,46.0,40.0,44.0,39.0,32.0,43.0,42.0,53.0,33.0,46.0,42.0,29.0,39.0,33.0,47.0,37.0,39.0,29.0,36.0,17.0,34.0,31.0,33.0,25.0,24.0,14.0,31.0,33.0,28.0,19.0,23.0,26.0,28.0,22.0,30.0,21.0,30.0,10.0,0.0,0.0,1.0,55.0,49.0,38.0,41.0,45.0,41.0,39.0,37.0,43.0,27.0,34.0,39.0,41.0,29.0,36.0,33.0,34.0,30.0,29.0,24.0,20.0,30.0,19.0,39.0,38.0,21.0,27.0,27.0,34.0,32.0,36.0,34.0,28.0,39.0,45.0,42.0,34.0,33.0,40.0,30.0,36.0,42.0,34.0,43.0,35.0,41.0,28.0,30.0,38.0,46.0,27.0,35.0,27.0,27.0,32.0,21.0,35.0,21.0,24.0,42.0,33.0,36.0,33.0,31.0,21.0,26.0,38.0,30.0,35.0,34.0,28.0,40.0,33.0,28.0,36.0,37.0,31.0,38.0,30.0,31.0,32.0,32.0,26.0,21.0,18.0,26.0,30.0,31.0,23.0,26.0,25.0,32.0,30.0,26.0,23.0,30.0,32.0,26.0,21.0,17.0,22.0,19.0,21.0,21.0,24.0,19.0,10.0,18.0,16.0,22.0,27.0,27.0,12.0,23.0,18.0,21.0,30.0,28.0,23.0,17.0,29.0,18.0,21.0,22.0,22.0,21.0,19.0,23.0,18.0,14.0,28.0,16.0,12.0,6.0,13.0,14.0,17.0,13.0,9.0,14.0,11.0,13.0,11.0,10.0,10.0,13.0:1
6.0,7.0,3.0,5.0,8.0,2.0,5.0,2.0,9.0,3.0,6.0,2.0,2.0,4.0,2.0,2.0,2.0,3.0,2.0,3.0,5.0,0.0,4.0,1.0,4.0,3.0,3.0,1.0,3.0,2.0,1.0,2.0,0.0,3.0,1.0,0.0,0.0,1.0,2.0,1.0,3.0,1.0,3.0,3.0,2.0,2.0,1.0,0.0,2.0,1.0,1.0,1.0,0.0,3.0,1.0,3.0,0.0,4.0,5.0,3.0,3.0,9.0,5.0,10.0,7.0,13.0,11.0,14.0,12.0,5.0,18.0,10.0,20.0,12.0,23.0,19.0,17.0,24.0,19.0,23.0,28.0,21.0,28.0,24.0,32.0,37.0,39.0,41.0,34.0,25.0,40.0,39.0,43.0,45.0,34.0,34.0,37.0,32.0,39.0,36.0,45.0,34.0,41.0,53.0,48.0,40.0,39.0,38.0,43.0,47.0,41.0,34.0,28.0,21.0,31.0,32.0,20.0,20.0,20.0,40.0,33.0,27.0,32.0,34.0,42.0,34.0,28.0,27.0,36.0,32.0,36.0,23.0,28.0,23.0,23.0,34.0,28.0,36.0,31.0,37.0,21.0,29.0,21.0,19.0,40.0,31.0,28.0,25.0,16.0,24.0,21.0,32.0,31.0,30.0,11.0,22.0,18.0,24.0,22.0,27.0,22.0,21.0,21.0,21.0,25.0,29.0,32.0,39.0,30.0,32.0,33.0,25.0,28.0,32.0,28.0,31.0,29.0,32.0,30.0,36.0,26.0,29.0,23.0,31.0,38.0,38.0,37.0,35.0,42.0,40.0,38.0,25.0,29.0,32.0,34.0,43.0,32.0,27.0,29.0,19.0,32.0,35.0,36.0,28.0,31.0,38.0,20.0,30.0,33.0,29.0,25.0,38.0,32.0,31.0,40.0,36.0,25.0,28.0,30.0,35.0,35.0,33.0,33.0,22.0,36.0,26.0,17.0,19.0,23.0,19.0,33.0,25.0,23.0,24.0,17.0,28.0,21.0,24.0,19.0,19.0,12.0,25.0,8.0,15.0,14.0,10.0,12.0,17.0,21.0,20.0,19.0,20.0,18.0,21.0,27.0,19.0,21.0,21.0,26.0,17.0,38.0,23.0,22.0,13.0,14.0,23.0,10.0,12.0,10.0,9.0,9.0,12.0,15.0,12.0,14.0,5.0,5.0,15.0,13.0,9.0,9.0,3.0,10.0,6.0,8.0,7.0,7.0,10.0:1
10.0,14.0,16.0,6.0,10.0,16.0,15.0,12.0,3.0,10.0,6.0,5.0,4.0,5.0,8.0,7.0,6.0,4.0,6.0,9.0,2.0,7.0,7.0,7.0,5.0,6.0,12.0,5.0,11.0,6.0,5.0,9.0,12.0,3.0,5.0,9.0,3.0,4.0,2.0,2.0,6.0,2.0,2.0,3.0,2.0,4.0,3.0,4.0,2.0,3.0,3.0,3.0,0.0,1.0,3.0,5.0,5.0,2.0,5.0,3.0,1.0,1.0,2.0,5.0,0.0,2.0,3.0,6.0,2.0,2.0,6.0,8.0,5.0,7.0,8.0,8.0,9.0,8.0,11.0,7.0,8.0,12.0,17.0,11.0,12.0,15.0,10.0,5.0,9.0,8.0,17.0,17.0,11.0,15.0,14.0,14.0,11.0,17.0,18.0,19.0,11.0,16.0,18.0,18.0,17.0,22.0,13.0,9.0,14.0,14.0,11.0,13.0,14.0,24.0,18.0,11.0,21.0,22.0,14.0,16.0,11.0,20.0,23.0,19.0,21.0,7.0,24.0,27.0,19.0,16.0,17.0,14.0,17.0,18.0,16.0,16.0,17.0,13.0,19.0,20.0,16.0,22.0,31.0,18.0,21.0,27.0,21.0,19.0,22.0,22.0,26.0,24.0,17.0,22.0,14.0,29.0,24.0,24.0,28.0,23.0,28.0,21.0,26.0,27.0,23.0,30.0,24.0,29.0,21.0,26.0,16.0,24.0,24.0,28.0,27.0,25.0,35.0,23.0,24.0,28.0,24.0,19.0,18.0,22.0,30.0,22.0,22.0,23.0,28.0,31.0,32.0,33.0,33.0,26.0,16.0,30.0,19.0,23.0,31.0,18.0,26.0,19.0,27.0,30.0,24.0,26.0,26.0,37.0,28.0,26.0,27.0,21.0,31.0,34.0,27.0,18.0,25.0,40.0,19.0,18.0,26.0,27.0,24.0,31.0,37.0,22.0,17.0,23.0,25.0,14.0,21.0,29.0,20.0,31.0,24.0,17.0,27.0,23.0,34.0,24.0,22.0,27.0,18.0,24.0,20.0,15.0,19.0,11.0,12.0,20.0,19.0,24.0,12.0,12.0,14.0,19.0,21.0,15.0,16.0,33.0,31.0,24.0,11.0,32.0,23.0,20.0,18.0,35.0,16.0,27.0,30.0,25.0,16.0,22.0,21.0,17.0,17.0,18.0,20.0,18.0,15.0,12.0,16.0,16.0,18.0,9.0,14.0,23.0:1
5.0,4.0,7.0,8.0,5.0,7.0,0.0,7.0,4.0,8.0,0.0,8.0,2.0,3.0,1.0,6.0,3.0,1.0,2.0,4.0,8.0,4.0,4.0,1.0,3.0,6.0,3.0,5.0,3.0,3.0,2.0,0.0,2.0,0.0,3.0,1.0,3.0,0.0,4.0,1.0,0.0,0.0,1.0,2.0,6.0,2.0,0.0,1.0,2.0,1.0,1.0,3.0,6.0,0.0,2.0,2.0,5.0,11.0,9.0,5.0,5.0,8.0,9.0,6.0,10.0,10.0,11.0,7.0,11.0,16.0,10.0,13.0,5.0,13.0,11.0,17.0,16.0,22.0,14.0,30.0,26.0,31.0,26.0,32.0,29.0,48.0,47.0,39.0,41.0,32.0,40.0,36.0,34.0,34.0,25.0,37.0,28.0,39.0,36.0,49.0,33.0,42.0,23.0,32.0,43.0,49.0,40.0,44.0,37.0,29.0,30.0,24.0,36.0,27.0,41.0,34.0,22.0,29.0,49.0,25.0,38.0,44.0,38.0,31.0,33.0,32.0,28.0,26.0,31.0,37.0,25.0,29.0,27.0,19.0,29.0,25.0,31.0,34.0,39.0,37.0,29.0,25.0,28.0,25.0,23.0,29.0,26.0,26.0,33.0,43.0,19.0,27.0,23.0,35.0,40.0,35.0,31.0,29.0,33.0,32.0,28.0,34.0,31.0,27.0,40.0,28.0,38.0,38.0,39.0,33.0,39.0,28.0,43.0,31.0,42.0,44.0,41.0,40.0,37.0,36.0,43.0,39.0,48.0,47.0,47.0,32.0,34.0,32.0,46.0,46.0,35.0,39.0,33.0,37.0,31.0,44.0,32.0,42.0,40.0,41.0,41.0,39.0,43.0,29.0,34.0,28.0,28.0,46.0,33.0,36.0,42.0,42.0,33.0,36.0,40.0,36.0,40.0,38.0,32.0,30.0,32.0,36.0,33.0,27.0,33.0,27.0,45.0,30.0,20.0,21.0,40.0,36.0,27.0,33.0,31.0,42.0,37.0,34.0,26.0,27.0,32.0,30.0,17.0,20.0,22.0,17.0,13.0,11.0,11.0,10.0,13.0,16.0,22.0,20.0,27.0,13.0,14.0,24.0,28.0,23.0,21.0,25.0,14.0,15.0,12.0,15.0,13.0,15.0,17.0,17.0,12.0,10.0,11.0,13.0,12.0,13.0,11.0,6.0,19.0,10.0,16.0,9.0,6.0,9.0,14.0,12.0,5.0,4.0:1
8.0,7.0,12.0,6.0,7.0,9.0,9.0,11.0,10.0,6.0,7.0,7.0,10.0,7.0,6.0,3.0,8.0,3.0,2.0,3.0,3.0,8.0,7.0,5.0,8.0,8.0,6.0,6.0,9.0,3.0,4.0,9.0,2.0,3.0,3.0,0.0,5.0,4.0,2.0,4.0,6.0,1.0,5.0,5.0,3.0,1.0,1.0,7.0,5.0,3.0,2.0,4.0,1.0,2.0,2.0,0.0,7.0,1.0,3.0,1.0,3.0,0.0,2.0,8.0,4.0,2.0,6.0,3.0,4.0,1.0,5.0,4.0,8.0,8.0,6.0,10.0,10.0,7.0,12.0,12.0,11.0,12.0,13.0,14.0,7.0,8.0,16.0,9.0,14.0,20.0,17.0,20.0,21.0,26.0,11.0,15.0,22.0,10.0,15.0,17.0,23.0,17.0,16.0,10.0,17.0,26.0,19.0,14.0,24.0,25.0,19.0,15.0,26.0,25.0,21.0,19.0,22.0,25.0,12.0,25.0,25.0,34.0,18.0,23.0,17.0,27.0,23.0,16.0,23.0,25.0,28.0,30.0,32.0,13.0,20.0,28.0,29.0,20.0,21.0,29.0,21.0,30.0,20.0,32.0,35.0,33.0,32.0,30.0,29.0,25.0,31.0,29.0,36.0,27.0,24.0,34.0,19.0,30.0,35.0,30.0,30.0,42.0,33.0,35.0,38.0,39.0,29.0,36.0,33.0,37.0,34.0,27.0,38.0,35.0,22.0,44.0,37.0,31.0,26.0,13.0,21.0,26.0,25.0,13.0,28.0,28.0,33.0,21.0,26.0,32.0,26.0,25.0,28.0,23.0,29.0,26.0,28.0,29.0,37.0,30.0,28.0,16.0,24.0,29.0,33.0,24.0,29.0,22.0,16.0,23.0,21.0,21.0,18.0,15.0,13.0,31.0,26.0,37.0,28.0,30.0,24.0,21.0,27.0,16.0,26.0,30.0,15.0,35.0,17.0,30.0,25.0,26.0,23.0,20.0,27.0,29.0,22.0,27.0,31.0,19.0,22.0,18.0,14.0,18.0,15.0,17.0,11.0,22.0,13.0,19.0,17.0,17.0,18.0,26.0,24.0,21.0,16.0,24.0,22.0,15.0,13.0,23.0,17.0,31.0,25.0,27.0,32.0,29.0,28.0,32.0,33.0,24.0,23.0,21.0,21.0,26.0,20.0,15.0,13.0,20.0,14.0,12.0,10.0,10.0,9.0,8.0,18.0,18.0:1
10.0,9.0,6.0,4.0,6.0,12.0,8.0,6.0,6.0,3.0,4.0,5.0,6.0,3.0,3.0,3.0,3.0,4.0,6.0,1.0,3.0,3.0,4.0,4.0,5.0,2.0,1.0,1.0,4.0,1.0,0.0,1.0,4.0,1.0,0.0,3.0,4.0,0.0,4.0,1.0,2.0,2.0,1.0,6.0,3.0,1.0,1.0,1.0,3.0,2.0,1.0,0.0,5.0,1.0,1.0,0.0,6.0,3.0,2.0,5.0,2.0,5.0,3.0,4.0,5.0,5.0,12.0,9.0,14.0,7.0,9.0,7.0,15.0,11.0,24.0,13.0,23.0,23.0,19.0,23.0,29.0,20.0,32.0,33.0,29.0,25.0,34.0,30.0,34.0,33.0,36.0,31.0,34.0,30.0,35.0,27.0,28.0,31.0,27.0,39.0,42.0,40.0,28.0,30.0,40.0,41.0,39.0,31.0,38.0,39.0,33.0,37.0,29.0,33.0,42.0,29.0,30.0,40.0,34.0,26.0,31.0,29.0,25.0,39.0,26.0,29.0,24.0,34.0,24.0,15.0,27.0,23.0,26.0,29.0,33.0,34.0,25.0,22.0,29.0,28.0,32.0,18.0,30.0,23.0,34.0,22.0,32.0,35.0,28.0,39.0,29.0,38.0,22.0,24.0,30.0,21.0,31.0,22.0,35.0,29.0,26.0,22.0,27.0,28.0,27.0,15.0,33.0,26.0,28.0,24.0,27.0,24.0,37.0,45.0,41.0,23.0,35.0,33.0,36.0,32.0,32.0,29.0,35.0,43.0,40.0,39.0,44.0,47.0,43.0,40.0,45.0,44.0,45.0,42.0,32.0,35.0,41.0,28.0,30.0,31.0,27.0,40.0,16.0,28.0,29.0,36.0,24.0,35.0,41.0,24.0,27.0,38.0,30.0,40.0,41.0,43.0,37.0,18.0,33.0,22.0,30.0,24.0,38.0,28.0,36.0,31.0,23.0,24.0,30.0,34.0,24.0,30.0,25.0,23.0,29.0,27.0,30.0,30.0,42.0,32.0,29.0,34.0,20.0,15.0,22.0,21.0,16.0,22.0,20.0,14.0,12.0,16.0,17.0,15.0,11.0,17.0,14.0,21.0,21.0,18.0,25.0,11.0,19.0,22.0,25.0,24.0,8.0,21.0,16.0,30.0,30.0,22.0,25.0,20.0,23.0,23.0,20.0,21.0,13.0,13.0,22.0,14.0,11.0,19.0,16.0,9.0,13.0,7.0:1
3.0,8.0,7.0,8.0,13.0,10.0,8.0,6.0,9.0,11.0,7.0,7.0,8.0,5.0,7.0,3.0,4.0,2.0,7.0,3.0,3.0,3.0,3.0,2.0,3.0,5.0,6.0,2.0,5.0,2.0,5.0,4.0,1.0,2.0,0.0,2.0,2.0,0.0,1.0,0.0,1.0,1.0,3.0,4.0,2.0,1.0,2.0,0.0,1.0,4.0,3.0,6.0,3.0,1.0,3.0,2.0,2.0,5.0,2.0,6.0,4.0,5.0,5.0,8.0,6.0,9.0,14.0,14.0,13.0,13.0,15.0,7.0,12.0,19.0,16.0,17.0,18.0,26.0,17.0,32.0,23.0,30.0,27.0,29.0,31.0,37.0,41.0,33.0,33.0,30.0,29.0,35.0,30.0,47.0,41.0,42.0,40.0,33.0,40.0,34.0,47.0,38.0,42.0,31.0,31.0,37.0,40.0,43.0,41.0,26.0,38.0,33.0,39.0,38.0,27.0,36.0,40.0,34.0,34.0,31.0,27.0,30.0,33.0,29.0,29.0,29.0,21.0,43.0,20.0,34.0,27.0,30.0,26.0,29.0,32.0,31.0,24.0,46.0,46.0,40.0,21.0,28.0,30.0,30.0,34.0,32.0,22.0,24.0,32.0,28.0,32.0,36.0,33.0,34.0,38.0,27.0,30.0,28.0,26.0,36.0,27.0,35.0,15.0,21.0,38.0,21.0,39.0,26.0,23.0,35.0,30.0,40.0,39.0,42.0,43.0,34.0,28.0,43.0,47.0,47.0,46.0,35.0,33.0,52.0,34.0,29.0,40.0,28.0,36.0,41.0,40.0,40.0,31.0,32.0,32.0,35.0,41.0,30.0,49.0,32.0,39.0,31.0,30.0,31.0,40.0,40.0,33.0,25.0,43.0,36.0,34.0,38.0,37.0,37.0,39.0,24.0,37.0,45.0,40.0,35.0,30.0,46.0,38.0,44.0,42.0,32.0,20.0,31.0,35.0,26.0,31.0,23.0,24.0,32.0,25.0,33.0,37.0,31.0,47.0,34.0,35.0,23.0,34.0,34.0,20.0,27.0,29.0,28.0,27.0,19.0,25.0,17.0,21.0,15.0,19.0,28.0,26.0,24.0,16.0,22.0,20.0,31.0,24.0,19.0,27.0,18.0,29.0,21.0,25.0,30.0,18.0,23.0,23.0,22.0,16.0,22.0,18.0,14.0,21.0,13.0,14.0,10.0,8.0,6.0,8.0,7.0,8.0,9.0:1
4.0,12.0,8.0,8.0,7.0,8.0,8.0,4.0,5.0,3.0,2.0,5.0,3.0,7.0,2.0,3.0,3.0,8.0,2.0,9.0,1.0,4.0,6.0,0.0,2.0,3.0,1.0,2.0,3.0,4.0,1.0,4.0,1.0,4.0,3.0,2.0,6.0,1.0,0.0,3.0,1.0,2.0,2.0,1.0,2.0,3.0,1.0,5.0,1.0,0.0,1.0,2.0,4.0,1.0,3.0,4.0,3.0,6.0,10.0,4.0,2.0,9.0,9.0,6.0,7.0,8.0,2.0,8.0,7.0,15.0,5.0,10.0,8.0,11.0,12.0,13.0,23.0,13.0,23.0,24.0,22.0,17.0,27.0,25.0,33.0,28.0,30.0,32.0,39.0,30.0,30.0,32.0,31.0,40.0,37.0,31.0,28.0,32.0,38.0,32.0,23.0,35.0,38.0,38.0,44.0,29.0,34.0,32.0,23.0,21.0,39.0,26.0,29.0,31.0,29.0,32.0,27.0,37.0,39.0,32.0,26.0,20.0,21.0,34.0,13.0,28.0,31.0,22.0,19.0,37.0,35.0,28.0,22.0,15.0,33.0,24.0,26.0,35.0,26.0,29.0,23.0,30.0,23.0,21.0,22.0,17.0,34.0,33.0,30.0,31.0,22.0,26.0,28.0,33.0,27.0,32.0,33.0,23.0,33.0,28.0,28.0,24.0,27.0,26.0,34.0,29.0,29.0,18.0,31.0,30.0,34.0,28.0,21.0,39.0,37.0,34.0,49.0,42.0,29.0,24.0,31.0,33.0,49.0,39.0,35.0,29.0,41.0,21.0,24.0,23.0,35.0,33.0,25.0,34.0,29.0,34.0,39.0,31.0,28.0,26.0,28.0,30.0,30.0,20.0,21.0,34.0,30.0,34.0,27.0,28.0,32.0,28.0,38.0,34.0,27.0,20.0,23.0,34.0,41.0,31.0,27.0,22.0,17.0,27.0,42.0,25.0,24.0,18.0,26.0,32.0,35.0,23.0,29.0,30.0,25.0,28.0,19.0,27.0,22.0,29.0,13.0,22.0,19.0,14.0,12.0,20.0,29.0,18.0,18.0,15.0,10.0,15.0,14.0,31.0,28.0,18.0,22.0,16.0,19.0,10.0,16.0,6.0,24.0,22.0,12.0,13.0,13.0,10.0,12.0,12.0,8.0,14.0,11.0,8.0,11.0,12.0,12.0,8.0,11.0,7.0,11.0,4.0,12.0,12.0,6.0,4.0,4.0,9.0:1
4.0,3.0,6.0,3.0,3.0,3.0,6.0,6.0,3.0,5.0,6.0,4.0,7.0,4.0,6.0,4.0,0.0,3.0,1.0,3.0,10.0,5.0,4.0,1.0,2.0,2.0,8.0,2.0,3.0,3.0,2.0,3.0,2.0,2.0,3.0,2.0,2.0,3.0,2.0,1.0,2.0,2.0,3.0,2.0,2.0,0.0,0.0,3.0,3.0,0.0,0.0,0.0,4.0,1.0,3.0,8.0,3.0,5.0,4.0,4.0,7.0,4.0,7.0,10.0,12.0,11.0,10.0,15.0,10.0,10.0,15.0,11.0,13.0,15.0,14.0,11.0,15.0,22.0,13.0,20.0,19.0,23.0,21.0,24.0,34.0,37.0,39.0,28.0,44.0,48.0,47.0,20.0,32.0,31.0,26.0,31.0,40.0,46.0,30.0,35.0,35.0,34.0,26.0,18.0,40.0,33.0,20.0,37.0,43.0,29.0,25.0,17.0,18.0,36.0,24.0,29.0,25.0,38.0,38.0,32.0,35.0,31.0,29.0,27.0,21.0,24.0,30.0,19.0,38.0,32.0,36.0,29.0,19.0,27.0,18.0,25.0,32.0,35.0,37.0,34.0,32.0,22.0,19.0,30.0,26.0,19.0,25.0,21.0,33.0,27.0,27.0,27.0,24.0,34.0,25.0,31.0,27.0,29.0,36.0,33.0,33.0,27.0,22.0,25.0,28.0,25.0,25.0,21.0,36.0,26.0,31.0,31.0,34.0,39.0,47.0,42.0,44.0,36.0,29.0,24.0,33.0,37.0,38.0,39.0,32.0,35.0,44.0,28.0,41.0,32.0,41.0,37.0,28.0,18.0,32.0,34.0,25.0,29.0,29.0,32.0,44.0,48.0,25.0,43.0,34.0,30.0,33.0,27.0,40.0,37.0,30.0,28.0,36.0,26.0,37.0,33.0,26.0,37.0,39.0,28.0,28.0,35.0,38.0,35.0,30.0,32.0,32.0,24.0,24.0,33.0,22.0,36.0,24.0,35.0,27.0,18.0,11.0,19.0,31.0,20.0,28.0,21.0,14.0,21.0,17.0,19.0,22.0,16.0,16.0,13.0,17.0,17.0,12.0,23.0,18.0,18.0,19.0,19.0,17.0,12.0,15.0,10.0,12.0,11.0,8.0,17.0,7.0,15.0,19.0,11.0,11.0,9.0,10.0,4.0,4.0,8.0,9.0,14.0,12.0,10.0,10.0,5.0,17.0,3.0,4.0,9.0,9.0,10.0:1
6.0,8.0,4.0,7.0,3.0,2.0,5.0,1.0,2.0,4.0,6.0,5.0,3.0,9.0,2.0,3.0,8.0,3.0,4.0,7.0,2.0,2.0,3.0,3.0,2.0,3.0,3.0,4.0,1.0,3.0,2.0,1.0,2.0,3.0,3.0,1.0,1.0,3.0,2.0,4.0,0.0,4.0,0.0,1.0,3.0,2.0,2.0,2.0,0.0,2.0,2.0,1.0,0.0,2.0,1.0,3.0,6.0,4.0,5.0,8.0,3.0,5.0,7.0,3.0,9.0,5.0,10.0,12.0,13.0,10.0,14.0,9.0,12.0,20.0,10.0,21.0,14.0,19.0,20.0,21.0,29.0,24.0,13.0,30.0,24.0,35.0,37.0,35.0,34.0,42.0,31.0,34.0,47.0,40.0,29.0,33.0,30.0,27.0,42.0,44.0,38.0,47.0,42.0,41.0,37.0,36.0,32.0,44.0,27.0,23.0,31.0,28.0,30.0,39.0,34.0,40.0,29.0,34.0,33.0,35.0,20.0,35.0,24.0,24.0,35.0,24.0,34.0,37.0,31.0,42.0,19.0,27.0,22.0,30.0,35.0,25.0,28.0,25.0,37.0,41.0,36.0,28.0,22.0,34.0,28.0,23.0,21.0,20.0,21.0,23.0,14.0,26.0,36.0,19.0,33.0,22.0,12.0,23.0,35.0,23.0,24.0,32.0,31.0,19.0,19.0,23.0,28.0,23.0,14.0,25.0,24.0,26.0,26.0,31.0,23.0,28.0,35.0,21.0,21.0,33.0,44.0,39.0,35.0,37.0,24.0,32.0,41.0,43.0,32.0,30.0,36.0,23.0,35.0,38.0,24.0,30.0,26.0,42.0,27.0,29.0,41.0,37.0,30.0,23.0,24.0,31.0,23.0,34.0,27.0,28.0,28.0,32.0,40.0,30.0,38.0,37.0,34.0,38.0,33.0,32.0,23.0,29.0,34.0,34.0,35.0,25.0,25.0,26.0,24.0,24.0,20.0,26.0,25.0,19.0,22.0,32.0,30.0,28.0,24.0,26.0,37.0,13.0,33.0,19.0,20.0,19.0,12.0,14.0,13.0,18.0,19.0,13.0,21.0,20.0,26.0,14.0,14.0,30.0,29.0,29.0,20.0,25.0,17.0,27.0,17.0,16.0,14.0,7.0,19.0,13.0,15.0,12.0,13.0,14.0,15.0,14.0,16.0,13.0,6.0,16.0,11.0,15.0,11.0,12.0,12.0,11.0,5.0,5.0:1
11.0,9.0,9.0,12.0,11.0,7.0,4.0,7.0,12.0,1.0,4.0,6.0,13.0,6.0,8.0,6.0,5.0,4.0,4.0,9.0,9.0,6.0,11.0,4.0,6.0,5.0,6.0,3.0,10.0,7.0,8.0,3.0,8.0,4.0,6.0,5.0,3.0,5.0,3.0,4.0,2.0,3.0,4.0,3.0,5.0,2.0,1.0,3.0,5.0,2.0,2.0,3.0,3.0,4.0,2.0,1.0,1.0,0.0,4.0,7.0,1.0,5.0,0.0,0.0,4.0,5.0,4.0,7.0,8.0,7.0,10.0,1.0,5.0,8.0,9.0,7.0,12.0,13.0,9.0,16.0,14.0,16.0,14.0,11.0,15.0,6.0,12.0,17.0,6.0,17.0,12.0,24.0,13.0,17.0,23.0,24.0,19.0,17.0,17.0,14.0,20.0,20.0,17.0,13.0,20.0,19.0,31.0,25.0,22.0,19.0,24.0,23.0,18.0,18.0,32.0,25.0,27.0,35.0,20.0,38.0,21.0,31.0,27.0,26.0,22.0,31.0,32.0,29.0,27.0,30.0,20.0,32.0,17.0,15.0,20.0,21.0,35.0,30.0,28.0,29.0,30.0,25.0,27.0,23.0,32.0,21.0,23.0,29.0,27.0,24.0,27.0,30.0,37.0,26.0,30.0,30.0,29.0,27.0,43.0,29.0,37.0,31.0,28.0,23.0,31.0,31.0,29.0,22.0,21.0,32.0,28.0,28.0,30.0,29.0,40.0,27.0,36.0,30.0,31.0,36.0,30.0,33.0,17.0,28.0,38.0,42.0,20.0,31.0,37.0,22.0,35.0,27.0,29.0,25.0,29.0,31.0,25.0,28.0,31.0,32.0,24.0,33.0,23.0,29.0,23.0,22.0,25.0,29.0,28.0,34.0,23.0,25.0,28.0,27.0,19.0,27.0,23.0,32.0,23.0,23.0,27.0,25.0,26.0,31.0,34.0,36.0,43.0,24.0,35.0,31.0,21.0,35.0,19.0,37.0,39.0,39.0,40.0,33.0,23.0,33.0,26.0,36.0,33.0,15.0,20.0,28.0,22.0,21.0,29.0,19.0,18.0,29.0,22.0,29.0,21.0,38.0,14.0,23.0,26.0,20.0,22.0,28.0,25.0,29.0,35.0,34.0,26.0,27.0,33.0,28.0,24.0,26.0,25.0,21.0,16.0,18.0,28.0,20.0,18.0,21.0,18.0,20.0,25.0,13.0,19.0,15.0,14.0,8.0:1
6.0,2.0,3.0,6.0,6.0,11.0,15.0,13.0,12.0,7.0,11.0,10.0,11.0,6.0,9.0,7.0,2.0,11.0,4.0,7.0,3.0,10.0,9.0,12.0,7.0,9.0,15.0,9.0,9.0,11.0,7.0,1.0,8.0,3.0,5.0,5.0,4.0,7.0,7.0,6.0,3.0,3.0,8.0,7.0,3.0,4.0,4.0,0.0,7.0,2.0,0.0,2.0,4.0,9.0,4.0,9.0,6.0,6.0,9.0,8.0,4.0,4.0,6.0,5.0,10.0,7.0,10.0,10.0,9.0,12.0,13.0,13.0,15.0,12.0,13.0,12.0,18.0,24.0,15.0,19.0,29.0,17.0,26.0,18.0,39.0,33.0,50.0,34.0,43.0,37.0,37.0,35.0,40.0,57.0,33.0,44.0,39.0,33.0,34.0,45.0,33.0,39.0,27.0,21.0,38.0,37.0,48.0,49.0,41.0,28.0,37.0,33.0,31.0,36.0,35.0,30.0,30.0,41.0,37.0,33.0,23.0,26.0,33.0,21.0,18.0,36.0,22.0,34.0,32.0,23.0,33.0,23.0,21.0,27.0,14.0,21.0,28.0,28.0,22.0,27.0,20.0,24.0,31.0,19.0,26.0,46.0,30.0,26.0,28.0,26.0,22.0,22.0,35.0,22.0,24.0,30.0,15.0,28.0,22.0,27.0,19.0,21.0,26.0,36.0,30.0,26.0,26.0,25.0,30.0,32.0,30.0,22.0,28.0,30.0,27.0,40.0,36.0,27.0,30.0,39.0,29.0,43.0,39.0,33.0,41.0,37.0,39.0,38.0,47.0,32.0,35.0,26.0,23.0,27.0,32.0,48.0,35.0,25.0,38.0,39.0,25.0,36.0,38.0,26.0,25.0,34.0,38.0,50.0,45.0,27.0,39.0,37.0,40.0,40.0,23.0,20.0,26.0,39.0,46.0,37.0,33.0,28.0,41.0,30.0,31.0,33.0,24.0,37.0,24.0,38.0,27.0,30.0,23.0,31.0,26.0,26.0,28.0,29.0,24.0,26.0,26.0,26.0,25.0,23.0,27.0,25.0,21.0,13.0,17.0,25.0,19.0,23.0,16.0,17.0,16.0,18.0,11.0,24.0,22.0,22.0,25.0,11.0,12.0,16.0,10.0,23.0,14.0,14.0,11.0,23.0,15.0,13.0,16.0,19.0,12.0,8.0,12.0,15.0,14.0,13.0,10.0,5.0,8.0,7.0,13.0,4.0,10.0,12.0:1
9.0,4.0,3.0,4.0,9.0,3.0,6.0,9.0,3.0,6.0,4.0,8.0,3.0,6.0,4.0,2.0,3.0,5.0,3.0,3.0,4.0,5.0,6.0,4.0,2.0,5.0,1.0,1.0,6.0,5.0,2.0,0.0,1.0,3.0,2.0,2.0,1.0,1.0,2.0,3.0,2.0,2.0,4.0,1.0,1.0,2.0,1.0,1.0,3.0,0.0,2.0,3.0,3.0,0.0,1.0,2.0,2.0,4.0,9.0,4.0,3.0,10.0,4.0,6.0,10.0,9.0,6.0,12.0,7.0,13.0,15.0,15.0,8.0,13.0,20.0,14.0,20.0,14.0,21.0,26.0,19.0,25.0,21.0,26.0,34.0,42.0,41.0,30.0,41.0,31.0,21.0,39.0,32.0,52.0,36.0,36.0,37.0,38.0,37.0,33.0,33.0,31.0,32.0,39.0,34.0,38.0,39.0,39.0,50.0,42.0,21.0,28.0,31.0,36.0,35.0,42.0,35.0,41.0,38.0,41.0,38.0,31.0,29.0,24.0,32.0,24.0,35.0,37.0,30.0,31.0,29.0,30.0,30.0,23.0,32.0,40.0,32.0,27.0,29.0,33.0,24.0,46.0,35.0,31.0,20.0,34.0,26.0,28.0,26.0,27.0,23.0,32.0,34.0,35.0,42.0,32.0,27.0,36.0,33.0,34.0,36.0,26.0,36.0,37.0,24.0,20.0,38.0,39.0,33.0,35.0,33.0,41.0,35.0,37.0,48.0,34.0,42.0,50.0,33.0,31.0,41.0,40.0,33.0,39.0,34.0,34.0,34.0,40.0,37.0,28.0,38.0,39.0,32.0,32.0,38.0,44.0,37.0,44.0,40.0,31.0,40.0,34.0,30.0,30.0,37.0,48.0,40.0,37.0,33.0,41.0,44.0,35.0,26.0,34.0,31.0,33.0,35.0,34.0,38.0,32.0,39.0,37.0,42.0,31.0,32.0,28.0,26.0,30.0,29.0,21.0,28.0,30.0,39.0,24.0,25.0,32.0,38.0,39.0,22.0,32.0,34.0,37.0,26.0,30.0,37.0,27.0,17.0,21.0,28.0,27.0,26.0,27.0,27.0,20.0,27.0,22.0,23.0,28.0,25.0,20.0,30.0,30.0,34.0,28.0,30.0,22.0,20.0,10.0,58.0,33.0,24.0,29.0,23.0,32.0,26.0,24.0,34.0,24.0,29.0,22.0,25.0,20.0,34.0,51.0,52.0,54.0,49.0,49.0:2
19.0,12.0,8.0,9.0,13.0,3.0,7.0,9.0,13.0,7.0,8.0,8.0,6.0,10.0,2.0,10.0,10.0,6.0,3.0,4.0,8.0,8.0,12.0,4.0,5.0,8.0,9.0,13.0,11.0,8.0,6.0,4.0,8.0,4.0,2.0,5.0,4.0,2.0,2.0,3.0,2.0,3.0,5.0,1.0,0.0,4.0,1.0,1.0,4.0,1.0,1.0,5.0,2.0,3.0,4.0,2.0,3.0,3.0,3.0,1.0,4.0,0.0,2.0,3.0,12.0,1.0,2.0,5.0,6.0,8.0,5.0,7.0,4.0,9.0,7.0,4.0,4.0,11.0,12.0,9.0,15.0,14.0,13.0,8.0,12.0,18.0,23.0,7.0,10.0,16.0,6.0,15.0,16.0,24.0,18.0,17.0,12.0,15.0,21.0,12.0,22.0,16.0,18.0,24.0,30.0,29.0,25.0,21.0,12.0,22.0,18.0,26.0,14.0,26.0,20.0,11.0,22.0,31.0,17.0,31.0,23.0,23.0,28.0,22.0,21.0,31.0,33.0,20.0,28.0,18.0,26.0,27.0,29.0,20.0,21.0,29.0,36.0,33.0,31.0,19.0,30.0,34.0,23.0,18.0,25.0,30.0,23.0,29.0,26.0,29.0,25.0,20.0,23.0,29.0,31.0,26.0,35.0,25.0,21.0,33.0,25.0,42.0,18.0,31.0,32.0,34.0,19.0,21.0,20.0,26.0,25.0,33.0,30.0,32.0,31.0,25.0,25.0,37.0,36.0,17.0,32.0,27.0,36.0,35.0,23.0,32.0,27.0,23.0,35.0,32.0,31.0,26.0,25.0,31.0,39.0,20.0,36.0,23.0,21.0,36.0,35.0,34.0,35.0,25.0,31.0,32.0,38.0,32.0,25.0,29.0,29.0,22.0,21.0,23.0,38.0,28.0,27.0,25.0,28.0,28.0,27.0,34.0,27.0,23.0,25.0,42.0,35.0,36.0,27.0,37.0,31.0,35.0,29.0,30.0,32.0,25.0,36.0,26.0,26.0,35.0,28.0,24.0,17.0,20.0,23.0,13.0,23.0,17.0,25.0,32.0,29.0,15.0,22.0,18.0,15.0,25.0,17.0,31.0,21.0,42.0,36.0,51.0,39.0,38.0,41.0,30.0,22.0,26.0,39.0,49.0,61.0,53.0,46.0,39.0,46.0,38.0,42.0,44.0,42.0,41.0,39.0,34.0,31.0,27.0,19.0,30.0,21.0,20.0:2
9.0,10.0,14.0,8.0,13.0,10.0,6.0,6.0,8.0,8.0,14.0,1.0,2.0,5.0,3.0,3.0,9.0,5.0,3.0,7.0,9.0,8.0,8.0,7.0,4.0,9.0,7.0,6.0,3.0,3.0,3.0,7.0,9.0,3.0,0.0,9.0,7.0,2.0,5.0,7.0,5.0,3.0,3.0,3.0,1.0,3.0,4.0,4.0,5.0,5.0,7.0,6.0,2.0,9.0,2.0,3.0,3.0,4.0,5.0,5.0,4.0,0.0,2.0,5.0,6.0,3.0,4.0,8.0,6.0,5.0,6.0,5.0,4.0,10.0,8.0,6.0,8.0,12.0,10.0,8.0,14.0,13.0,9.0,17.0,9.0,17.0,13.0,11.0,16.0,17.0,16.0,14.0,16.0,13.0,12.0,16.0,10.0,21.0,14.0,14.0,15.0,10.0,17.0,13.0,26.0,20.0,18.0,20.0,13.0,27.0,14.0,19.0,26.0,20.0,26.0,26.0,25.0,29.0,29.0,32.0,33.0,33.0,37.0,28.0,15.0,11.0,25.0,32.0,24.0,24.0,23.0,21.0,33.0,11.0,23.0,23.0,24.0,17.0,30.0,35.0,21.0,36.0,30.0,26.0,34.0,30.0,24.0,25.0,27.0,23.0,19.0,24.0,28.0,34.0,20.0,35.0,19.0,29.0,30.0,31.0,26.0,30.0,26.0,37.0,30.0,20.0,26.0,31.0,24.0,26.0,21.0,17.0,19.0,38.0,23.0,32.0,38.0,32.0,29.0,19.0,30.0,32.0,36.0,28.0,32.0,31.0,31.0,34.0,28.0,24.0,17.0,28.0,26.0,27.0,21.0,17.0,28.0,32.0,24.0,33.0,35.0,34.0,34.0,44.0,37.0,42.0,34.0,33.0,37.0,37.0,25.0,31.0,30.0,24.0,32.0,17.0,25.0,26.0,27.0,21.0,35.0,12.0,25.0,23.0,15.0,26.0,22.0,18.0,19.0,19.0,27.0,21.0,26.0,22.0,24.0,18.0,16.0,26.0,18.0,23.0,27.0,20.0,21.0,18.0,19.0,18.0,27.0,27.0,18.0,29.0,25.0,31.0,22.0,30.0,22.0,37.0,46.0,40.0,48.0,49.0,48.0,50.0,56.0,56.0,39.0,41.0,40.0,36.0,37.0,30.0,35.0,30.0,35.0,26.0,21.0,18.0,13.0,19.0,16.0,13.0,21.0,18.0,23.0,15.0,33.0,22.0,11.0,16.0:2
11.0,10.0,8.0,14.0,8.0,6.0,5.0,7.0,3.0,7.0,11.0,6.0,10.0,3.0,2.0,2.0,6.0,5.0,6.0,6.0,10.0,3.0,3.0,11.0,6.0,1.0,1.0,4.0,7.0,9.0,6.0,9.0,6.0,3.0,2.0,4.0,1.0,2.0,6.0,3.0,5.0,3.0,3.0,5.0,1.0,2.0,3.0,3.0,3.0,1.0,2.0,5.0,1.0,1.0,0.0,1.0,2.0,5.0,6.0,3.0,3.0,8.0,3.0,5.0,3.0,4.0,2.0,3.0,4.0,10.0,6.0,2.0,2.0,5.0,5.0,4.0,14.0,7.0,15.0,12.0,9.0,10.0,11.0,15.0,5.0,12.0,15.0,10.0,13.0,14.0,14.0,17.0,21.0,15.0,23.0,12.0,13.0,18.0,21.0,13.0,13.0,19.0,23.0,20.0,30.0,22.0,21.0,14.0,20.0,19.0,27.0,23.0,21.0,25.0,22.0,28.0,32.0,26.0,34.0,32.0,26.0,25.0,22.0,21.0,18.0,28.0,21.0,24.0,27.0,39.0,27.0,31.0,24.0,27.0,40.0,28.0,24.0,28.0,22.0,35.0,33.0,39.0,26.0,28.0,?,?,17.0,26.0,18.0,34.0,21.0,32.0,25.0,28.0,27.0,29.0,26.0,27.0,25.0,27.0,28.0,35.0,30.0,27.0,37.0,36.0,31.0,21.0,33.0,34.0,33.0,35.0,25.0,28.0,31.0,31.0,41.0,33.0,46.0,32.0,38.0,31.0,33.0,29.0,35.0,25.0,31.0,29.0,27.0,27.0,28.0,26.0,36.0,32.0,27.0,40.0,25.0,38.0,32.0,16.0,28.0,22.0,25.0,25.0,21.0,21.0,33.0,26.0,23.0,25.0,19.0,19.0,27.0,22.0,16.0,25.0,22.0,16.0,22.0,25.0,20.0,26.0,30.0,30.0,21.0,24.0,28.0,26.0,29.0,19.0,31.0,34.0,25.0,35.0,38.0,20.0,28.0,32.0,28.0,27.0,25.0,26.0,25.0,18.0,17.0,23.0,25.0,25.0,17.0,13.0,22.0,16.0,30.0,22.0,26.0,23.0,41.0,36.0,30.0,57.0,33.0,34.0,42.0,55.0,43.0,50.0,43.0,59.0,49.0,50.0,59.0,46.0,48.0,55.0,51.0,51.0,52.0,49.0,30.0,21.0,17.0,19.0,18.0,18.0,12.0,14.0,9.0,13.0:2
9.0,4.0,3.0,7.0,12.0,6.0,9.0,3.0,12.0,7.0,4.0,4.0,5.0,10.0,2.0,9.0,4.0,3.0,7.0,8.0,8.0,3.0,5.0,1.0,9.0,8.0,10.0,6.0,5.0,5.0,3.0,1.0,4.0,2.0,4.0,2.0,7.0,5.0,10.0,3.0,6.0,3.0,2.0,3.0,2.0,3.0,3.0,2.0,5.0,3.0,2.0,1.0,2.0,4.0,3.0,2.0,5.0,5.0,2.0,8.0,2.0,4.0,3.0,5.0,3.0,6.0,1.0,5.0,5.0,5.0,5.0,5.0,6.0,3.0,3.0,12.0,6.0,12.0,15.0,15.0,7.0,11.0,11.0,10.0,12.0,6.0,11.0,13.0,7.0,16.0,9.0,16.0,10.0,15.0,13.0,7.0,20.0,17.0,11.0,14.0,13.0,10.0,16.0,16.0,26.0,19.0,16.0,14.0,17.0,14.0,25.0,23.0,19.0,16.0,28.0,16.0,22.0,22.0,21.0,22.0,27.0,25.0,28.0,25.0,19.0,26.0,17.0,26.0,22.0,11.0,21.0,18.0,24.0,19.0,30.0,20.0,19.0,26.0,27.0,33.0,33.0,17.0,34.0,21.0,19.0,16.0,29.0,24.0,23.0,26.0,28.0,32.0,33.0,20.0,27.0,25.0,14.0,27.0,22.0,35.0,25.0,26.0,33.0,38.0,24.0,28.0,36.0,24.0,26.0,29.0,23.0,36.0,24.0,30.0,34.0,18.0,35.0,20.0,19.0,41.0,33.0,23.0,28.0,29.0,26.0,25.0,27.0,31.0,21.0,17.0,36.0,27.0,24.0,42.0,21.0,25.0,25.0,30.0,33.0,28.0,29.0,30.0,35.0,42.0,39.0,37.0,53.0,34.0,38.0,32.0,30.0,27.0,31.0,22.0,36.0,22.0,17.0,19.0,24.0,8.0,26.0,15.0,26.0,28.0,22.0,18.0,21.0,22.0,28.0,23.0,11.0,21.0,27.0,13.0,20.0,23.0,34.0,24.0,19.0,28.0,26.0,16.0,30.0,14.0,12.0,24.0,19.0,29.0,13.0,22.0,13.0,13.0,14.0,16.0,30.0,10.0,20.0,16.0,19.0,21.0,13.0,24.0,14.0,18.0,12.0,14.0,32.0,20.0,9.0,34.0,31.0,22.0,21.0,17.0,8.0,13.0,27.0,21.0,11.0,15.0,15.0,14.0,15.0,9.0,13.0,14.0,9.0,11.0:2
15.0,8.0,7.0,5.0,9.0,6.0,6.0,6.0,8.0,4.0,5.0,3.0,6.0,14.0,4.0,7.0,2.0,3.0,7.0,5.0,4.0,2.0,4.0,6.0,6.0,2.0,4.0,6.0,6.0,1.0,3.0,2.0,5.0,5.0,5.0,5.0,2.0,0.0,1.0,1.0,2.0,1.0,1.0,2.0,1.0,3.0,1.0,4.0,3.0,2.0,2.0,1.0,3.0,0.0,1.0,9.0,4.0,6.0,9.0,6.0,8.0,6.0,6.0,8.0,6.0,14.0,11.0,11.0,15.0,13.0,9.0,13.0,13.0,13.0,15.0,12.0,19.0,18.0,26.0,36.0,24.0,29.0,26.0,30.0,30.0,34.0,33.0,37.0,34.0,34.0,34.0,35.0,38.0,38.0,39.0,31.0,47.0,31.0,33.0,36.0,34.0,27.0,43.0,37.0,46.0,42.0,47.0,45.0,28.0,29.0,31.0,28.0,35.0,45.0,35.0,31.0,41.0,40.0,29.0,37.0,35.0,36.0,36.0,24.0,34.0,29.0,18.0,30.0,20.0,32.0,25.0,35.0,23.0,24.0,37.0,28.0,22.0,37.0,31.0,34.0,36.0,31.0,29.0,28.0,24.0,29.0,32.0,29.0,31.0,32.0,34.0,35.0,28.0,33.0,19.0,27.0,33.0,22.0,32.0,32.0,31.0,28.0,20.0,35.0,31.0,32.0,26.0,35.0,30.0,38.0,36.0,36.0,25.0,33.0,31.0,38.0,44.0,44.0,37.0,27.0,32.0,36.0,46.0,46.0,44.0,42.0,41.0,40.0,52.0,35.0,40.0,42.0,30.0,30.0,39.0,28.0,24.0,43.0,40.0,29.0,31.0,41.0,31.0,18.0,25.0,32.0,36.0,32.0,30.0,40.0,32.0,31.0,34.0,28.0,45.0,39.0,44.0,39.0,42.0,36.0,42.0,37.0,31.0,29.0,23.0,43.0,25.0,34.0,43.0,28.0,36.0,37.0,30.0,30.0,26.0,37.0,36.0,29.0,28.0,29.0,29.0,33.0,24.0,31.0,23.0,29.0,21.0,28.0,19.0,26.0,25.0,26.0,28.0,25.0,27.0,25.0,28.0,31.0,26.0,24.0,33.0,36.0,38.0,36.0,46.0,40.0,54.0,32.0,39.0,43.0,41.0,38.0,27.0,30.0,18.0,12.0,25.0,10.0,19.0,9.0,11.0,13.0,12.0,12.0,9.0,9.0,5.0,8.0:2
10.0,5.0,8.0,1.0,3.0,7.0,1.0,6.0,6.0,5.0,3.0,4.0,5.0,5.0,2.0,4.0,4.0,2.0,5.0,7.0,5.0,3.0,3.0,6.0,10.0,4.0,4.0,2.0,1.0,2.0,3.0,0.0,3.0,2.0,0.0,4.0,4.0,1.0,2.0,2.0,0.0,1.0,2.0,1.0,1.0,1.0,1.0,4.0,1.0,4.0,3.0,1.0,2.0,1.0,3.0,3.0,5.0,6.0,9.0,5.0,5.0,6.0,3.0,11.0,4.0,11.0,11.0,11.0,4.0,9.0,13.0,13.0,8.0,16.0,18.0,11.0,18.0,19.0,27.0,32.0,31.0,30.0,34.0,24.0,37.0,42.0,39.0,44.0,26.0,32.0,32.0,27.0,41.0,36.0,23.0,39.0,35.0,37.0,46.0,39.0,39.0,37.0,41.0,38.0,40.0,30.0,30.0,37.0,37.0,27.0,24.0,38.0,40.0,25.0,40.0,31.0,34.0,47.0,34.0,34.0,35.0,34.0,32.0,28.0,29.0,29.0,17.0,27.0,32.0,33.0,31.0,37.0,25.0,14.0,19.0,26.0,19.0,29.0,38.0,29.0,29.0,20.0,31.0,29.0,32.0,23.0,27.0,28.0,31.0,33.0,33.0,34.0,29.0,28.0,24.0,18.0,25.0,17.0,26.0,20.0,21.0,37.0,38.0,21.0,20.0,32.0,36.0,30.0,27.0,21.0,32.0,34.0,36.0,41.0,38.0,44.0,44.0,29.0,44.0,41.0,24.0,38.0,38.0,34.0,39.0,35.0,30.0,41.0,45.0,35.0,36.0,42.0,30.0,37.0,44.0,39.0,35.0,48.0,41.0,41.0,32.0,41.0,41.0,36.0,26.0,35.0,37.0,41.0,40.0,29.0,26.0,33.0,34.0,33.0,27.0,28.0,33.0,41.0,33.0,31.0,34.0,37.0,41.0,33.0,44.0,44.0,18.0,32.0,25.0,39.0,34.0,26.0,35.0,32.0,22.0,23.0,25.0,24.0,25.0,28.0,28.0,20.0,29.0,22.0,34.0,17.0,14.0,20.0,27.0,23.0,24.0,18.0,18.0,26.0,22.0,27.0,28.0,21.0,32.0,26.0,26.0,48.0,39.0,31.0,34.0,28.0,35.0,31.0,28.0,28.0,27.0,44.0,42.0,31.0,36.0,33.0,32.0,33.0,20.0,20.0,17.0,24.0,19.0,9.0,13.0,11.0,14.0,17.0:2
18.0,13.0,10.0,16.0,16.0,12.0,9.0,15.0,13.0,7.0,9.0,17.0,10.0,10.0,9.0,9.0,8.0,13.0,8.0,10.0,9.0,10.0,3.0,12.0,5.0,10.0,8.0,9.0,8.0,5.0,10.0,7.0,11.0,10.0,7.0,3.0,4.0,3.0,4.0,7.0,3.0,3.0,3.0,5.0,5.0,6.0,2.0,5.0,4.0,3.0,7.0,3.0,4.0,4.0,2.0,2.0,4.0,7.0,1.0,3.0,3.0,5.0,2.0,3.0,2.0,4.0,3.0,3.0,3.0,5.0,4.0,5.0,7.0,2.0,4.0,6.0,4.0,5.0,4.0,10.0,4.0,4.0,5.0,2.0,4.0,6.0,9.0,6.0,2.0,12.0,11.0,5.0,9.0,11.0,2.0,13.0,9.0,16.0,4.0,4.0,11.0,14.0,9.0,7.0,19.0,14.0,12.0,23.0,13.0,15.0,6.0,14.0,11.0,10.0,16.0,19.0,18.0,16.0,27.0,22.0,17.0,16.0,19.0,14.0,25.0,28.0,32.0,23.0,33.0,22.0,18.0,27.0,13.0,19.0,21.0,16.0,24.0,28.0,22.0,34.0,26.0,34.0,22.0,25.0,19.0,25.0,23.0,24.0,23.0,26.0,24.0,26.0,29.0,27.0,20.0,27.0,25.0,19.0,20.0,18.0,17.0,26.0,23.0,31.0,24.0,30.0,24.0,32.0,48.0,37.0,23.0,28.0,22.0,37.0,16.0,24.0,24.0,37.0,33.0,19.0,31.0,35.0,25.0,37.0,26.0,38.0,33.0,31.0,46.0,42.0,58.0,53.0,46.0,48.0,47.0,54.0,50.0,49.0,58.0,46.0,50.0,51.0,40.0,51.0,46.0,41.0,32.0,20.0,24.0,22.0,35.0,31.0,38.0,28.0,31.0,27.0,36.0,27.0,24.0,26.0,29.0,23.0,33.0,35.0,21.0,26.0,30.0,29.0,25.0,29.0,24.0,27.0,19.0,18.0,30.0,27.0,17.0,17.0,14.0,14.0,18.0,30.0,23.0,15.0,25.0,18.0,23.0,20.0,27.0,17.0,17.0,16.0,13.0,33.0,16.0,19.0,10.0,14.0,14.0,26.0,14.0,12.0,9.0,19.0,12.0,20.0,15.0,22.0,14.0,8.0,10.0,12.0,13.0,18.0,11.0,19.0,9.0,7.0,11.0,12.0,3.0,7.0,4.0,6.0,5.0,2.0,1.0,10.0:2
2.0,2.0,7.0,7.0,10.0,1.0,6.0,8.0,2.0,4.0,9.0,2.0,3.0,4.0,1.0,6.0,5.0,5.0,2.0,4.0,0.0,2.0,5.0,4.0,3.0,6.0,3.0,2.0,2.0,2.0,2.0,4.0,1.0,2.0,4.0,4.0,2.0,2.0,0.0,5.0,1.0,0.0,4.0,3.0,1.0,1.0,3.0,2.0,4.0,1.0,1.0,5.0,4.0,2.0,4.0,3.0,5.0,5.0,4.0,6.0,5.0,8.0,9.0,5.0,4.0,15.0,14.0,9.0,16.0,8.0,11.0,17.0,9.0,18.0,23.0,7.0,15.0,19.0,31.0,27.0,33.0,33.0,29.0,35.0,31.0,43.0,39.0,39.0,38.0,46.0,34.0,40.0,41.0,46.0,36.0,48.0,50.0,20.0,33.0,35.0,33.0,43.0,34.0,42.0,45.0,31.0,39.0,32.0,43.0,25.0,32.0,34.0,50.0,39.0,27.0,27.0,30.0,22.0,32.0,22.0,19.0,24.0,29.0,29.0,34.0,27.0,24.0,26.0,29.0,28.0,17.0,27.0,19.0,30.0,20.0,32.0,33.0,33.0,27.0,30.0,31.0,28.0,23.0,28.0,31.0,17.0,28.0,24.0,28.0,21.0,20.0,20.0,24.0,25.0,29.0,19.0,26.0,16.0,34.0,24.0,31.0,22.0,33.0,26.0,25.0,26.0,24.0,27.0,27.0,27.0,17.0,19.0,35.0,31.0,33.0,36.0,41.0,38.0,34.0,26.0,35.0,37.0,46.0,42.0,32.0,40.0,36.0,31.0,34.0,36.0,36.0,43.0,37.0,30.0,28.0,32.0,37.0,36.0,34.0,40.0,44.0,32.0,36.0,39.0,44.0,20.0,35.0,32.0,40.0,39.0,37.0,38.0,30.0,29.0,30.0,33.0,35.0,26.0,38.0,38.0,41.0,25.0,22.0,40.0,22.0,30.0,22.0,28.0,34.0,19.0,34.0,40.0,24.0,29.0,25.0,17.0,26.0,29.0,24.0,23.0,18.0,17.0,20.0,25.0,17.0,20.0,12.0,15.0,18.0,22.0,12.0,13.0,18.0,14.0,18.0,21.0,22.0,26.0,36.0,15.0,31.0,18.0,20.0,28.0,24.0,24.0,29.0,30.0,30.0,25.0,13.0,25.0,40.0,26.0,23.0,14.0,13.0,20.0,17.0,13.0,4.0,3.0,5.0,12.0,14.0,7.0,10.0,10.0:2
5.0,7.0,12.0,3.0,11.0,3.0,3.0,3.0,3.0,5.0,8.0,1.0,3.0,3.0,3.0,4.0,4.0,2.0,2.0,4.0,3.0,3.0,4.0,3.0,5.0,3.0,0.0,3.0,4.0,1.0,4.0,4.0,0.0,2.0,5.0,2.0,0.0,1.0,1.0,2.0,1.0,2.0,2.0,3.0,2.0,2.0,1.0,4.0,1.0,2.0,2.0,4.0,1.0,3.0,5.0,4.0,4.0,8.0,11.0,7.0,4.0,6.0,3.0,6.0,2.0,7.0,13.0,14.0,11.0,14.0,10.0,19.0,8.0,16.0,3.0,16.0,10.0,20.0,16.0,22.0,32.0,33.0,23.0,33.0,33.0,35.0,42.0,35.0,36.0,42.0,40.0,37.0,50.0,36.0,39.0,37.0,32.0,34.0,35.0,35.0,45.0,39.0,30.0,37.0,44.0,54.0,32.0,43.0,32.0,40.0,37.0,34.0,29.0,30.0,38.0,25.0,37.0,39.0,27.0,28.0,39.0,28.0,32.0,31.0,29.0,32.0,31.0,26.0,32.0,33.0,41.0,32.0,25.0,12.0,23.0,37.0,21.0,29.0,23.0,22.0,18.0,22.0,30.0,28.0,16.0,22.0,26.0,29.0,27.0,15.0,35.0,27.0,32.0,20.0,19.0,29.0,19.0,23.0,29.0,15.0,24.0,23.0,16.0,41.0,30.0,27.0,20.0,27.0,31.0,19.0,28.0,23.0,31.0,30.0,35.0,41.0,45.0,35.0,38.0,39.0,44.0,40.0,41.0,39.0,38.0,32.0,41.0,44.0,41.0,46.0,37.0,32.0,28.0,43.0,40.0,42.0,38.0,37.0,31.0,40.0,39.0,31.0,37.0,31.0,45.0,40.0,44.0,27.0,35.0,41.0,40.0,48.0,46.0,34.0,36.0,25.0,42.0,35.0,40.0,34.0,31.0,30.0,40.0,31.0,40.0,30.0,30.0,24.0,30.0,24.0,27.0,31.0,27.0,31.0,27.0,19.0,25.0,18.0,13.0,26.0,23.0,18.0,17.0,23.0,22.0,21.0,20.0,16.0,29.0,26.0,23.0,20.0,25.0,31.0,23.0,24.0,30.0,31.0,48.0,42.0,39.0,38.0,33.0,46.0,46.0,35.0,23.0,17.0,18.0,16.0,15.0,19.0,10.0,8.0,12.0,8.0,6.0,7.0,2.0,9.0,12.0,9.0,8.0,3.0,3.0,4.0,4.0,9.0:2
6.0,10.0,4.0,8.0,6.0,8.0,5.0,8.0,3.0,4.0,11.0,6.0,6.0,5.0,3.0,9.0,4.0,7.0,5.0,9.0,6.0,7.0,8.0,5.0,14.0,5.0,7.0,8.0,4.0,8.0,5.0,9.0,1.0,6.0,3.0,7.0,3.0,2.0,5.0,5.0,7.0,6.0,6.0,8.0,5.0,2.0,3.0,5.0,3.0,3.0,0.0,0.0,1.0,2.0,2.0,1.0,2.0,0.0,7.0,4.0,2.0,3.0,2.0,3.0,3.0,5.0,3.0,4.0,1.0,3.0,3.0,5.0,4.0,7.0,4.0,7.0,9.0,5.0,6.0,7.0,11.0,6.0,6.0,9.0,6.0,10.0,6.0,10.0,8.0,6.0,9.0,10.0,7.0,10.0,7.0,7.0,10.0,6.0,6.0,7.0,12.0,6.0,17.0,16.0,15.0,14.0,7.0,9.0,19.0,11.0,12.0,15.0,16.0,11.0,13.0,13.0,20.0,27.0,19.0,21.0,22.0,13.0,12.0,17.0,23.0,15.0,19.0,24.0,13.0,17.0,11.0,21.0,14.0,11.0,15.0,13.0,18.0,13.0,21.0,33.0,16.0,20.0,16.0,12.0,18.0,22.0,8.0,23.0,28.0,20.0,16.0,28.0,28.0,22.0,22.0,23.0,32.0,31.0,27.0,29.0,24.0,21.0,26.0,18.0,23.0,28.0,21.0,28.0,26.0,14.0,26.0,14.0,23.0,22.0,25.0,21.0,14.0,11.0,24.0,21.0,13.0,25.0,19.0,19.0,14.0,19.0,20.0,19.0,24.0,15.0,16.0,13.0,11.0,18.0,25.0,19.0,17.0,19.0,16.0,16.0,18.0,19.0,24.0,14.0,17.0,23.0,21.0,16.0,12.0,14.0,15.0,18.0,18.0,12.0,23.0,17.0,18.0,9.0,19.0,13.0,16.0,19.0,22.0,12.0,16.0,26.0,20.0,23.0,16.0,20.0,26.0,25.0,20.0,27.0,19.0,23.0,16.0,25.0,38.0,45.0,42.0,19.0,25.0,30.0,26.0,34.0,44.0,63.0,57.0,39.0,27.0,15.0,18.0,9.0,14.0,19.0,9.0,16.0,11.0,12.0,13.0,8.0,12.0,17.0,15.0,18.0,12.0,16.0,10.0,10.0,11.0,10.0,7.0,7.0,11.0,9.0,9.0,8.0,10.0,11.0,5.0,8.0,7.0,8.0,12.0,5.0,6.0,4.0:2
7.0,12.0,4.0,6.0,2.0,5.0,3.0,5.0,7.0,1.0,4.0,4.0,2.0,7.0,3.0,2.0,1.0,6.0,2.0,4.0,4.0,5.0,3.0,2.0,2.0,0.0,2.0,0.0,0.0,3.0,0.0,2.0,0.0,4.0,1.0,1.0,3.0,0.0,1.0,1.0,1.0,0.0,1.0,0.0,0.0,0.0,1.0,3.0,1.0,2.0,1.0,3.0,4.0,0.0,4.0,6.0,2.0,9.0,4.0,7.0,3.0,6.0,10.0,7.0,7.0,3.0,10.0,9.0,11.0,11.0,14.0,9.0,4.0,16.0,20.0,15.0,16.0,18.0,22.0,32.0,32.0,36.0,28.0,35.0,38.0,40.0,42.0,43.0,39.0,43.0,35.0,42.0,42.0,47.0,41.0,28.0,32.0,41.0,36.0,45.0,31.0,28.0,43.0,47.0,41.0,51.0,36.0,35.0,32.0,39.0,24.0,46.0,34.0,39.0,42.0,39.0,42.0,38.0,47.0,43.0,41.0,30.0,30.0,19.0,30.0,38.0,38.0,21.0,28.0,20.0,28.0,28.0,23.0,31.0,27.0,31.0,30.0,26.0,29.0,25.0,42.0,26.0,32.0,33.0,36.0,18.0,24.0,25.0,28.0,36.0,24.0,26.0,36.0,24.0,30.0,33.0,23.0,33.0,24.0,25.0,23.0,21.0,34.0,30.0,28.0,35.0,23.0,20.0,40.0,29.0,21.0,45.0,35.0,39.0,27.0,38.0,41.0,50.0,41.0,29.0,43.0,40.0,49.0,42.0,38.0,37.0,34.0,32.0,42.0,45.0,36.0,31.0,35.0,37.0,35.0,36.0,20.0,39.0,45.0,37.0,41.0,42.0,47.0,49.0,42.0,41.0,32.0,29.0,31.0,47.0,43.0,48.0,27.0,38.0,38.0,29.0,28.0,34.0,38.0,47.0,44.0,32.0,38.0,38.0,38.0,42.0,37.0,32.0,31.0,37.0,31.0,28.0,27.0,22.0,32.0,28.0,36.0,28.0,28.0,35.0,25.0,22.0,23.0,27.0,28.0,24.0,23.0,22.0,19.0,22.0,19.0,22.0,19.0,32.0,24.0,28.0,27.0,28.0,35.0,25.0,29.0,22.0,21.0,24.0,41.0,46.0,48.0,56.0,50.0,51.0,46.0,30.0,45.0,41.0,50.0,32.0,16.0,18.0,15.0,17.0,16.0,13.0,12.0,11.0,17.0,8.0,13.0,13.0:2
7.0,5.0,4.0,9.0,2.0,8.0,2.0,2.0,3.0,3.0,1.0,6.0,7.0,2.0,4.0,3.0,5.0,4.0,2.0,6.0,3.0,3.0,1.0,4.0,3.0,4.0,1.0,2.0,4.0,4.0,2.0,2.0,2.0,2.0,5.0,1.0,3.0,3.0,1.0,1.0,0.0,1.0,2.0,2.0,1.0,1.0,1.0,1.0,0.0,3.0,4.0,2.0,1.0,1.0,2.0,4.0,4.0,8.0,8.0,4.0,8.0,9.0,7.0,8.0,2.0,13.0,9.0,7.0,12.0,15.0,13.0,8.0,7.0,10.0,17.0,10.0,19.0,15.0,23.0,21.0,24.0,31.0,24.0,23.0,19.0,36.0,34.0,38.0,24.0,38.0,33.0,39.0,32.0,26.0,27.0,36.0,39.0,25.0,40.0,40.0,36.0,37.0,40.0,39.0,39.0,51.0,54.0,29.0,29.0,20.0,36.0,33.0,23.0,35.0,28.0,26.0,32.0,38.0,40.0,31.0,36.0,34.0,28.0,42.0,25.0,42.0,26.0,37.0,25.0,22.0,18.0,21.0,24.0,31.0,11.0,20.0,30.0,29.0,21.0,23.0,23.0,21.0,30.0,22.0,22.0,28.0,24.0,23.0,19.0,20.0,25.0,23.0,21.0,37.0,31.0,23.0,32.0,22.0,25.0,20.0,16.0,21.0,26.0,20.0,36.0,25.0,34.0,19.0,25.0,20.0,27.0,32.0,22.0,31.0,22.0,24.0,37.0,26.0,27.0,26.0,30.0,20.0,42.0,35.0,32.0,20.0,32.0,41.0,45.0,30.0,30.0,25.0,39.0,32.0,20.0,42.0,17.0,43.0,35.0,35.0,27.0,35.0,44.0,35.0,37.0,30.0,23.0,29.0,32.0,37.0,32.0,21.0,15.0,27.0,29.0,26.0,26.0,30.0,30.0,33.0,21.0,28.0,39.0,36.0,23.0,26.0,20.0,29.0,19.0,24.0,34.0,27.0,36.0,27.0,29.0,34.0,33.0,25.0,27.0,24.0,29.0,21.0,21.0,18.0,20.0,13.0,19.0,24.0,17.0,15.0,24.0,22.0,18.0,21.0,23.0,31.0,24.0,31.0,22.0,15.0,19.0,15.0,23.0,28.0,36.0,24.0,21.0,43.0,50.0,46.0,41.0,36.0,35.0,19.0,22.0,10.0,15.0,9.0,16.0,13.0,8.0,10.0,9.0,8.0,7.0,5.0,7.0,4.0:2
8.0,7.0,10.0,7.0,9.0,4.0,2.0,5.0,4.0,4.0,8.0,3.0,5.0,4.0,0.0,3.0,7.0,8.0,5.0,4.0,3.0,3.0,3.0,4.0,1.0,4.0,5.0,1.0,4.0,4.0,7.0,4.0,2.0,3.0,4.0,5.0,1.0,1.0,3.0,3.0,2.0,7.0,1.0,3.0,3.0,3.0,4.0,1.0,3.0,4.0,3.0,1.0,1.0,5.0,0.0,2.0,5.0,5.0,5.0,6.0,7.0,1.0,4.0,3.0,9.0,14.0,12.0,9.0,7.0,10.0,9.0,10.0,11.0,10.0,12.0,18.0,20.0,22.0,19.0,36.0,32.0,26.0,36.0,34.0,37.0,35.0,40.0,30.0,46.0,44.0,35.0,49.0,47.0,44.0,41.0,53.0,42.0,28.0,28.0,43.0,38.0,25.0,36.0,46.0,40.0,38.0,27.0,45.0,42.0,35.0,46.0,33.0,40.0,31.0,30.0,30.0,41.0,36.0,32.0,32.0,35.0,34.0,29.0,39.0,27.0,15.0,29.0,25.0,32.0,25.0,41.0,22.0,17.0,34.0,19.0,25.0,28.0,24.0,29.0,26.0,43.0,35.0,32.0,26.0,25.0,29.0,30.0,24.0,34.0,19.0,34.0,29.0,32.0,28.0,28.0,26.0,26.0,21.0,37.0,21.0,36.0,39.0,22.0,24.0,30.0,36.0,28.0,27.0,29.0,22.0,33.0,29.0,39.0,36.0,26.0,30.0,27.0,32.0,34.0,27.0,32.0,44.0,39.0,28.0,27.0,37.0,38.0,46.0,42.0,41.0,32.0,31.0,33.0,29.0,36.0,25.0,37.0,25.0,32.0,37.0,26.0,48.0,24.0,30.0,29.0,37.0,46.0,37.0,44.0,29.0,25.0,22.0,28.0,34.0,22.0,27.0,36.0,36.0,34.0,36.0,39.0,35.0,31.0,32.0,32.0,24.0,38.0,32.0,38.0,17.0,32.0,39.0,33.0,36.0,28.0,32.0,25.0,27.0,36.0,17.0,31.0,17.0,13.0,18.0,14.0,20.0,24.0,25.0,18.0,19.0,20.0,17.0,16.0,25.0,17.0,16.0,45.0,25.0,30.0,34.0,41.0,41.0,40.0,50.0,43.0,33.0,37.0,21.0,18.0,25.0,16.0,15.0,10.0,11.0,7.0,11.0,9.0,9.0,19.0,7.0,7.0,7.0,11.0,13.0,7.0,9.0,11.0,16.0:2
2.0,4.0,4.0,8.0,4.0,7.0,4.0,5.0,6.0,4.0,6.0,4.0,7.0,4.0,3.0,2.0,4.0,7.0,4.0,7.0,4.0,6.0,4.0,1.0,4.0,3.0,1.0,2.0,2.0,1.0,5.0,2.0,2.0,1.0,2.0,3.0,1.0,1.0,1.0,1.0,0.0,2.0,4.0,1.0,2.0,3.0,3.0,1.0,1.0,0.0,2.0,1.0,2.0,1.0,1.0,1.0,7.0,3.0,4.0,6.0,7.0,3.0,6.0,11.0,11.0,6.0,8.0,13.0,14.0,11.0,18.0,12.0,13.0,20.0,19.0,19.0,14.0,17.0,29.0,28.0,34.0,31.0,25.0,37.0,29.0,32.0,39.0,42.0,38.0,34.0,27.0,37.0,29.0,33.0,30.0,34.0,29.0,33.0,26.0,24.0,24.0,24.0,57.0,37.0,27.0,52.0,21.0,35.0,26.0,28.0,25.0,15.0,35.0,28.0,29.0,33.0,30.0,45.0,23.0,41.0,20.0,28.0,25.0,31.0,18.0,25.0,24.0,23.0,21.0,32.0,19.0,13.0,16.0,28.0,29.0,12.0,27.0,19.0,21.0,29.0,31.0,16.0,29.0,22.0,18.0,29.0,17.0,22.0,29.0,14.0,25.0,14.0,25.0,28.0,13.0,22.0,37.0,29.0,24.0,22.0,31.0,29.0,30.0,28.0,39.0,33.0,37.0,31.0,32.0,21.0,30.0,19.0,24.0,21.0,32.0,43.0,36.0,28.0,36.0,38.0,29.0,37.0,26.0,26.0,33.0,27.0,28.0,35.0,30.0,30.0,46.0,40.0,37.0,20.0,32.0,28.0,45.0,26.0,40.0,24.0,43.0,33.0,36.0,35.0,37.0,34.0,29.0,32.0,26.0,38.0,29.0,24.0,17.0,20.0,43.0,24.0,32.0,35.0,30.0,28.0,28.0,32.0,24.0,25.0,24.0,20.0,18.0,28.0,15.0,22.0,26.0,27.0,24.0,26.0,20.0,29.0,21.0,22.0,17.0,19.0,19.0,24.0,17.0,16.0,19.0,18.0,22.0,15.0,20.0,25.0,16.0,24.0,16.0,20.0,15.0,29.0,21.0,10.0,16.0,32.0,28.0,39.0,37.0,32.0,38.0,46.0,42.0,49.0,31.0,38.0,20.0,16.0,13.0,11.0,11.0,8.0,8.0,18.0,9.0,20.0,8.0,7.0,5.0,6.0,4.0,4.0,6.0,7.0:2
6.0,4.0,12.0,4.0,7.0,8.0,7.0,14.0,7.0,4.0,2.0,6.0,1.0,3.0,1.0,6.0,4.0,5.0,5.0,1.0,3.0,1.0,3.0,1.0,2.0,5.0,?,?,0.0,?,?,?,?,0.0,?,?,?,?,?,0.0,0.0,?,?,?,?,?,0.0,?,?,?,?,?,?,0.0,0.0,?,?,?,?,0.0,?,?,?,5.0,10.0,?,30.0,?,5.0,?,10.0,0.0,3.0,17.0,10.0,?,?,50.0,?,?,?,?,60.0,?,?,?,60.0,60.0,0.0,?,?,?,10.0,?,?,?,?,?,?,25.0,?,90.0,?,0.0,?,?,70.0,?,?,70.0,?,37.0,?,?,50.0,50.0,0.0,30.0,?,0.0,50.0,?,?,10.0,60.0,10.0,30.0,30.0,15.0,?,?,0.0,30.0,?,35.0,40.0,46.0,30.0,21.0,26.0,23.0,33.0,21.0,27.0,28.0,32.0,26.0,29.0,40.0,23.0,33.0,24.0,32.0,22.0,30.0,13.0,24.0,28.0,30.0,23.0,29.0,29.0,26.0,14.0,34.0,28.0,28.0,20.0,13.0,38.0,34.0,39.0,45.0,26.0,27.0,36.0,27.0,40.0,33.0,31.0,31.0,30.0,30.0,39.0,24.0,21.0,34.0,42.0,27.0,39.0,30.0,35.0,16.0,26.0,23.0,18.0,31.0,53.0,34.0,46.0,36.0,32.0,33.0,43.0,26.0,43.0,43.0,43.0,37.0,36.0,58.0,34.0,30.0,8.0,31.0,30.0,40.0,17.0,28.0,42.0,11.0,36.0,36.0,15.0,22.0,37.0,27.0,31.0,9.0,36.0,29.0,26.0,25.0,30.0,24.0,16.0,20.0,23.0,13.0,23.0,15.0,9.0,30.0,30.0,17.0,18.0,24.0,20.0,19.0,14.0,22.0,23.0,24.0,20.0,29.0,20.0,29.0,18.0,29.0,24.0,19.0,13.0,19.0,34.0,43.0,34.0,54.0,24.0,47.0,49.0,29.0,25.0,39.0,40.0,49.0,34.0,13.0,30.0,16.0,20.0,18.0,8.0,13.0,6.0,10.0,10.0,10.0,10.0:2
2.0,6.0,2.0,3.0,3.0,3.0,7.0,3.0,3.0,8.0,8.0,7.0,6.0,2.0,4.0,6.0,8.0,0.0,2.0,8.0,2.0,2.0,0.0,5.0,2.0,2.0,2.0,2.0,3.0,2.0,2.0,2.0,1.0,0.0,2.0,5.0,0.0,2.0,2.0,1.0,0.0,2.0,0.0,0.0,1.0,1.0,2.0,0.0,1.0,2.0,2.0,3.0,1.0,2.0,1.0,0.0,4.0,8.0,8.0,2.0,6.0,5.0,6.0,3.0,3.0,4.0,10.0,17.0,14.0,14.0,12.0,15.0,5.0,10.0,21.0,16.0,17.0,25.0,16.0,22.0,22.0,24.0,18.0,33.0,21.0,39.0,43.0,45.0,35.0,32.0,31.0,43.0,33.0,39.0,32.0,44.0,22.0,33.0,27.0,37.0,29.0,29.0,31.0,38.0,34.0,36.0,45.0,45.0,36.0,42.0,23.0,30.0,45.0,44.0,30.0,35.0,43.0,42.0,35.0,39.0,37.0,32.0,24.0,19.0,23.0,19.0,24.0,28.0,27.0,27.0,28.0,18.0,25.0,23.0,28.0,19.0,30.0,17.0,35.0,31.0,24.0,19.0,19.0,30.0,25.0,27.0,31.0,27.0,33.0,33.0,19.0,29.0,28.0,27.0,24.0,14.0,17.0,15.0,36.0,29.0,25.0,26.0,23.0,26.0,34.0,30.0,27.0,27.0,27.0,26.0,22.0,21.0,26.0,29.0,39.0,36.0,27.0,24.0,32.0,33.0,27.0,28.0,41.0,54.0,44.0,29.0,34.0,37.0,32.0,37.0,42.0,27.0,20.0,38.0,31.0,30.0,39.0,26.0,28.0,24.0,26.0,32.0,32.0,26.0,22.0,40.0,37.0,37.0,20.0,24.0,26.0,29.0,28.0,27.0,33.0,37.0,33.0,30.0,32.0,32.0,31.0,23.0,27.0,31.0,29.0,34.0,20.0,32.0,40.0,24.0,26.0,26.0,31.0,27.0,44.0,39.0,36.0,19.0,28.0,11.0,9.0,21.0,16.0,22.0,19.0,23.0,14.0,17.0,10.0,12.0,16.0,26.0,20.0,12.0,24.0,16.0,26.0,16.0,14.0,35.0,24.0,25.0,33.0,16.0,21.0,31.0,29.0,32.0,25.0,19.0,44.0,21.0,16.0,16.0,17.0,8.0,13.0,23.0,13.0,12.0,13.0,9.0,13.0,12.0,12.0,6.0,6.0,5.0:2
7.0,4.0,5.0,3.0,6.0,11.0,2.0,2.0,2.0,4.0,8.0,3.0,4.0,4.0,5.0,3.0,1.0,5.0,0.0,5.0,1.0,4.0,1.0,5.0,3.0,4.0,5.0,4.0,2.0,3.0,1.0,0.0,2.0,2.0,0.0,2.0,1.0,2.0,0.0,1.0,2.0,2.0,1.0,6.0,1.0,2.0,0.0,0.0,4.0,1.0,3.0,5.0,0.0,0.0,2.0,3.0,4.0,6.0,7.0,8.0,5.0,7.0,7.0,4.0,7.0,10.0,17.0,10.0,17.0,17.0,5.0,15.0,16.0,12.0,21.0,19.0,26.0,20.0,30.0,11.0,37.0,29.0,23.0,18.0,29.0,24.0,35.0,34.0,30.0,41.0,51.0,33.0,31.0,43.0,38.0,26.0,33.0,23.0,29.0,33.0,36.0,28.0,32.0,23.0,40.0,37.0,33.0,36.0,38.0,34.0,29.0,34.0,31.0,30.0,25.0,35.0,25.0,24.0,25.0,21.0,24.0,28.0,30.0,34.0,26.0,22.0,30.0,28.0,35.0,26.0,28.0,28.0,20.0,27.0,23.0,30.0,23.0,22.0,21.0,28.0,16.0,18.0,23.0,18.0,24.0,30.0,30.0,30.0,18.0,21.0,35.0,21.0,19.0,31.0,24.0,26.0,21.0,23.0,30.0,24.0,25.0,21.0,15.0,17.0,35.0,16.0,27.0,30.0,35.0,37.0,27.0,24.0,28.0,29.0,22.0,36.0,31.0,35.0,20.0,27.0,35.0,38.0,34.0,38.0,38.0,44.0,30.0,32.0,35.0,39.0,35.0,35.0,30.0,36.0,39.0,31.0,37.0,37.0,25.0,44.0,32.0,37.0,33.0,31.0,34.0,40.0,31.0,46.0,42.0,41.0,25.0,26.0,30.0,38.0,39.0,44.0,33.0,24.0,36.0,28.0,32.0,28.0,34.0,23.0,18.0,23.0,43.0,28.0,29.0,24.0,29.0,27.0,40.0,22.0,17.0,31.0,27.0,25.0,37.0,20.0,28.0,26.0,31.0,19.0,20.0,16.0,24.0,11.0,19.0,20.0,20.0,9.0,32.0,19.0,26.0,32.0,32.0,19.0,29.0,21.0,30.0,19.0,10.0,14.0,21.0,30.0,41.0,37.0,53.0,49.0,48.0,44.0,43.0,45.0,42.0,49.0,45.0,37.0,27.0,35.0,32.0,25.0,23.0,15.0,4.0,6.0,9.0,7.0:2
11.0,7.0,6.0,8.0,4.0,10.0,5.0,7.0,2.0,7.0,11.0,5.0,1.0,2.0,5.0,2.0,3.0,2.0,5.0,3.0,2.0,1.0,3.0,2.0,3.0,3.0,3.0,2.0,1.0,2.0,5.0,3.0,1.0,4.0,1.0,0.0,1.0,3.0,1.0,2.0,0.0,1.0,3.0,2.0,3.0,1.0,4.0,1.0,1.0,1.0,5.0,1.0,2.0,0.0,2.0,4.0,7.0,7.0,6.0,3.0,3.0,4.0,3.0,5.0,5.0,6.0,4.0,9.0,15.0,16.0,9.0,16.0,11.0,14.0,9.0,19.0,7.0,18.0,18.0,35.0,32.0,27.0,24.0,30.0,30.0,31.0,41.0,41.0,34.0,38.0,31.0,27.0,37.0,40.0,37.0,34.0,39.0,24.0,29.0,31.0,28.0,28.0,43.0,29.0,43.0,38.0,44.0,37.0,26.0,39.0,48.0,48.0,39.0,29.0,42.0,36.0,37.0,29.0,38.0,36.0,44.0,31.0,46.0,20.0,?,?,?,?,?,?,?,?,?,?,?,10.0,26.0,25.0,22.0,33.0,31.0,20.0,20.0,29.0,20.0,30.0,28.0,26.0,18.0,32.0,27.0,27.0,32.0,29.0,32.0,20.0,26.0,29.0,34.0,?,?,24.0,34.0,24.0,27.0,23.0,27.0,22.0,32.0,20.0,36.0,30.0,36.0,41.0,34.0,33.0,44.0,33.0,44.0,36.0,29.0,41.0,38.0,39.0,41.0,34.0,39.0,33.0,30.0,54.0,29.0,35.0,25.0,33.0,32.0,34.0,33.0,35.0,26.0,29.0,22.0,36.0,34.0,33.0,35.0,40.0,31.0,35.0,38.0,27.0,30.0,26.0,33.0,29.0,35.0,25.0,25.0,22.0,30.0,43.0,27.0,41.0,39.0,33.0,36.0,31.0,24.0,20.0,28.0,41.0,33.0,36.0,34.0,35.0,27.0,27.0,21.0,34.0,22.0,25.0,23.0,20.0,15.0,20.0,16.0,27.0,32.0,20.0,16.0,16.0,22.0,16.0,13.0,14.0,23.0,18.0,20.0,23.0,26.0,28.0,36.0,25.0,59.0,50.0,47.0,59.0,42.0,44.0,32.0,50.0,56.0,41.0,49.0,38.0,45.0,34.0,43.0,36.0,20.0,21.0,19.0,14.0,15.0,14.0,14.0,12.0,17.0,10.0:2
6.0,3.0,6.0,6.0,4.0,7.0,9.0,4.0,6.0,3.0,9.0,7.0,7.0,2.0,10.0,4.0,6.0,5.0,2.0,6.0,3.0,2.0,2.0,3.0,2.0,5.0,0.0,1.0,1.0,3.0,1.0,3.0,0.0,0.0,0.0,1.0,1.0,2.0,1.0,1.0,4.0,1.0,3.0,1.0,0.0,1.0,4.0,0.0,2.0,0.0,2.0,1.0,1.0,5.0,2.0,2.0,7.0,3.0,3.0,2.0,1.0,6.0,8.0,6.0,4.0,9.0,4.0,17.0,18.0,5.0,15.0,10.0,17.0,17.0,22.0,22.0,24.0,21.0,23.0,19.0,36.0,25.0,32.0,32.0,31.0,48.0,33.0,40.0,40.0,42.0,29.0,37.0,42.0,29.0,53.0,36.0,26.0,32.0,35.0,24.0,35.0,38.0,33.0,38.0,41.0,36.0,35.0,43.0,40.0,34.0,33.0,34.0,39.0,41.0,32.0,25.0,40.0,40.0,36.0,20.0,30.0,35.0,34.0,23.0,18.0,29.0,23.0,28.0,22.0,18.0,27.0,29.0,18.0,21.0,32.0,25.0,22.0,23.0,25.0,32.0,21.0,33.0,35.0,24.0,28.0,16.0,31.0,28.0,27.0,27.0,31.0,29.0,29.0,37.0,32.0,29.0,26.0,17.0,22.0,24.0,16.0,25.0,30.0,23.0,19.0,29.0,29.0,24.0,22.0,31.0,31.0,31.0,27.0,23.0,33.0,31.0,43.0,37.0,39.0,37.0,30.0,28.0,48.0,45.0,45.0,40.0,38.0,43.0,43.0,36.0,46.0,45.0,45.0,39.0,41.0,37.0,42.0,38.0,36.0,30.0,25.0,29.0,33.0,31.0,33.0,31.0,35.0,36.0,33.0,40.0,43.0,30.0,28.0,26.0,31.0,35.0,17.0,41.0,42.0,30.0,32.0,33.0,38.0,27.0,33.0,34.0,27.0,29.0,31.0,27.0,24.0,20.0,25.0,24.0,13.0,23.0,15.0,19.0,27.0,17.0,15.0,15.0,16.0,23.0,13.0,11.0,21.0,20.0,22.0,12.0,19.0,26.0,22.0,14.0,21.0,14.0,21.0,10.0,20.0,23.0,26.0,42.0,20.0,30.0,34.0,37.0,22.0,26.0,36.0,42.0,37.0,37.0,44.0,10.0,18.0,10.0,3.0,16.0,16.0,13.0,9.0,13.0,7.0,6.0,14.0,15.0,6.0,3.0:2
4.0,5.0,1.0,4.0,9.0,5.0,3.0,4.0,3.0,3.0,3.0,0.0,3.0,0.0,1.0,3.0,2.0,3.0,3.0,5.0,0.0,3.0,3.0,2.0,1.0,2.0,2.0,2.0,5.0,1.0,4.0,3.0,2.0,2.0,1.0,1.0,2.0,1.0,1.0,3.0,0.0,5.0,3.0,2.0,3.0,2.0,0.0,1.0,0.0,0.0,1.0,3.0,3.0,1.0,1.0,3.0,1.0,4.0,5.0,5.0,4.0,9.0,4.0,3.0,2.0,9.0,7.0,17.0,8.0,7.0,14.0,18.0,11.0,16.0,16.0,21.0,16.0,28.0,29.0,21.0,19.0,33.0,34.0,42.0,34.0,34.0,41.0,41.0,24.0,34.0,43.0,32.0,29.0,35.0,28.0,40.0,31.0,39.0,45.0,34.0,34.0,30.0,38.0,44.0,36.0,35.0,28.0,38.0,31.0,45.0,16.0,35.0,35.0,35.0,31.0,21.0,32.0,27.0,39.0,31.0,31.0,36.0,28.0,24.0,28.0,32.0,36.0,25.0,21.0,32.0,26.0,24.0,17.0,33.0,14.0,18.0,25.0,31.0,16.0,16.0,31.0,32.0,31.0,22.0,29.0,20.0,17.0,29.0,19.0,21.0,34.0,18.0,34.0,18.0,21.0,44.0,28.0,15.0,24.0,23.0,34.0,27.0,26.0,22.0,28.0,29.0,23.0,34.0,31.0,35.0,24.0,27.0,31.0,33.0,31.0,45.0,34.0,34.0,33.0,31.0,40.0,23.0,30.0,49.0,51.0,47.0,33.0,33.0,46.0,31.0,37.0,38.0,38.0,33.0,41.0,40.0,29.0,42.0,32.0,38.0,38.0,38.0,33.0,33.0,26.0,35.0,31.0,30.0,26.0,37.0,31.0,31.0,36.0,33.0,39.0,36.0,29.0,49.0,33.0,42.0,33.0,36.0,32.0,34.0,32.0,20.0,40.0,30.0,35.0,26.0,22.0,19.0,16.0,22.0,25.0,22.0,18.0,28.0,34.0,24.0,18.0,10.0,24.0,23.0,24.0,17.0,15.0,17.0,16.0,13.0,16.0,19.0,16.0,18.0,22.0,20.0,34.0,43.0,31.0,31.0,28.0,32.0,22.0,15.0,33.0,43.0,46.0,53.0,34.0,48.0,27.0,40.0,22.0,14.0,14.0,8.0,10.0,15.0,11.0,8.0,10.0,8.0,11.0,3.0,6.0,7.0,4.0,5.0:2
7.0,3.0,5.0,6.0,4.0,6.0,4.0,4.0,2.0,5.0,4.0,2.0,3.0,1.0,5.0,2.0,5.0,4.0,3.0,0.0,1.0,3.0,0.0,4.0,4.0,0.0,1.0,3.0,3.0,2.0,5.0,1.0,3.0,1.0,0.0,4.0,4.0,0.0,1.0,0.0,1.0,0.0,2.0,1.0,3.0,1.0,2.0,2.0,1.0,2.0,2.0,2.0,2.0,0.0,4.0,3.0,1.0,6.0,6.0,7.0,10.0,9.0,9.0,8.0,4.0,4.0,11.0,17.0,12.0,17.0,9.0,16.0,11.0,13.0,18.0,19.0,18.0,19.0,28.0,25.0,31.0,35.0,31.0,31.0,29.0,32.0,41.0,44.0,41.0,42.0,47.0,34.0,30.0,52.0,49.0,41.0,35.0,36.0,32.0,36.0,38.0,38.0,28.0,41.0,42.0,37.0,46.0,47.0,31.0,38.0,43.0,31.0,31.0,33.0,38.0,37.0,27.0,38.0,34.0,33.0,38.0,36.0,31.0,31.0,31.0,41.0,29.0,37.0,29.0,33.0,26.0,17.0,21.0,22.0,31.0,22.0,40.0,31.0,30.0,30.0,26.0,28.0,32.0,24.0,26.0,25.0,33.0,24.0,28.0,18.0,22.0,30.0,29.0,15.0,32.0,24.0,36.0,23.0,27.0,24.0,30.0,30.0,15.0,35.0,30.0,32.0,30.0,39.0,26.0,28.0,34.0,30.0,31.0,36.0,46.0,40.0,39.0,29.0,37.0,39.0,35.0,36.0,41.0,40.0,29.0,35.0,46.0,34.0,36.0,39.0,43.0,41.0,37.0,39.0,31.0,44.0,34.0,46.0,38.0,38.0,34.0,36.0,39.0,24.0,44.0,39.0,46.0,41.0,36.0,34.0,39.0,36.0,29.0,29.0,33.0,38.0,38.0,49.0,50.0,43.0,34.0,35.0,28.0,34.0,33.0,29.0,37.0,36.0,29.0,27.0,22.0,32.0,38.0,27.0,28.0,42.0,28.0,24.0,19.0,17.0,31.0,19.0,23.0,27.0,23.0,21.0,27.0,17.0,17.0,16.0,30.0,20.0,34.0,24.0,20.0,23.0,37.0,32.0,26.0,28.0,41.0,41.0,38.0,45.0,44.0,41.0,31.0,25.0,25.0,15.0,5.0,18.0,26.0,37.0,47.0,42.0,46.0,37.0,19.0,20.0,27.0,18.0,13.0,9.0,15.0,13.0,12.0,11.0:2
6.0,5.0,2.0,5.0,4.0,3.0,5.0,11.0,6.0,4.0,7.0,6.0,6.0,8.0,4.0,4.0,3.0,4.0,5.0,3.0,4.0,6.0,4.0,9.0,4.0,4.0,5.0,2.0,1.0,5.0,0.0,2.0,4.0,3.0,1.0,5.0,4.0,1.0,2.0,1.0,0.0,0.0,5.0,1.0,4.0,2.0,2.0,0.0,2.0,1.0,3.0,3.0,1.0,1.0,2.0,3.0,3.0,5.0,5.0,5.0,3.0,3.0,8.0,4.0,11.0,9.0,5.0,15.0,10.0,12.0,19.0,18.0,13.0,16.0,11.0,21.0,14.0,24.0,18.0,31.0,26.0,21.0,23.0,24.0,17.0,15.0,22.0,31.0,18.0,29.0,31.0,32.0,26.0,19.0,29.0,32.0,28.0,24.0,28.0,20.0,13.0,23.0,39.0,43.0,34.0,37.0,52.0,25.0,32.0,20.0,31.0,42.0,25.0,34.0,17.0,27.0,35.0,29.0,25.0,21.0,28.0,28.0,21.0,20.0,24.0,33.0,27.0,28.0,28.0,23.0,28.0,29.0,29.0,17.0,24.0,27.0,33.0,28.0,21.0,29.0,32.0,30.0,27.0,31.0,20.0,39.0,35.0,50.0,40.0,28.0,16.0,29.0,22.0,29.0,31.0,30.0,26.0,32.0,29.0,28.0,22.0,17.0,39.0,39.0,28.0,36.0,27.0,36.0,29.0,36.0,26.0,29.0,35.0,31.0,37.0,36.0,28.0,36.0,40.0,41.0,36.0,46.0,38.0,27.0,29.0,26.0,31.0,28.0,18.0,41.0,29.0,36.0,33.0,35.0,26.0,30.0,25.0,33.0,38.0,21.0,30.0,29.0,25.0,28.0,28.0,31.0,34.0,44.0,35.0,19.0,27.0,30.0,40.0,34.0,25.0,20.0,14.0,11.0,31.0,23.0,32.0,29.0,22.0,26.0,32.0,23.0,35.0,28.0,24.0,27.0,25.0,24.0,28.0,13.0,20.0,23.0,21.0,22.0,22.0,23.0,23.0,19.0,33.0,23.0,12.0,17.0,8.0,25.0,24.0,14.0,13.0,7.0,23.0,13.0,13.0,24.0,17.0,19.0,17.0,27.0,37.0,28.0,19.0,21.0,32.0,44.0,30.0,29.0,33.0,30.0,33.0,58.0,38.0,56.0,53.0,46.0,20.0,38.0,29.0,17.0,16.0,16.0,12.0,15.0,20.0,12.0,11.0,6.0:2
6.0,9.0,9.0,4.0,5.0,3.0,6.0,5.0,6.0,6.0,7.0,3.0,8.0,5.0,4.0,1.0,1.0,5.0,2.0,3.0,4.0,1.0,3.0,1.0,5.0,4.0,4.0,2.0,2.0,5.0,2.0,1.0,2.0,1.0,2.0,1.0,2.0,0.0,0.0,2.0,5.0,0.0,3.0,0.0,0.0,1.0,2.0,2.0,4.0,2.0,1.0,6.0,2.0,2.0,4.0,4.0,2.0,5.0,7.0,8.0,5.0,3.0,11.0,9.0,5.0,7.0,8.0,11.0,13.0,15.0,14.0,18.0,12.0,23.0,16.0,13.0,27.0,19.0,26.0,22.0,32.0,25.0,28.0,27.0,27.0,39.0,45.0,38.0,34.0,31.0,37.0,48.0,32.0,43.0,34.0,41.0,36.0,27.0,40.0,49.0,36.0,42.0,35.0,47.0,42.0,46.0,56.0,40.0,41.0,43.0,36.0,36.0,48.0,39.0,23.0,32.0,36.0,31.0,36.0,31.0,26.0,26.0,37.0,34.0,30.0,32.0,32.0,36.0,28.0,24.0,35.0,30.0,37.0,29.0,31.0,31.0,30.0,30.0,33.0,37.0,31.0,24.0,35.0,32.0,32.0,33.0,32.0,26.0,35.0,25.0,23.0,27.0,28.0,33.0,40.0,29.0,33.0,26.0,36.0,33.0,33.0,27.0,34.0,27.0,30.0,29.0,24.0,24.0,26.0,23.0,30.0,35.0,51.0,29.0,37.0,42.0,45.0,31.0,45.0,42.0,41.0,31.0,39.0,44.0,36.0,33.0,25.0,39.0,41.0,29.0,41.0,36.0,44.0,39.0,38.0,32.0,30.0,38.0,42.0,30.0,40.0,36.0,37.0,35.0,29.0,26.0,38.0,38.0,48.0,40.0,29.0,36.0,44.0,43.0,39.0,33.0,26.0,41.0,36.0,34.0,33.0,38.0,40.0,32.0,35.0,51.0,34.0,27.0,29.0,46.0,37.0,37.0,31.0,34.0,24.0,26.0,32.0,23.0,31.0,30.0,27.0,18.0,31.0,31.0,24.0,29.0,23.0,21.0,20.0,19.0,23.0,19.0,14.0,27.0,34.0,23.0,14.0,20.0,23.0,29.0,41.0,46.0,30.0,32.0,22.0,17.0,33.0,31.0,32.0,52.0,46.0,30.0,51.0,48.0,29.0,13.0,16.0,15.0,18.0,12.0,7.0,16.0,13.0,12.0,6.0,10.0,9.0,8.0:2
3.0,8.0,10.0,6.0,1.0,4.0,9.0,4.0,6.0,13.0,5.0,5.0,4.0,7.0,5.0,4.0,5.0,1.0,8.0,2.0,3.0,0.0,2.0,1.0,1.0,0.0,2.0,1.0,2.0,4.0,0.0,0.0,0.0,3.0,1.0,0.0,3.0,0.0,3.0,0.0,0.0,2.0,1.0,1.0,1.0,1.0,0.0,3.0,1.0,2.0,1.0,1.0,2.0,1.0,2.0,2.0,5.0,2.0,5.0,4.0,6.0,5.0,5.0,7.0,4.0,5.0,12.0,12.0,11.0,12.0,11.0,13.0,19.0,16.0,19.0,15.0,8.0,14.0,30.0,35.0,20.0,27.0,33.0,24.0,39.0,42.0,36.0,50.0,42.0,38.0,38.0,40.0,49.0,39.0,43.0,44.0,40.0,22.0,25.0,42.0,37.0,36.0,34.0,41.0,37.0,36.0,40.0,37.0,41.0,38.0,36.0,44.0,33.0,30.0,41.0,36.0,35.0,36.0,35.0,42.0,31.0,25.0,28.0,27.0,23.0,25.0,24.0,23.0,20.0,31.0,19.0,25.0,25.0,34.0,8.0,26.0,30.0,31.0,28.0,27.0,22.0,18.0,30.0,28.0,34.0,39.0,32.0,28.0,32.0,35.0,34.0,35.0,40.0,13.0,34.0,30.0,34.0,42.0,32.0,38.0,45.0,33.0,28.0,40.0,32.0,29.0,36.0,30.0,19.0,31.0,31.0,40.0,32.0,29.0,28.0,30.0,38.0,26.0,43.0,28.0,42.0,38.0,43.0,45.0,40.0,44.0,57.0,59.0,49.0,48.0,52.0,38.0,57.0,58.0,51.0,55.0,54.0,53.0,50.0,35.0,47.0,47.0,53.0,40.0,33.0,46.0,44.0,39.0,49.0,41.0,31.0,40.0,44.0,33.0,42.0,45.0,41.0,46.0,27.0,45.0,41.0,44.0,34.0,43.0,41.0,46.0,39.0,52.0,32.0,33.0,32.0,23.0,26.0,25.0,30.0,32.0,33.0,28.0,24.0,22.0,24.0,14.0,26.0,15.0,12.0,16.0,15.0,18.0,13.0,18.0,13.0,22.0,21.0,17.0,14.0,20.0,12.0,17.0,19.0,24.0,17.0,22.0,11.0,17.0,15.0,10.0,8.0,18.0,13.0,12.0,11.0,14.0,12.0,18.0,10.0,7.0,10.0,9.0,10.0,4.0,10.0,2.0,6.0,5.0,4.0,5.0,6.0,7.0:2
6.0,9.0,9.0,4.0,3.0,8.0,5.0,7.0,10.0,5.0,4.0,4.0,4.0,1.0,2.0,1.0,2.0,2.0,2.0,2.0,1.0,2.0,7.0,2.0,4.0,1.0,4.0,2.0,6.0,3.0,1.0,2.0,1.0,3.0,4.0,0.0,2.0,6.0,0.0,1.0,3.0,1.0,6.0,1.0,1.0,2.0,5.0,0.0,1.0,1.0,2.0,2.0,2.0,4.0,2.0,5.0,2.0,5.0,2.0,5.0,5.0,6.0,8.0,7.0,3.0,11.0,17.0,7.0,16.0,15.0,16.0,15.0,11.0,19.0,13.0,19.0,16.0,19.0,20.0,17.0,24.0,26.0,27.0,29.0,23.0,20.0,43.0,34.0,33.0,35.0,42.0,30.0,41.0,48.0,47.0,46.0,37.0,36.0,24.0,32.0,26.0,34.0,36.0,42.0,44.0,27.0,38.0,34.0,39.0,30.0,44.0,47.0,34.0,29.0,30.0,33.0,27.0,33.0,34.0,24.0,30.0,34.0,22.0,22.0,28.0,27.0,33.0,17.0,27.0,18.0,10.0,19.0,17.0,16.0,17.0,27.0,19.0,18.0,21.0,22.0,28.0,22.0,26.0,23.0,31.0,22.0,19.0,23.0,14.0,23.0,26.0,15.0,22.0,25.0,14.0,20.0,32.0,17.0,28.0,22.0,28.0,19.0,16.0,22.0,27.0,28.0,18.0,25.0,21.0,27.0,21.0,28.0,24.0,27.0,40.0,30.0,38.0,34.0,33.0,27.0,29.0,38.0,33.0,24.0,25.0,29.0,35.0,41.0,28.0,37.0,40.0,36.0,36.0,30.0,26.0,36.0,32.0,44.0,28.0,19.0,36.0,26.0,21.0,20.0,30.0,34.0,35.0,31.0,38.0,38.0,37.0,33.0,36.0,36.0,36.0,26.0,44.0,42.0,35.0,41.0,24.0,36.0,28.0,32.0,44.0,39.0,38.0,31.0,38.0,37.0,26.0,30.0,27.0,31.0,24.0,32.0,45.0,32.0,30.0,34.0,28.0,28.0,24.0,13.0,31.0,24.0,23.0,30.0,18.0,18.0,19.0,20.0,13.0,22.0,23.0,32.0,20.0,22.0,26.0,42.0,20.0,35.0,42.0,34.0,32.0,35.0,33.0,27.0,28.0,54.0,64.0,60.0,48.0,56.0,55.0,42.0,45.0,42.0,41.0,38.0,41.0,38.0,23.0,20.0,22.0,10.0,11.0,10.0:2
16.0,11.0,5.0,8.0,3.0,6.0,11.0,10.0,4.0,8.0,9.0,4.0,6.0,8.0,2.0,9.0,3.0,14.0,7.0,2.0,3.0,8.0,3.0,6.0,2.0,8.0,7.0,3.0,5.0,12.0,9.0,4.0,7.0,4.0,2.0,3.0,1.0,3.0,2.0,6.0,2.0,2.0,3.0,4.0,2.0,2.0,3.0,2.0,3.0,5.0,4.0,0.0,5.0,0.0,3.0,3.0,4.0,0.0,2.0,3.0,10.0,3.0,2.0,3.0,5.0,8.0,4.0,2.0,3.0,6.0,6.0,4.0,4.0,8.0,6.0,10.0,6.0,11.0,12.0,7.0,17.0,14.0,9.0,14.0,5.0,9.0,14.0,10.0,10.0,14.0,19.0,20.0,14.0,10.0,20.0,13.0,20.0,17.0,16.0,14.0,13.0,12.0,15.0,19.0,24.0,24.0,10.0,17.0,29.0,25.0,20.0,19.0,20.0,30.0,22.0,25.0,30.0,23.0,17.0,33.0,14.0,20.0,24.0,17.0,14.0,15.0,22.0,22.0,26.0,25.0,23.0,20.0,25.0,29.0,24.0,22.0,23.0,30.0,19.0,26.0,23.0,20.0,21.0,23.0,33.0,22.0,13.0,22.0,23.0,23.0,15.0,17.0,24.0,28.0,16.0,17.0,30.0,17.0,29.0,27.0,38.0,26.0,33.0,40.0,26.0,24.0,41.0,29.0,28.0,26.0,33.0,19.0,35.0,32.0,31.0,23.0,24.0,26.0,29.0,24.0,22.0,29.0,23.0,18.0,19.0,29.0,41.0,26.0,36.0,34.0,27.0,28.0,33.0,46.0,50.0,38.0,47.0,46.0,42.0,50.0,54.0,36.0,46.0,39.0,34.0,58.0,50.0,33.0,43.0,25.0,29.0,37.0,41.0,27.0,24.0,18.0,12.0,24.0,25.0,22.0,18.0,10.0,18.0,20.0,48.0,27.0,22.0,22.0,17.0,31.0,19.0,29.0,23.0,26.0,31.0,28.0,16.0,28.0,31.0,17.0,20.0,18.0,30.0,10.0,10.0,19.0,24.0,13.0,13.0,21.0,14.0,22.0,7.0,19.0,12.0,21.0,26.0,30.0,22.0,28.0,21.0,28.0,14.0,20.0,26.0,18.0,18.0,23.0,15.0,16.0,23.0,22.0,27.0,34.0,28.0,26.0,17.0,17.0,21.0,23.0,18.0,28.0,12.0,22.0,21.0,16.0,21.0,6.0:2
8.0,5.0,4.0,5.0,7.0,7.0,4.0,7.0,9.0,8.0,2.0,7.0,7.0,3.0,4.0,7.0,5.0,8.0,7.0,3.0,4.0,4.0,6.0,8.0,2.0,7.0,5.0,8.0,6.0,2.0,2.0,4.0,5.0,0.0,5.0,3.0,7.0,6.0,4.0,2.0,1.0,3.0,1.0,1.0,1.0,3.0,2.0,3.0,3.0,1.0,1.0,0.0,4.0,1.0,2.0,5.0,4.0,3.0,3.0,6.0,2.0,4.0,4.0,2.0,2.0,3.0,1.0,2.0,9.0,2.0,6.0,2.0,3.0,6.0,5.0,5.0,3.0,6.0,7.0,6.0,13.0,2.0,17.0,4.0,4.0,4.0,9.0,6.0,7.0,9.0,12.0,14.0,10.0,13.0,5.0,10.0,8.0,13.0,9.0,12.0,17.0,8.0,10.0,8.0,13.0,10.0,8.0,10.0,8.0,3.0,8.0,8.0,12.0,16.0,15.0,11.0,16.0,18.0,16.0,20.0,11.0,18.0,13.0,12.0,16.0,18.0,16.0,15.0,22.0,18.0,11.0,19.0,8.0,18.0,13.0,16.0,17.0,19.0,20.0,11.0,23.0,11.0,22.0,32.0,24.0,17.0,34.0,13.0,20.0,22.0,12.0,14.0,17.0,17.0,18.0,17.0,18.0,18.0,17.0,18.0,19.0,23.0,13.0,21.0,27.0,23.0,16.0,22.0,24.0,27.0,15.0,21.0,18.0,29.0,12.0,20.0,29.0,18.0,20.0,20.0,15.0,17.0,20.0,17.0,18.0,19.0,17.0,15.0,17.0,23.0,14.0,17.0,18.0,20.0,13.0,20.0,13.0,23.0,18.0,12.0,22.0,16.0,13.0,17.0,15.0,20.0,23.0,19.0,20.0,15.0,27.0,13.0,11.0,13.0,19.0,19.0,21.0,5.0,11.0,16.0,11.0,18.0,12.0,18.0,22.0,13.0,13.0,13.0,18.0,18.0,19.0,25.0,23.0,32.0,31.0,28.0,38.0,44.0,48.0,46.0,45.0,51.0,52.0,52.0,45.0,50.0,56.0,61.0,48.0,33.0,19.0,16.0,24.0,19.0,25.0,16.0,12.0,15.0,10.0,13.0,10.0,13.0,11.0,18.0,17.0,12.0,9.0,20.0,13.0,18.0,11.0,13.0,8.0,7.0,11.0,7.0,6.0,11.0,8.0,7.0,5.0,10.0,2.0,7.0,4.0,9.0,6.0,4.0:2
10.0,9.0,2.0,7.0,3.0,3.0,4.0,3.0,2.0,2.0,7.0,4.0,1.0,4.0,2.0,6.0,1.0,3.0,3.0,4.0,1.0,5.0,1.0,6.0,5.0,1.0,7.0,1.0,3.0,2.0,2.0,2.0,1.0,4.0,1.0,2.0,4.0,1.0,3.0,1.0,5.0,6.0,1.0,2.0,2.0,3.0,2.0,1.0,2.0,3.0,0.0,2.0,2.0,2.0,1.0,4.0,6.0,8.0,5.0,2.0,4.0,5.0,6.0,7.0,5.0,7.0,7.0,3.0,16.0,3.0,14.0,9.0,11.0,21.0,21.0,11.0,17.0,23.0,17.0,31.0,28.0,32.0,24.0,35.0,27.0,36.0,37.0,45.0,47.0,26.0,40.0,45.0,53.0,45.0,32.0,29.0,30.0,40.0,31.0,42.0,38.0,33.0,34.0,47.0,48.0,51.0,47.0,43.0,35.0,31.0,33.0,45.0,32.0,30.0,36.0,29.0,36.0,40.0,34.0,28.0,28.0,27.0,20.0,21.0,23.0,18.0,20.0,26.0,32.0,38.0,24.0,25.0,22.0,27.0,19.0,23.0,20.0,24.0,25.0,17.0,22.0,33.0,16.0,19.0,27.0,23.0,13.0,35.0,22.0,21.0,31.0,26.0,25.0,34.0,23.0,27.0,24.0,26.0,34.0,29.0,26.0,17.0,18.0,19.0,32.0,26.0,28.0,22.0,21.0,27.0,21.0,39.0,28.0,25.0,30.0,45.0,38.0,40.0,41.0,42.0,27.0,40.0,42.0,32.0,43.0,34.0,32.0,32.0,44.0,43.0,47.0,45.0,38.0,41.0,39.0,41.0,44.0,40.0,35.0,31.0,30.0,36.0,49.0,45.0,41.0,35.0,32.0,28.0,27.0,34.0,23.0,27.0,37.0,38.0,22.0,19.0,20.0,29.0,30.0,18.0,25.0,27.0,35.0,25.0,22.0,24.0,25.0,29.0,29.0,28.0,19.0,33.0,20.0,24.0,26.0,27.0,33.0,25.0,19.0,16.0,27.0,19.0,28.0,12.0,22.0,24.0,15.0,19.0,19.0,12.0,18.0,15.0,25.0,19.0,23.0,20.0,21.0,26.0,27.0,29.0,27.0,30.0,46.0,30.0,34.0,29.0,35.0,23.0,19.0,26.0,15.0,10.0,10.0,6.0,6.0,13.0,8.0,10.0,12.0,13.0,13.0,10.0,19.0,10.0,10.0,9.0,2.0,4.0:2
9.0,8.0,13.0,5.0,11.0,11.0,15.0,13.0,5.0,16.0,11.0,13.0,14.0,11.0,8.0,6.0,10.0,4.0,14.0,7.0,9.0,9.0,13.0,5.0,15.0,5.0,8.0,7.0,9.0,5.0,4.0,7.0,10.0,7.0,5.0,4.0,7.0,5.0,3.0,3.0,5.0,3.0,5.0,9.0,6.0,4.0,2.0,5.0,12.0,2.0,7.0,12.0,5.0,12.0,6.0,7.0,3.0,7.0,5.0,4.0,5.0,5.0,7.0,4.0,3.0,3.0,4.0,12.0,10.0,11.0,14.0,7.0,10.0,7.0,13.0,10.0,7.0,6.0,11.0,13.0,18.0,11.0,13.0,15.0,17.0,12.0,12.0,17.0,15.0,16.0,18.0,21.0,19.0,13.0,20.0,14.0,17.0,20.0,9.0,10.0,9.0,9.0,15.0,18.0,19.0,20.0,10.0,15.0,16.0,15.0,15.0,8.0,15.0,15.0,15.0,19.0,21.0,27.0,21.0,16.0,28.0,21.0,25.0,21.0,27.0,20.0,23.0,10.0,24.0,19.0,18.0,25.0,20.0,19.0,24.0,16.0,25.0,23.0,29.0,25.0,33.0,41.0,28.0,20.0,21.0,23.0,20.0,24.0,27.0,36.0,19.0,26.0,20.0,21.0,24.0,28.0,24.0,19.0,22.0,23.0,28.0,28.0,31.0,30.0,21.0,25.0,37.0,22.0,22.0,24.0,17.0,32.0,28.0,30.0,38.0,31.0,36.0,36.0,31.0,42.0,43.0,35.0,40.0,35.0,31.0,25.0,36.0,43.0,43.0,44.0,43.0,44.0,47.0,49.0,46.0,53.0,52.0,45.0,52.0,51.0,51.0,50.0,50.0,43.0,49.0,48.0,51.0,29.0,36.0,24.0,30.0,34.0,22.0,34.0,18.0,20.0,22.0,24.0,24.0,30.0,23.0,22.0,28.0,21.0,24.0,23.0,24.0,20.0,25.0,22.0,25.0,28.0,26.0,16.0,20.0,17.0,26.0,20.0,18.0,20.0,20.0,22.0,21.0,14.0,24.0,26.0,20.0,18.0,20.0,13.0,19.0,12.0,8.0,9.0,10.0,15.0,13.0,20.0,16.0,14.0,10.0,15.0,12.0,17.0,16.0,20.0,19.0,13.0,15.0,10.0,10.0,9.0,14.0,7.0,13.0,8.0,11.0,15.0,7.0,7.0,8.0,7.0,10.0,5.0,9.0,3.0,7.0,7.0:2
4.0,5.0,6.0,2.0,5.0,6.0,6.0,8.0,7.0,5.0,2.0,0.0,2.0,3.0,5.0,3.0,6.0,7.0,4.0,2.0,7.0,7.0,4.0,1.0,4.0,2.0,6.0,4.0,4.0,3.0,0.0,4.0,7.0,2.0,3.0,6.0,2.0,2.0,1.0,4.0,3.0,7.0,2.0,4.0,1.0,3.0,1.0,5.0,1.0,2.0,5.0,2.0,3.0,2.0,4.0,3.0,4.0,9.0,7.0,3.0,9.0,1.0,1.0,4.0,6.0,9.0,10.0,10.0,14.0,17.0,13.0,12.0,12.0,14.0,11.0,16.0,24.0,18.0,16.0,19.0,22.0,17.0,21.0,23.0,37.0,35.0,34.0,49.0,33.0,28.0,41.0,18.0,26.0,26.0,31.0,34.0,29.0,39.0,36.0,29.0,28.0,34.0,42.0,29.0,43.0,33.0,39.0,40.0,41.0,42.0,41.0,34.0,37.0,28.0,28.0,20.0,29.0,33.0,44.0,24.0,36.0,29.0,34.0,26.0,22.0,24.0,23.0,22.0,32.0,36.0,23.0,12.0,27.0,35.0,36.0,35.0,32.0,22.0,22.0,36.0,26.0,36.0,30.0,31.0,21.0,18.0,31.0,25.0,26.0,24.0,24.0,33.0,28.0,25.0,28.0,26.0,26.0,16.0,31.0,39.0,26.0,33.0,24.0,26.0,31.0,27.0,28.0,31.0,22.0,27.0,36.0,40.0,25.0,21.0,38.0,22.0,48.0,36.0,36.0,40.0,34.0,22.0,43.0,29.0,33.0,27.0,44.0,39.0,41.0,26.0,29.0,39.0,29.0,36.0,36.0,27.0,39.0,41.0,36.0,26.0,24.0,32.0,31.0,32.0,30.0,24.0,30.0,33.0,35.0,31.0,17.0,36.0,34.0,31.0,28.0,25.0,25.0,21.0,17.0,41.0,27.0,37.0,39.0,10.0,24.0,26.0,23.0,39.0,25.0,29.0,26.0,37.0,28.0,31.0,23.0,32.0,45.0,21.0,33.0,28.0,29.0,25.0,28.0,23.0,15.0,24.0,22.0,13.0,22.0,20.0,16.0,22.0,19.0,23.0,11.0,28.0,30.0,24.0,26.0,32.0,38.0,44.0,33.0,49.0,44.0,37.0,18.0,27.0,44.0,49.0,70.0,51.0,43.0,47.0,41.0,29.0,26.0,23.0,30.0,20.0,18.0,17.0,13.0,14.0,10.0,12.0,12.0,14.0:2
11.0,4.0,8.0,14.0,5.0,12.0,8.0,10.0,8.0,5.0,2.0,13.0,13.0,9.0,11.0,7.0,6.0,10.0,7.0,6.0,4.0,3.0,5.0,5.0,9.0,8.0,5.0,8.0,7.0,4.0,7.0,9.0,11.0,3.0,4.0,2.0,3.0,1.0,2.0,8.0,2.0,4.0,3.0,2.0,3.0,1.0,1.0,3.0,2.0,3.0,6.0,3.0,0.0,5.0,2.0,3.0,1.0,6.0,5.0,8.0,6.0,5.0,6.0,1.0,5.0,0.0,7.0,5.0,4.0,6.0,3.0,4.0,11.0,6.0,5.0,7.0,9.0,3.0,6.0,9.0,14.0,14.0,14.0,19.0,11.0,20.0,9.0,15.0,12.0,11.0,8.0,17.0,21.0,12.0,18.0,16.0,9.0,14.0,20.0,13.0,15.0,17.0,17.0,17.0,26.0,33.0,19.0,22.0,28.0,19.0,23.0,22.0,9.0,21.0,27.0,22.0,26.0,41.0,29.0,21.0,13.0,23.0,19.0,26.0,20.0,25.0,15.0,20.0,21.0,36.0,16.0,24.0,18.0,19.0,19.0,25.0,22.0,20.0,20.0,33.0,22.0,32.0,25.0,27.0,14.0,28.0,25.0,36.0,35.0,23.0,33.0,38.0,26.0,34.0,29.0,27.0,30.0,29.0,18.0,29.0,31.0,26.0,32.0,27.0,39.0,28.0,33.0,25.0,23.0,18.0,33.0,33.0,22.0,30.0,25.0,24.0,33.0,25.0,31.0,36.0,28.0,26.0,25.0,31.0,30.0,26.0,29.0,37.0,26.0,28.0,26.0,28.0,32.0,23.0,28.0,29.0,26.0,24.0,26.0,24.0,17.0,26.0,19.0,26.0,25.0,27.0,25.0,27.0,27.0,23.0,26.0,24.0,29.0,22.0,25.0,22.0,14.0,25.0,32.0,25.0,24.0,22.0,27.0,29.0,36.0,17.0,28.0,26.0,24.0,39.0,21.0,25.0,27.0,28.0,38.0,41.0,32.0,42.0,26.0,28.0,27.0,25.0,19.0,29.0,27.0,24.0,25.0,20.0,14.0,24.0,16.0,29.0,28.0,19.0,27.0,31.0,33.0,27.0,35.0,37.0,43.0,44.0,55.0,36.0,55.0,41.0,41.0,45.0,46.0,40.0,41.0,29.0,19.0,28.0,35.0,23.0,14.0,16.0,13.0,18.0,19.0,12.0,19.0,12.0,12.0,7.0,6.0,3.0:2
?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,10.0,6.0,3.0,5.0,6.0,9.0,5.0,3.0,5.0,2.0,6.0,11.0,6.0,11.0,5.0,8.0,9.0,13.0,12.0,6.0,10.0,4.0,12.0,12.0,11.0,14.0,8.0,7.0,8.0,17.0,11.0,13.0,15.0,18.0,18.0,14.0,28.0,20.0,20.0,6.0,13.0,19.0,16.0,30.0,26.0,35.0,30.0,34.0,22.0,20.0,30.0,18.0,32.0,25.0,39.0,30.0,27.0,31.0,23.0,19.0,16.0,24.0,17.0,20.0,17.0,26.0,17.0,15.0,37.0,37.0,30.0,37.0,22.0,33.0,19.0,26.0,28.0,19.0,22.0,23.0,35.0,28.0,24.0,17.0,25.0,27.0,24.0,21.0,17.0,18.0,27.0,23.0,29.0,40.0,29.0,34.0,40.0,32.0,36.0,36.0,29.0,24.0,26.0,17.0,23.0,20.0,24.0,24.0,19.0,25.0,32.0,30.0,34.0,30.0,23.0,42.0,26.0,32.0,29.0,29.0,31.0,22.0,34.0,36.0,49.0,38.0,42.0,48.0,47.0,42.0,40.0,48.0,28.0,44.0,30.0,38.0,24.0,27.0,25.0,24.0,39.0,26.0,17.0,29.0,24.0,30.0,25.0,24.0,12.0,11.0,33.0,28.0,21.0,26.0,21.0,12.0,11.0,18.0,26.0,22.0,18.0,29.0,15.0,29.0,16.0,9.0,20.0,16.0,21.0,17.0,28.0,18.0,18.0,18.0,18.0,24.0,12.0,21.0,20.0,24.0,12.0,16.0,10.0,16.0,8.0,15.0,20.0,7.0,18.0,17.0,9.0,9.0,9.0,13.0,13.0,10.0,12.0,10.0,14.0,7.0,14.0,7.0,8.0,11.0,6.0,13.0,10.0,9.0,7.0,5.0,9.0,8.0,6.0,3.0,3.0,7.0,2.0:2
3.0,9.0,3.0,4.0,10.0,6.0,2.0,10.0,9.0,5.0,8.0,9.0,10.0,2.0,4.0,4.0,5.0,5.0,4.0,3.0,6.0,3.0,4.0,5.0,3.0,1.0,5.0,2.0,3.0,5.0,2.0,4.0,1.0,3.0,4.0,1.0,1.0,0.0,3.0,1.0,2.0,1.0,3.0,2.0,3.0,3.0,2.0,2.0,1.0,1.0,2.0,4.0,0.0,1.0,3.0,3.0,3.0,2.0,2.0,3.0,6.0,8.0,8.0,3.0,6.0,6.0,11.0,19.0,16.0,8.0,16.0,7.0,13.0,18.0,24.0,19.0,25.0,23.0,19.0,25.0,27.0,32.0,24.0,33.0,20.0,37.0,39.0,45.0,40.0,34.0,35.0,35.0,33.0,49.0,33.0,32.0,38.0,23.0,28.0,36.0,33.0,35.0,40.0,43.0,43.0,40.0,32.0,39.0,27.0,28.0,44.0,42.0,31.0,35.0,27.0,23.0,39.0,39.0,32.0,28.0,29.0,45.0,22.0,28.0,19.0,38.0,27.0,29.0,29.0,26.0,17.0,20.0,24.0,33.0,24.0,16.0,32.0,16.0,28.0,38.0,32.0,40.0,27.0,35.0,32.0,34.0,38.0,36.0,26.0,34.0,28.0,25.0,34.0,30.0,36.0,27.0,41.0,40.0,41.0,28.0,33.0,40.0,40.0,24.0,29.0,32.0,26.0,27.0,34.0,26.0,22.0,28.0,33.0,23.0,44.0,45.0,36.0,33.0,44.0,26.0,44.0,32.0,43.0,38.0,47.0,42.0,39.0,41.0,43.0,41.0,32.0,24.0,30.0,36.0,30.0,30.0,32.0,32.0,30.0,25.0,34.0,31.0,36.0,32.0,29.0,37.0,24.0,32.0,20.0,37.0,25.0,30.0,30.0,22.0,26.0,29.0,33.0,23.0,28.0,40.0,28.0,18.0,30.0,32.0,19.0,40.0,26.0,23.0,28.0,28.0,19.0,32.0,34.0,27.0,31.0,24.0,27.0,32.0,29.0,25.0,18.0,15.0,35.0,16.0,15.0,21.0,18.0,18.0,13.0,12.0,19.0,6.0,23.0,21.0,19.0,12.0,24.0,20.0,16.0,27.0,20.0,23.0,24.0,17.0,26.0,30.0,44.0,36.0,37.0,31.0,36.0,40.0,34.0,44.0,48.0,22.0,29.0,27.0,20.0,32.0,13.0,10.0,7.0,10.0,14.0,10.0,17.0,10.0:2
10.0,23.0,12.0,17.0,21.0,14.0,12.0,7.0,11.0,12.0,6.0,7.0,8.0,13.0,6.0,5.0,7.0,13.0,6.0,7.0,12.0,5.0,16.0,10.0,4.0,10.0,5.0,5.0,14.0,8.0,4.0,8.0,4.0,13.0,6.0,5.0,6.0,2.0,5.0,4.0,7.0,4.0,3.0,4.0,4.0,3.0,7.0,8.0,4.0,6.0,7.0,1.0,1.0,6.0,3.0,2.0,2.0,1.0,0.0,6.0,9.0,6.0,3.0,1.0,5.0,5.0,4.0,2.0,9.0,3.0,2.0,3.0,3.0,2.0,3.0,3.0,6.0,3.0,4.0,8.0,3.0,12.0,7.0,6.0,6.0,10.0,4.0,7.0,13.0,10.0,12.0,5.0,7.0,13.0,10.0,8.0,9.0,13.0,9.0,9.0,11.0,9.0,4.0,12.0,14.0,17.0,30.0,18.0,24.0,15.0,19.0,19.0,16.0,12.0,17.0,15.0,21.0,27.0,19.0,15.0,14.0,25.0,10.0,26.0,24.0,25.0,18.0,12.0,24.0,17.0,20.0,20.0,20.0,19.0,23.0,23.0,25.0,21.0,31.0,33.0,21.0,32.0,24.0,32.0,28.0,25.0,20.0,28.0,24.0,17.0,25.0,17.0,25.0,27.0,22.0,21.0,14.0,18.0,28.0,16.0,19.0,18.0,16.0,23.0,23.0,36.0,35.0,32.0,33.0,37.0,28.0,22.0,26.0,25.0,29.0,24.0,27.0,18.0,25.0,33.0,29.0,17.0,32.0,27.0,32.0,27.0,29.0,30.0,34.0,21.0,38.0,35.0,45.0,32.0,44.0,41.0,51.0,41.0,42.0,44.0,58.0,48.0,45.0,37.0,34.0,28.0,32.0,33.0,25.0,31.0,31.0,30.0,35.0,27.0,42.0,27.0,27.0,19.0,32.0,28.0,31.0,31.0,31.0,34.0,27.0,27.0,36.0,20.0,29.0,30.0,35.0,15.0,27.0,21.0,27.0,29.0,18.0,31.0,22.0,15.0,26.0,22.0,16.0,21.0,25.0,18.0,19.0,16.0,15.0,24.0,16.0,13.0,17.0,13.0,14.0,14.0,15.0,11.0,23.0,6.0,13.0,10.0,14.0,13.0,13.0,16.0,16.0,18.0,21.0,12.0,12.0,10.0,13.0,7.0,7.0,11.0,5.0,10.0,9.0,9.0,5.0,4.0,9.0,5.0,5.0,9.0,8.0,11.0:2
10.0,3.0,10.0,7.0,7.0,5.0,7.0,9.0,3.0,2.0,11.0,4.0,6.0,3.0,3.0,4.0,1.0,3.0,5.0,7.0,3.0,6.0,4.0,5.0,8.0,5.0,5.0,4.0,3.0,2.0,3.0,2.0,2.0,4.0,0.0,2.0,3.0,4.0,6.0,3.0,1.0,3.0,3.0,3.0,2.0,3.0,0.0,3.0,3.0,1.0,3.0,6.0,2.0,2.0,2.0,1.0,3.0,8.0,5.0,6.0,4.0,6.0,13.0,8.0,3.0,6.0,9.0,12.0,11.0,21.0,11.0,11.0,15.0,7.0,15.0,10.0,21.0,28.0,20.0,37.0,27.0,30.0,31.0,29.0,25.0,42.0,38.0,32.0,40.0,40.0,33.0,32.0,34.0,35.0,48.0,43.0,42.0,35.0,42.0,37.0,49.0,33.0,36.0,40.0,41.0,47.0,56.0,29.0,35.0,24.0,38.0,31.0,39.0,36.0,47.0,42.0,30.0,41.0,26.0,17.0,27.0,30.0,28.0,37.0,32.0,21.0,35.0,28.0,27.0,24.0,25.0,36.0,12.0,23.0,28.0,37.0,31.0,27.0,19.0,25.0,33.0,37.0,20.0,27.0,25.0,26.0,20.0,32.0,26.0,35.0,29.0,34.0,33.0,25.0,21.0,29.0,24.0,23.0,37.0,27.0,27.0,36.0,32.0,26.0,30.0,32.0,33.0,31.0,34.0,29.0,36.0,32.0,39.0,37.0,41.0,41.0,45.0,43.0,44.0,31.0,34.0,35.0,24.0,36.0,33.0,41.0,42.0,37.0,38.0,36.0,39.0,36.0,26.0,28.0,32.0,44.0,38.0,29.0,39.0,40.0,35.0,44.0,35.0,27.0,34.0,28.0,36.0,39.0,41.0,33.0,42.0,38.0,27.0,34.0,25.0,28.0,33.0,26.0,30.0,35.0,34.0,35.0,47.0,36.0,44.0,37.0,49.0,28.0,38.0,39.0,26.0,35.0,39.0,34.0,33.0,42.0,28.0,33.0,37.0,43.0,30.0,35.0,22.0,37.0,26.0,29.0,29.0,26.0,20.0,25.0,29.0,32.0,33.0,28.0,30.0,32.0,19.0,23.0,31.0,22.0,32.0,22.0,29.0,28.0,40.0,36.0,33.0,30.0,33.0,36.0,37.0,52.0,59.0,57.0,39.0,49.0,50.0,54.0,52.0,35.0,54.0,57.0,30.0,28.0,17.0,25.0,20.0,15.0:2
8.0,7.0,4.0,6.0,1.0,5.0,5.0,8.0,2.0,2.0,3.0,5.0,6.0,3.0,3.0,7.0,4.0,6.0,4.0,4.0,2.0,5.0,4.0,3.0,3.0,4.0,1.0,4.0,6.0,6.0,4.0,1.0,0.0,3.0,4.0,1.0,0.0,0.0,5.0,1.0,0.0,3.0,3.0,0.0,3.0,0.0,3.0,3.0,0.0,1.0,0.0,2.0,2.0,3.0,2.0,3.0,8.0,9.0,3.0,5.0,4.0,6.0,9.0,8.0,7.0,7.0,12.0,12.0,14.0,10.0,12.0,15.0,9.0,15.0,13.0,15.0,13.0,19.0,22.0,16.0,25.0,24.0,29.0,24.0,27.0,26.0,27.0,39.0,30.0,23.0,26.0,32.0,32.0,40.0,47.0,34.0,38.0,35.0,31.0,41.0,32.0,26.0,26.0,34.0,31.0,25.0,30.0,32.0,31.0,39.0,44.0,42.0,39.0,29.0,32.0,31.0,28.0,30.0,29.0,26.0,34.0,24.0,28.0,24.0,14.0,22.0,27.0,31.0,23.0,33.0,21.0,13.0,36.0,23.0,21.0,23.0,25.0,25.0,16.0,27.0,24.0,28.0,20.0,32.0,32.0,32.0,18.0,21.0,25.0,27.0,39.0,29.0,35.0,32.0,21.0,30.0,36.0,30.0,29.0,37.0,23.0,23.0,20.0,34.0,18.0,31.0,19.0,32.0,36.0,28.0,40.0,42.0,31.0,43.0,34.0,38.0,38.0,37.0,42.0,47.0,46.0,34.0,38.0,38.0,42.0,38.0,40.0,43.0,19.0,34.0,38.0,39.0,30.0,22.0,22.0,34.0,36.0,25.0,36.0,27.0,24.0,22.0,30.0,28.0,27.0,35.0,33.0,31.0,24.0,36.0,27.0,25.0,30.0,32.0,24.0,36.0,37.0,28.0,36.0,29.0,35.0,25.0,29.0,29.0,25.0,27.0,23.0,23.0,25.0,29.0,35.0,37.0,28.0,26.0,25.0,27.0,29.0,33.0,24.0,21.0,26.0,17.0,19.0,13.0,21.0,22.0,19.0,13.0,21.0,13.0,14.0,16.0,21.0,19.0,30.0,19.0,22.0,19.0,15.0,21.0,25.0,23.0,25.0,26.0,16.0,45.0,40.0,35.0,33.0,39.0,32.0,47.0,49.0,52.0,49.0,38.0,45.0,33.0,35.0,42.0,38.0,34.0,26.0,17.0,18.0,9.0,19.0,10.0:2
3.0,6.0,6.0,5.0,7.0,3.0,2.0,7.0,6.0,4.0,2.0,2.0,3.0,3.0,4.0,1.0,4.0,2.0,2.0,3.0,4.0,5.0,5.0,2.0,1.0,5.0,3.0,2.0,2.0,1.0,4.0,5.0,2.0,3.0,0.0,1.0,2.0,4.0,0.0,0.0,1.0,3.0,5.0,2.0,0.0,2.0,2.0,1.0,2.0,0.0,3.0,2.0,5.0,4.0,3.0,4.0,2.0,6.0,7.0,7.0,5.0,6.0,4.0,11.0,7.0,9.0,10.0,9.0,10.0,14.0,13.0,13.0,17.0,16.0,14.0,7.0,15.0,23.0,21.0,24.0,34.0,25.0,19.0,19.0,43.0,36.0,30.0,42.0,43.0,50.0,35.0,41.0,32.0,44.0,46.0,46.0,37.0,38.0,28.0,41.0,32.0,38.0,45.0,46.0,34.0,37.0,50.0,42.0,43.0,32.0,34.0,36.0,33.0,35.0,24.0,41.0,34.0,39.0,33.0,31.0,27.0,27.0,29.0,36.0,28.0,22.0,26.0,42.0,21.0,22.0,27.0,37.0,28.0,17.0,32.0,20.0,25.0,32.0,27.0,32.0,30.0,33.0,26.0,36.0,35.0,28.0,39.0,30.0,15.0,28.0,30.0,31.0,38.0,17.0,36.0,26.0,36.0,20.0,49.0,34.0,32.0,31.0,38.0,23.0,26.0,29.0,33.0,25.0,42.0,35.0,32.0,32.0,35.0,34.0,42.0,40.0,48.0,41.0,35.0,35.0,30.0,34.0,49.0,40.0,35.0,38.0,29.0,31.0,42.0,38.0,31.0,39.0,34.0,31.0,32.0,46.0,28.0,46.0,28.0,49.0,34.0,41.0,36.0,30.0,32.0,40.0,38.0,44.0,40.0,33.0,40.0,32.0,46.0,43.0,39.0,31.0,37.0,30.0,38.0,35.0,40.0,23.0,42.0,34.0,20.0,14.0,22.0,21.0,19.0,26.0,37.0,30.0,27.0,26.0,31.0,25.0,32.0,22.0,18.0,26.0,18.0,19.0,20.0,26.0,28.0,16.0,23.0,9.0,28.0,27.0,26.0,20.0,29.0,36.0,27.0,31.0,31.0,28.0,56.0,43.0,50.0,56.0,61.0,45.0,43.0,37.0,35.0,46.0,21.0,22.0,21.0,23.0,8.0,12.0,10.0,6.0,11.0,4.0,11.0,9.0,11.0,13.0,8.0,5.0,5.0,7.0,3.0,5.0:2
18.0,14.0,17.0,15.0,8.0,14.0,9.0,9.0,8.0,3.0,12.0,3.0,7.0,10.0,18.0,7.0,8.0,8.0,5.0,9.0,10.0,5.0,5.0,10.0,4.0,14.0,13.0,8.0,8.0,10.0,8.0,8.0,10.0,9.0,5.0,6.0,5.0,4.0,4.0,8.0,6.0,4.0,3.0,8.0,5.0,4.0,3.0,3.0,5.0,8.0,5.0,1.0,5.0,0.0,2.0,4.0,4.0,2.0,5.0,1.0,6.0,3.0,4.0,1.0,6.0,3.0,2.0,0.0,4.0,2.0,5.0,4.0,4.0,5.0,6.0,1.0,4.0,8.0,2.0,2.0,10.0,6.0,7.0,4.0,3.0,10.0,9.0,8.0,6.0,5.0,18.0,10.0,5.0,5.0,9.0,10.0,12.0,6.0,5.0,10.0,6.0,13.0,12.0,13.0,15.0,7.0,13.0,13.0,17.0,12.0,15.0,17.0,17.0,22.0,15.0,14.0,28.0,16.0,20.0,22.0,15.0,21.0,28.0,24.0,22.0,21.0,22.0,24.0,27.0,26.0,23.0,15.0,26.0,35.0,25.0,28.0,25.0,27.0,35.0,22.0,36.0,33.0,28.0,31.0,25.0,26.0,29.0,22.0,18.0,19.0,28.0,27.0,30.0,23.0,22.0,24.0,21.0,30.0,20.0,28.0,25.0,30.0,22.0,29.0,31.0,31.0,27.0,28.0,21.0,33.0,28.0,25.0,25.0,38.0,35.0,19.0,18.0,36.0,36.0,30.0,22.0,34.0,27.0,25.0,30.0,47.0,24.0,34.0,41.0,41.0,48.0,54.0,54.0,50.0,40.0,45.0,53.0,45.0,48.0,41.0,40.0,44.0,35.0,41.0,37.0,23.0,27.0,32.0,23.0,25.0,23.0,29.0,26.0,35.0,32.0,23.0,32.0,21.0,16.0,30.0,24.0,19.0,23.0,21.0,24.0,28.0,31.0,12.0,20.0,34.0,19.0,14.0,20.0,24.0,18.0,27.0,14.0,28.0,13.0,23.0,16.0,16.0,12.0,16.0,11.0,13.0,24.0,18.0,11.0,19.0,17.0,16.0,19.0,18.0,12.0,13.0,12.0,7.0,18.0,15.0,14.0,19.0,13.0,19.0,8.0,15.0,13.0,18.0,9.0,10.0,13.0,11.0,7.0,14.0,16.0,16.0,16.0,10.0,7.0,15.0,13.0,11.0,11.0,10.0,12.0,10.0,9.0,0.0:2
9.0,13.0,7.0,14.0,17.0,11.0,4.0,7.0,11.0,7.0,11.0,6.0,8.0,7.0,9.0,9.0,10.0,7.0,6.0,16.0,10.0,12.0,11.0,10.0,10.0,11.0,6.0,17.0,8.0,3.0,9.0,6.0,3.0,7.0,2.0,11.0,6.0,1.0,5.0,6.0,5.0,3.0,4.0,6.0,2.0,1.0,6.0,10.0,5.0,4.0,5.0,4.0,7.0,3.0,3.0,4.0,5.0,1.0,3.0,2.0,2.0,2.0,3.0,4.0,4.0,3.0,4.0,4.0,7.0,6.0,4.0,7.0,4.0,3.0,4.0,0.0,3.0,5.0,6.0,7.0,2.0,8.0,7.0,5.0,5.0,5.0,10.0,10.0,8.0,8.0,5.0,13.0,17.0,11.0,6.0,10.0,11.0,8.0,7.0,12.0,8.0,12.0,14.0,14.0,19.0,18.0,15.0,10.0,16.0,19.0,10.0,21.0,22.0,16.0,21.0,16.0,29.0,26.0,29.0,22.0,17.0,16.0,34.0,19.0,27.0,20.0,26.0,30.0,24.0,23.0,23.0,23.0,26.0,26.0,27.0,25.0,18.0,24.0,32.0,27.0,33.0,28.0,26.0,23.0,24.0,24.0,23.0,13.0,19.0,21.0,25.0,19.0,14.0,33.0,23.0,19.0,23.0,35.0,21.0,23.0,23.0,23.0,24.0,27.0,25.0,24.0,28.0,28.0,39.0,22.0,25.0,33.0,37.0,37.0,31.0,36.0,23.0,24.0,20.0,30.0,17.0,29.0,28.0,30.0,50.0,30.0,31.0,33.0,32.0,28.0,44.0,44.0,37.0,32.0,33.0,44.0,33.0,34.0,29.0,42.0,41.0,37.0,26.0,34.0,47.0,33.0,37.0,38.0,43.0,45.0,56.0,47.0,53.0,44.0,33.0,30.0,34.0,36.0,27.0,30.0,32.0,24.0,30.0,26.0,29.0,23.0,27.0,25.0,22.0,23.0,24.0,19.0,19.0,26.0,20.0,22.0,23.0,21.0,22.0,25.0,24.0,18.0,26.0,18.0,19.0,25.0,22.0,19.0,32.0,12.0,16.0,17.0,15.0,32.0,19.0,22.0,14.0,19.0,22.0,18.0,4.0,22.0,19.0,19.0,16.0,17.0,9.0,11.0,12.0,7.0,12.0,15.0,14.0,11.0,6.0,10.0,11.0,15.0,14.0,5.0,12.0,14.0,8.0,8.0,8.0,7.0,12.0,7.0:2
5.0,7.0,6.0,5.0,6.0,4.0,5.0,6.0,3.0,0.0,4.0,2.0,0.0,3.0,1.0,6.0,4.0,5.0,2.0,1.0,2.0,3.0,0.0,1.0,1.0,5.0,1.0,2.0,2.0,2.0,2.0,0.0,4.0,2.0,3.0,5.0,1.0,2.0,2.0,1.0,2.0,0.0,2.0,2.0,0.0,0.0,3.0,2.0,0.0,1.0,3.0,3.0,0.0,3.0,3.0,4.0,5.0,1.0,8.0,3.0,2.0,9.0,4.0,5.0,4.0,7.0,7.0,15.0,8.0,6.0,10.0,10.0,16.0,10.0,18.0,18.0,24.0,19.0,16.0,30.0,26.0,30.0,19.0,36.0,26.0,40.0,35.0,46.0,36.0,40.0,29.0,43.0,31.0,47.0,43.0,33.0,41.0,38.0,32.0,31.0,38.0,43.0,42.0,47.0,45.0,37.0,43.0,39.0,40.0,33.0,41.0,31.0,24.0,36.0,26.0,37.0,29.0,25.0,34.0,24.0,28.0,34.0,35.0,29.0,27.0,29.0,22.0,35.0,30.0,22.0,21.0,29.0,19.0,29.0,25.0,28.0,20.0,17.0,25.0,17.0,32.0,33.0,15.0,24.0,24.0,26.0,20.0,23.0,22.0,30.0,21.0,35.0,18.0,20.0,31.0,22.0,8.0,26.0,19.0,23.0,24.0,34.0,16.0,39.0,30.0,34.0,25.0,30.0,29.0,25.0,32.0,34.0,36.0,29.0,33.0,37.0,35.0,41.0,42.0,23.0,44.0,25.0,42.0,46.0,44.0,40.0,24.0,30.0,41.0,32.0,33.0,41.0,38.0,41.0,49.0,43.0,34.0,34.0,37.0,38.0,45.0,46.0,40.0,39.0,36.0,37.0,33.0,41.0,34.0,38.0,36.0,31.0,22.0,31.0,34.0,25.0,30.0,25.0,38.0,36.0,37.0,44.0,41.0,32.0,31.0,21.0,36.0,21.0,28.0,29.0,22.0,28.0,31.0,16.0,23.0,27.0,21.0,37.0,25.0,20.0,20.0,15.0,18.0,9.0,21.0,16.0,14.0,22.0,15.0,15.0,17.0,25.0,23.0,26.0,20.0,17.0,20.0,20.0,25.0,20.0,34.0,30.0,48.0,37.0,50.0,52.0,46.0,30.0,36.0,34.0,35.0,41.0,43.0,35.0,36.0,37.0,29.0,21.0,17.0,15.0,16.0,9.0,16.0,14.0,6.0,8.0,5.0,5.0:2
13.0,8.0,21.0,13.0,7.0,3.0,5.0,7.0,9.0,4.0,4.0,14.0,7.0,11.0,8.0,4.0,10.0,4.0,13.0,5.0,6.0,11.0,6.0,4.0,4.0,1.0,1.0,6.0,7.0,10.0,6.0,5.0,4.0,5.0,7.0,5.0,3.0,6.0,7.0,6.0,3.0,2.0,4.0,6.0,3.0,0.0,3.0,2.0,1.0,0.0,3.0,1.0,3.0,2.0,4.0,0.0,3.0,3.0,3.0,1.0,6.0,3.0,3.0,4.0,1.0,4.0,1.0,4.0,3.0,6.0,2.0,4.0,4.0,9.0,6.0,2.0,3.0,3.0,3.0,6.0,6.0,5.0,8.0,1.0,11.0,6.0,8.0,7.0,4.0,7.0,6.0,10.0,4.0,4.0,14.0,10.0,6.0,3.0,10.0,12.0,7.0,13.0,19.0,7.0,10.0,7.0,12.0,10.0,15.0,13.0,10.0,12.0,10.0,11.0,18.0,14.0,11.0,24.0,18.0,28.0,12.0,14.0,13.0,14.0,25.0,16.0,28.0,18.0,29.0,26.0,23.0,23.0,20.0,27.0,20.0,26.0,19.0,22.0,30.0,27.0,34.0,24.0,39.0,21.0,25.0,22.0,26.0,28.0,24.0,33.0,31.0,28.0,24.0,30.0,17.0,23.0,25.0,23.0,24.0,19.0,26.0,31.0,32.0,21.0,27.0,27.0,38.0,33.0,45.0,34.0,27.0,32.0,18.0,21.0,23.0,22.0,19.0,22.0,19.0,14.0,9.0,26.0,16.0,26.0,16.0,28.0,26.0,22.0,20.0,28.0,29.0,27.0,30.0,42.0,39.0,41.0,43.0,36.0,34.0,42.0,46.0,41.0,47.0,49.0,33.0,50.0,40.0,24.0,29.0,15.0,22.0,29.0,20.0,19.0,22.0,24.0,16.0,25.0,29.0,23.0,12.0,26.0,14.0,22.0,23.0,18.0,17.0,21.0,19.0,19.0,14.0,12.0,10.0,22.0,23.0,25.0,22.0,27.0,13.0,28.0,9.0,12.0,13.0,27.0,16.0,21.0,16.0,19.0,22.0,16.0,18.0,22.0,16.0,27.0,17.0,12.0,26.0,15.0,15.0,18.0,17.0,15.0,20.0,12.0,11.0,10.0,13.0,10.0,10.0,11.0,6.0,11.0,9.0,9.0,11.0,12.0,6.0,9.0,9.0,5.0,6.0,5.0,10.0,10.0,7.0,5.0,7.0,1.0:2
5.0,7.0,9.0,3.0,7.0,12.0,9.0,1.0,10.0,4.0,4.0,12.0,0.0,6.0,0.0,3.0,4.0,2.0,5.0,4.0,2.0,3.0,2.0,1.0,3.0,1.0,1.0,4.0,1.0,3.0,7.0,3.0,1.0,3.0,2.0,3.0,1.0,3.0,3.0,2.0,1.0,0.0,2.0,2.0,1.0,2.0,1.0,1.0,4.0,1.0,1.0,4.0,2.0,3.0,2.0,2.0,10.0,6.0,4.0,6.0,1.0,8.0,2.0,7.0,5.0,9.0,11.0,8.0,14.0,9.0,15.0,15.0,16.0,16.0,23.0,12.0,22.0,26.0,20.0,30.0,23.0,18.0,33.0,41.0,37.0,37.0,33.0,39.0,32.0,33.0,41.0,34.0,55.0,46.0,44.0,28.0,46.0,25.0,31.0,39.0,25.0,39.0,43.0,40.0,36.0,26.0,40.0,32.0,25.0,28.0,44.0,38.0,28.0,37.0,32.0,33.0,38.0,44.0,33.0,42.0,30.0,27.0,25.0,32.0,25.0,27.0,20.0,11.0,20.0,21.0,27.0,15.0,10.0,22.0,23.0,14.0,26.0,19.0,36.0,20.0,28.0,22.0,34.0,26.0,32.0,35.0,31.0,39.0,28.0,30.0,26.0,31.0,18.0,22.0,22.0,27.0,29.0,29.0,28.0,19.0,25.0,25.0,24.0,26.0,24.0,17.0,44.0,34.0,30.0,21.0,38.0,36.0,32.0,23.0,41.0,52.0,49.0,48.0,49.0,45.0,41.0,42.0,50.0,46.0,51.0,49.0,48.0,47.0,42.0,43.0,48.0,48.0,44.0,42.0,49.0,41.0,42.0,43.0,41.0,30.0,32.0,46.0,35.0,39.0,39.0,30.0,34.0,29.0,37.0,34.0,35.0,35.0,37.0,47.0,26.0,40.0,26.0,18.0,30.0,29.0,40.0,27.0,31.0,31.0,31.0,31.0,26.0,31.0,21.0,32.0,28.0,29.0,29.0,32.0,30.0,35.0,39.0,29.0,21.0,33.0,33.0,31.0,13.0,14.0,15.0,12.0,22.0,10.0,8.0,16.0,16.0,13.0,15.0,19.0,14.0,28.0,14.0,17.0,24.0,18.0,27.0,9.0,19.0,13.0,12.0,12.0,17.0,19.0,21.0,15.0,18.0,14.0,14.0,8.0,16.0,17.0,14.0,11.0,12.0,7.0,13.0,10.0,10.0,8.0,13.0,11.0,9.0,4.0:2
6.0,6.0,6.0,5.0,6.0,2.0,5.0,4.0,4.0,10.0,6.0,1.0,3.0,3.0,4.0,2.0,5.0,0.0,6.0,3.0,6.0,6.0,2.0,2.0,4.0,0.0,2.0,1.0,2.0,2.0,2.0,3.0,3.0,3.0,2.0,0.0,1.0,3.0,1.0,1.0,1.0,3.0,3.0,2.0,4.0,6.0,1.0,0.0,1.0,2.0,3.0,2.0,3.0,1.0,2.0,4.0,4.0,4.0,5.0,4.0,5.0,10.0,3.0,8.0,4.0,5.0,5.0,7.0,11.0,13.0,10.0,13.0,12.0,19.0,12.0,17.0,10.0,11.0,20.0,28.0,18.0,25.0,21.0,27.0,26.0,43.0,27.0,26.0,32.0,42.0,32.0,42.0,18.0,41.0,40.0,22.0,24.0,35.0,30.0,28.0,33.0,28.0,23.0,42.0,35.0,39.0,32.0,36.0,40.0,43.0,25.0,39.0,25.0,37.0,26.0,32.0,28.0,31.0,23.0,39.0,20.0,39.0,29.0,20.0,34.0,28.0,28.0,29.0,38.0,31.0,20.0,31.0,41.0,20.0,27.0,37.0,30.0,33.0,22.0,38.0,22.0,35.0,30.0,25.0,25.0,24.0,30.0,28.0,31.0,28.0,37.0,23.0,29.0,33.0,23.0,21.0,18.0,39.0,24.0,32.0,26.0,32.0,20.0,29.0,26.0,26.0,19.0,33.0,14.0,17.0,33.0,30.0,26.0,22.0,20.0,32.0,37.0,34.0,18.0,22.0,34.0,28.0,31.0,26.0,26.0,31.0,23.0,34.0,38.0,23.0,32.0,28.0,26.0,26.0,20.0,24.0,11.0,34.0,28.0,28.0,40.0,27.0,38.0,14.0,33.0,18.0,27.0,29.0,35.0,23.0,28.0,16.0,32.0,14.0,29.0,31.0,27.0,24.0,28.0,30.0,24.0,32.0,21.0,38.0,25.0,29.0,20.0,22.0,32.0,26.0,27.0,23.0,23.0,27.0,28.0,24.0,29.0,18.0,25.0,26.0,19.0,16.0,20.0,9.0,15.0,16.0,7.0,8.0,9.0,20.0,16.0,17.0,22.0,31.0,15.0,25.0,15.0,28.0,29.0,36.0,35.0,42.0,38.0,23.0,29.0,43.0,16.0,15.0,34.0,22.0,26.0,15.0,26.0,26.0,34.0,26.0,34.0,40.0,27.0,13.0,12.0,16.0,17.0,9.0,4.0,4.0,5.0,7.0:2
7.0,6.0,7.0,4.0,8.0,3.0,3.0,1.0,5.0,3.0,1.0,1.0,1.0,2.0,1.0,1.0,3.0,1.0,3.0,6.0,2.0,0.0,3.0,2.0,7.0,7.0,2.0,4.0,1.0,2.0,5.0,0.0,1.0,1.0,0.0,2.0,3.0,2.0,0.0,1.0,1.0,5.0,2.0,1.0,3.0,1.0,2.0,1.0,2.0,2.0,3.0,5.0,4.0,3.0,2.0,1.0,6.0,2.0,5.0,3.0,8.0,4.0,5.0,3.0,1.0,13.0,11.0,10.0,16.0,12.0,10.0,10.0,11.0,15.0,8.0,16.0,17.0,10.0,7.0,18.0,15.0,21.0,22.0,28.0,22.0,35.0,36.0,36.0,21.0,49.0,33.0,34.0,43.0,30.0,40.0,32.0,33.0,25.0,24.0,30.0,33.0,30.0,27.0,52.0,43.0,41.0,44.0,33.0,21.0,36.0,35.0,37.0,45.0,33.0,35.0,38.0,33.0,25.0,38.0,27.0,35.0,36.0,28.0,32.0,31.0,29.0,33.0,39.0,37.0,19.0,37.0,26.0,16.0,17.0,25.0,15.0,38.0,18.0,17.0,19.0,21.0,14.0,24.0,21.0,27.0,19.0,19.0,25.0,23.0,26.0,22.0,27.0,21.0,19.0,25.0,21.0,22.0,32.0,24.0,22.0,25.0,20.0,22.0,29.0,11.0,20.0,29.0,28.0,28.0,22.0,28.0,26.0,31.0,22.0,43.0,28.0,42.0,45.0,40.0,26.0,30.0,25.0,28.0,39.0,33.0,35.0,39.0,43.0,41.0,35.0,43.0,29.0,30.0,38.0,37.0,40.0,39.0,39.0,21.0,23.0,22.0,42.0,46.0,39.0,35.0,40.0,40.0,40.0,36.0,31.0,28.0,30.0,22.0,26.0,27.0,23.0,34.0,41.0,30.0,39.0,29.0,31.0,47.0,43.0,37.0,39.0,33.0,38.0,33.0,35.0,38.0,36.0,29.0,22.0,35.0,17.0,28.0,24.0,21.0,12.0,16.0,17.0,17.0,9.0,16.0,20.0,12.0,9.0,12.0,21.0,15.0,7.0,21.0,13.0,22.0,16.0,21.0,22.0,20.0,31.0,43.0,29.0,40.0,37.0,37.0,26.0,46.0,34.0,42.0,31.0,47.0,37.0,32.0,23.0,18.0,11.0,10.0,9.0,6.0,10.0,5.0,5.0,9.0,7.0,13.0,3.0,8.0,13.0:2
17.0,11.0,9.0,3.0,14.0,16.0,10.0,9.0,5.0,7.0,11.0,8.0,9.0,9.0,11.0,7.0,8.0,4.0,7.0,4.0,3.0,10.0,3.0,6.0,9.0,12.0,5.0,3.0,5.0,7.0,6.0,7.0,1.0,7.0,6.0,6.0,5.0,5.0,7.0,2.0,7.0,4.0,7.0,3.0,7.0,9.0,4.0,2.0,2.0,4.0,8.0,2.0,3.0,7.0,6.0,2.0,3.0,2.0,4.0,3.0,2.0,2.0,4.0,2.0,1.0,7.0,6.0,2.0,7.0,2.0,7.0,1.0,3.0,3.0,3.0,5.0,6.0,10.0,7.0,7.0,4.0,8.0,7.0,13.0,13.0,18.0,11.0,20.0,14.0,23.0,28.0,21.0,20.0,27.0,21.0,16.0,24.0,21.0,21.0,26.0,24.0,22.0,21.0,32.0,27.0,37.0,20.0,30.0,26.0,30.0,37.0,30.0,21.0,37.0,27.0,27.0,22.0,30.0,33.0,20.0,34.0,26.0,29.0,29.0,15.0,19.0,20.0,17.0,32.0,30.0,20.0,33.0,11.0,24.0,21.0,29.0,16.0,17.0,23.0,19.0,28.0,30.0,30.0,35.0,28.0,31.0,27.0,26.0,24.0,26.0,27.0,21.0,17.0,12.0,31.0,31.0,32.0,22.0,30.0,23.0,22.0,23.0,24.0,17.0,16.0,26.0,39.0,23.0,17.0,31.0,34.0,30.0,34.0,31.0,34.0,29.0,38.0,25.0,38.0,35.0,36.0,33.0,51.0,42.0,34.0,32.0,28.0,46.0,64.0,62.0,56.0,51.0,58.0,55.0,56.0,53.0,57.0,56.0,58.0,46.0,40.0,27.0,26.0,27.0,24.0,29.0,35.0,30.0,31.0,36.0,27.0,26.0,29.0,27.0,20.0,26.0,14.0,27.0,23.0,27.0,28.0,28.0,19.0,29.0,19.0,22.0,19.0,30.0,26.0,17.0,20.0,22.0,28.0,16.0,29.0,17.0,31.0,15.0,30.0,17.0,22.0,22.0,20.0,28.0,26.0,19.0,17.0,17.0,18.0,14.0,21.0,11.0,17.0,23.0,24.0,10.0,11.0,22.0,17.0,15.0,14.0,8.0,16.0,14.0,7.0,13.0,11.0,12.0,15.0,11.0,13.0,12.0,11.0,11.0,11.0,10.0,7.0,8.0,3.0,14.0,7.0,5.0,6.0,11.0,13.0,3.0,8.0,4.0:2
6.0,5.0,4.0,4.0,4.0,4.0,4.0,2.0,12.0,2.0,3.0,1.0,1.0,3.0,3.0,0.0,0.0,3.0,7.0,3.0,3.0,2.0,2.0,2.0,3.0,3.0,1.0,3.0,3.0,2.0,2.0,0.0,0.0,0.0,2.0,1.0,0.0,2.0,1.0,2.0,0.0,1.0,2.0,1.0,1.0,1.0,2.0,1.0,3.0,2.0,4.0,2.0,3.0,1.0,3.0,2.0,2.0,4.0,7.0,5.0,4.0,2.0,8.0,2.0,6.0,8.0,9.0,13.0,14.0,8.0,12.0,13.0,9.0,9.0,15.0,14.0,16.0,12.0,21.0,30.0,25.0,29.0,32.0,26.0,40.0,31.0,36.0,38.0,51.0,40.0,43.0,36.0,38.0,34.0,38.0,35.0,35.0,32.0,29.0,29.0,34.0,33.0,42.0,53.0,34.0,48.0,41.0,46.0,40.0,45.0,39.0,41.0,29.0,30.0,29.0,30.0,36.0,36.0,23.0,29.0,31.0,30.0,35.0,32.0,31.0,30.0,31.0,36.0,36.0,20.0,25.0,30.0,24.0,18.0,25.0,26.0,30.0,15.0,18.0,20.0,24.0,29.0,25.0,26.0,25.0,27.0,28.0,16.0,26.0,27.0,26.0,34.0,32.0,26.0,32.0,19.0,27.0,23.0,24.0,27.0,30.0,27.0,32.0,30.0,32.0,27.0,38.0,37.0,42.0,43.0,40.0,33.0,31.0,37.0,37.0,42.0,33.0,27.0,36.0,35.0,37.0,26.0,44.0,42.0,36.0,30.0,38.0,43.0,47.0,36.0,53.0,35.0,42.0,33.0,37.0,40.0,30.0,36.0,29.0,41.0,33.0,40.0,14.0,37.0,23.0,42.0,39.0,31.0,23.0,28.0,18.0,31.0,29.0,22.0,25.0,31.0,42.0,35.0,30.0,31.0,33.0,31.0,39.0,32.0,46.0,33.0,32.0,14.0,33.0,31.0,34.0,28.0,26.0,28.0,46.0,27.0,32.0,20.0,22.0,21.0,19.0,21.0,13.0,12.0,26.0,27.0,21.0,22.0,17.0,15.0,22.0,27.0,25.0,29.0,30.0,23.0,19.0,19.0,27.0,31.0,28.0,32.0,36.0,30.0,54.0,39.0,66.0,49.0,61.0,35.0,38.0,49.0,45.0,44.0,31.0,10.0,12.0,13.0,7.0,7.0,15.0,10.0,4.0,10.0,6.0,10.0,6.0,16.0:2
14.0,10.0,9.0,14.0,8.0,15.0,11.0,7.0,3.0,10.0,9.0,15.0,3.0,7.0,6.0,3.0,17.0,7.0,4.0,10.0,6.0,8.0,10.0,6.0,2.0,6.0,11.0,4.0,2.0,8.0,5.0,5.0,11.0,3.0,2.0,4.0,5.0,4.0,3.0,3.0,11.0,1.0,4.0,3.0,6.0,1.0,4.0,6.0,3.0,9.0,7.0,5.0,5.0,8.0,6.0,5.0,5.0,11.0,3.0,6.0,7.0,8.0,5.0,9.0,11.0,13.0,17.0,9.0,10.0,8.0,19.0,18.0,12.0,18.0,12.0,14.0,10.0,25.0,20.0,26.0,22.0,36.0,24.0,29.0,37.0,39.0,48.0,42.0,36.0,39.0,40.0,45.0,42.0,47.0,40.0,45.0,39.0,37.0,39.0,33.0,45.0,39.0,39.0,38.0,42.0,45.0,40.0,37.0,41.0,43.0,40.0,43.0,32.0,25.0,31.0,37.0,41.0,30.0,39.0,28.0,25.0,35.0,35.0,33.0,28.0,25.0,29.0,39.0,21.0,22.0,22.0,23.0,20.0,25.0,24.0,15.0,15.0,20.0,22.0,20.0,32.0,32.0,22.0,26.0,16.0,20.0,33.0,27.0,29.0,32.0,23.0,31.0,38.0,31.0,30.0,20.0,16.0,32.0,24.0,27.0,23.0,38.0,36.0,34.0,29.0,21.0,31.0,24.0,26.0,24.0,25.0,23.0,31.0,38.0,29.0,31.0,38.0,37.0,33.0,27.0,39.0,40.0,46.0,39.0,37.0,32.0,39.0,39.0,41.0,35.0,33.0,32.0,26.0,31.0,29.0,41.0,41.0,41.0,35.0,29.0,37.0,36.0,37.0,30.0,42.0,44.0,35.0,34.0,31.0,33.0,33.0,32.0,33.0,33.0,34.0,35.0,32.0,34.0,36.0,38.0,38.0,35.0,34.0,32.0,30.0,23.0,23.0,34.0,32.0,38.0,29.0,34.0,34.0,34.0,24.0,26.0,29.0,16.0,30.0,21.0,28.0,24.0,16.0,15.0,13.0,21.0,19.0,17.0,11.0,19.0,10.0,22.0,20.0,26.0,30.0,24.0,28.0,28.0,39.0,35.0,15.0,27.0,33.0,29.0,29.0,14.0,40.0,26.0,31.0,47.0,24.0,20.0,29.0,25.0,18.0,20.0,14.0,10.0,15.0,9.0,13.0,9.0,6.0,17.0,4.0,9.0,7.0,5.0:2
6.0,5.0,3.0,13.0,10.0,6.0,8.0,6.0,6.0,12.0,6.0,4.0,6.0,7.0,4.0,7.0,6.0,6.0,4.0,5.0,8.0,3.0,5.0,4.0,9.0,5.0,5.0,5.0,4.0,5.0,3.0,6.0,4.0,2.0,1.0,1.0,2.0,3.0,6.0,4.0,1.0,4.0,3.0,1.0,4.0,3.0,4.0,1.0,4.0,2.0,1.0,2.0,1.0,1.0,4.0,0.0,4.0,7.0,4.0,3.0,4.0,9.0,2.0,12.0,13.0,7.0,16.0,11.0,15.0,21.0,11.0,12.0,7.0,21.0,18.0,16.0,19.0,25.0,24.0,29.0,24.0,31.0,32.0,28.0,33.0,30.0,37.0,42.0,43.0,35.0,32.0,38.0,42.0,36.0,29.0,27.0,46.0,33.0,38.0,39.0,23.0,36.0,35.0,40.0,46.0,43.0,33.0,43.0,41.0,40.0,30.0,49.0,35.0,29.0,29.0,29.0,28.0,36.0,34.0,24.0,43.0,25.0,35.0,23.0,19.0,30.0,41.0,37.0,30.0,33.0,38.0,21.0,16.0,33.0,25.0,29.0,25.0,25.0,28.0,21.0,36.0,21.0,32.0,22.0,17.0,25.0,32.0,27.0,32.0,33.0,25.0,21.0,26.0,31.0,35.0,24.0,32.0,18.0,17.0,28.0,34.0,26.0,28.0,22.0,21.0,23.0,30.0,40.0,30.0,18.0,36.0,33.0,27.0,34.0,43.0,33.0,32.0,43.0,33.0,30.0,33.0,22.0,40.0,47.0,34.0,43.0,29.0,28.0,35.0,42.0,34.0,25.0,30.0,34.0,35.0,41.0,37.0,28.0,35.0,36.0,36.0,34.0,34.0,25.0,35.0,36.0,29.0,37.0,38.0,33.0,29.0,45.0,29.0,34.0,50.0,40.0,32.0,43.0,48.0,36.0,40.0,34.0,28.0,44.0,32.0,26.0,36.0,30.0,31.0,47.0,29.0,41.0,20.0,41.0,43.0,27.0,40.0,29.0,35.0,28.0,25.0,25.0,21.0,22.0,18.0,22.0,18.0,21.0,22.0,14.0,21.0,21.0,24.0,21.0,21.0,24.0,18.0,29.0,28.0,20.0,30.0,18.0,18.0,19.0,15.0,18.0,23.0,23.0,22.0,21.0,25.0,23.0,30.0,40.0,39.0,22.0,19.0,37.0,32.0,54.0,40.0,32.0,21.0,14.0,18.0,14.0,11.0,6.0:2
15.0,21.0,8.0,16.0,7.0,11.0,9.0,15.0,7.0,6.0,6.0,6.0,6.0,7.0,9.0,7.0,8.0,8.0,7.0,2.0,8.0,11.0,5.0,7.0,13.0,14.0,3.0,10.0,2.0,5.0,9.0,6.0,5.0,5.0,4.0,5.0,4.0,3.0,4.0,2.0,6.0,2.0,2.0,4.0,2.0,1.0,3.0,1.0,1.0,1.0,5.0,0.0,6.0,2.0,3.0,2.0,3.0,4.0,7.0,5.0,4.0,5.0,0.0,2.0,7.0,7.0,3.0,7.0,4.0,6.0,8.0,6.0,5.0,10.0,6.0,4.0,8.0,11.0,6.0,13.0,17.0,14.0,10.0,8.0,21.0,10.0,7.0,9.0,16.0,20.0,21.0,22.0,9.0,13.0,19.0,14.0,16.0,13.0,17.0,21.0,18.0,21.0,24.0,21.0,23.0,17.0,33.0,23.0,29.0,16.0,16.0,14.0,14.0,18.0,28.0,20.0,20.0,21.0,30.0,28.0,18.0,18.0,31.0,26.0,29.0,15.0,24.0,15.0,26.0,27.0,23.0,30.0,30.0,24.0,22.0,24.0,28.0,28.0,17.0,22.0,22.0,22.0,21.0,20.0,20.0,32.0,20.0,26.0,26.0,17.0,17.0,23.0,24.0,16.0,29.0,21.0,32.0,29.0,28.0,25.0,28.0,12.0,24.0,18.0,22.0,15.0,20.0,18.0,21.0,20.0,20.0,30.0,25.0,30.0,27.0,37.0,24.0,27.0,34.0,29.0,31.0,34.0,36.0,31.0,29.0,31.0,30.0,29.0,43.0,41.0,43.0,34.0,48.0,34.0,48.0,51.0,46.0,47.0,52.0,48.0,44.0,56.0,49.0,52.0,44.0,50.0,52.0,39.0,26.0,28.0,33.0,22.0,18.0,27.0,26.0,23.0,21.0,23.0,25.0,38.0,34.0,33.0,39.0,39.0,29.0,40.0,25.0,34.0,35.0,28.0,32.0,29.0,37.0,21.0,31.0,32.0,40.0,39.0,31.0,33.0,29.0,22.0,22.0,35.0,22.0,23.0,18.0,21.0,23.0,19.0,24.0,33.0,17.0,18.0,23.0,32.0,22.0,28.0,29.0,20.0,27.0,20.0,18.0,18.0,20.0,17.0,28.0,16.0,16.0,27.0,30.0,16.0,32.0,24.0,29.0,18.0,8.0,15.0,15.0,13.0,10.0,6.0,13.0,15.0,14.0,16.0,8.0,8.0:2
7.0,6.0,3.0,6.0,11.0,3.0,7.0,3.0,4.0,5.0,2.0,3.0,3.0,4.0,3.0,5.0,1.0,2.0,1.0,3.0,4.0,5.0,0.0,2.0,1.0,3.0,0.0,4.0,1.0,1.0,7.0,2.0,4.0,2.0,3.0,0.0,4.0,2.0,1.0,3.0,3.0,0.0,3.0,1.0,3.0,3.0,0.0,4.0,2.0,1.0,1.0,5.0,6.0,3.0,3.0,6.0,4.0,4.0,5.0,3.0,5.0,3.0,5.0,3.0,3.0,9.0,8.0,6.0,16.0,11.0,12.0,5.0,15.0,20.0,10.0,17.0,18.0,28.0,16.0,18.0,24.0,20.0,31.0,31.0,36.0,31.0,32.0,45.0,35.0,39.0,44.0,47.0,42.0,37.0,28.0,29.0,39.0,39.0,20.0,41.0,41.0,39.0,35.0,41.0,35.0,32.0,45.0,32.0,28.0,31.0,37.0,39.0,32.0,29.0,38.0,34.0,24.0,20.0,27.0,29.0,28.0,37.0,37.0,22.0,36.0,27.0,19.0,30.0,26.0,24.0,19.0,15.0,20.0,25.0,28.0,27.0,28.0,30.0,28.0,27.0,32.0,28.0,24.0,28.0,18.0,26.0,22.0,22.0,28.0,25.0,33.0,18.0,22.0,33.0,19.0,19.0,27.0,34.0,29.0,28.0,25.0,33.0,22.0,34.0,23.0,27.0,23.0,31.0,22.0,22.0,35.0,27.0,36.0,29.0,32.0,34.0,38.0,38.0,50.0,43.0,37.0,20.0,41.0,38.0,43.0,45.0,28.0,37.0,37.0,51.0,49.0,26.0,40.0,40.0,43.0,37.0,40.0,30.0,35.0,34.0,32.0,36.0,22.0,32.0,32.0,46.0,44.0,27.0,38.0,36.0,31.0,30.0,23.0,34.0,39.0,25.0,31.0,31.0,30.0,30.0,29.0,37.0,37.0,34.0,30.0,29.0,24.0,21.0,29.0,20.0,21.0,34.0,31.0,20.0,13.0,16.0,16.0,17.0,19.0,18.0,20.0,24.0,18.0,20.0,32.0,19.0,15.0,23.0,18.0,14.0,13.0,24.0,20.0,28.0,27.0,40.0,28.0,30.0,27.0,10.0,22.0,39.0,34.0,32.0,44.0,29.0,36.0,30.0,20.0,16.0,18.0,15.0,14.0,7.0,7.0,12.0,8.0,10.0,15.0,12.0,9.0,10.0,8.0,5.0,3.0,1.0,5.0,4.0:2
2.0,4.0,4.0,4.0,7.0,3.0,5.0,3.0,4.0,4.0,6.0,0.0,2.0,1.0,1.0,2.0,1.0,5.0,6.0,3.0,2.0,2.0,2.0,3.0,1.0,2.0,2.0,3.0,2.0,2.0,0.0,1.0,3.0,0.0,1.0,6.0,3.0,1.0,0.0,0.0,2.0,3.0,1.0,2.0,1.0,2.0,1.0,1.0,2.0,1.0,3.0,1.0,4.0,0.0,4.0,3.0,2.0,4.0,9.0,5.0,8.0,6.0,7.0,6.0,9.0,8.0,7.0,11.0,15.0,14.0,12.0,15.0,11.0,11.0,15.0,23.0,18.0,19.0,27.0,24.0,30.0,29.0,35.0,22.0,18.0,33.0,40.0,47.0,36.0,35.0,43.0,37.0,40.0,34.0,44.0,37.0,43.0,41.0,39.0,50.0,41.0,39.0,42.0,30.0,43.0,41.0,47.0,39.0,27.0,26.0,21.0,25.0,42.0,24.0,37.0,30.0,12.0,33.0,35.0,32.0,43.0,34.0,32.0,30.0,26.0,34.0,23.0,20.0,28.0,27.0,33.0,24.0,26.0,24.0,19.0,28.0,32.0,24.0,21.0,29.0,35.0,23.0,21.0,26.0,18.0,28.0,22.0,26.0,23.0,16.0,32.0,17.0,25.0,30.0,24.0,23.0,33.0,23.0,20.0,26.0,19.0,30.0,39.0,38.0,20.0,34.0,32.0,17.0,19.0,19.0,29.0,19.0,31.0,25.0,31.0,25.0,37.0,27.0,29.0,39.0,37.0,32.0,48.0,37.0,26.0,28.0,40.0,22.0,46.0,49.0,32.0,41.0,25.0,43.0,34.0,26.0,28.0,34.0,44.0,38.0,32.0,34.0,34.0,23.0,38.0,29.0,43.0,35.0,30.0,25.0,25.0,35.0,35.0,41.0,33.0,30.0,28.0,35.0,28.0,36.0,46.0,36.0,31.0,41.0,38.0,29.0,39.0,29.0,32.0,37.0,38.0,27.0,33.0,23.0,28.0,35.0,22.0,30.0,32.0,23.0,21.0,19.0,19.0,20.0,25.0,14.0,19.0,19.0,19.0,9.0,12.0,20.0,17.0,31.0,35.0,32.0,36.0,19.0,19.0,21.0,14.0,17.0,22.0,21.0,33.0,23.0,20.0,21.0,29.0,41.0,43.0,48.0,47.0,31.0,19.0,17.0,9.0,10.0,13.0,6.0,8.0,6.0,9.0,9.0,5.0,5.0,7.0,9.0:2
13.0,7.0,9.0,10.0,10.0,8.0,6.0,11.0,15.0,9.0,11.0,13.0,5.0,11.0,7.0,10.0,13.0,13.0,9.0,1.0,7.0,21.0,4.0,4.0,3.0,5.0,6.0,7.0,8.0,12.0,4.0,6.0,7.0,6.0,4.0,7.0,3.0,6.0,7.0,4.0,4.0,5.0,6.0,8.0,3.0,2.0,1.0,9.0,4.0,10.0,3.0,6.0,5.0,2.0,7.0,2.0,4.0,6.0,4.0,1.0,3.0,4.0,5.0,5.0,5.0,2.0,3.0,1.0,6.0,8.0,4.0,4.0,3.0,2.0,6.0,5.0,4.0,10.0,3.0,11.0,7.0,4.0,7.0,9.0,4.0,9.0,9.0,8.0,12.0,7.0,10.0,12.0,10.0,14.0,16.0,10.0,12.0,12.0,15.0,9.0,16.0,10.0,14.0,14.0,17.0,15.0,21.0,19.0,20.0,14.0,14.0,22.0,14.0,18.0,17.0,27.0,18.0,28.0,13.0,30.0,22.0,15.0,26.0,22.0,22.0,15.0,21.0,26.0,31.0,28.0,32.0,14.0,24.0,25.0,30.0,25.0,17.0,19.0,25.0,29.0,28.0,19.0,28.0,20.0,23.0,17.0,27.0,17.0,29.0,15.0,23.0,17.0,16.0,21.0,18.0,24.0,29.0,34.0,36.0,21.0,32.0,20.0,25.0,24.0,26.0,23.0,29.0,40.0,45.0,32.0,25.0,31.0,22.0,28.0,31.0,24.0,29.0,24.0,29.0,26.0,37.0,33.0,35.0,36.0,28.0,39.0,42.0,41.0,45.0,56.0,51.0,50.0,62.0,55.0,57.0,53.0,49.0,55.0,48.0,28.0,28.0,19.0,28.0,32.0,28.0,29.0,25.0,21.0,23.0,24.0,33.0,28.0,25.0,23.0,22.0,13.0,26.0,21.0,24.0,23.0,17.0,30.0,19.0,28.0,24.0,29.0,22.0,14.0,24.0,22.0,23.0,25.0,19.0,27.0,37.0,19.0,18.0,21.0,20.0,20.0,33.0,30.0,20.0,19.0,26.0,27.0,15.0,11.0,20.0,14.0,12.0,19.0,14.0,14.0,10.0,13.0,12.0,16.0,11.0,16.0,8.0,18.0,11.0,9.0,11.0,16.0,12.0,17.0,14.0,13.0,14.0,12.0,2.0,12.0,8.0,18.0,12.0,14.0,8.0,19.0,7.0,11.0,5.0,8.0,13.0,11.0,13.0,6.0:2
2.0,6.0,4.0,5.0,1.0,5.0,4.0,6.0,6.0,4.0,2.0,5.0,6.0,7.0,2.0,4.0,5.0,5.0,3.0,9.0,9.0,2.0,3.0,4.0,5.0,4.0,1.0,5.0,3.0,5.0,2.0,2.0,3.0,6.0,0.0,2.0,3.0,1.0,3.0,4.0,1.0,4.0,4.0,1.0,1.0,0.0,0.0,1.0,3.0,3.0,2.0,6.0,2.0,1.0,0.0,2.0,4.0,6.0,4.0,2.0,2.0,10.0,5.0,10.0,10.0,7.0,10.0,11.0,10.0,14.0,12.0,9.0,10.0,12.0,20.0,16.0,17.0,9.0,18.0,34.0,25.0,29.0,17.0,25.0,36.0,30.0,38.0,34.0,35.0,33.0,31.0,29.0,47.0,32.0,38.0,38.0,41.0,38.0,30.0,39.0,31.0,42.0,32.0,34.0,34.0,46.0,49.0,33.0,38.0,40.0,40.0,20.0,33.0,31.0,21.0,32.0,37.0,34.0,31.0,30.0,33.0,34.0,32.0,32.0,22.0,30.0,26.0,24.0,28.0,14.0,29.0,28.0,33.0,19.0,16.0,16.0,29.0,38.0,32.0,35.0,22.0,29.0,27.0,25.0,23.0,15.0,30.0,32.0,31.0,34.0,19.0,26.0,20.0,21.0,24.0,16.0,16.0,20.0,30.0,24.0,22.0,32.0,24.0,28.0,18.0,17.0,29.0,26.0,23.0,34.0,27.0,24.0,31.0,26.0,31.0,34.0,41.0,32.0,26.0,40.0,38.0,23.0,35.0,31.0,51.0,30.0,39.0,47.0,37.0,35.0,45.0,39.0,33.0,35.0,48.0,37.0,27.0,36.0,24.0,24.0,28.0,33.0,38.0,47.0,36.0,20.0,30.0,28.0,35.0,41.0,29.0,34.0,38.0,30.0,25.0,33.0,35.0,28.0,44.0,45.0,40.0,37.0,28.0,40.0,36.0,29.0,35.0,30.0,30.0,17.0,27.0,24.0,28.0,27.0,35.0,25.0,31.0,31.0,33.0,22.0,19.0,18.0,25.0,21.0,22.0,31.0,17.0,16.0,22.0,20.0,22.0,23.0,18.0,24.0,25.0,21.0,22.0,24.0,24.0,17.0,13.0,18.0,27.0,19.0,39.0,33.0,27.0,29.0,34.0,18.0,22.0,32.0,51.0,50.0,54.0,24.0,21.0,12.0,17.0,10.0,13.0,8.0,9.0,7.0,7.0,13.0,20.0,6.0:2
9.0,5.0,4.0,4.0,6.0,10.0,3.0,6.0,1.0,1.0,4.0,2.0,2.0,3.0,3.0,4.0,3.0,1.0,2.0,3.0,8.0,5.0,1.0,5.0,1.0,4.0,0.0,3.0,0.0,1.0,3.0,4.0,1.0,1.0,1.0,1.0,0.0,1.0,0.0,3.0,0.0,1.0,5.0,2.0,0.0,0.0,1.0,2.0,3.0,2.0,2.0,1.0,1.0,6.0,1.0,4.0,4.0,6.0,4.0,2.0,2.0,3.0,5.0,2.0,2.0,3.0,14.0,8.0,13.0,10.0,8.0,14.0,13.0,17.0,17.0,18.0,21.0,18.0,19.0,33.0,21.0,39.0,17.0,30.0,26.0,36.0,42.0,45.0,29.0,37.0,34.0,37.0,43.0,39.0,46.0,41.0,34.0,30.0,21.0,21.0,33.0,38.0,34.0,33.0,38.0,45.0,41.0,30.0,48.0,37.0,45.0,33.0,37.0,34.0,32.0,36.0,34.0,35.0,28.0,25.0,20.0,25.0,38.0,24.0,28.0,21.0,33.0,27.0,26.0,30.0,21.0,19.0,25.0,15.0,23.0,19.0,23.0,23.0,24.0,20.0,24.0,28.0,29.0,32.0,22.0,19.0,34.0,16.0,31.0,21.0,28.0,24.0,33.0,31.0,26.0,28.0,26.0,24.0,33.0,27.0,23.0,15.0,18.0,25.0,13.0,16.0,28.0,33.0,17.0,25.0,39.0,25.0,31.0,41.0,39.0,45.0,30.0,42.0,35.0,42.0,36.0,30.0,43.0,34.0,34.0,40.0,30.0,36.0,45.0,43.0,35.0,32.0,39.0,42.0,29.0,35.0,39.0,29.0,32.0,40.0,44.0,30.0,37.0,32.0,33.0,37.0,46.0,22.0,35.0,25.0,30.0,32.0,35.0,26.0,38.0,28.0,33.0,42.0,31.0,29.0,38.0,40.0,37.0,36.0,31.0,39.0,32.0,35.0,19.0,16.0,29.0,27.0,24.0,25.0,31.0,19.0,19.0,23.0,31.0,12.0,12.0,21.0,24.0,13.0,13.0,18.0,23.0,15.0,9.0,18.0,24.0,11.0,23.0,17.0,36.0,33.0,19.0,20.0,21.0,31.0,31.0,32.0,49.0,42.0,48.0,46.0,36.0,28.0,32.0,22.0,15.0,18.0,21.0,8.0,15.0,8.0,4.0,13.0,5.0,3.0,4.0,5.0,11.0,5.0,4.0,10.0,12.0,9.0:2
12.0,9.0,7.0,2.0,7.0,2.0,6.0,7.0,3.0,8.0,1.0,5.0,3.0,2.0,4.0,0.0,6.0,3.0,2.0,5.0,4.0,3.0,1.0,1.0,1.0,4.0,5.0,3.0,4.0,1.0,2.0,1.0,3.0,2.0,1.0,2.0,3.0,2.0,4.0,2.0,5.0,7.0,1.0,0.0,1.0,1.0,1.0,5.0,1.0,3.0,2.0,1.0,3.0,3.0,3.0,3.0,3.0,10.0,10.0,5.0,4.0,2.0,5.0,5.0,10.0,6.0,11.0,8.0,14.0,4.0,15.0,8.0,10.0,16.0,13.0,8.0,14.0,23.0,20.0,22.0,28.0,26.0,32.0,26.0,33.0,33.0,44.0,32.0,31.0,36.0,32.0,36.0,42.0,33.0,36.0,26.0,35.0,36.0,29.0,49.0,42.0,38.0,30.0,38.0,36.0,45.0,45.0,32.0,34.0,37.0,27.0,29.0,13.0,28.0,33.0,25.0,40.0,46.0,35.0,16.0,41.0,20.0,22.0,27.0,26.0,16.0,31.0,33.0,20.0,38.0,34.0,17.0,22.0,17.0,20.0,24.0,18.0,21.0,27.0,19.0,23.0,34.0,35.0,29.0,27.0,28.0,20.0,36.0,49.0,23.0,37.0,26.0,33.0,22.0,28.0,35.0,27.0,33.0,40.0,20.0,30.0,38.0,11.0,29.0,43.0,25.0,15.0,23.0,28.0,12.0,40.0,22.0,23.0,20.0,27.0,23.0,75.0,47.0,23.0,30.0,43.0,25.0,47.0,33.0,27.0,30.0,11.0,26.0,30.0,30.0,39.0,12.0,10.0,51.0,29.0,21.0,28.0,24.0,37.0,29.0,39.0,20.0,30.0,45.0,24.0,36.0,25.0,28.0,31.0,45.0,23.0,23.0,33.0,23.0,31.0,37.0,25.0,43.0,23.0,35.0,33.0,28.0,38.0,17.0,27.0,30.0,15.0,38.0,26.0,18.0,34.0,20.0,24.0,42.0,39.0,39.0,19.0,43.0,23.0,42.0,3.0,33.0,26.0,36.0,21.0,25.0,18.0,32.0,21.0,28.0,21.0,19.0,22.0,23.0,26.0,24.0,20.0,27.0,29.0,40.0,34.0,39.0,24.0,38.0,43.0,44.0,60.0,40.0,54.0,60.0,50.0,55.0,46.0,49.0,53.0,36.0,32.0,24.0,10.0,24.0,25.0,22.0,20.0,25.0,10.0,10.0,16.0,10.0:2
4.0,6.0,11.0,10.0,3.0,7.0,7.0,7.0,4.0,6.0,4.0,4.0,4.0,7.0,3.0,1.0,3.0,4.0,2.0,1.0,8.0,1.0,6.0,6.0,3.0,5.0,2.0,4.0,7.0,2.0,3.0,3.0,3.0,1.0,2.0,2.0,2.0,1.0,0.0,1.0,3.0,0.0,0.0,3.0,1.0,1.0,2.0,1.0,1.0,0.0,0.0,3.0,3.0,3.0,2.0,2.0,3.0,7.0,6.0,8.0,3.0,9.0,8.0,0.0,8.0,11.0,12.0,13.0,8.0,13.0,12.0,13.0,12.0,19.0,32.0,22.0,24.0,30.0,25.0,47.0,37.0,43.0,42.0,26.0,39.0,38.0,36.0,31.0,42.0,41.0,27.0,50.0,30.0,47.0,40.0,31.0,35.0,48.0,46.0,39.0,36.0,31.0,25.0,46.0,45.0,48.0,54.0,36.0,31.0,33.0,32.0,33.0,35.0,38.0,38.0,47.0,32.0,39.0,44.0,45.0,37.0,30.0,35.0,38.0,30.0,43.0,32.0,35.0,32.0,36.0,36.0,35.0,24.0,30.0,35.0,30.0,30.0,38.0,37.0,42.0,30.0,36.0,31.0,33.0,36.0,23.0,28.0,32.0,33.0,28.0,35.0,28.0,30.0,21.0,33.0,40.0,42.0,32.0,28.0,34.0,27.0,37.0,44.0,29.0,31.0,32.0,37.0,34.0,36.0,40.0,29.0,35.0,45.0,42.0,52.0,45.0,55.0,48.0,47.0,55.0,38.0,54.0,56.0,57.0,58.0,55.0,53.0,41.0,53.0,58.0,53.0,46.0,43.0,55.0,47.0,39.0,43.0,43.0,32.0,35.0,33.0,47.0,44.0,48.0,28.0,39.0,34.0,35.0,44.0,39.0,38.0,33.0,40.0,45.0,36.0,40.0,42.0,41.0,50.0,40.0,38.0,49.0,40.0,40.0,45.0,40.0,56.0,53.0,51.0,34.0,43.0,32.0,40.0,25.0,31.0,36.0,31.0,27.0,34.0,37.0,26.0,25.0,30.0,29.0,21.0,31.0,23.0,27.0,21.0,28.0,26.0,17.0,36.0,31.0,32.0,35.0,24.0,25.0,28.0,24.0,26.0,17.0,26.0,19.0,22.0,17.0,16.0,23.0,20.0,16.0,16.0,8.0,13.0,12.0,11.0,9.0,10.0,17.0,23.0,10.0,11.0,10.0,5.0,12.0,8.0,6.0,9.0,9.0:2
4.0,1.0,7.0,2.0,6.0,1.0,3.0,7.0,1.0,1.0,3.0,1.0,3.0,0.0,4.0,3.0,2.0,3.0,1.0,3.0,1.0,2.0,1.0,0.0,0.0,4.0,2.0,3.0,2.0,2.0,2.0,2.0,2.0,0.0,1.0,7.0,1.0,1.0,1.0,2.0,2.0,2.0,2.0,1.0,0.0,3.0,1.0,1.0,3.0,2.0,0.0,4.0,1.0,3.0,2.0,1.0,7.0,7.0,3.0,8.0,6.0,3.0,4.0,8.0,7.0,4.0,7.0,9.0,16.0,10.0,12.0,7.0,12.0,19.0,15.0,14.0,23.0,23.0,21.0,21.0,29.0,21.0,28.0,34.0,26.0,48.0,35.0,41.0,43.0,35.0,42.0,30.0,35.0,26.0,42.0,23.0,27.0,40.0,29.0,19.0,23.0,28.0,29.0,36.0,39.0,43.0,34.0,19.0,36.0,34.0,28.0,31.0,44.0,38.0,31.0,39.0,42.0,34.0,34.0,32.0,28.0,17.0,32.0,23.0,28.0,37.0,30.0,30.0,27.0,29.0,33.0,17.0,21.0,21.0,20.0,29.0,37.0,35.0,15.0,22.0,33.0,33.0,31.0,38.0,27.0,36.0,30.0,29.0,25.0,31.0,28.0,42.0,29.0,37.0,38.0,42.0,26.0,37.0,31.0,26.0,34.0,31.0,28.0,32.0,34.0,27.0,32.0,17.0,27.0,18.0,29.0,36.0,37.0,40.0,32.0,46.0,33.0,40.0,39.0,35.0,35.0,28.0,38.0,35.0,31.0,44.0,42.0,32.0,30.0,32.0,28.0,32.0,22.0,34.0,28.0,33.0,31.0,32.0,30.0,38.0,25.0,27.0,22.0,36.0,31.0,29.0,25.0,32.0,38.0,43.0,44.0,34.0,29.0,29.0,26.0,31.0,24.0,32.0,31.0,25.0,39.0,29.0,33.0,39.0,25.0,30.0,27.0,22.0,29.0,17.0,19.0,25.0,22.0,23.0,30.0,18.0,24.0,26.0,14.0,22.0,15.0,16.0,12.0,22.0,19.0,16.0,25.0,17.0,21.0,18.0,19.0,12.0,13.0,27.0,19.0,23.0,26.0,8.0,14.0,22.0,21.0,21.0,23.0,15.0,31.0,22.0,24.0,24.0,18.0,10.0,47.0,40.0,57.0,51.0,16.0,30.0,11.0,28.0,17.0,15.0,12.0,6.0,7.0,10.0,4.0,3.0,8.0,11.0:2
15.0,13.0,5.0,11.0,7.0,9.0,6.0,8.0,4.0,7.0,3.0,10.0,3.0,8.0,8.0,5.0,3.0,14.0,12.0,5.0,1.0,4.0,5.0,9.0,4.0,4.0,4.0,8.0,3.0,7.0,7.0,8.0,6.0,8.0,3.0,3.0,5.0,3.0,8.0,5.0,4.0,4.0,7.0,6.0,3.0,4.0,7.0,3.0,3.0,9.0,3.0,2.0,2.0,0.0,6.0,3.0,1.0,3.0,5.0,3.0,0.0,1.0,1.0,7.0,1.0,1.0,3.0,3.0,3.0,3.0,4.0,4.0,2.0,1.0,7.0,7.0,3.0,2.0,6.0,6.0,8.0,7.0,6.0,7.0,5.0,4.0,8.0,7.0,6.0,11.0,5.0,12.0,10.0,12.0,7.0,6.0,6.0,11.0,12.0,8.0,10.0,6.0,6.0,17.0,4.0,8.0,6.0,9.0,2.0,8.0,4.0,13.0,14.0,21.0,13.0,14.0,6.0,13.0,24.0,17.0,20.0,15.0,20.0,23.0,23.0,17.0,31.0,20.0,15.0,22.0,21.0,19.0,19.0,25.0,18.0,23.0,23.0,22.0,23.0,24.0,28.0,31.0,34.0,26.0,26.0,10.0,21.0,22.0,19.0,21.0,27.0,32.0,20.0,25.0,29.0,19.0,22.0,26.0,28.0,23.0,19.0,20.0,23.0,26.0,31.0,20.0,30.0,37.0,37.0,25.0,33.0,33.0,28.0,36.0,46.0,31.0,26.0,37.0,41.0,30.0,34.0,30.0,24.0,34.0,23.0,21.0,25.0,13.0,26.0,32.0,27.0,28.0,22.0,21.0,21.0,13.0,17.0,20.0,19.0,21.0,28.0,26.0,21.0,29.0,32.0,20.0,22.0,27.0,20.0,21.0,19.0,12.0,26.0,23.0,16.0,16.0,27.0,21.0,24.0,20.0,24.0,19.0,11.0,23.0,26.0,18.0,31.0,14.0,18.0,17.0,16.0,21.0,20.0,17.0,14.0,9.0,13.0,18.0,10.0,14.0,19.0,10.0,13.0,26.0,20.0,18.0,20.0,12.0,22.0,15.0,18.0,20.0,18.0,18.0,8.0,14.0,22.0,5.0,10.0,14.0,3.0,21.0,14.0,27.0,32.0,21.0,17.0,19.0,19.0,19.0,16.0,24.0,13.0,16.0,38.0,59.0,66.0,57.0,58.0,58.0,51.0,38.0,52.0,37.0,72.0,37.0,44.0,8.0:2
41.0,36.0,20.0,15.0,15.0,9.0,15.0,17.0,7.0,10.0,6.0,6.0,4.0,5.0,5.0,3.0,10.0,15.0,7.0,12.0,10.0,9.0,8.0,10.0,7.0,10.0,13.0,2.0,4.0,4.0,4.0,4.0,2.0,2.0,6.0,5.0,6.0,2.0,8.0,1.0,0.0,4.0,1.0,2.0,3.0,3.0,3.0,0.0,1.0,3.0,2.0,4.0,3.0,6.0,3.0,5.0,7.0,3.0,0.0,4.0,2.0,7.0,5.0,3.0,6.0,2.0,5.0,5.0,3.0,5.0,5.0,7.0,8.0,6.0,7.0,9.0,6.0,6.0,12.0,10.0,6.0,12.0,10.0,18.0,10.0,13.0,9.0,8.0,20.0,10.0,24.0,14.0,21.0,16.0,18.0,17.0,15.0,19.0,20.0,10.0,20.0,22.0,29.0,20.0,25.0,29.0,18.0,36.0,16.0,15.0,22.0,26.0,25.0,28.0,24.0,30.0,30.0,32.0,18.0,19.0,33.0,23.0,20.0,20.0,13.0,25.0,21.0,11.0,27.0,25.0,35.0,29.0,22.0,20.0,19.0,24.0,22.0,25.0,23.0,23.0,22.0,28.0,33.0,20.0,28.0,28.0,22.0,13.0,25.0,26.0,22.0,29.0,22.0,24.0,28.0,35.0,36.0,43.0,34.0,24.0,36.0,30.0,42.0,23.0,32.0,39.0,25.0,31.0,31.0,32.0,33.0,33.0,26.0,26.0,32.0,36.0,34.0,22.0,33.0,31.0,28.0,47.0,39.0,34.0,39.0,31.0,46.0,33.0,42.0,47.0,48.0,53.0,58.0,56.0,62.0,52.0,58.0,54.0,49.0,56.0,55.0,55.0,56.0,51.0,45.0,50.0,38.0,50.0,32.0,36.0,40.0,39.0,31.0,36.0,27.0,19.0,17.0,28.0,30.0,21.0,32.0,44.0,34.0,36.0,39.0,23.0,28.0,41.0,41.0,31.0,33.0,37.0,28.0,25.0,31.0,31.0,43.0,31.0,32.0,27.0,39.0,27.0,26.0,22.0,25.0,30.0,20.0,31.0,21.0,15.0,26.0,14.0,32.0,16.0,15.0,23.0,22.0,22.0,15.0,27.0,22.0,30.0,27.0,28.0,37.0,26.0,22.0,25.0,20.0,25.0,14.0,17.0,23.0,18.0,13.0,33.0,17.0,16.0,22.0,17.0,13.0,17.0,15.0,19.0,12.0,20.0,15.0,13.0:2
22.0,17.0,7.0,11.0,11.0,5.0,3.0,10.0,9.0,11.0,5.0,6.0,4.0,4.0,8.0,4.0,5.0,7.0,1.0,7.0,10.0,8.0,5.0,4.0,6.0,6.0,8.0,13.0,13.0,5.0,7.0,4.0,13.0,3.0,4.0,1.0,3.0,3.0,4.0,2.0,1.0,2.0,3.0,3.0,2.0,0.0,3.0,3.0,2.0,0.0,4.0,1.0,1.0,1.0,2.0,1.0,4.0,6.0,4.0,3.0,0.0,4.0,4.0,4.0,4.0,6.0,6.0,3.0,9.0,8.0,6.0,3.0,11.0,4.0,11.0,6.0,12.0,12.0,11.0,10.0,13.0,8.0,8.0,12.0,8.0,10.0,21.0,15.0,11.0,17.0,22.0,17.0,16.0,7.0,14.0,15.0,14.0,10.0,21.0,21.0,13.0,11.0,20.0,29.0,27.0,15.0,11.0,14.0,18.0,18.0,14.0,17.0,19.0,29.0,24.0,31.0,26.0,24.0,18.0,16.0,27.0,26.0,26.0,31.0,24.0,28.0,26.0,17.0,30.0,29.0,20.0,16.0,22.0,35.0,26.0,30.0,22.0,26.0,23.0,35.0,24.0,15.0,16.0,18.0,36.0,20.0,27.0,21.0,16.0,24.0,26.0,23.0,21.0,31.0,32.0,18.0,21.0,25.0,23.0,27.0,24.0,31.0,16.0,19.0,28.0,20.0,16.0,22.0,20.0,24.0,24.0,30.0,23.0,23.0,25.0,19.0,24.0,30.0,27.0,27.0,26.0,31.0,28.0,20.0,30.0,22.0,23.0,25.0,29.0,29.0,15.0,18.0,24.0,31.0,29.0,36.0,32.0,18.0,32.0,23.0,20.0,25.0,27.0,30.0,27.0,21.0,30.0,25.0,32.0,33.0,23.0,28.0,15.0,23.0,25.0,8.0,31.0,16.0,18.0,28.0,18.0,21.0,25.0,21.0,26.0,23.0,23.0,23.0,18.0,18.0,31.0,38.0,25.0,24.0,13.0,16.0,26.0,29.0,24.0,23.0,14.0,24.0,21.0,8.0,21.0,10.0,26.0,17.0,15.0,17.0,21.0,11.0,17.0,27.0,38.0,31.0,32.0,49.0,47.0,41.0,57.0,43.0,50.0,57.0,46.0,42.0,47.0,48.0,52.0,55.0,37.0,48.0,28.0,23.0,20.0,25.0,27.0,22.0,29.0,24.0,24.0,26.0,16.0,20.0,10.0,18.0,9.0,11.0:2
17.0,11.0,9.0,16.0,10.0,4.0,10.0,13.0,7.0,11.0,11.0,7.0,4.0,13.0,9.0,17.0,5.0,14.0,7.0,4.0,10.0,9.0,9.0,9.0,10.0,5.0,11.0,9.0,1.0,9.0,8.0,8.0,7.0,7.0,6.0,3.0,7.0,9.0,3.0,7.0,4.0,14.0,4.0,3.0,2.0,6.0,3.0,3.0,4.0,6.0,1.0,3.0,9.0,3.0,8.0,4.0,0.0,2.0,1.0,3.0,3.0,3.0,3.0,3.0,4.0,4.0,4.0,2.0,4.0,3.0,8.0,3.0,0.0,2.0,1.0,3.0,3.0,4.0,5.0,8.0,10.0,1.0,6.0,10.0,6.0,9.0,7.0,8.0,9.0,8.0,9.0,5.0,4.0,14.0,12.0,12.0,16.0,6.0,13.0,9.0,7.0,7.0,17.0,11.0,15.0,18.0,19.0,18.0,15.0,12.0,14.0,19.0,16.0,12.0,17.0,13.0,18.0,21.0,11.0,30.0,26.0,16.0,11.0,16.0,15.0,19.0,21.0,21.0,24.0,16.0,13.0,16.0,17.0,21.0,28.0,32.0,17.0,20.0,26.0,24.0,31.0,29.0,31.0,31.0,28.0,27.0,26.0,21.0,29.0,20.0,29.0,19.0,24.0,29.0,22.0,19.0,24.0,36.0,30.0,20.0,33.0,28.0,22.0,26.0,29.0,33.0,40.0,34.0,21.0,35.0,41.0,31.0,26.0,29.0,28.0,23.0,42.0,36.0,19.0,28.0,14.0,28.0,36.0,3.0,38.0,34.0,37.0,21.0,37.0,28.0,38.0,28.0,28.0,61.0,39.0,47.0,43.0,34.0,40.0,41.0,55.0,28.0,40.0,38.0,13.0,17.0,20.0,38.0,21.0,30.0,16.0,14.0,12.0,10.0,28.0,22.0,24.0,28.0,38.0,18.0,20.0,30.0,34.0,26.0,27.0,34.0,24.0,37.0,26.0,28.0,30.0,14.0,30.0,34.0,36.0,22.0,29.0,19.0,18.0,24.0,19.0,19.0,21.0,17.0,25.0,17.0,15.0,22.0,27.0,19.0,14.0,17.0,25.0,14.0,19.0,21.0,13.0,14.0,25.0,20.0,7.0,9.0,16.0,14.0,7.0,16.0,9.0,8.0,14.0,8.0,10.0,14.0,16.0,10.0,15.0,10.0,17.0,7.0,7.0,9.0,12.0,4.0,5.0,4.0,10.0,6.0,4.0,3.0:2
18.0,12.0,14.0,13.0,8.0,7.0,7.0,6.0,13.0,8.0,6.0,3.0,11.0,7.0,4.0,7.0,5.0,8.0,5.0,8.0,8.0,13.0,5.0,11.0,6.0,6.0,5.0,4.0,3.0,3.0,4.0,2.0,5.0,14.0,3.0,1.0,2.0,5.0,1.0,4.0,4.0,4.0,1.0,6.0,2.0,3.0,4.0,3.0,3.0,4.0,6.0,5.0,2.0,4.0,2.0,6.0,2.0,3.0,3.0,1.0,7.0,2.0,6.0,5.0,2.0,6.0,5.0,7.0,7.0,4.0,1.0,9.0,10.0,8.0,8.0,2.0,9.0,4.0,7.0,12.0,9.0,14.0,17.0,11.0,14.0,8.0,8.0,11.0,14.0,17.0,11.0,17.0,11.0,20.0,24.0,15.0,16.0,10.0,19.0,16.0,22.0,27.0,35.0,18.0,31.0,31.0,14.0,20.0,19.0,20.0,23.0,13.0,26.0,27.0,22.0,23.0,28.0,30.0,29.0,21.0,26.0,27.0,13.0,29.0,22.0,34.0,21.0,31.0,24.0,34.0,20.0,23.0,16.0,22.0,32.0,24.0,27.0,19.0,25.0,35.0,25.0,32.0,23.0,29.0,14.0,21.0,19.0,24.0,20.0,22.0,28.0,25.0,33.0,36.0,27.0,22.0,31.0,24.0,20.0,20.0,21.0,29.0,20.0,29.0,22.0,14.0,17.0,22.0,23.0,13.0,39.0,29.0,38.0,21.0,14.0,34.0,27.0,25.0,19.0,34.0,22.0,26.0,29.0,27.0,35.0,27.0,36.0,41.0,27.0,23.0,33.0,31.0,27.0,24.0,34.0,30.0,36.0,23.0,31.0,32.0,26.0,32.0,29.0,28.0,30.0,36.0,26.0,28.0,31.0,30.0,20.0,41.0,35.0,33.0,22.0,32.0,21.0,20.0,40.0,32.0,39.0,37.0,26.0,32.0,32.0,35.0,27.0,32.0,21.0,18.0,30.0,26.0,22.0,31.0,27.0,14.0,31.0,23.0,19.0,24.0,37.0,22.0,23.0,39.0,26.0,33.0,21.0,24.0,29.0,31.0,19.0,18.0,16.0,20.0,23.0,23.0,35.0,32.0,21.0,43.0,42.0,42.0,37.0,38.0,29.0,29.0,40.0,24.0,38.0,52.0,50.0,50.0,51.0,28.0,17.0,26.0,36.0,26.0,28.0,24.0,11.0,20.0,28.0,20.0,22.0,19.0,16.0,24.0:2
7.0,6.0,5.0,4.0,6.0,3.0,8.0,4.0,5.0,8.0,2.0,2.0,4.0,1.0,1.0,3.0,2.0,2.0,4.0,4.0,2.0,1.0,1.0,3.0,3.0,5.0,4.0,2.0,5.0,3.0,1.0,5.0,3.0,1.0,1.0,2.0,1.0,1.0,1.0,1.0,4.0,0.0,0.0,4.0,4.0,2.0,0.0,2.0,4.0,1.0,1.0,0.0,1.0,4.0,1.0,4.0,5.0,2.0,10.0,3.0,4.0,3.0,6.0,4.0,4.0,4.0,12.0,13.0,11.0,11.0,9.0,18.0,11.0,13.0,17.0,13.0,16.0,17.0,33.0,26.0,20.0,30.0,29.0,32.0,35.0,41.0,41.0,44.0,28.0,31.0,44.0,48.0,35.0,46.0,39.0,30.0,30.0,30.0,33.0,29.0,43.0,34.0,40.0,40.0,33.0,33.0,46.0,42.0,34.0,40.0,42.0,38.0,33.0,44.0,28.0,39.0,31.0,37.0,40.0,36.0,30.0,32.0,35.0,21.0,29.0,17.0,23.0,33.0,21.0,21.0,21.0,24.0,15.0,17.0,14.0,29.0,19.0,20.0,21.0,25.0,36.0,30.0,26.0,21.0,21.0,26.0,26.0,33.0,30.0,26.0,16.0,34.0,27.0,27.0,26.0,17.0,25.0,22.0,28.0,39.0,28.0,30.0,27.0,26.0,28.0,33.0,22.0,28.0,28.0,33.0,30.0,36.0,46.0,23.0,35.0,25.0,42.0,46.0,37.0,25.0,24.0,27.0,42.0,41.0,43.0,42.0,35.0,38.0,47.0,50.0,48.0,47.0,49.0,46.0,39.0,37.0,30.0,37.0,34.0,37.0,29.0,38.0,40.0,37.0,42.0,39.0,38.0,42.0,32.0,44.0,38.0,34.0,25.0,27.0,22.0,30.0,39.0,41.0,41.0,39.0,28.0,35.0,34.0,33.0,37.0,37.0,26.0,34.0,31.0,30.0,26.0,25.0,30.0,28.0,22.0,25.0,20.0,14.0,19.0,21.0,28.0,11.0,28.0,11.0,18.0,13.0,12.0,18.0,13.0,20.0,16.0,21.0,13.0,13.0,22.0,20.0,19.0,20.0,12.0,13.0,18.0,20.0,31.0,28.0,36.0,28.0,27.0,37.0,49.0,48.0,41.0,41.0,33.0,28.0,23.0,22.0,14.0,13.0,10.0,9.0,7.0,9.0,11.0,9.0,12.0,6.0,5.0,6.0:2
14.0,10.0,10.0,7.0,10.0,5.0,11.0,9.0,11.0,9.0,7.0,11.0,7.0,11.0,15.0,7.0,6.0,10.0,7.0,5.0,9.0,7.0,5.0,10.0,9.0,4.0,6.0,4.0,10.0,6.0,8.0,10.0,4.0,6.0,6.0,3.0,5.0,6.0,2.0,3.0,2.0,4.0,1.0,1.0,4.0,7.0,2.0,2.0,9.0,1.0,0.0,3.0,5.0,3.0,5.0,7.0,2.0,8.0,1.0,1.0,2.0,4.0,3.0,5.0,3.0,6.0,4.0,8.0,2.0,4.0,3.0,7.0,2.0,5.0,3.0,5.0,8.0,1.0,3.0,13.0,8.0,11.0,5.0,10.0,7.0,7.0,8.0,9.0,8.0,6.0,4.0,8.0,13.0,9.0,9.0,14.0,10.0,8.0,6.0,14.0,10.0,14.0,10.0,8.0,15.0,12.0,19.0,11.0,16.0,23.0,18.0,18.0,21.0,15.0,25.0,15.0,22.0,14.0,20.0,18.0,16.0,24.0,27.0,25.0,26.0,13.0,29.0,18.0,18.0,22.0,15.0,16.0,19.0,18.0,18.0,11.0,23.0,22.0,36.0,20.0,25.0,26.0,32.0,26.0,16.0,16.0,15.0,23.0,15.0,29.0,24.0,14.0,33.0,18.0,20.0,23.0,16.0,25.0,25.0,26.0,29.0,33.0,26.0,24.0,20.0,39.0,30.0,20.0,40.0,30.0,30.0,34.0,27.0,30.0,15.0,32.0,29.0,23.0,37.0,16.0,29.0,43.0,24.0,34.0,35.0,29.0,41.0,49.0,58.0,46.0,48.0,54.0,53.0,49.0,51.0,42.0,51.0,63.0,43.0,53.0,61.0,45.0,41.0,30.0,25.0,24.0,31.0,20.0,27.0,20.0,19.0,16.0,19.0,28.0,21.0,21.0,28.0,17.0,28.0,22.0,21.0,24.0,23.0,17.0,24.0,18.0,26.0,23.0,32.0,21.0,28.0,24.0,15.0,26.0,20.0,20.0,13.0,22.0,31.0,26.0,24.0,29.0,17.0,21.0,9.0,28.0,22.0,17.0,15.0,17.0,24.0,15.0,15.0,21.0,10.0,18.0,8.0,12.0,27.0,23.0,18.0,23.0,17.0,16.0,18.0,13.0,15.0,13.0,10.0,5.0,18.0,15.0,13.0,11.0,9.0,10.0,16.0,6.0,14.0,4.0,9.0,2.0,15.0,7.0,12.0,3.0,6.0,6.0:2
8.0,8.0,4.0,5.0,5.0,8.0,3.0,6.0,6.0,2.0,4.0,4.0,3.0,5.0,5.0,2.0,1.0,4.0,2.0,1.0,1.0,1.0,3.0,3.0,4.0,4.0,0.0,4.0,1.0,1.0,7.0,4.0,1.0,3.0,5.0,0.0,3.0,0.0,0.0,3.0,2.0,0.0,0.0,1.0,0.0,2.0,3.0,1.0,0.0,2.0,2.0,3.0,3.0,2.0,5.0,6.0,5.0,6.0,10.0,6.0,3.0,9.0,1.0,7.0,6.0,14.0,6.0,12.0,17.0,11.0,5.0,10.0,16.0,13.0,11.0,14.0,22.0,16.0,24.0,23.0,32.0,32.0,34.0,25.0,29.0,36.0,38.0,38.0,40.0,37.0,39.0,42.0,45.0,50.0,42.0,39.0,35.0,22.0,44.0,31.0,30.0,45.0,40.0,38.0,37.0,30.0,33.0,31.0,33.0,34.0,29.0,31.0,22.0,25.0,38.0,32.0,34.0,44.0,33.0,57.0,38.0,34.0,40.0,28.0,26.0,29.0,26.0,32.0,30.0,29.0,26.0,25.0,33.0,28.0,31.0,28.0,31.0,26.0,30.0,26.0,40.0,16.0,28.0,18.0,29.0,33.0,32.0,38.0,19.0,30.0,29.0,40.0,28.0,22.0,23.0,30.0,27.0,23.0,32.0,28.0,35.0,30.0,35.0,24.0,48.0,30.0,17.0,30.0,22.0,43.0,35.0,27.0,42.0,31.0,32.0,37.0,48.0,43.0,29.0,36.0,29.0,29.0,40.0,38.0,29.0,27.0,41.0,43.0,37.0,37.0,40.0,37.0,32.0,34.0,40.0,28.0,29.0,35.0,29.0,40.0,35.0,45.0,35.0,41.0,30.0,48.0,38.0,42.0,43.0,42.0,37.0,31.0,41.0,24.0,31.0,37.0,39.0,44.0,46.0,35.0,30.0,38.0,40.0,33.0,34.0,24.0,37.0,36.0,39.0,33.0,41.0,48.0,40.0,47.0,48.0,32.0,21.0,33.0,23.0,29.0,25.0,38.0,24.0,18.0,20.0,23.0,22.0,14.0,22.0,19.0,18.0,31.0,22.0,20.0,19.0,26.0,39.0,34.0,50.0,35.0,25.0,33.0,41.0,51.0,56.0,32.0,51.0,55.0,40.0,41.0,43.0,35.0,29.0,16.0,14.0,17.0,10.0,11.0,15.0,8.0,9.0,10.0,5.0,5.0,8.0,11.0,8.0,4.0:2
