#!/bin/bash
 

ELEPHANT_REASONER=./elephant-reasoner

memlimit=`expr $2 / 1024`
timeoutsec=`expr $1 / 1000`

ulimit -Sv $memlimit

if [ -x $ELEPHANT_REASONER ]; then
	echo Started $3 on $4
	output_dir=`dirname $5`
	error_file=$5
	input_file=`basename $4`
	error_file+="_err"
	out_msg=`timeout $timeoutsec $ELEPHANT_REASONER -r $3 -i $4 -o $5 2> $error_file`
	if [ $? -ne 0 ]; then
		echo ELepHant terminated abnormally. >&2
		echo Please see the file $error_file for the error. >&2
		exit -1
	fi
	echo $out_msg
	operation_time=`echo "$out_msg" | grep 'Total time' | awk -F":" '{print $2}' | sed 's/ milisecs//' | sed 's/\.[0-9]*//'`
	echo Operation time: $operation_time 
	echo Completed  $3 on $4
	rm -f $error_file
	exit 0
else
	echo Could not find the executable $ELEPHANT_REASONER. >&2
	echo Please place it in this directory and set the executable bit. >&2 
	exit -1
fi
