!-----------------------------------------------------------------------
!  Parameters for EAM Ni by Mishin et al.
!  Cutoff radius should be 6.2872 Ang.
!  See Mishin et al. PRB 59(5) (1999) 3393--3407.
!-----------------------------------------------------------------------
!      real(8),parameter:: am_al = 26.9815d0
!      real(8),parameter:: rc_eam= 6.2872d0
!
!      integer,parameter:: neamd = 25
  real(8),parameter:: rc_eam_Ni = 5.8037d0
  real(8):: rtbl_Ni(1:neamd)=(/ &
       2.0000, &
       2.1585, &
       2.3170, &
       2.4755, &
       2.6340, &
       2.7924, &
       2.9509, &
       3.1094, &
       3.2679, &
       3.4264, &
       3.5849, &
       3.7434, &
       3.9019, &
       4.0604, &
       4.2189, &
       4.3773, &
       4.5358, &
       4.6943, &
       4.8528, &
       5.0113, &
       5.1698, &
       5.3283, &
       5.4868, &
       5.6453, &
       5.8037 /)

  real(8):: rhotbl_Ni(1:neamd)=(/ &
       0.000, &
       0.050, &
       0.100, &
       0.150, &
       0.200, &
       0.250, &
       0.300, &
       0.350, &
       0.400, &
       0.450, &
       0.500, &
       0.550, &
       0.600, &
       0.650, &
       0.700, &
       0.750, &
       0.800, &
       0.850, &
       0.900, &
       0.950, &
       0.975, &
       1.000, &
       1.025, &
       1.050, &
       1.100 /)

  real(8):: rhoprm_Ni(1:4,1:neamd-1)= reshape([ &
        7.8024207E-01, -1.1453294E+00,  5.9156878E-01, -9.8594797E-02, &
        3.8737172E-01, -5.9929696E-01,  3.3860031E-01, -5.9529324E-02, &
        1.0815400E+00, -1.4980907E+00,  7.2651299E-01, -1.1533607E-01, &
       -1.7122107E+00,  1.8875899E+00, -6.4116244E-01,  6.8825438E-02, &
       -2.0831137E+00,  2.3100307E+00, -8.0154238E-01,  8.9121559E-02, &
       -2.4486693E+00,  2.7027634E+00, -9.4218581E-01,  1.0591039E-01, &
       -3.9378521E+00,  4.2167247E+00, -1.4552365E+00,  1.6386454E-01, &
        4.7253659E-01, -3.8490485E-02, -8.6736107E-02,  1.7158812E-02, &
        3.0502102E+00, -2.4048483E+00,  6.3738576E-01, -5.6703287E-02, &
        2.4379699E+00, -1.8687986E+00,  4.8093883E-01, -4.1483530E-02, &
        1.8398220E+00, -1.3682425E+00,  3.4130980E-01, -2.8500460E-02, &
        2.7276190E+00, -2.0797323E+00,  5.3137493E-01, -4.5424925E-02, &
       -5.2275353E-01,  4.1933680E-01, -1.0909999E-01,  9.2898651E-03, &
       -4.5417687E-01,  3.6866938E-01, -9.6621556E-02,  8.2654644E-03, &
        1.4685298E+00, -9.9854004E-01,  2.2744619E-01, -1.7338978E-02, &
       -9.1085643E-01,  6.3218176E-01, -1.4509437E-01,  1.1030151E-02, &
        2.8638986E-01, -1.5968272E-01,  2.9486626E-02, -1.7997064E-03, &
        4.9655211E-01, -2.9399172E-01,  5.8097708E-02, -3.8313250E-03, &
        9.7167370E-01, -5.8771179E-01,  1.1862360E-01, -7.9887802E-03, &
       -1.3768576E+00,  8.1822956E-01, -1.6193061E-01,  1.0672659E-02, &
        1.4226156E+00, -8.0628581E-01,  1.5230115E-01, -9.5880705E-03, &
       -4.1596174E-01,  2.2889088E-01, -4.1977830E-02,  2.5658361E-03, &
        1.1940472E-01, -6.3829710E-02,  1.1372136E-02, -6.7527385E-04, &
       -2.6404921E-02,  1.3655794E-02, -2.3535306E-03,  1.3517415E-04], &
       [4,neamd-1])

  real(8):: vprm_Ni(1:4,1:neamd-1)= reshape([ &
       -9.9039606E+01,  1.5767554E+02, -8.0831913E+01,  1.3471985E+01, &
        6.1748321E+01, -6.5796218E+01,  2.2699129E+01, -2.5161301E+00, &
        1.3593724E+02, -1.6185438E+02,  6.4157117E+01, -8.4804500E+00, &
        2.4464899E+01, -2.6763679E+01,  9.5860419E+00, -1.1322947E+00, &
        2.1982268E+01, -2.3936082E+01,  8.5125426E+00, -9.9644312E-01, &
        1.9325555E+01, -2.1081856E+01,  7.4904018E+00, -8.7442851E-01, &
       -1.9303780E+00,  5.2775435E-01,  1.6734448E-01, -4.7216769E-02, &
       -1.7950715E+01,  1.5984437E+01, -4.8036091E+00,  4.8567849E-01, &
        3.7983769E+00, -3.9816799E+00,  1.3061609E+00, -1.3753213E-01, &
       -1.2959621E+00,  4.7869159E-01,  4.3947392E-03, -1.0891328E-02, &
        2.7209131E-01, -8.3352362E-01,  3.7043430E-01, -4.4926638E-02, &
       -5.4957859E+00,  3.7889137E+00, -8.6438893E-01,  6.5028948E-02, &
       -1.5703477E+01,  1.1637161E+01, -2.8757800E+00,  2.3685901E-01, &
       -9.4048060E+00,  6.9834284E+00, -1.7296535E+00,  1.4276922E-01, &
        9.1271346E+00, -6.1943720E+00,  1.3938622E+00, -1.0401831E-01, &
        9.1961095E+00, -6.2416442E+00,  1.4046616E+00, -1.0484069E-01, &
        9.1317463E+00, -6.1990741E+00,  1.3952762E+00, -1.0415097E-01, &
       -6.2230711E+00,  3.6137739E+00, -6.9509889E-01,  4.4282605E-02, &
       -1.2912495E+01,  7.7491742E+00, -1.5472668E+00,  1.0281705E-01, &
       -1.5334999E+01,  9.1993995E+00, -1.8366578E+00,  1.2206628E-01, &
        2.4211883E+01, -1.3749389E+01,  2.6023511E+00, -1.6414781E-01, &
        5.8992308E+00, -3.4387916E+00,  6.6728791E-01, -4.3092117E-02, &
       -3.1914707E+01,  1.7236614E+01, -3.1009204E+00,  1.8583356E-01, &
        1.9062893E+01, -9.8536739E+00,  1.6978127E+00, -9.7513233E-02], &
       [4,neamd-1])

  real(8):: fprm_Ni(1:4,1:neamd-1)= reshape([ &
        0.0000000E+00, -3.9773281E+00,  0.0000000E+00, -1.4026875E+02, &
       -2.8601560E-02, -2.2612345E+00, -3.4321872E+01,  8.8543736E+01, &
        3.2248372E-02, -4.0867325E+00, -1.6066893E+01,  2.7693804E+01, &
       -2.2383584E-02, -2.9940934E+00, -2.3351154E+01,  4.3881050E+01, &
        1.5208836E-02, -3.5579797E+00, -2.0531722E+01,  3.9181997E+01, &
       -1.3056222E-02, -3.2187990E+00, -2.1888445E+01,  4.0990961E+01, &
        1.6970374E+00, -2.0319736E+01,  3.5114677E+01, -2.2345841E+01, &
        1.6825351E+00, -2.0195430E+01,  3.4759519E+01, -2.2007595E+01, &
        1.7091708E+00, -2.0395197E+01,  3.5258937E+01, -2.2423777E+01, &
        1.6611952E+00, -2.0075360E+01,  3.4548188E+01, -2.1897296E+01, &
       -1.1275870E+00, -3.3426670E+00,  1.0828014E+00,  4.1296147E-01, &
       -1.0997173E+00, -3.4946835E+00,  1.3591949E+00,  2.4545022E-01, &
       -1.0910314E+00, -3.5381131E+00,  1.4315775E+00,  2.0523766E-01, &
       -1.1812077E+00, -3.1219149E+00,  7.9127263E-01,  5.3359914E-01, &
       -1.0188886E+00, -3.8175680E+00,  1.7850627E+00,  6.0365763E-02, &
       -1.3414425E+00, -2.5273526E+00,  6.4775640E-02,  8.2493780E-01, &
       -8.3709441E-01, -4.4186578E+00,  2.4289071E+00, -1.6011698E-01, &
       -1.3134387E+00, -2.7374427E+00,  4.5100703E-01,  6.1553011E-01, &
       -9.3615669E-01, -3.9950494E+00,  1.8483477E+00,  9.7996525E-02, &
       -1.7741991E+00, -1.3485998E+00, -9.3738866E-01,  1.0754479E+00, &
        1.8069194E+00, -1.2367426E+01,  1.0363971E+01, -2.7882649E+00, &
        2.0941043E+01, -6.9769796E+01,  6.7766341E+01, -2.1922388E+01, &
        9.2877115E+01, -2.8031440E+02,  2.7317571E+02, -8.8722182E+01, &
       -5.8443717E+01,  1.5203084E+02, -1.3858166E+02,  4.1994442E+01], &
       [4,neamd-1])
