#!/usr/bin/env python
"""
Elements and their attributes.
"""

elements = {
    'H'  :{'number':  1, 'name':'Hydrogen',      'mass':1.008 , 'abundance':'1400  ', 'valence':1,  'CPKcolor':'#FFFFFF', },
    'He' :{'number':  2, 'name':'Hellium',       'mass':4.0026, 'abundance':'0.008 ', 'valence':2,  'CPKcolor':'#D9FFFF', },
    'Li' :{'number':  3, 'name':'Lithium',       'mass':6.94  , 'abundance':'20    ', 'valence':1,  'CPKcolor':'#CC80FF', },
    'Be' :{'number':  4, 'name':'Beryllium',     'mass':9.0122, 'abundance':'2.8   ', 'valence':2,  'CPKcolor':'#C2FF00', },
    'B'  :{'number':  5, 'name':'Boron',         'mass':10.81 , 'abundance':'10    ', 'valence':3,  'CPKcolor':'#FFB5B5', },
    'C'  :{'number':  6, 'name':'Carbon',        'mass':12.011, 'abundance':'200   ', 'valence':4,  'CPKcolor':'#909090', },
    'N'  :{'number':  7, 'name':'Nitrogen',      'mass':14.007, 'abundance':'19    ', 'valence':5,  'CPKcolor':'#3050F8', },
    'O'  :{'number':  8, 'name':'Oxygen',        'mass':15.999, 'abundance':'461000', 'valence':6,  'CPKcolor':'#FF0D0D', },
    'F'  :{'number':  9, 'name':'Fluorine',      'mass':18.998, 'abundance':'585   ', 'valence':7,  'CPKcolor':'#90E050', },
    'Ne' :{'number': 10, 'name':'Neon',          'mass':20.180, 'abundance':'0.005 ', 'valence':8,  'CPKcolor':'#B3E3F5', },
    'Na' :{'number': 11, 'name':'Sodium',        'mass':22.990, 'abundance':'23600 ', 'valence':1,  'CPKcolor':'#AB5CF2', },
    'Mg' :{'number': 12, 'name':'Magnesium',     'mass':24.305, 'abundance':'23300 ', 'valence':2,  'CPKcolor':'#8AFF00', },
    'Al' :{'number': 13, 'name':'Aluminum',      'mass':26.982, 'abundance':'82300 ', 'valence':3,  'CPKcolor':'#BFA6A6', },
    'Si' :{'number': 14, 'name':'Silicon',       'mass':28.085, 'abundance':'282000', 'valence':4,  'CPKcolor':'#F0C8A0', },
    'P'  :{'number': 15, 'name':'Phosphorus',    'mass':30.974, 'abundance':'1050  ', 'valence':5,  'CPKcolor':'#FF8000', },
    'S'  :{'number': 16, 'name':'Sulfur',        'mass':32.06 , 'abundance':'350   ', 'valence':6,  'CPKcolor':'#FFFF30', },
    'Cl' :{'number': 17, 'name':'Chlorine',      'mass':35.45 , 'abundance':'145   ', 'valence':7,  'CPKcolor':'#1FF01F', },
    'Ar' :{'number': 18, 'name':'Argon',         'mass':39.948, 'abundance':'3.5   ', 'valence':8,  'CPKcolor':'#80D1E3', },
    'K'  :{'number': 19, 'name':'Potassium',     'mass':39.098, 'abundance':'20900 ', 'valence':1,  'CPKcolor':'#8F40D4', },
    'Ca' :{'number': 20, 'name':'Calcium',       'mass':40.078, 'abundance':'41500 ', 'valence':2,  'CPKcolor':'#3DFF00', },
    'Sc' :{'number': 21, 'name':'Scandium',      'mass':44.956, 'abundance':'22    ', 'valence':3,  'CPKcolor':'#E6E6E6', },
    'Ti' :{'number': 22, 'name':'Titanium',      'mass':47.867, 'abundance':'5650  ', 'valence':4,  'CPKcolor':'#BFC2C7', },
    'V'  :{'number': 23, 'name':'Vanadium',      'mass':50.942, 'abundance':'120   ', 'valence':5,  'CPKcolor':'#A6A6AB', },
    'Cr' :{'number': 24, 'name':'Chromium',      'mass':51.996, 'abundance':'102   ', 'valence':6,  'CPKcolor':'#8A99C7', },
    'Mn' :{'number': 25, 'name':'Manganese',     'mass':54.938, 'abundance':'950   ', 'valence':7,  'CPKcolor':'#9C7AC7', },
    'Fe' :{'number': 26, 'name':'Iron',          'mass':55.845, 'abundance':'56300 ', 'valence':8,  'CPKcolor':'#E06633', },
    'Co' :{'number': 27, 'name':'Cobalt',        'mass':58.933, 'abundance':'25    ', 'valence':9,  'CPKcolor':'#F090A0', },
    'Ni' :{'number': 28, 'name':'Nickel',        'mass':58.693, 'abundance':'84    ', 'valence':10, 'CPKcolor':'#50D050', },
    'Cu' :{'number': 29, 'name':'Copper',        'mass':63.546, 'abundance':'60    ', 'valence':11, 'CPKcolor':'#C88033', },
    'Zn' :{'number': 30, 'name':'Zinc',          'mass':65.38 , 'abundance':'70    ', 'valence':12, 'CPKcolor':'#7D80B0', },
    'Ga' :{'number': 31, 'name':'Gallium',       'mass':69.723, 'abundance':'19    ', 'valence':3,  'CPKcolor':'#C28F8F', },
    'Ge' :{'number': 32, 'name':'Germanium',     'mass':72.631, 'abundance':'1.5   ', 'valence':4,  'CPKcolor':'#668F8F', },
    'As' :{'number': 33, 'name':'Arsenic',       'mass':74.922, 'abundance':'1.8   ', 'valence':5,  'CPKcolor':'#BD80E3', },
    'Se' :{'number': 34, 'name':'Selenium',      'mass':78.972, 'abundance':'0.05  ', 'valence':6,  'CPKcolor':'#FFA100', },
    'Br' :{'number': 35, 'name':'Bromine',       'mass':79.904, 'abundance':'2.4   ', 'valence':7,  'CPKcolor':'#A62929', },
    'Kr' :{'number': 36, 'name':'Krypton',       'mass':84.798, 'abundance':'<0.001', 'valence':8,  'CPKcolor':'#5CB8D1', },
    'Rb' :{'number': 37, 'name':'Rubidium',      'mass':85.468, 'abundance':'90    ', 'valence':1,  'CPKcolor':'#702EB0', },
    'Sr' :{'number': 38, 'name':'Strontium',     'mass':87.62 , 'abundance':'370   ', 'valence':2,  'CPKcolor':'#00FF00', },
    'Y'  :{'number': 39, 'name':'Yttrium',       'mass':88.906, 'abundance':'33    ', 'valence':3,  'CPKcolor':'#94FFFF', },
    'Zr' :{'number': 40, 'name':'Zirconium',     'mass':91.224, 'abundance':'165   ', 'valence':4,  'CPKcolor':'#94E0E0', },
    'Nb' :{'number': 41, 'name':'Niobium',       'mass':92.906, 'abundance':'20    ', 'valence':5,  'CPKcolor':'#73C2C9', },
    'Mo' :{'number': 42, 'name':'Molybdenium',   'mass':95.95 , 'abundance':'1.2   ', 'valence':6,  'CPKcolor':'#54B5B5', },
    'Tc' :{'number': 43, 'name':'Technetium',    'mass':98.907, 'abundance':'<0.001', 'valence':7,  'CPKcolor':'#3B9E9E', },
    'Ru' :{'number': 44, 'name':'Ruthenium',     'mass':101.07, 'abundance':'0.001 ', 'valence':8,  'CPKcolor':'#248F8F', },
    'Rh' :{'number': 45, 'name':'Rhodium',       'mass':102.90, 'abundance':'0.001 ', 'valence':9,  'CPKcolor':'#0A7D8C', },
    'Pd' :{'number': 46, 'name':'Palladium',     'mass':106.42, 'abundance':'0.015 ', 'valence':10, 'CPKcolor':'#006985', },
    'Ag' :{'number': 47, 'name':'Silver',        'mass':107.86, 'abundance':'0.075 ', 'valence':11, 'CPKcolor':'#C0C0C0', },
    'Cd' :{'number': 48, 'name':'Cadmium',       'mass':112.41, 'abundance':'0.159 ', 'valence':12, 'CPKcolor':'#FFD98F', },
    'In' :{'number': 49, 'name':'Indium',        'mass':114.81, 'abundance':'0.25  ', 'valence':3,  'CPKcolor':'#A67573', },
    'Sn' :{'number': 50, 'name':'Tin',           'mass':118.71, 'abundance':'2.3   ', 'valence':4,  'CPKcolor':'#668080', },
    'Sb' :{'number': 51, 'name':'Antimony',      'mass':121.76, 'abundance':'0.2   ', 'valence':5,  'CPKcolor':'#9E63B5', },
    'Te' :{'number': 52, 'name':'Tellurium',     'mass':127.60, 'abundance':'0.001 ', 'valence':6,  'CPKcolor':'#D47A00', },
    'I'  :{'number': 53, 'name':'Iodin',         'mass':126.90, 'abundance':'0.45  ', 'valence':7,  'CPKcolor':'#940094', },
    'Xe' :{'number': 54, 'name':'Xenon',         'mass':131.29, 'abundance':'<0.001', 'valence':8,  'CPKcolor':'#429EB0', },
    'Cs' :{'number': 55, 'name':'Caesium',       'mass':132.90, 'abundance':'3     ', 'valence':1,  'CPKcolor':'#57178F', },
    'Ba' :{'number': 56, 'name':'Barium',        'mass':137.32, 'abundance':'425   ', 'valence':2,  'CPKcolor':'#00C900', },
    'La' :{'number': 57, 'name':'Lanthanum',     'mass':138.90, 'abundance':'39    ', 'valence':3,  'CPKcolor':'#70D4FF', },
    'Ce' :{'number': 58, 'name':'Cerium',        'mass':140.11, 'abundance':'66.5  ', 'valence':4,  'CPKcolor':'#FFFFC7', },
    'Pr' :{'number': 59, 'name':'Praseodymium',  'mass':140.90, 'abundance':'9.2   ', 'valence':5,  'CPKcolor':'#D9FFC7', },
    'Nd' :{'number': 60, 'name':'Neodymium    ', 'mass':144.24, 'abundance':'41.5  ', 'valence':6,  'CPKcolor':'#C7FFC7', },
    'Pm' :{'number': 61, 'name':'Promethium   ', 'mass':144.91, 'abundance':'<0.001', 'valence':7,  'CPKcolor':'#A3FFC7', },
    'Sm' :{'number': 62, 'name':'Samarium     ', 'mass':150.36, 'abundance':'7.05  ', 'valence':8,  'CPKcolor':'#8FFFC7', },
    'Eu' :{'number': 63, 'name':'Europium     ', 'mass':151.96, 'abundance':'2     ', 'valence':9,  'CPKcolor':'#61FFC7', },
    'Gd' :{'number': 64, 'name':'Gadolinium   ', 'mass':157.25, 'abundance':'6.2   ', 'valence':10, 'CPKcolor':'#45FFC7', },
    'Tb' :{'number': 65, 'name':'Terbium      ', 'mass':158.92, 'abundance':'1.2   ', 'valence':11, 'CPKcolor':'#30FFC7', },
    'Dy' :{'number': 66, 'name':'Dysprosium   ', 'mass':162.50, 'abundance':'5.2   ', 'valence':12, 'CPKcolor':'#1FFFC7', },
    'Ho' :{'number': 67, 'name':'Holmium      ', 'mass':164.93, 'abundance':'1.3   ', 'valence':13, 'CPKcolor':'#00FF9C', },
    'Er' :{'number': 68, 'name':'Erbium       ', 'mass':167.25, 'abundance':'3.5   ', 'valence':14, 'CPKcolor':'#00E675', },
    'Tm' :{'number': 69, 'name':'Thulium      ', 'mass':168.93, 'abundance':'0.52  ', 'valence':15, 'CPKcolor':'#00D452', },
    'Yb' :{'number': 70, 'name':'Ytterbium    ', 'mass':173.05, 'abundance':'3.2   ', 'valence':16, 'CPKcolor':'#00BF38', },
    'Lu' :{'number': 71, 'name':'Lutetium     ', 'mass':174.96, 'abundance':'0.8   ', 'valence':17, 'CPKcolor':'#00AB24', },
    'Hf' :{'number': 72, 'name':'Hafnium      ', 'mass':178.49, 'abundance':'3     ', 'valence':4,  'CPKcolor':'#4DC2FF', },
    'Ta' :{'number': 73, 'name':'Tantalum     ', 'mass':180.94, 'abundance':'2     ', 'valence':5,  'CPKcolor':'#4DA6FF', },
    'W'  :{'number': 74, 'name':'Tungsten     ', 'mass':183.84, 'abundance':'1.3   ', 'valence':6,  'CPKcolor':'#2194D6', },
    'Re' :{'number': 75, 'name':'Rhenium      ', 'mass':186.20, 'abundance':'<0.001', 'valence':7,  'CPKcolor':'#267DAB', },
    'Os' :{'number': 76, 'name':'Osmium       ', 'mass':190.23, 'abundance':'0.002 ', 'valence':8,  'CPKcolor':'#266696', },
    'Ir' :{'number': 77, 'name':'Iridium      ', 'mass':192.21, 'abundance':'0.001 ', 'valence':9,  'CPKcolor':'#175487', },
    'Pt' :{'number': 78, 'name':'Platinum     ', 'mass':195.08, 'abundance':'0.005 ', 'valence':10, 'CPKcolor':'#D0D0E0', },
    'Au' :{'number': 79, 'name':'Gold         ', 'mass':196.96, 'abundance':'0.004 ', 'valence':11, 'CPKcolor':'#FFD123', },
    'Hg' :{'number': 80, 'name':'Mercury      ', 'mass':200.59, 'abundance':'0.085 ', 'valence':12, 'CPKcolor':'#B8B8D0', },
    'Tl' :{'number': 81, 'name':'Thallium     ', 'mass':204.38, 'abundance':'0.85  ', 'valence':3,  'CPKcolor':'#A6544D', },
    'Pb' :{'number': 82, 'name':'Lead         ', 'mass':207.20, 'abundance':'14    ', 'valence':4,  'CPKcolor':'#575961', },
    'Bi' :{'number': 83, 'name':'Bismuth      ', 'mass':208.98, 'abundance':'0.009 ', 'valence':5,  'CPKcolor':'#9E4FB5', },
    'Po' :{'number': 84, 'name':'Polonium     ', 'mass':208.98, 'abundance':'<0.001', 'valence':6,  'CPKcolor':'#AB5C00', },
    'At' :{'number': 85, 'name':'Astatine     ', 'mass':209.98, 'abundance':'<0.001', 'valence':7,  'CPKcolor':'#754F45', },
    'Rn' :{'number': 86, 'name':'Radon        ', 'mass':222.01, 'abundance':'<0.001', 'valence':8,  'CPKcolor':'#428296', },
    'Fr' :{'number': 87, 'name':'Francium     ', 'mass':223.20, 'abundance':'<0.001', 'valence':1,  'CPKcolor':'#420066', },
    'Ra' :{'number': 88, 'name':'Radium       ', 'mass':226.02, 'abundance':'<0.001', 'valence':2,  'CPKcolor':'#007D00', },
    'Ac' :{'number': 89, 'name':'Actinium     ', 'mass':227.02, 'abundance':'<0.001', 'valence':3,  'CPKcolor':'#70ABFA', },
    'Th' :{'number': 90, 'name':'Thorium      ', 'mass':232.03, 'abundance':'9.6   ', 'valence':4,  'CPKcolor':'#00BAFF', },
    'Pa' :{'number': 91, 'name':'Protactinium ', 'mass':231.03, 'abundance':'<0.001', 'valence':5,  'CPKcolor':'#00A1FF', },
    'U'  :{'number': 92, 'name':'Uranium      ', 'mass':238.02, 'abundance':'2.7   ', 'valence':6,  'CPKcolor':'#008FFF', },
    'Np' :{'number': 93, 'name':'Neptunium    ', 'mass':237.04, 'abundance':'<0.001', 'valence':7,  'CPKcolor':'#0080FF', },
    'Pu' :{'number': 94, 'name':'Plutonium    ', 'mass':244.06, 'abundance':'<0.001', 'valence':8,  'CPKcolor':'#006BFF', },
    'Am' :{'number': 95, 'name':'Americium    ', 'mass':243.06, 'abundance':'<0.001', 'valence':9,  'CPKcolor':'#545CF2', },
    'Cm' :{'number': 96, 'name':'Curium       ', 'mass':247.00, 'abundance':'<0.001', 'valence':10, 'CPKcolor':'#785CE3', },
    'Bk' :{'number': 97, 'name':'Berkelium    ', 'mass':247.07, 'abundance':'<0.001', 'valence':11, 'CPKcolor':'#8A4FE3', },
    'Cf' :{'number': 98, 'name':'Californium  ', 'mass':251.08, 'abundance':'<0.001', 'valence':12, 'CPKcolor':'#A136D4', },
    'Es' :{'number': 99, 'name':'Einsteinium  ', 'mass':254.00, 'abundance':'0     ', 'valence':13, 'CPKcolor':'#B31FD4', },
    'Fm' :{'number':100, 'name':'Fermium      ', 'mass':257.09, 'abundance':'0     ', 'valence':14, 'CPKcolor':'#B31FBA', },
    'Md' :{'number':101, 'name':'Mendelevium  ', 'mass':258.10, 'abundance':'0     ', 'valence':15, 'CPKcolor':'#B30DA6', },
    'No' :{'number':102, 'name':'Nobelium     ', 'mass':259.10, 'abundance':'0     ', 'valence':16, 'CPKcolor':'#BD0D87', },
    'Lr' :{'number':103, 'name':'Lawrencium   ', 'mass':262.00, 'abundance':'0     ', 'valence':17, 'CPKcolor':'#C70066', },
    'Rf' :{'number':104, 'name':'Rutherfordium', 'mass':261.00, 'abundance':'0     ', 'valence':4,  'CPKcolor':'#CC0059', },
    'Db' :{'number':105, 'name':'Dubnium      ', 'mass':262.00, 'abundance':'0     ', 'valence':5,  'CPKcolor':'#D1004F', },
    'Sg' :{'number':106, 'name':'Seaborgium   ', 'mass':266.00, 'abundance':'0     ', 'valence':6,  'CPKcolor':'#D90045', },
    'Bh' :{'number':107, 'name':'Bohrium      ', 'mass':264.00, 'abundance':'0     ', 'valence':7,  'CPKcolor':'#E00038', },
    'Hs' :{'number':108, 'name':'Hassium      ', 'mass':269.00, 'abundance':'0     ', 'valence':8,  'CPKcolor':'#E6002E', },
    'Mt' :{'number':109, 'name':'Meitnerium   ', 'mass':268.00, 'abundance':'0     ', 'valence':9,  'CPKcolor':'#EB0026', },
    'Ds' :{'number':110, 'name':'Darmstadtium ', 'mass':269.00, 'abundance':'0     ', 'valence':10, 'CPKcolor':'#EB0026', },
    'Rg' :{'number':111, 'name':'Roentgenium  ', 'mass':272.00, 'abundance':'0     ', 'valence':11, 'CPKcolor':'#EB0026', },
    'Cn' :{'number':112, 'name':'Copernicium  ', 'mass':277.00, 'abundance':'0     ', 'valence':12, 'CPKcolor':'#EB0026', },
    'Nh' :{'number':113, 'name':'Nihonium     ', 'mass':278.00, 'abundance':'0     ', 'valence':3,  'CPKcolor':'#EB0026', },
    'Fl' :{'number':114, 'name':'Flerovium    ', 'mass':289.00, 'abundance':'0     ', 'valence':4,  'CPKcolor':'#EB0026', },
    'Mc' :{'number':115, 'name':'Moscovium    ', 'mass':289.00, 'abundance':'0     ', 'valence':5,  'CPKcolor':'#EB0026', },
    'Lv' :{'number':116, 'name':'Livermorium  ', 'mass':293.00, 'abundance':'0     ', 'valence':6,  'CPKcolor':'#EB0026', },
    'Ts' :{'number':117, 'name':'Tennessine   ', 'mass':293.00, 'abundance':'0     ', 'valence':7,  'CPKcolor':'#EB0026', },
    'Og' :{'number':118, 'name':'Oganesson    ', 'mass':294.00, 'abundance':'0     ', 'valence':8,  'CPKcolor':'#EB0026', },
}

elements_order = ['X',
                  'H','He',  # 1,2
                  'Li','Be','B','C','N','O','F','Ne',  # 3,4,5,6,7,8,9,10
                  'Na','Mg','Al','Si','P','S','Cl','Ar',  # 11 - 18
                  'K','Ca','Sc','Ti','V','Cr','Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As','Se','Br','Kr',  # 19 - 36
                  'Rb','Sr','Y','Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn','Sb','Te','I','Xe',  # 36 - 54
                  'Cs','Ba','La','Ce','Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb','Lu',  # 55 - 71
                  'Hf','Ta','W','Re','Os','Ir','Pt','Au','Hg','Tl','Pb','Bi','Po','At','Rn',  # 72 - 86
                  'Fr','Ra','Ac','Th','Pa','U','Np','Pu','Am','Cm','Bk','Cf','Es','Fm','Md','No','Lr','Rf','Db','Sg','Bh',  #
                  'Hs','Mt','Ds','Rg','Cn','Nh','Fl','Mc','Lv','Ts','Og',
                  ]

def get_number_from_symbol(symbol):
    """
    Convert symbol to number.
    """
    return elements[symbol]['number']

def get_symbol_from_number(number):
    return elements_order[number]
