
# nap documentation

This is a documentation of **Nagoya Atomistic-simulation Package
(nap)**.

-   **nap** is hosted at Github: <https://github.com/ryokbys/nap>
-   **nap** includes the following programs and utilities:
    -   *pmd*: Fortran program of massively parallel molecular dynamics
    -   *fitpot*: Fortran program for fitting the parameters of
        neural-network potential
    -   *fp.py*: Python script for fitting the parameters of classical
        potentials
    -   *nappy*: Python scripts for pre- and post-processing
-   **Nagoya** is the name of a city in Japan, where the project
    started.

------------------------------------------------------------------------

## How to cite nap

- [R. Kobayashi, Y. Miyaji, K. Nakano, M. Nakayama, APL Materials 8, 081111 (2020)](https://aip.scitation.org/doi/10.1063/5.0015373) for *nap* package and/or *fp.py* program.
- [Kobayashi, Ryo, Daniele Giofré, Till Junge, Michele Ceriotti, and William Arthur Curtin. Physical Review Materials 1, 53604--11 (2017)](https://journals.aps.org/prmaterials/abstract/10.1103/PhysRevMaterials.1.053604) for *fitpot* program and/or neural-network (NN) potential.

------------------------------------------------------------------------

## License

The **nap** is distributed under the MIT license, please see the license statement in the GitHub repository.

------------------------------------------------------------------------

## Contact

**Ryo KOBAYASHI**  
kobayashi.ryo [at] nitech.ac.jp  
Department of Physical Science and Engineering, Nagoya Institute of Technology

------------------------------------------------------------------------

## Acknowledgements

This program was supported in part by ["Materials research by Information Integration" Initiative (MI2I)](http://www.nims.go.jp/MII-I/) project of the Support Program for Starting Up Innovation Hub from Japan Science and Technology Agency (JST).


