分子動力学法(MD)の基礎
======================

MDの概要
--------

分子動力学法(molecular dynamics,
MD)は，原子・分子の動きを計算機上で再現することで，

> -   実験では観測できないミクロの世界の現象を観たり，
> -   実験では行うことのできない状況の仮想実験を行ってみたり，
> -   統計データからマクロな物理量を計算したり，

と，様々なことが可能な計算機シミュレーション手法である．

単純に言えば，MDシミュレーションとは，

> 1.  原子間に働く力，つまりは原子に働く加速度を求める．
> 2.  加速度に従い原子を動かす．

の2つを繰り返すシミュレーションであり，
原子間に働く力をいかに正確に求められるかがシミュレーションの精度を決定する．
単純であるが(もしくは単純であるが故に?)，応用範囲は広く，研究レベルでは

> -   工学
> -   化学
> -   生物，創薬
> -   物理

の様々な分野で使われている．
しかし，有限要素法や第一原理計算に比べると，企業レベルではまだまだ知名度は低いと思われる．

分子動力学シミュレーションにおいて重要なことは，

> -   原子間ポテンシャル
> -   モデリング
> -   結果の解釈

である．すでに述べたように，まずは原子間ポテンシャルが正しくないと，原子間に働く力が現実と異なるので，どんなに他を頑張ってもダメなことがある．
しかし，完璧な原子間ポテンシャルなどは存在しないので，その限界や適用範囲などを理解しながらシミュレーションを行い，
結果を解釈できれば，目的は達成できると期待される．
そのため，シミュレーションをするに際し，何を解決するために，どのようなことが分かれば良いのかを明確にしなければならない．
そして初めてどのようなシミュレーションを行えば良いのかが決まる．
この段階が **モデリング** と呼ばれる．

原子間ポテンシャル
------------------

原子に働く力は，原子の周りに存在している電子を介した量子論的な相互作用により初めて求まるものである．
そのため，量子論的な計算を行い，原子間に働く力を求め，それを用いて分子動力学シミュレーションを行う
**第一原理分子動力学法** もある．
ただし，一般的に量子論的な計算は非常に計算量が多いために，多数の原子や，長時間のダイナミクスを行うことは現在でも難しい．
そこで，量子論的な相互作用を何らかの関数系で近似し，原子に働く力を求めてシミュレーションを行うことを(古典)分子動力学法という．
これまでに，様々な関数系が種々の系に対して提案されている．

### Lennard-Joneポテンシャル

希ガス原子の間の相互作用は電子の揺らぎに起因する静電相互作用であり，van
der Waals相互作用と呼ばれる． これは距離 $r$
の-6乗に比例する引力となることが知られている．
この相互作用を表現するのがLennard-Jonesポテンシャルであり，次のような形となっている．

$$\phi (r_{ij}) = \epsilon_{ij} \left[ \left( \frac{\sigma_{ij}}{r_{ij}} \right)^{12} - \left( \frac{\sigma_{ij}}{r_{ij}} \right)^{6} \right]$$

斥力項には物理的な根拠はないが，一般的には-12乗が用いられる．

### Moorseポテンシャル

### Embeded Atom Method (EAM) ポテンシャル

-   EAMポテンシャル
-   FSポテンシャル
-   MEAMポテンシャル
-   GEAMポテンシャル

### Stillinger-Weberポテンシャル

### Tersoffポテンシャル

### 長距離力 (クーロン力)

高速化技法
----------

### Cell list法とBook keeping法

原子間ポテンシャルの計算には近くに存在する原子の情報が必要である．
大抵の原子間ポテンシャルにおいて，隣接原子を検索する段階が計算スピードのボトルネックとなる．
そのため，MDシミュレーションでは，隣接原子の検索をどれだけ速く計算できるかが重要なポイントである．

単純に全ての他の原子との距離を計算すると，N個の原子一つ一つが(N-1)個の他の原子との距離を計算するので，
O(N\^2)の計算量となる． これを減らすための手法が **Cell list法** と
**Book keeping法** である．

**Cell list法**

:   系を小さなセルに分割し，そこに原子を登録していく．
    こうすることで，全ての原子との距離を計算する必要がなくなり，隣のセルに入っている原子とのみ距離を測れば良くなり，
    O(N)の計算量となる．

**Book keeping法**

:   Cell
    list法では，27個のセルの中に入っている原子の数だけ検索すれば良いので，O(N\^2)に比べれば非常に高速だが，
    そのセルの端にある原子はカットオフ半径の外にあるので，毎回検索するとムダが多い．
    そのため，カットオフ半径に入っている原子だけをリストに保存しておいて，ポテンシャルと力の計算に用いることで計算量を減らすことができる．
    その際，カットオフ半径よりも少し大きめの半径を取っておけば，毎ステップこのリストを更新する必要がなくなるため，
    全シミュレーションとしての計算量を減らすことができる．

### 空間分割並列化法

多くの原子間ポテンシャルは短距離相互作用となっているので，遠くまで相互作用は及ばない．
そのことを活かし，大規模な系を空間分割し，各領域を各プロセスとして同時並列的に各領域の計算を行う．
こうすることで，およぼ並列数倍だけ計算が速くなる．

各領域の端にある原子は，隣りの領域（つまりは別プロセス）の原子と相互作用する必要があるため，
毎ステップ原子座標情報を隣りの領域と交換する必要がある．
このデータ通信量が大きいと並列性能がでない．
隣りの領域と情報交換する原子は，領域の端からカットオフ半径程度にある原子であるため，
カットオフ半径が長いポテンシャルは，隣接原子探索にも時間がかかるし，並列性能も悪くなる．

MDで得られる物理量
------------------

### 凝集エネルギー

### 輸送係数

-   グリーン・久保公式
