# Reappraising double pendulum dynamics across multiple computational platforms

[![License: WTFPL](https://img.shields.io/badge/License-WTFPL-brightgreen.svg)](http://www.wtfpl.net/about/)
[![No Maintenance Intended](http://unmaintained.tech/badge.svg)](http://unmaintained.tech/)
[![GitHub watchers](https://img.shields.io/github/watchers/Naereen/StrapDown.js.svg?style=social&label=Watch&maxAge=2592000)](https://github.com/sandyherho/doublePendulum/watchers)


This repository contains the code and data associated with the paper titled "Reappraising double pendulum dynamics across multiple computational platforms" by [Sandy H. S. Herho](https://scholar.google.com/citations?user=uYQgjxMAAAAJ&hl=id), [Faiz R. Fajary](https://scholar.google.co.jp/citations?user=cTqtdTIAAAAJ&hl=en), [Katarina E. P. Herho](https://scholar.google.com/citations?user=XsjZGN0AAAAJ&hl=id), [Iwan P. Anwar](https://scholar.google.co.id/citations?user=NMs_TswAAAAJ&hl=id), [Rusmawan Suwarman](https://scholar.google.co.id/citations?user=NfMfR8LMVz8C&hl=en), and [Dasapta E. Irawan](https://scholar.google.com/citations?user=Myvc78MAAAAJ&hl=en).


## Dependencies

The dependencies for each programming language implementation includes:

- [Python](https://www.python.org/): [Matplotlib](https://matplotlib.org/), [NumPy](https://numpy.org/), [Pandas](https://pandas.pydata.org/), [scikit-posthoc](https://scikit-posthocs.readthedocs.io/en/latest/), [SciPy](https://scipy.org/), [seaborn](https://seaborn.pydata.org/) 

- [GNU Octave](https://octave.org/)

- [R](https://www.r-project.org/): [deSolve](https://desolve.r-forge.r-project.org/)

- [Julia](https://julialang.org/): [CSV.jl](https://csv.juliadata.org/stable/), [DataFrames.jl](https://dataframes.juliadata.org/stable/), [DifferentialEquations.jl](https://docs.sciml.ai/DiffEqDocs/stable/)


## License

This project is licensed under the [WTFPL](http://www.wtfpl.net/).


## Citation

If you use this code or data in your research, please cite the following paper:

```
@article{herho2024Inertial,
  title={{Reappraising double pendulum dynamics across multiple computational platforms}},
  author={Herho, S. H. S. and Fajary, F. R. and  Herho, K. E. P. and Anwar, I. P. and Suwarman, R. and Irawan, D. E.},
  journal={xxx},
  year={2024},
  doi={xxx}
}
```
