library(Hmsc)
load(file = "allModels.RData")
nChains = 4
samples = 250
thin = 100
n1 = length(allmodels)
n2 = length(allmodels[[1]])

text.file = file.path("VP.text")
cat("VARIANCE PARTITIONINGS","\n","\n",file = text.file)

for(i in 1:n1){
  load(file = paste0("models/allInfluencerModels_sp_",as.character(i),"_samples_",as.character(samples),
                     "_thin_",as.character(thin),".RData"))
  
  cat(c("FOCAL SPECIES: ",names(allmodels)[i]),"\n","\n",file = text.file,append = TRUE)
  for(j in 1:n2){
    m = models[[j]]
    if(j==1){
      group = c(1,1,1,1,2)
      groupnames = c("abiotic","seq.depth")
    }
    if(j==2){
      group = c(1,1,2,2,2,3)
      groupnames = c("biotic","abiotic","seq.depth")
    }
    if(j==3){
      group = c(1,1,2,2,2,3)
      groupnames = c("biotic","abiotic","seq.depth")
    }
    if(j==4){
      group = c(1,1,1,2,2,2,3)
      groupnames = c("biotic","abiotic","seq.depth")
    }
    if(j==5){
      group = c(1,1,1,2,2,2,3)
      groupnames = c("biotic","abiotic","seq.depth")
    }
    if(j==6){
      group = c(1,1,1,2,2,2,3)
      groupnames = c("biotic","abiotic","seq.depth")
    }
    if(j==7){
      group = c(rep(1,11),2,2,2,3)
      groupnames = c("biotic","abiotic","seq.depth")
    }
    if(j==8){
      c(rep(1,11),2,2,2,3)
      groupnames = c("biotic","abiotic","seq.depth")
    }
    if(j==9){
      c(rep(1,11),2,2,2,3)
      groupnames = c("biotic","abiotic","seq.depth")
    }
    if(j==10){
      c(rep(1,11),2,2,2,3)
      groupnames = c("biotic","abiotic","seq.depth")
    }
    VP = computeVariancePartitioning(hM = m,group = group,groupnames = groupnames)
    cat(c("MODEL: ",names(models)[j]),"\n",file = text.file,append = TRUE)
    cat(rownames(VP$vals),"\n",file = text.file,append = TRUE)
    cat(rowMeans(VP$vals),"\n","\n",file = text.file,append = TRUE)
  }
}
