library(Hmsc)
nChains = 4
samples = 250
thin = 100
load(file = paste0("allModels.RData"))
spp = names(allmodels)
n1 = length(allmodels)
n2 = length(allmodels[[1]])
for(sp in 1:n1){
  load(file = paste0("allModels_sp_",as.character(sp),
                     "_samples_",as.character(samples),
                     "_thin_",as.character(thin),".RData"))
  allmodels[[sp]] = models
}

for(i in 1:n1){
  models = allmodels[[i]]
  for(j in 1:n2){
    m = models[[j]]
    
    postBeta = getPostEstimate(m, parName="Beta")
    filename = paste("parameter_estimates_Beta_",names(allmodels)[i],"_",names(models[j]),
                     ".xlsx")
    me = as.data.frame(t(postBeta$mean))
    me = cbind(m$spNames,me)
    colnames(me) = c("Species",m$covNames)
    po = as.data.frame(t(postBeta$support))
    po = cbind(m$spNames,po)
    colnames(po) = c("Species",m$covNames)
    ne = as.data.frame(t(postBeta$supportNeg))
    ne = cbind(m$spNames,ne)
    colnames(ne) = c("Species",m$covNames)
    vals = list("Posterior mean"=me,"Pr(x>0)"=po,"Pr(x<0)"=ne)
    writexl::write_xlsx(vals,path = filename)
  }
}

dna = matrix(NA,nrow=n1,ncol=2)
for(i in 1:n1){
  models = allmodels[[i]]
  m = models$dna
  beta = getPostEstimate(hM=m,parName="Beta")
  dna[i,1] = beta$mean[2]
  dna[i,2] = beta$support[2]
}
colnames(dna) = c("beta(dna)","Pr(beta(dna)>0)")
rownames(dna) = spp

S = matrix(NA,nrow=n1,ncol=2)
for(i in 1:n1){
  models = allmodels[[i]]
  m = models$S
  beta = getPostEstimate(hM=m,parName="Beta")
  S[i,1] = beta$mean[2]
  S[i,2] = beta$support[2]
}
colnames(S) = c("beta(S)","Pr(beta(S)>0)")
rownames(S) = spp

ba = matrix(NA,nrow=n1,ncol=4)
for(i in 1:n1){
  models = allmodels[[i]]
  m = models$ba
  beta = getPostEstimate(hM=m,parName="Beta")
  ba[i,1] = beta$mean[2]
  ba[i,2] = beta$support[2]
  ba[i,3] = beta$mean[3]
  ba[i,4] = beta$support[3]
}
colnames(ba) = c("beta(basio)","Pr(beta(basio)>0)","beta(asco)","Pr(beta(asco)>0)")
rownames(ba) = spp

lv.pa = matrix(NA,nrow=n1,ncol=4)
for(i in 1:n1){
  models = allmodels[[i]]
  m = models$lv.pa
  beta = getPostEstimate(hM=m,parName="Beta")
  lv.pa[i,1] = beta$mean[2]
  lv.pa[i,2] = beta$support[2]
  lv.pa[i,3] = beta$mean[3]
  lv.pa[i,4] = beta$support[3]
}
colnames(lv.pa) = c("beta(lv1)","Pr(beta(lv1)>0)","beta(lv2)","Pr(beta(lv2)>0)")
rownames(lv.pa) = spp

lv.abu = matrix(NA,nrow=n1,ncol=4)
for(i in 1:n1){
  models = allmodels[[i]]
  m = models$lv.abu
  beta = getPostEstimate(hM=m,parName="Beta")
  lv.abu[i,1] = beta$mean[2]
  lv.abu[i,2] = beta$support[2]
  lv.abu[i,3] = beta$mean[3]
  lv.abu[i,4] = beta$support[3]
}
colnames(lv.abu) = c("beta(,v1)","Pr(beta(lv1)>0)","beta(lv2)","Pr(beta(lv2)>0)")
rownames(lv.abu) = spp

pa.10.all = list()
for(i in 1:n1){
  models = allmodels[[i]]
  m = models$pa.10
  pa.10 = matrix(NA,nrow=10,ncol=2)
  beta = getPostEstimate(hM=m,parName="Beta")
  for(j in 1:10){
    pa.10[j,1] = beta$mean[j+1]
    pa.10[j,2] = beta$support[j+1]
  }
  colnames(pa.10) = c("beta","Pr(beta>0)")
  rownames(pa.10) = m$covNames[2:11]
  pa.10.all[[i]] = pa.10
}
names(pa.10.all) = names(allmodels)

abu.10.all = list()
for(i in 1:n1){
  models = allmodels[[i]]
  m = models$abu.10
  abu.10 = matrix(NA,nrow=10,ncol=2)
  beta = getPostEstimate(hM=m,parName="Beta")
  for(j in 1:10){
    abu.10[j,1] = beta$mean[j+1]
    abu.10[j,2] = beta$support[j+1]
  }
  colnames(abu.10) = c("beta","Pr(beta>0)")
  rownames(abu.10) = m$covNames[2:11]
  abu.10.all[[i]] = abu.10
}
names(abu.10.all) = names(allmodels)

sel.pa.10.all = list()
for(i in 1:n1){
  models = allmodels[[i]]
  m = models$sel.pa.10
  sel.pa.10 = matrix(NA,nrow=10,ncol=3)
  beta = getPostEstimate(hM=m,parName="Beta")
  for(j in 1:10){
    sel.pa.10[j,1] = beta$mean[j+1]
    sel.pa.10[j,2] = beta$support[j+1]
    sel.pa.10[j,3] = beta$supportNeg[j+1]
  }
  colnames(sel.pa.10) = c("beta","Pr(beta>0)","Pr(beta<0)")
  rownames(sel.pa.10) = m$covNames[2:11]
  sel.pa.10.all[[i]] = sel.pa.10
}
names(sel.pa.10.all) = names(allmodels)

sel.abu.10.all = list()
for(i in 1:n1){
  models = allmodels[[i]]
  m = models$sel.abu.10
  sel.abu.10 = matrix(NA,nrow=10,ncol=3)
  beta = getPostEstimate(hM=m,parName="Beta")
  for(j in 1:10){
    sel.abu.10[j,1] = beta$mean[j+1]
    sel.abu.10[j,2] = beta$support[j+1]
    sel.abu.10[j,3] = beta$supportNeg[j+1]
  }
  colnames(sel.abu.10) = c("beta","Pr(beta>0)","Pr(beta<0)")
  rownames(sel.abu.10) = m$covNames[2:11]
  sel.abu.10.all[[i]] = sel.abu.10
}
names(sel.abu.10.all) = names(allmodels)

print(dna)
print(S)
print(ba)
print(lv.pa)
print(lv.abu)
sp = 3
print(names(allmodels)[sp])
pa.10.all[[sp]]
sel.pa.10.all[[sp]]
abu.10.all[[sp]]
sel.abu.10.all[[sp]]
save(dna,S,ba,lv.pa,lv.abu,pa.10.all,sel.pa.10.all,abu.10,sel.abu.10.all,file="betaResults.RData")
