library(Hmsc)
nChains = 4
samples = 250
thin = 100
load(file = paste0("allModels.RData"))
n1 = length(allmodels)
prev = rep(NA,n1)
for(i in 1:n1){
  prev[i] = sum(allmodels[[i]][[1]]$Y)
}
n2 = length(allmodels[[1]])
allmodelfits=list()
for(sp in 1:n1){
  load(file = paste0("allModelFits_sp_",as.character(sp),
                     "_samples_",as.character(samples),
                     "_thin_",as.character(thin),".RData"))
  allmodelfits[[sp]] = modelfits
}
names(allmodelfits) = names(allmodels)
WAIC = matrix(NA,nrow = n1,ncol = n2)
AUC = matrix(NA,nrow = n1,ncol = n2)
AUC.CV = matrix(NA,nrow = n1,ncol = n2)
TjurR2 = matrix(NA,nrow = n1,ncol = n2)
TjurR2.CV = matrix(NA,nrow = n1,ncol = n2)
for(i in 1:n1){
  for(j in 1:n2){
    WAIC[i,j] = allmodelfits[[i]][[j]]$WAIC
    AUC[i,j] = allmodelfits[[i]][[j]]$MF$AUC
    AUC.CV[i,j] = allmodelfits[[i]][[j]]$MFCV$AUC
    TjurR2[i,j] = allmodelfits[[i]][[j]]$MF$TjurR2
    TjurR2.CV[i,j] = allmodelfits[[i]][[j]]$MFCV$TjurR2
  }
}
save(WAIC,AUC,AUC.CV,TjurR2,TjurR2.CV,file="model_comparison.RData")

pdf("model_comparison.pdf")
par(mar=c(10,4,4,2)+0.1)
for(c in 2){
  if(c==1){
    var = TjurR2.CV
    varname = "TjurR2"
    ref = 0
  }
  if(c==2){
    var = AUC.CV
    varname = "AUC"
    ref = 0.5
  }
  plot(NULL,xlim=c(0,10),ylim=c(0,1),
       ylab = varname, xlab = "",xaxt = "n")
  text(x=1:9, y=par()$usr[3]-0.1*(par()$usr[4]-par()$usr[3]),
       labels=paste0(names(allmodels)," (n=",as.character(prev),")"), srt=45, adj=1, xpd=TRUE)
  axis(1, at =1:9, las=2,labels = F)
  for(j in 1:n1){points(rep(j,n2)+
                          0.2*c(0,-1,-1,0,1,1,-1,-1,1,1),var[j,],
                        pch=c(7,16,17,17,17,16,17,16,17,16),
                        col = c("black","red","red","orange","green","green","blue","blue","cyan","cyan"))}
  abline(h=ref,col="grey")
}
dev.off()