library(Hmsc)
load(file = "allModels.RData")
nChains = 4
samples = 250
thin = 100
transient = round(0.5*samples*thin)
n1 = length(allmodels)
n2 = length(allmodels[[1]])
for(i in 1:9){
  models = allmodels[[i]]
  modelfits = list()
  for(j in 1:n2){
    print(c(samples,thin,i,j))
    m = allmodels[[i]][[j]]
    m = sampleMcmc(m,samples = samples,transient = transient,
                   thin = thin, nChains = nChains,nParallel = nChains)
    models[[j]] = m
    predY = computePredictedValues(m)
    MF = evaluateModelFit(hM = m, predY = predY)
    predY = computePredictedValues(m,partition = 1:m$ny,nParallel = nChains)
    MFCV = evaluateModelFit(hM = m, predY = predY)
    WAIC = computeWAIC(hM = m)
    modelfits[[j]] = list(MF=MF, MFCV=MFCV, WAIC=WAIC)
  }
  names(modelfits) = names(models)
  save(models,file = paste0("allModels_sp_",as.character(i),"_samples_",as.character(samples),
                            "_thin_",as.character(thin),".RData"))
  save(modelfits,file = paste0("allModelFits_sp_",as.character(i),"_samples_",as.character(samples),
                               "_thin_",as.character(thin),".RData"))
}
