% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{threshold_config}
\alias{threshold_config}
\alias{threshold_uniform}
\alias{threshold_set}
\alias{threshold_lookup}
\title{Configuration for threshold representations}
\usage{
threshold_config(type = c("uniform", "set", "lookup"), ...)

threshold_uniform(from, to, by, thresh_names = NULL)

threshold_set(thresholds, thresh_names = names(thresholds))

threshold_lookup(thresholds, precision, thresh_names = names(thresholds))
}
\arguments{
\item{type}{(\code{character} string) representation of thresholds.}

\item{...}{passed on to variants}

\item{from}{(\code{numeric} scalar) smallest threshold; typically between 0 and 1}

\item{to}{(\code{numeric} scalar) largest threshold; typically between 0 and 1}

\item{by}{(\code{numeric} scalar) step size}

\item{thresh_names}{(\code{character} vector) optional names for the thresholds;
will be used as row names in clustering matrix.}

\item{thresholds}{(\code{numeric} vector) explicit list of thresholds.  Should be
sorted in ascending order.}

\item{precision}{(\code{numeric} scalar) precision for distances; this is used to
generate a look-up table for distances to the smallest encompassing threshold.}
}
\value{
an object representing the thresholds
}
\description{
Configuration for threshold representations
}
\section{Functions}{
\itemize{
\item \code{threshold_uniform()}: helper function for type \code{"uniform"}

\item \code{threshold_set()}: helper function for method \code{"set"}

\item \code{threshold_lookup()}: helper function for method \code{"lookup"}

}}
