% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_linkage.R
\name{seq_cluster_usearch}
\alias{seq_cluster_usearch}
\title{Do single-linkage clustering at a series of increasing similarity thresholds
using USEARCH to calculate sequence similarities.}
\usage{
seq_cluster_usearch(
  seq,
  seq_id = names(seq),
  threshold_config,
  clust_config = clust_index(),
  parallel_config = parallel_concurrent(1),
  output_type = c("matrix", "hclust"),
  which = TRUE,
  usearch_ncpu = NULL,
  usearch = Sys.which("usearch")
)
}
\arguments{
\item{seq}{(\code{character} vector, filename,
\link[Biostrings:XStringSet-class]{DNAStringSet}, or \code{data.frame} with columns
"seq_id" (\code{character}) and "seq" (\code{character})) sequences to cluster}

\item{seq_id}{(\code{character} vector) names for the sequences.  If they are
already named, this will replace the names.  Has no effect if \code{seq} is a
filename.}

\item{threshold_config}{(\code{optimotu_threshold_config} object returned by
\code{\link[=threshold_config]{threshold_config()}} or one of its helper functions) Definition of the
thresholds to use for clustering.}

\item{clust_config}{(\code{optimotu_cluster_config} object returned by
\code{\link[=clust_config]{clust_config()}} or one of its helpers) The clustering algorithm to use; all
algorithms give identical results, but may have different performance
characteristics on different problems.}

\item{parallel_config}{(\code{optimotu_parallel_config} object returned by
\code{\link[=parallel_config]{parallel_config()}} or one of its helpers) The method to use for
parallel clustering. For single-threaded clustering, use the default value
(\code{\link[=parallel_concurrent]{parallel_concurrent()}} with \code{threads = 1}).}

\item{output_type}{(\code{character}) Which type of output to give; one of
\code{"matrix"} or \code{"hclust"}. \code{"matrix"} returns an integer matrix giving
clustering results, where the element in row \code{i} and column \code{j} gives the
0-based index of the first member of the cluster to which sequence \code{j}
belongs when clustered at the \code{i}th clustering threshold. \code{"hclust"} returns
an object as returned by \code{\link[stats:hclust]{stats::hclust()}}, which requires less memory,
especially for large problems. If \code{which} is given, then both \code{output_type}s
instead return a list whose elements are of the chosen type.}

\item{which}{(\code{list} of \code{character} vectors) Instead of performing clustering
on all input sequences, perform independent clustering on subsets of the
sequences defined by the elements of \code{which}. Subsets do not need to be
disjoint (and indeed, if they are it is probably faster to calculate the
distance matrices separately.)}

\item{usearch_ncpu}{(\code{integer} scalar) number of threads to use for
calculating the distance matrix.  The number of threads for clustering is
specified in the "parallel_config" argument.}

\item{usearch}{(\code{character} scalar) path to usearch executable}
}
\value{
An \code{\link[methods:StructureClasses]{integer matrix}} if
\code{output_type=="matrix"}, an \code{\link[stats:hclust]{hclust}} object if
\code{output_type=="hclust"}, or a list of one of these when \code{which} is a list.
}
\description{
This function uses a unix pipe to direct the output of the
USEARCH "\code{calc_distmx}" command  to \code{\link[=distmx_cluster]{distmx_cluster()}}. USEARCH (version 8.0
or higher) should be installed separately; it is available with a free
license for most users at https://www.drive5.com/usearch/.
}
