% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mutual_information}
\alias{mutual_information}
\alias{adjusted_mutual_information}
\title{Calculate similarity for a set of alternate "test" partitions vs. a "true" partition}
\usage{
mutual_information(k, c, threads = 1L)

adjusted_mutual_information(k, c, threads = 1L)
}
\arguments{
\item{k}{(\code{m} x \code{n} \code{integer} matrix) \code{m} alternative "test" partitions; each
row gives the cluster assignment for the \code{n} objects. Objects with the same
cluster ID are clustered together. Cluster IDs do not need to be
consecutive, and they do not need to correspond between different
partitions.}

\item{c}{(\code{integer} vector of length \code{n}) "True" partition of the \code{n}
objects.}

\item{threads}{(\code{integer} count) number of parallel threads to use.}
}
\value{
(\code{numeric} vector of length \code{m}) The similarity measure between each
of the alternative partitions and the "true" partition.
}
\description{
Calculate similarity for a set of alternate "test" partitions vs. a "true" partition
}
