% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmeasure.R
\name{fmeasure}
\alias{fmeasure}
\title{Calculate multiclass F measure}
\usage{
fmeasure(k, c, ncpu = 1)
}
\arguments{
\item{k}{(\code{integer} matrix or \code{list} of \code{list}s of \code{integer} vectors) "test" clusters. See Details}

\item{c}{(\code{integer} vector or \code{list} of \code{integer} vectors) "true" clusters. See Details}

\item{ncpu}{(\code{integer} scalar) number of threads to use}
}
\value{
\code{numeric} vector giving the F-measure for each row
(matrix representation) or top-level element (set representation) of k.
}
\description{
Calculate multiclass F measure
}
\details{
'k' and 'c' can be given in two different representations. In both
cases, $n$ objects are clustered, 'k' represents $m$ different "test"
clusterings, and 'c' represents the "true" clusters.

In the 'matrix' representation, \code{k} is an integer matrix with $m$ rows and
$n$ columns, where \code{k[i, j]} is the index of the cluster to which element
$j$ belongs in the $i$th test clustering. \code{c} is an integer vector of length
$n$, where \code{c[j]} represents the index of the cluster which element $j$
belongs to in the true clustering. Cluster indices need not be dense (i.e.,
the presence of clusters with indices 1 and 3 does not imply the presence of
a cluster with index 2), and need not match between different test
clusterings and the true clustering; all that matters is that two elements
with the same value in \code{k[i,]} (or in \code{c}) are considered to be clustered
together.

In the 'set' representation, \code{k} is a list of lists of integer vectors, where
each vector gives the \strong{sorted} indices of the elements which are included
in one cluster.  Then the inner list gives a full clustering of the $n$
elements, and the outer list contains $m$ such clusterings. \code{c} is analogous
to one of the inner lists of \code{k}. The order of clusters does not matter, but
the indexing scheme used in \code{c} and \code{k} must match; i.e. index 4 must refer to
the same element each time it appears in \code{k} and \code{c}.  In order to be a
coherent clustering, each element should only in exactly one cluster in \code{c}
and each inner list of \code{k}, but this is not actually checked.

The algorithm used for the 'matrix' calculation is considerably faster, and
in the future the 'set' representation will probably be converted internally
to the 'matrix' representation.
}
