% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/confusion_matrix.R
\name{confusion_matrix}
\alias{confusion_matrix}
\alias{rand_index}
\alias{rand_index.matrix}
\alias{rand_index.data.frame}
\alias{adjusted_rand_index}
\alias{adjusted_rand_index.matrix}
\alias{adjusted_rand_index.data.frame}
\alias{matthews_correlation_coefficient}
\alias{matthews_correlation_coefficient.matrix}
\alias{matthews_correlation_coefficient.data.frame}
\alias{fowlkes_mallow_index}
\alias{fowlkes_mallow_index.matrix}
\alias{fowlkes_mallow_index.data.frame}
\title{Confusion matrix for a set of "test" partitions vs. a "true" partition}
\usage{
confusion_matrix(k, c, threads = 1L)

rand_index(x, ...)

\method{rand_index}{matrix}(x, c, threads = 1, ...)

\method{rand_index}{data.frame}(x, ...)

adjusted_rand_index(x, ...)

\method{adjusted_rand_index}{matrix}(x, c, threads = 1, ...)

\method{adjusted_rand_index}{data.frame}(x, ...)

matthews_correlation_coefficient(x, ...)

\method{matthews_correlation_coefficient}{matrix}(x, c, threads = 1, ...)

\method{matthews_correlation_coefficient}{data.frame}(x, ...)

fowlkes_mallow_index(x, ...)

\method{fowlkes_mallow_index}{matrix}(x, c, threads = 1, ...)

\method{fowlkes_mallow_index}{data.frame}(x, ...)
}
\arguments{
\item{k}{(\code{m} x \code{n} \code{integer} matrix) \code{m} alternative "test" partitions; each
row gives the cluster assignment for the \code{n} objects. Objects with the same
cluster ID are clustered together. Cluster IDs do not need to be
consecutive, and they do not need to correspond between different
partitions.}

\item{c}{(\code{integer} vector of length \code{n}) "True" partition of the \code{n}
objects.}

\item{threads}{(\code{integer} count) number of parallel threads to use.}

\item{x}{(either a \code{data.frame} as returned by \code{confusion_matrix()}, or an
\code{m} x \code{n} matrix, as described for \code{k}) data for which to calculate the
index.}

\item{...}{passed on to methods}
}
\value{
(\code{data.frame} with \code{m} rows) for each "test" partition, the number
of true positives ("\code{TP}"), false positives ("\code{FP}"), false negatives
("\code{FN}"), and true negatives ("\code{TN}") relative to the "true" partition.
}
\description{
One way to analyze the comparison of two different partitions of the same
data is to treat it as a binary classification problem operating on pairs
of objects, where pairs should be classified as belonging to the same
cluster or not.  Then a "true positive" is a pair which belong to the same
cluster in both the "test" partition and the "true" partition; a "false
positive" is a pair which belongs to the same cluster in the "test"
partition but not the "true" partition; a "false negative" is a pair which
belongs to the same cluster in the "true" partition but not in the "test"
partition; and a "true" negative is a pair which does not belong to the same
cluster in either the "test" partition or the "true" partition.
}
\details{
This formulation allows various measures of binary classification
performance to be applied to the case of clustering.
}
