# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Confusion matrix for a set of "test" partitions vs. a "true" partition
#'
#' One way to analyze the comparison of two different partitions of the same
#' data is to treat it as a binary classification problem operating on pairs
#' of objects, where pairs should be classified as belonging to the same
#' cluster or not.  Then a "true positive" is a pair which belong to the same
#' cluster in both the "test" partition and the "true" partition; a "false
#' positive" is a pair which belongs to the same cluster in the "test"
#' partition but not the "true" partition; a "false negative" is a pair which
#' belongs to the same cluster in the "true" partition but not in the "test"
#' partition; and a "true" negative is a pair which does not belong to the same
#' cluster in either the "test" partition or the "true" partition.
#'
#' This formulation allows various measures of binary classification
#' performance to be applied to the case of clustering.
#'
#' @return (`data.frame` with `m` rows) for each "test" partition, the number
#' of true positives ("`TP`"), false positives ("`FP`"), false negatives
#' ("`FN`"), and true negatives ("`TN`") relative to the "true" partition.
#'
#' @export
#' @inheritParams mutual_information
confusion_matrix <- function(k, c, threads = 1L) {
    .Call(`_optimotu_confusion_matrix`, k, c, threads)
}

distmx_cluster_single <- function(file, seqnames, threshold_config, method_config, parallel_config, output_type = "matrix") {
    .Call(`_optimotu_distmx_cluster_single`, file, seqnames, threshold_config, method_config, parallel_config, output_type)
}

distmx_cluster_multi <- function(file, seqnames, which, threshold_config, method_config, parallel_config, output_type = "matrix") {
    .Call(`_optimotu_distmx_cluster_multi`, file, seqnames, which, threshold_config, method_config, parallel_config, output_type)
}

#' Size of the intersection between two sorted sets
#'
#' This implementation is much faster that `length(intersect(c, k))`. However
#' it assumes (without checking!) that the sets are sorted.
#'
#' @param c (sorted `integer` or ` character` vector) the first set to compare
#' @param k (sorted `integer` or ` character` vector) the second set to compare
#'
#' @return (`integer` count) the number of elements which occur in both sets
#' @export
intersect_length <- function(c, k) {
    .Call(`_optimotu_intersect_length`, c, k)
}

#' @export
#' @rdname intersect_length
intersect_length_string <- function(c, k) {
    .Call(`_optimotu_intersect_length_string`, c, k)
}

inner_fmeasure <- function(cj, kpartition, nk) {
    .Call(`_optimotu_inner_fmeasure`, cj, kpartition, nk)
}

fmeasure_list <- function(k, c, ncpu = 1L) {
    .Call(`_optimotu_fmeasure_list`, k, c, ncpu)
}

fmeasure_matrix <- function(k, c, ncpu = 1L) {
    .Call(`_optimotu_fmeasure_matrix`, k, c, ncpu)
}

#' Calculate similarity for a set of alternate "test" partitions vs. a "true" partition
#'
#' @param k (`m` x `n` `integer` matrix) `m` alternative "test" partitions; each
#' row gives the cluster assignment for the `n` objects. Objects with the same
#' cluster ID are clustered together. Cluster IDs do not need to be
#' consecutive, and they do not need to correspond between different
#' partitions.
#' @param c (`integer` vector of length `n`) "True" partition of the `n`
#' objects.
#' @param threads (`integer` count) number of parallel threads to use.
#'
#' @return (`numeric` vector of length `m`) The similarity measure between each
#' of the alternative partitions and the "true" partition.
#' @export
mutual_information <- function(k, c, threads = 1L) {
    .Call(`_optimotu_mutual_information`, k, c, threads)
}

#' @rdname mutual_information
#' @export
adjusted_mutual_information <- function(k, c, threads = 1L) {
    .Call(`_optimotu_adjusted_mutual_information`, k, c, threads)
}

