# Cluster Set-Up for Retrieval Calculations
The python notebooks in this script contain the basics for setting up a full high-resolution atmospheric retrieval on a cluster. The script fm.py contains functions to calculate a model atmosphere given input opacity files, abundances, etc.
Note that the opacity files for each molecule are not included in this tutorial - you'll have to download the ones you want from sources such as ExoMol, HITEMP, etc. and edit the paths in the script to correctly locate your files.
The script call_pymultinest.py contains a wrapper for using pymultinest nested sampling to perform the actual fitting. At each step, it uses fm.py to make an atmospheric model, calculates the cross-correlation between that model and the data, and uses the goodness-of-fit from that cross-correlation to drive the nested sampling.
Also note that both of these files are set up to run on a single cluster. Each cluster uses slightly different notation to run batch files like these, and each cluster may have different python packages installed as defaults. Therefore, these files will likely not run directly on whatever cluster you are using - they are intended as a guide only to see how a retrieval can be set up.
