# CoolWalks: data
This folder contains the raw and processed datasets to reproduce the results of the CoolWalks paper for Manhattan, Barcelona and Valencia.

Depending on the city and data type, they files are subject to different licenses.

# Raw data (`exp_raw/*`)
## Street networks
All street networks are based on OpenStreetMap data and are licensed under the [Open Data Commons Open Database License (ODbL)](https://opendatacommons.org/licenses/odbl/).
The data has been downloaded from [OpenStreetMap](https://www.openstreetmap.org/) using [MinistryOfCoolWalks.jl](https://github.com/henrik-wolf/MinistryOfCoolWalks.jl).

This includes the following files:
- `manhattan/network_bike.json`
- `manhattan/network_walk.json`
- `barcelona/network_bike.json`
- `barcelona/network_bike.json`
- `valencia/network_walk.json`
- `valencia/network_walk.json`

## Building footprints
### Manhattan
The building footprints for Manhattan are based on the [Building footprints](https://data.cityofnewyork.us/Housing-Development/Building-Footprints/nqwf-w8eh) provided by the Office of Technology and Innovation (OTI) of the City of New York.

This includes the files in `manhattan/buildings/*`.

### Barcelona and Valencia
The building footprints for Barcelona and Valencia are based on the [Building footprints](http://www.catastro.minhap.gob.es/INSPIRE/buildings/ES.SDGC.BU.atom.xml) provided by the [Spanish General Directorate for Cadastre](http://www.catastro.minhap.gob.es/webinspire/index_eng.html).

Unfortunatly, the [LICENSE OF ACCESS AND USE OF INSPIRE DATASETS AND SERVICES OF THE DIRECTORATE GENERAL FOR CADASTRE](http://www.catastro.minhap.gob.es/webinspire/documentos/Licencia_en.pdf) does not allow for distribution of the raw datasets. Therefore, we only provide the processed building footprints in `barcelona/buildings.geojson` and `valencia/buildings.geojson`.

They have been derived from the raw data using the functionality in [CompositeBuildings.jl](https://github.com/henrik-wolf/CompositeBuildings.jl).

# Processed data (`exp_pro/*`)
## `real_cities`
This folder contains the final data from the real cities Manhattan, Barcelona and Valencia from which we derive our plots.

## `synthetic_manhattan`
this folder contains the synthetic data for the grid and random city based on Manhattan.

## `synthetic_barcelona`
this folder contains the synthetic data for the grid city based on Barcelona.