        program particle_statistics

        integer icount(124,60)
        integer ilon, jlat

        real sum_day(124,60)
        real sum_dep(124,60)
        real sum_tmp(124,60)
        real sum_sal(124,60)
        real sum_sig0(124,60)

        real day_mean(124,60)
        real dep_mean(124,60)
        real tmp_mean(124,60)
        real sal_mean(124,60)
        real sig0_mean(124,60)

        character*8, expt
        character*17, filin
        character*17, filout
        character*16, filout2
        character*16, filout3
        character*16, filout4
        character*16, filout5
        character*17, filout6

        print*, 'which experiment (e.g., W1B30Y10)'
        read(5,'(a8)') expt

        write(filin,'(a8,a9)') expt,'/traj.txt'
        open(1,file=filin,status='old')

        print*, 'how many positions?'
        read(5,*) npos

        do ilon = 1,124
        do jlat = 1,60
        icount(ilon,jlat) = 0
        sum_day(ilon,jlat) = 0
        sum_dep(ilon,jlat) = 0
        sum_tmp(ilon,jlat) = 0
        sum_sal(ilon,jlat) = 0
        sum_sig0(ilon,jlat) = 0
        enddo
        enddo

        do ipos = 1,npos
        print*, ipos
        read(1,*) ipart, alon, alat, adep, aday, atemp, asaln, asig

!80W to 20E in 1/2 deg intervals
        alonw = -100.5
        do ilon = 1,124
        alonw = alonw + 0.5
        alone = alonw + 0.5

!10S to 40N in 1/2 deg intervals 
        alats = -0.5
        do jlat = 1,60
        alats = alats + 0.5
        alatn = alats + 0.5

        if(alon.le.alone.and.alon.gt.alonw.and.alat.ge.alats.and.alat.lt.alatn)then
        icount(ilon,jlat) = icount(ilon,jlat) + 1
        sum_day(ilon,jlat) = sum_day(ilon,jlat) + aday
        sum_dep(ilon,jlat) = sum_dep(ilon,jlat) + adep
        sum_tmp(ilon,jlat) = sum_tmp(ilon,jlat) + atemp
        sum_sal(ilon,jlat) = sum_sal(ilon,jlat) + asaln
        sum_sig0(ilon,jlat) = sum_sig0(ilon,jlat) + asig
        endif

        enddo
        enddo

        enddo

        do ilon = 1,124
        do jlat = 1,60
        if(icount(ilon,jlat).gt.0) then
        day_mean(ilon,jlat) = sum_day(ilon,jlat)/icount(ilon,jlat)
        dep_mean(ilon,jlat) = sum_dep(ilon,jlat)/icount(ilon,jlat)
        tmp_mean(ilon,jlat) = sum_tmp(ilon,jlat)/icount(ilon,jlat)
        sal_mean(ilon,jlat) = sum_sal(ilon,jlat)/icount(ilon,jlat)
        sig0_mean(ilon,jlat) = sum_sig0(ilon,jlat)/icount(ilon,jlat)
        else
        day_mean(ilon,jlat) = 0.0
        dep_mean(ilon,jlat) = 0.0
        tmp_mean(ilon,jlat) = 0.0
        sal_mean(ilon,jlat) = 0.0
        sig0_mean(ilon,jlat) = 0.0
        endif
        enddo
        enddo

        write(filout,'(a8,a9)') expt,'/prob.txt'
        write(filout2,'(a8,a8)') expt,'/age.txt'
        write(filout3,'(a8,a8)') expt,'/dep.txt'
        write(filout4,'(a8,a8)') expt,'/tmp.txt'
        write(filout5,'(a8,a8)') expt,'/sal.txt'
        write(filout6,'(a8,a9)') expt,'/sig0.txt'

        open(2,file=filout)
        open(3,file=filout2)
        open(4,file=filout3)
        open(7,file=filout4)
        open(8,file=filout5)
        open(9,file=filout6)

        count_max = npos

        alon0 = -100.25
        do ilon = 1,124
        alon0 = alon0 + 0.5
        alat0 = -0.25
        do jlat = 1,60
        alat0 = alat0 + 0.5
        write(2,*) alon0,alat0,icount(ilon,jlat)/count_max
        write(3,*) alon0,alat0,day_mean(ilon,jlat)
        write(4,*) alon0,alat0,dep_mean(ilon,jlat)
        write(7,*) alon0,alat0,tmp_mean(ilon,jlat)
        write(8,*) alon0,alat0,sal_mean(ilon,jlat)
        write(9,*) alon0,alat0,sig0_mean(ilon,jlat)
        enddo
        enddo

        stop
        end
