
## function start
filter_distance <- function(obj, 
                            location = c(-1.110557, 51.602436), # has to be c(long, lat) as input
                            method = c('buffer'),
                            distance = 20000, # distance willing to go in metres
                            crds_loc = 4326, # coords of the location
                            crds_obj = 27700){ 
  
  require(sf)
  require(raster)
  
  if(method == 'buffer'){
    
    # first need to convert long lat to BNG
    dat_sf <- st_sf(st_sfc(st_point(location)), crs = crds_loc) # load location points, convert to spatial lat/lon
    trans_loc <- st_transform(dat_sf, crs = crds_obj) # transform to BNG
    buffed <- st_buffer(trans_loc, distance) # create a buffer around the point
    
    # # show where the buffered zone is
    # par(mfrow = c(1,2))
    # plot(raster)
    # plot(buffed, add = T)
    
    
    if (is.null(obj)){ # stop if object is NULL and return NULL
      
      warning('!!  Cropping object is empty, returning NULL output')
      
      c_buf <- NULL
      
    } else if(class(obj)[1] != 'sf' & 
              class(obj)[1] != 'RasterLayer' & 
              class(obj)[1] != 'RasterStack') {
      
      stop(paste('!!  object must be of class "Raster*" or "sf". Current class is:', class(obj)))
      
    } else if(class(obj)[1] == 'RasterLayer' | class(obj)[1] == 'RasterStack'){ # extract the masked extent for raster
      
      c_buf <- crop(obj, buffed) # crop the raster - creates a square extent
      masked_area <- mask(c_buf, buffed)
      # plot(masked_area) # then mask it to get only the area within the 'travel distance'
      # par(mfrow = c(1,1))
      
      return(masked_area) # return only the masked region x distance from the 'location'
      
    } else if (class(obj)[1] == 'sf' && 
               any(unique(st_geometry_type(obj)) == 'LINESTRING') |
               any(unique(st_geometry_type(obj)) == 'MULTILINESTRING') |
               any(unique(st_geometry_type(obj)) == 'POINT') | 
               any(unique(st_geometry_type(obj)) == 'MULTIPOINT')){
      c_buf <- st_intersection(obj, 
                               buffed) # crop the sf layer
      
      return(c_buf) # return only the masked region x distance from the 'location'
      
    } else if(class(obj)[1] == 'sf' && 
              (any(unique(st_geometry_type(obj)) == 'POLYGON') | 
               any(unique(st_geometry_type(obj)) == 'MULTIPOLYGON'))){
      
      c_buf <- st_intersection(sf::st_buffer(obj, dist = 0), # this is a hack to get around shapes that self-intersect. Works for some reason?!
                               buffed) # crop the sf layer
      
      return(c_buf)
    } 
    
  }
  
}

