#!/bin/bash
set -e
 gmx_mpi grompp -f minimization.mdp -c s2_fibril.gro -r s2_fibril.gro -p topol.top -o em_steep_s2.tpr
 mpirun gmx_mpi mdrun -ntomp 16 -nb gpu -v -deffnm em_steep_s2
 gmx_mpi grompp -f minimization_cg.mdp -c em_steep_s2.gro -r em_steep_s2.gro -p topol.top -o em_cg_s2.tpr
 mpirun gmx_mpi mdrun -ntomp 16 -nb gpu -v -deffnm em_cg_s2
 gmx_mpi grompp -f equilibration.mdp -c em_cg_s2.gro -r em_cg_s2.gro -p topol.top -o equilibration.tpr
 mpirun gmx_mpi mdrun -ntomp 16 -nb gpu -v -deffnm equilibration

 gmx_mpi grompp -f npt_300K_100Mpa_s2.mdp -c equilibration.gro -r equilibration.gro -p topol.top -o npt_300K_100Mpa_s2.tpr 
 mpirun gmx_mpi mdrun -ntomp 16 -nb gpu -v -deffnm npt_300K_100Mpa_s2

 gmx_mpi grompp -f npt_300K_1P_anealing.mdp -c npt_300K_100Mpa_s2.gro -r npt_300K_100Mpa_s2.gro -p topol.top -o npt_300K_1P_anealing_s2.tpr 
 mpirun gmx_mpi mdrun -ntomp 16 -nb gpu -v -deffnm npt_300K_1P_anealing

 gmx_mpi grompp -f npt_300ns.mdp -c npt_300K_1P_anealing.gro -r npt_300K_1P_anealing.gro -p topol.top -o npt_300ns.tpr 
 mpirun gmx_mpi mdrun -ntomp 16 -nb gpu -v -deffnm npt_300ns 
