# Data from: seasonal patterns and processes of migration in a long-distance migratory bird: energy or time minimization

## The Xnnn\_acc.csv files contain acceleration data for migrating little ringed plovers *Charadrius dubius*

Description of the data and file structure

The csv-files contain nine columns of data (A-I), where each data row is the summary of acceleration data sampled for one hour, consisting of 12 samples. The data in each column are as follows:
(A)	Date and time.
(B)	Sequence number. Only of operational interest. The number is a control function that indicates that timing of the sampling routine works as expected. The number represents minutes passed since sampling was activated, truncated to 1 byte, i.e. when minutes is greater than 255, 256 is subtracted. The first values are 60, 120, 180, 240, and then they are 300-256 = 44, 104, 164, and so on.
(C)	acc (0), acc(1), .., acc(5), columns C-H: Every 5 minutes a summary is stored for how many of 5 samples indicated active flight, i-5- 0..5. Every hour the distribution of the 12 runs are summarized according to activity level (acc(0), .., acc(5)). If the bird has been motionless during the preceding hour the data will be (12, 0, 0, 0, 0, 0), and if it has been flying continuously the numbers stored are (0, 0, 0, 0, 0, 12).
(D)	sumAcc (column I): The sum of columns C-H. The value should be 12 when sampling has followed the expected routine; if <12 the logger may have failed to the record data during >0 five minute periods.

## The Xnnn\_yyyy\_mm\_dd\_1.lux files contain light data for migrating little ringed plovers Charadrius dubius

Description of the data and file structure

The .lux files contain time stamped (UTC) light level measurements on a scale 1..255.

In the loggers deployed in years 2016-2020 light level was measured for five day periods as follows (mmdd): 0715-0720, 0901-0906, 1115-1120, 0201-0206, 0415-0420, 0505-0510, 0715-0720,..
The loggers deployed in 2021 had the following measurement schedule: 0615-0620, 0711-0720, 0901-0910, 1201-1210, 0201-0210, 0301-0310, 0401-0410, 0501-0510, 0615-0620,..

## The Little ringed plover reduced data.csv file contains reduced data used for statistical analyses for migrating little ringed plovers Charadrius dubius

Description of the data and file structure

The columns contain data as follows:

A (Rnr)				Ring number, Swedish Museum of Natural History
B (Logger)			Logger identification code
C (Sex) 			Sex of bird, male (M) or female (F)
D (Year)			Year
E (Season)			Autumn (A) or spring (S)
F (day start)			Date and time of migratory flight start
G (day stop)			Date and time of migratory flight stop
H (flight periods)		Number of 5 min periods when flight activity score was 4 or 5 (possible score is 0..6)
I (flight periods excluded)	Number of 5 min periods when flight activity score was <4 (possible score is 0..6)
J (flight duration min)  	Flight duration in minutes
K (flight duration h)    	Flight duration in hours
L (T2-T1)			Time (in hours) between start and stop of migratory flight (difference between columns G and F; always equal or less than flight duration of column J depending on number of activity scores <4). 
M (cum flight dur)		Cumulated flight duration for the migration season (hours)
N (stopover duration)		Time (hours) between consecutive migratory flights. For the first flight of a season the time required to accumulate fuel for the first flight was estimated by assuming a daily fuel deposition rate of 1.3% of the lean body mass. 
Q (MigDist)			Season specific migration distance (km)

Missing data code: null
