package org.vcell.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipUtility {
    /**
     * Size of the buffer to read/write data
     */
    private static final int BUFFER_SIZE = 4096;
    
//    public void unzip(String zipFilePath, String destDirectory) throws IOException {
//    	unzip(new FileInputStream(zipFilePath), destDirectory);
//    }
    /**
     * Extracts a zip file specified by the zipFilePath to a directory specified by
     * destDirectory (will be created if does not exists)
     * @param zipFilePath
     * @param destDirectory
     * @throws IOException
     */
    public void unzip(InputStream instream, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(instream);
        ZipEntry entry = zipIn.getNextEntry();
        // iterates over entries in the zip file
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                // if the entry is a file, extracts it
                extractFile(zipIn, filePath);
            } else {
                // if the entry is a directory, make the directory
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }
    public void unzip(String zipFilePath, String destDirectory) throws IOException {
    	File destDir = new File(destDirectory);
    	if (!destDir.exists()) {
    	destDir.mkdir();
    	}
    	ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
    	ZipEntry entry = zipIn.getNextEntry();
    	// iterates over entries in the zip file
    	while (entry != null) {
    	String filePath = destDirectory + File.separator + entry.getName();
    	if (!entry.isDirectory()) {
    	// if the entry is a file, extracts it
    	extractFile(zipIn, filePath);
    	} else {
    	// if the entry is a directory, make the directory
    	File dir = new File(filePath);
    	dir.mkdir();
    	}
    	zipIn.closeEntry();
    	entry = zipIn.getNextEntry();
    	}
    	zipIn.close();
    	}
    /**
     * Extracts a zip entry (file entry)
     * @param zipIn
     * @param filePath
     * @throws IOException
     */
    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[BUFFER_SIZE];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

//	public static void main(String[] args) {
//        String zipFilePath = "C:/Users/frm/Downloads/strawberry-perl-5.24.1.1-32bit-portable.zip";
//        String destDirectory = "C:/Users/frm/.vcell/bngperltest";
//        UnzipUtility unzipper = new UnzipUtility();
//        try {
//            unzipper.unzip(zipFilePath, destDirectory);
//        } catch (Exception ex) {
//            // some errors occurred
//            ex.printStackTrace();
//        }
//	}

}
