// $Id: BareBonesBrowserLaunch.java,v 1.5 2013/03/31 13:52:04 gerard Exp $
package com.centerkey.utils;

import java.io.IOException;
import java.util.Arrays;

import javax.swing.JOptionPane;

/**
 * <b>Bare Bones Browser Launch for Java</b><br>
 * Utility class to open a web page from a Swing application
 * in the user's default browser.<br>
 * Supports: Mac OS X, GNU/Linux, Unix, Windows XP/Vista/7<br>
 * Example Usage:<code><br> &nbsp; &nbsp;
 *    String url = "http://www.google.com/";<br> &nbsp; &nbsp;
 *    BareBonesBrowserLaunch.openURL(url);<br></code>
 * Latest Version: <a href="http://www.centerkey.com/java/browser/">www.centerkey.com/java/browser</a><br>
 * Author: Dem Pilafian<br>
 * Public Domain Software -- Free to Use as You Like
 * @version 3.1, June 6, 2010
 */
public class BareBonesBrowserLaunch {

    public static final String[] browsers = {
        "google-chrome",
        "firefox",
        "opera",
        "epiphany",
        "konqueror",
        "conkeror",
        "midori",
        "kazehakase",
        "mozilla",
        "chromium-browser",
        "xdg-open"
    };

    public static final String errMsg = "Error attempting to launch web browser";

    /**
     * lazy evaluated active browser
     */
    private static String browser;

    /**
     * Opens the specified web page in the user's default browser
     * @param url A web address (URL) of a web page (ex: "http://www.google.com/")
     */
    public static void openURL(String url) {
        try {  //attempt to use Desktop library from JDK 1.6+
            Class<?> d = Class.forName("java.awt.Desktop");
            d.getDeclaredMethod("browse", new Class[] {java.net.URI.class}).invoke(
                d.getDeclaredMethod("getDesktop").invoke(null),
                new Object[] {java.net.URI.create(url)});
            //above code mimicks:  java.awt.Desktop.getDesktop().browse()
        }
        catch (Exception ignore) {  //library not available or failed
            String osName = System.getProperty("os.name");
            try {
                if (osName.startsWith("Mac OS")) {
                    Class.forName("com.apple.eio.FileManager").getDeclaredMethod(
                        "openURL", new Class[] {String.class}).invoke(null,
                                new Object[] {url});
                }
                else if (osName.startsWith("Windows"))
                    Runtime.getRuntime().exec(
                        "rundll32 url.dll,FileProtocolHandler " + url);
                else { //assume Unix or Linux
                    if (getBrowser() != null) {
                        Runtime.getRuntime().exec(new String[] {browser, url});
                    }
                    else {
                        throw new Exception("Unable to find available browser, searched for " +
                                            Arrays.toString(browsers));
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, errMsg + "\n" + e.toString());
            }
        }
    }

    /**
     * lazy evaluate and cache available browser name
     * @return {@link #browser} or null if none found
     * @throws IOException
     */
    private static String  getBrowser() throws IOException {
        if (browser == null) {
            for (String b : browsers) {
                if (browser == null && Runtime.getRuntime().exec(new String[]
                        {"which", b}).getInputStream().read() != -1)
                    browser = b;
            }
        }
        return browser;
    }

}
/*
 * $Log: BareBonesBrowserLaunch.java,v $
 * Revision 1.5  2013/03/31 13:52:04  gerard
 * add browser name for ubuntu, detect Desktop browse fail
 *
 * Revision 1.4  2012/01/11 12:43:01  gerard
 * restore
 *
 * Revision 1.2  2011/03/20 17:53:07  gerard
 * Refactor to include "DataIdentification" functionality within UniformDataElements
 *
 * Revision 1.1  2011/03/14 22:30:37  gerard
 * online help link and units
 *
 */
