/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.solvers;
import java.io.File;
import java.util.Date;

import cbit.vcell.messaging.server.SimulationTask;
import cbit.vcell.server.VCellConnection;
import cbit.vcell.solver.server.Solver;
import cbit.vcell.solver.server.SolverListener;
/**
 * This interface was generated by a SmartGuide.
 * 
 */
public class SolverControllerImpl {
	//
	// for inner class only
	//
	private VCellConnection vcConn = null;
	private SolverListener solverListener = null;
	
	private SimulationTask simulationTask = null;
	private Solver solver = null;
	private File directory = null;
	private Date startDate = null;
	private Date endDate = null;

/**
 * This method was created by a SmartGuide.
 * @param simContext cbit.vcell.math.MathDescription
 * @param platform cbit.vcell.solvers.Platform
 * @param directory java.lang.String
 * @param simIdentifier java.lang.String
 */
public SolverControllerImpl (VCellConnection argVCellConnection, SimulationTask simulationTask, java.io.File directory) throws cbit.vcell.solver.SolverException {
	this.simulationTask = simulationTask;
	this.directory = directory;
	this.vcConn = argVCellConnection;
	//
	// instantiate an appropriate solver
	//
	this.solver = cbit.vcell.solver.server.SolverFactory.createSolver(directory,simulationTask, false);
}


/**
 * This method was created by a SmartGuide.
 * @return java.util.Date
 */
public Date getEndDate() {
	return endDate;
}


/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.math.MathDescription
 */
public SimulationTask getSimulationTask() {
	return simulationTask;
}


/**
 * Insert the method's description here.
 * Creation date: (6/26/2001 6:25:18 PM)
 * @return cbit.vcell.solver.Solver
 */
public cbit.vcell.solver.server.Solver getSolver() {
	return solver;
}


/**
 * This method was created by a SmartGuide.
 * @return java.util.Date
 */
public Date getStartDate() {
	return startDate;
}


/**
 * This method was created by a SmartGuide.
 */
public void startSimulationJob() throws SimExecutionException {
	if (getSolver() != null){
		startDate = new Date();
		getSolver().startSolver();
		endDate = new Date();
	}
}


/**
 * This method was created by a SmartGuide.
 */
public void stopSimulationJob() {
	if (getSolver() != null) {
		getSolver().stopSolver();
		endDate = new Date();
	}
}
}
