/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.solver;
import java.io.Serializable;

import org.vcell.util.document.KeyValue;
import org.vcell.util.document.SimulationVersion;
import org.vcell.util.document.User;
import org.vcell.util.document.VCellSoftwareVersion;
import org.vcell.util.document.Version;
import org.vcell.util.document.VersionInfo;
import org.vcell.util.document.VersionableType;

/**
 * This class was generated by a SmartGuide.
 * 
 */
public class SimulationInfo implements Serializable,VersionInfo {
	private KeyValue mathRef = null;
	private SimulationVersion simulationVersion = null;
	private String simulationID = null;
	private VCellSoftwareVersion softwareVersion = null;

/**
 * This method was created in VisualAge.
 * @param argGeomRef KeyValue
 * @param argVersion cbit.sql.Version
 */
public SimulationInfo(KeyValue argMathRef, SimulationVersion argSimulationVersion, VCellSoftwareVersion softwareVersion) {
	super();
	if (argSimulationVersion==null){
		throw new IllegalArgumentException("version cannot be null");
	}
	this.mathRef = argMathRef;
	this.simulationVersion = argSimulationVersion;
	this.softwareVersion = softwareVersion;
}


/**
 * Insert the method's description here.
 * Creation date: (1/25/01 12:24:41 PM)
 * @return boolean
 * @param object java.lang.Object
 */
public boolean equals(Object object) {
	if (object instanceof SimulationInfo){
		if (!getVersion().getVersionKey().equals(((SimulationInfo)object).getVersion().getVersionKey())){
			return false;
		}
		return true;
	}
	return false;
}


/**
 * Insert the method's description here.
 * Creation date: (8/24/2004 1:18:11 PM)
 * @return cbit.vcell.solver.VCSimulationIdentifier
 */
public VCSimulationIdentifier getAuthoritativeVCSimulationIdentifier() {
	if (getParentSimulationReference()==null){
		return new VCSimulationIdentifier(getVersion().getVersionKey(),getVersion().getOwner());
	}else{
		return new VCSimulationIdentifier(getParentSimulationReference(),getVersion().getOwner());
	}
}


/**
 * Gets the description property (java.lang.String) value.
 * @return The description property value.
 */
public java.lang.String getDescription() {
	return simulationVersion.getAnnot();
}


/**
 * This method was created in VisualAge.
 * @return cbit.sql.KeyValue
 */
public KeyValue getMathRef() {
	return mathRef;
}


/**
 * Gets the name property (java.lang.String) value.
 * @return The name property value.
 */
public java.lang.String getName() {
	return simulationVersion.getName();
}


/**
 * This method was created in VisualAge.
 * @return cbit.sql.Version
 */
public User getOwner() {
	return simulationVersion.getOwner();
}


/**
 * Insert the method's description here.
 * Creation date: (7/9/2004 1:43:29 PM)
 * @return cbit.sql.KeyValue
 */
public KeyValue getParentSimulationReference() {
	return simulationVersion.getParentSimulationReference();
}


/**
 * This method was created in VisualAge.
 * @return cbit.sql.Version
 */
public SimulationVersion getSimulationVersion() {
	return simulationVersion;
}


/**
 * This method was created in VisualAge.
 * @return cbit.sql.Version
 */
public Version getVersion() {
	return simulationVersion;
}


/**
 * Insert the method's description here.
 * Creation date: (1/25/01 12:28:06 PM)
 * @return int
 */
public int hashCode() {
	return getVersion().getVersionKey().hashCode();
}


/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String toString() {
		return "SimulationInfo(mathRef="+mathRef+",SimulationID="+simulationID+",Version="+simulationVersion+")";
}


public VersionableType getVersionType() {
	return VersionableType.Simulation;
}


public VCellSoftwareVersion getSoftwareVersion() {
	return softwareVersion;
}
}
