/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.server;
import org.vcell.util.DataAccessException;
import org.vcell.util.document.KeyValue;

import cbit.vcell.message.server.bootstrap.client.RemoteProxyVCellConnectionFactory.RemoteProxyException;
import cbit.vcell.solver.VCSimulationIdentifier;
/**
 * This interface was generated by a SmartGuide.
 * 
 */
public interface SimulationController {
/**
 * This method was created by a SmartGuide.
 * @exception RemoteProxyException The exception description.
 */
public SimulationStatus startSimulation(VCSimulationIdentifier vcSimulationIdentifier, int numSimulationScanJobs) throws RemoteProxyException;


/**
 * This method was created by a SmartGuide.
 * @exception RemoteProxyException The exception description.
 */
public SimulationStatus stopSimulation(VCSimulationIdentifier vcSimulationIdentifier) throws RemoteProxyException;


public SimulationStatus[] getSimulationStatus(KeyValue[] simKeys) throws DataAccessException, RemoteProxyException;


public SimulationStatus getSimulationStatus(KeyValue simulationKey) throws DataAccessException, RemoteProxyException;

public SimpleJobStatus[] getSimpleJobStatus(SimpleJobStatusQuerySpec simStatusQuerySpec) throws DataAccessException, RemoteProxyException;
}
