/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.model;

import java.beans.PropertyVetoException;
import java.util.List;

import org.vcell.util.*;
import org.vcell.util.Issue.IssueCategory;

import cbit.vcell.parser.Expression;
import cbit.vcell.parser.ExpressionException;

/**
 * This class was generated by a SmartGuide.
 * 
 */
public class GeneralCurrentKinetics extends DistributedKinetics {

public GeneralCurrentKinetics(ReactionStep reactionStep) throws ExpressionException {
	super(KineticsDescription.GeneralCurrent.getName(),reactionStep);
	try {
		KineticsParameter currentParm = new KineticsParameter(getDefaultParameterName(ROLE_CurrentDensity),new Expression(0.0),ROLE_CurrentDensity,null);
		KineticsParameter rateParm = new KineticsParameter(getDefaultParameterName(ROLE_ReactionRate),new Expression(0.0),ROLE_ReactionRate,null);
		KineticsParameter carrierChargeValence = new KineticsParameter(getDefaultParameterName(ROLE_CarrierChargeValence),new Expression(1.0),ROLE_CarrierChargeValence,null);
		KineticsParameter netChargeValence = new KineticsParameter(getDefaultParameterName(ROLE_NetChargeValence),new Expression(1.0),ROLE_NetChargeValence,null);

		if (reactionStep instanceof FluxReaction){
			setKineticsParameters(new KineticsParameter[] { currentParm, rateParm, carrierChargeValence });
		}else{
			setKineticsParameters(new KineticsParameter[] { currentParm, rateParm, netChargeValence });
		}
		updateGeneratedExpressions();
		refreshUnits();
	}catch (PropertyVetoException e){
		throw new RuntimeException("unexpected exception: "+e.getMessage(), e);
	}
}

	@Override
	public boolean compareEqual(Matchable obj) {
		if (obj == this){
			return true;
		}
		if (!(obj instanceof GeneralCurrentKinetics)){
			return false;
		}

		GeneralCurrentKinetics gck = (GeneralCurrentKinetics)obj;

		if (!compareEqual0(gck)){
			return false;
		}

		return true;
	}

	@Override
	public boolean relate(Relatable obj, RelationVisitor rv) {
		if (obj == this){
			return true;
		}
		if (!(obj instanceof GeneralCurrentKinetics)){
			return false;
		}

		GeneralCurrentKinetics gck = (GeneralCurrentKinetics)obj;

		if (!relate0(gck, rv)){
			return false;
		}

		return true;
	}
/**
 * Insert the method's description here.
 * Creation date: (5/12/2004 3:08:25 PM)
 * @return cbit.util.Issue[]
 */
@Override
public void gatherIssues(IssueContext issueContext, List<Issue> issueList){

	super.gatherIssues(issueContext,issueList);
	
	if (getReactionStep() instanceof SimpleReaction){
		issueList.add(new Issue(getReactionStep(),issueContext,IssueCategory.KineticsApplicability,"General Current Kinetics expected within a flux reaction only",Issue.SEVERITY_ERROR));
	}
}
/**
 * Insert the method's description here.
 * Creation date: (8/5/2002 6:02:20 PM)
 * @return cbit.vcell.model.KineticsDescription
 */
public KineticsDescription getKineticsDescription() {
	return KineticsDescription.GeneralCurrent;
}
/**
 * Insert the method's description here.
 * Creation date: (3/31/2004 3:56:05 PM)
 */
protected void refreshUnits() {
	if (bRefreshingUnits){
		return;
	}
	try {
		bRefreshingUnits = true;
		Model model = getReactionStep().getModel();
		if (model != null) {
			ModelUnitSystem modelUnitSystem = model.getUnitSystem();
			Kinetics.KineticsParameter rateParm = getReactionRateParameter();
			if (getReactionStep() instanceof FluxReaction){
				if (rateParm != null){
					rateParm.setUnitDefinition(modelUnitSystem.getFluxReactionUnit());
				}
			}else if (getReactionStep() instanceof SimpleReaction){
				if (rateParm != null){
					rateParm.setUnitDefinition(modelUnitSystem.getMembraneReactionRateUnit());
				}
			}
			Kinetics.KineticsParameter currentDensityParm = getCurrentDensityParameter();
			if (currentDensityParm != null){
				currentDensityParm.setUnitDefinition(modelUnitSystem.getCurrentDensityUnit());
			}
			KineticsParameter chargeValenceParm = getChargeValenceParameter();
			if (chargeValenceParm!=null){
				chargeValenceParm.setUnitDefinition(modelUnitSystem.getInstance_DIMENSIONLESS());
			}
		}
	}finally {
		bRefreshingUnits = false;
	}
	
}
/**
 * Insert the method's description here.
 * Creation date: (10/18/2003 11:57:27 PM)
 */
protected void updateGeneratedExpressions() throws ExpressionException, PropertyVetoException {
	// PRIMARY CURRENT DENSITY
	// user defined, nothing to do
	
	// SECONDARY REACTION RATE
	// update from current density
	updateReactionRatesFromInwardCurrentDensity();
}
}
