/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.math;
import org.vcell.util.Compare;
import org.vcell.util.Matchable;

import cbit.vcell.parser.Expression;
import cbit.vcell.parser.ExpressionBindingException;
import cbit.vcell.parser.ExpressionException;
import cbit.vcell.parser.SymbolTable;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class Constant extends Variable {
	private Expression exp = null;
	private Boolean bConstant = null;

/**
 * Constant constructor comment.
 * @param name java.lang.String
 */
public Constant(String name, Expression exp) {
	super(name, null);
	if (exp==null){
		throw new IllegalArgumentException("exp is null");
	}
	this.exp = new Expression(exp);
}


/**
 * This method was created by a SmartGuide.
 * @param symbolTable cbit.vcell.parser.SymbolTable
 * @exception java.lang.Exception The exception description.
 */
public void bind(SymbolTable symbolTable) throws ExpressionBindingException {
	if (exp!=null){
		exp.bindExpression(symbolTable);	
	}	
}


/**
 * This method was created in VisualAge.
 * @return boolean
 * @param obj Matchable
 */
public boolean compareEqual(Matchable obj,boolean bIgnoreMissingDomain) {
	if (!(obj instanceof Constant)){
		return false;
	}
	if (!compareEqual0(obj,bIgnoreMissingDomain)){
		return false;
	}
	Constant v = (Constant)obj;
	if (!Compare.isEqualOrNull(exp,v.exp)){
		return false;
	}
	
	return true;
}


/**
 * This method was created in VisualAge.
 * @return double
 */
public double getConstantValue() throws ExpressionException {
	return exp.evaluateConstant();
}


/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.parser.Expression
 * @exception java.lang.Exception The exception description.
 */
public Expression getExpression() {
	return exp;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getVCML() {
	return VCML.Constant + "  " + getName() + "\t" + exp.infix() + ";";
}


/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
public boolean isConstant() {
	if (bConstant == null) {
		try {
			exp.evaluateConstant();
			bConstant = true;
		}catch (ExpressionException e){
			bConstant = false;
		}
	}
	return bConstant;
}


/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String toString() {
	return "Constant("+hashCode()+") <"+getName()+"> = '"+getExpression()+"'";
}
}
