/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package org.vcell.util;
import java.io.File;
import java.io.FilenameFilter;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class SimpleFilenameFilter extends javax.swing.filechooser.FileFilter implements FilenameFilter {
	private String extension = null;
	private String description = null;

/**
 * This method was created by a SmartGuide.
 * @param mask java.lang.String
 */
public SimpleFilenameFilter (String extension) {
	this.extension = extension;
	this.description = checkKnownExtensions(extension);
}


/**
 * This method was created in VisualAge.
 * @return boolean
 * @param file java.io.File
 */
public boolean accept(File file) {
	return accept(file.getParentFile(), file.getName());
}


/**
 * accept method comment.
 */
public boolean accept(File dir, String name) {
	if (dir != null && name != null) {
		File file = new File(dir, name);
		if (file.isDirectory()) {
			return true;
		} else {
			return (name.toLowerCase().endsWith(extension.toLowerCase()));
		}
	} else {
		return false;
	}
}


/**
 * Insert the method's description here.
 * Creation date: (5/31/2001 6:11:54 PM)
 * @return java.lang.String
 * @param extension java.lang.String
 */
private String checkKnownExtensions(String extension) {
	if (extension == null) {
		return null;
	} else if (extension.equalsIgnoreCase("zip")) {
		return "ZIP archive files";
	} else if (extension.equalsIgnoreCase("jpg")) {
		return "JPEG compressed image files";
	} else if (extension.equalsIgnoreCase("tif")) {
		return "TIFF image files";
	} else if (extension.equalsIgnoreCase("gif")) {
		return "GIF image files";
	} else if (extension.equalsIgnoreCase("mov")) {
		return "Quicktime movie files";
	} else if (extension.equalsIgnoreCase("csv")) {
		return "Comma-delimited ASCII files";
	}
	return ("." + extension + " files");
}


/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String getDescription() {
	return description;
}
}
