CREATE TABLE vc_userinfo(id bigint PRIMARY KEY,USERID varchar(255) UNIQUE NOT NULL,PASSWORD varchar(255) NOT NULL,EMAIL varchar(255) NOT NULL,FIRSTNAME varchar(255) NOT NULL,LASTNAME varchar(255) ,TITLE varchar(255) ,COMPANYNAME varchar(255) ,ADDRESS1 varchar(255) ,ADDRESS2 varchar(255) ,CITY varchar(255) ,STATE varchar(255) ,COUNTRY varchar(255) ,ZIP varchar(255) ,NOTIFY varchar(255) NOT NULL,insertDate timestamp NOT NULL,DIGESTPW varchar(255) NOT NULL);
CREATE TABLE vc_group(id bigint PRIMARY KEY,groupid bigint NOT NULL,userRef bigint NOT NULL REFERENCES vc_userinfo(id) ON DELETE CASCADE,isHiddenFromOwner bigint NOT NULL,groupMemberHash numeric NOT NULL);
CREATE TABLE vc_model(id bigint PRIMARY KEY,name varchar(255) NOT NULL,ownerRef bigint NOT NULL REFERENCES vc_userinfo(id),privacy bigint NOT NULL,versionPRef bigint REFERENCES vc_model(id),versionDate timestamp NOT NULL,versionFlag bigint NOT NULL,versionAnnot varchar(4000) ,versionBranchID bigint NOT NULL,unitSystemXML varchar(4000) ,rbmLRG text ,rbmSML varchar(4000) );
CREATE TABLE vc_celltype(id bigint PRIMARY KEY,name varchar(255) NOT NULL,annotation varchar(255) NOT NULL);
CREATE TABLE vc_struct(id bigint PRIMARY KEY,strName varchar(255) NOT NULL,structType varchar(10) NOT NULL,parentRef bigint ,cellTypeRef bigint REFERENCES vc_celltype(id),memVoltName varchar(64) ,negFeatureRef bigint REFERENCES vc_struct(id),posFeatureRef bigint REFERENCES vc_struct(id));
CREATE TABLE vc_reactstep(id bigint PRIMARY KEY,reactType varchar(10) NOT NULL,modelRef bigint NOT NULL REFERENCES vc_model(id) ON DELETE CASCADE,structRef bigint NOT NULL REFERENCES vc_struct(id),kinetics text ,name varchar(255) ,chargeValence bigint ,physicsOptions bigint ,kineticsLRG text ,kineticsSML varchar(4000) ,annotation varchar(4000) ,sbmlname varchar(255) );
CREATE TABLE vc_protein(id bigint PRIMARY KEY,organism varchar(1024) ,accessionnumber varchar(1024) ,swissprotid varchar(32) UNIQUE NOT NULL,keywords varchar(1024) ,description varchar(1024) ,molWeight numeric );
CREATE TABLE vc_proteinalias(id bigint PRIMARY KEY,proteinRef bigint REFERENCES vc_protein(id) ON DELETE CASCADE NOT NULL,name varchar(256) NOT NULL,preferred varchar(1) NOT NULL);
CREATE TABLE vc_compound(id bigint PRIMARY KEY,formula varchar(256) ,casId varchar(256) ,keggId varchar(32) UNIQUE NOT NULL);
CREATE TABLE vc_compoundalias(id bigint PRIMARY KEY,compoundRef bigint REFERENCES vc_compound(id) ON DELETE CASCADE NOT NULL,name varchar(256) NOT NULL,preferred varchar(1) NOT NULL);
CREATE TABLE vc_enzyme(id bigint PRIMARY KEY,reaction varchar(512) ,ecnumber varchar(32) UNIQUE NOT NULL,sysname varchar(512) ,casid varchar(256) );
CREATE TABLE vc_enzymealias(id bigint PRIMARY KEY,enzymeRef bigint REFERENCES vc_enzyme(id) ON DELETE CASCADE NOT NULL,name varchar(256) NOT NULL,preferred varchar(1) NOT NULL);
CREATE TABLE vc_enzymereaction(id bigint PRIMARY KEY,reactionId varchar(32) NOT NULL,enzymeRef bigint REFERENCES vc_enzyme(id) ON DELETE CASCADE,compoundRef bigint REFERENCES vc_compound(id) ON DELETE CASCADE NOT NULL,type varchar(1) NOT NULL,stoich bigint NOT NULL,parsedECNumber varchar(32) );
CREATE TABLE vc_dbspecies(id bigint PRIMARY KEY,compoundRef bigint REFERENCES vc_compound(id),enzymeRef bigint REFERENCES vc_enzyme(id),proteinRef bigint REFERENCES vc_protein(id), CONSTRAINT com_enz_pro_unique UNIQUE(compoundRef,enzymeRef,proteinRef), CONSTRAINT com_enz_pro_only_1 CHECK((CASE WHEN compoundref IS NULL THEN 0 ELSE 1 END)+(CASE WHEN enzymeref IS NULL THEN 0 ELSE 1 END)+(CASE WHEN proteinref IS NULL THEN 0 ELSE 1 END) = 1));
CREATE TABLE vc_specialusers(id bigint PRIMARY KEY,SPECIAL varchar(255) NOT NULL,USERREF bigint NOT NULL REFERENCES vc_userinfo(id),USERDETAIL varchar(255) );
CREATE TABLE vc_species(id bigint PRIMARY KEY,commonName varchar(255) NOT NULL,dbSpeciesRef bigint REFERENCES vc_dbspecies(id),annotation varchar(1024) );
CREATE TABLE vc_modelsc(id bigint PRIMARY KEY,modelRef bigint NOT NULL REFERENCES vc_model(id) ON DELETE CASCADE,speciesRef bigint NOT NULL REFERENCES vc_species(id),structRef bigint NOT NULL REFERENCES vc_struct(id),name varchar(255) NOT NULL,hasOverride varchar(1) NOT NULL,speciesPattern varchar(2000) ,sbmlName varchar(255) );
CREATE TABLE vc_modelstruct(id bigint PRIMARY KEY,modelRef bigint NOT NULL REFERENCES vc_model(id) ON DELETE CASCADE,structRef bigint NOT NULL REFERENCES vc_struct(id));
CREATE TABLE vc_reactpart(id bigint PRIMARY KEY,role varchar(10) NOT NULL,stoich bigint NOT NULL,reactStepRef bigint NOT NULL REFERENCES vc_reactstep(id) ON DELETE CASCADE,scRef bigint NOT NULL REFERENCES vc_modelsc(id));
CREATE TABLE vc_diagram(id bigint PRIMARY KEY,name varchar(255) NOT NULL,modelRef bigint NOT NULL REFERENCES vc_model(id) ON DELETE CASCADE,structRef bigint NOT NULL REFERENCES vc_struct(id),language text ,diagramLRG text ,diagramSML varchar(4000) );
CREATE TABLE vc_geomextent(id bigint PRIMARY KEY,extentX numeric NOT NULL,extentY numeric NOT NULL,extentZ numeric NOT NULL);
CREATE TABLE vc_image(id bigint PRIMARY KEY,name varchar(255) NOT NULL,ownerRef bigint NOT NULL REFERENCES vc_userinfo(id),privacy bigint NOT NULL,versionPRef bigint REFERENCES vc_image(id),versionDate timestamp NOT NULL,versionFlag bigint NOT NULL,versionAnnot varchar(4000) ,versionBranchID bigint NOT NULL,numX bigint NOT NULL,numY bigint NOT NULL,numZ bigint NOT NULL,extentRef bigint NOT NULL REFERENCES vc_geomextent(id));
CREATE TABLE vc_imagedata(id bigint PRIMARY KEY,imageRef bigint NOT NULL REFERENCES vc_image(id) ON DELETE CASCADE,data bytea NOT NULL);
CREATE TABLE vc_browsedata(id bigint PRIMARY KEY,imageRef bigint NOT NULL REFERENCES vc_image(id) ON DELETE CASCADE,data bytea NOT NULL);
CREATE TABLE vc_imageregion(id bigint PRIMARY KEY,regionName varchar(255) NOT NULL,imageRef bigint NOT NULL REFERENCES vc_image(id) ON DELETE CASCADE,pixelValue bigint NOT NULL);
CREATE TABLE vc_geometry(id bigint PRIMARY KEY,name varchar(255) NOT NULL,ownerRef bigint NOT NULL REFERENCES vc_userinfo(id),privacy bigint NOT NULL,versionPRef bigint REFERENCES vc_geometry(id),versionDate timestamp NOT NULL,versionFlag bigint NOT NULL,versionAnnot varchar(4000) ,versionBranchID bigint NOT NULL,dimension bigint NOT NULL,originX numeric NOT NULL,originY numeric NOT NULL,originZ numeric NOT NULL,extentRef bigint NOT NULL REFERENCES vc_geomextent(id),imageRef bigint REFERENCES vc_image(id));
CREATE TABLE vc_subvolume(id bigint PRIMARY KEY,name varchar(255) NOT NULL,imageRegionRef bigint REFERENCES vc_imageregion(id),geometryRef bigint NOT NULL REFERENCES vc_geometry(id) ON DELETE CASCADE,expression varchar(2048) ,handle bigint NOT NULL,ordinal bigint NOT NULL);
CREATE TABLE vc_surfaceclass(id bigint PRIMARY KEY,name varchar(255) NOT NULL,geometryRef bigint NOT NULL REFERENCES vc_geometry(id) ON DELETE CASCADE,subVolumeRef1 bigint REFERENCES vc_subvolume(id),subVolumeRef2 bigint REFERENCES vc_subvolume(id));
CREATE TABLE vc_math(id bigint PRIMARY KEY,name varchar(255) NOT NULL,ownerRef bigint NOT NULL REFERENCES vc_userinfo(id),privacy bigint NOT NULL,versionPRef bigint REFERENCES vc_math(id),versionDate timestamp NOT NULL,versionFlag bigint NOT NULL,versionAnnot varchar(4000) ,versionBranchID bigint NOT NULL,geometryRef bigint NOT NULL REFERENCES vc_geometry(id),language text NOT NULL);
CREATE TABLE vc_simcontext(id bigint PRIMARY KEY,name varchar(255) NOT NULL,ownerRef bigint NOT NULL REFERENCES vc_userinfo(id),privacy bigint NOT NULL,versionPRef bigint REFERENCES vc_simcontext(id),versionDate timestamp NOT NULL,versionFlag bigint NOT NULL,versionAnnot varchar(4000) ,versionBranchID bigint NOT NULL,mathRef bigint REFERENCES vc_math(id),modelRef bigint NOT NULL REFERENCES vc_model(id),geometryRef bigint NOT NULL REFERENCES vc_geometry(id),charSize numeric ,appComponentsLRG text ,appComponentsSML varchar(4000) );
CREATE TABLE vc_speciescontextspec(id bigint PRIMARY KEY,specContextRef bigint NOT NULL REFERENCES vc_modelsc(id),simContextRef bigint NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,bEnableDif bigint NOT NULL,bForceConst bigint NOT NULL,bForceIndep bigint NOT NULL,initCondExp varchar(2048) ,diffRateExp varchar(1024) NOT NULL,boundaryXmExp varchar(255) ,boundaryXpExp varchar(255) ,boundaryYmExp varchar(255) ,boundaryYpExp varchar(255) ,boundaryZmExp varchar(255) ,boundaryZpExp varchar(255) ,initCondCountExp varchar(1024) ,velocityXExp varchar(1024) ,velocityYExp varchar(1024) ,velocityZExp varchar(1024) ,bWellMixed bigint ,bForceContinuous bigint ,internalLinks varchar(4000) ,siteAttributesSpecs varchar(4000) );
CREATE TABLE vc_structmapping(id bigint PRIMARY KEY,subVolumeRef bigint REFERENCES vc_subvolume(id),structRef bigint NOT NULL REFERENCES vc_struct(id),simContextRef bigint NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,bResolved bigint NOT NULL,surfToVolExp varchar(1024) ,volFractExp varchar(1024) ,boundaryTypeXm varchar(10) ,boundaryTypeXp varchar(10) ,boundaryTypeYm varchar(10) ,boundaryTypeYp varchar(10) ,boundaryTypeZm varchar(10) ,boundaryTypeZp varchar(10) ,bCalculateV bigint ,specificCap numeric ,initialV varchar(1024) ,sizeExp varchar(1024) ,volPerUnitAreaExp varchar(1024) ,volPerUnitVolExp varchar(1024) ,areaPerUnitAreaExp varchar(1024) ,areaPerUnitVolExp varchar(1024) ,surfaceClassRef bigint REFERENCES vc_surfaceclass(id));
CREATE TABLE vc_reactionspec(id bigint PRIMARY KEY,reactStepRef bigint NOT NULL REFERENCES vc_reactstep(id),simContextRef bigint NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,mapping bigint NOT NULL);
CREATE TABLE vc_stimulus(id bigint PRIMARY KEY,structRef bigint NOT NULL REFERENCES vc_struct(id),simContextRef bigint NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,name varchar(255) ,stimulusType bigint NOT NULL,expression varchar(4000) ,posX numeric NOT NULL,posY numeric NOT NULL,posZ numeric NOT NULL,params varchar(4000) );
CREATE TABLE vc_analysistask(id bigint PRIMARY KEY,simContextRef bigint NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,analysisTaskXML text NOT NULL,insertDate timestamp NOT NULL);
CREATE TABLE vc_filament(id bigint PRIMARY KEY,filamentName varchar(255) NOT NULL,geometryRef bigint NOT NULL REFERENCES vc_geometry(id) ON DELETE CASCADE);
CREATE TABLE vc_curve(id bigint PRIMARY KEY,curveData text NOT NULL,filamentRef bigint NOT NULL REFERENCES vc_filament(id) ON DELETE CASCADE);
CREATE TABLE vc_simulation(id bigint PRIMARY KEY,name varchar(255) NOT NULL,ownerRef bigint NOT NULL REFERENCES vc_userinfo(id),privacy bigint NOT NULL,versionPRef bigint REFERENCES vc_simulation(id),versionDate timestamp NOT NULL,versionFlag bigint NOT NULL,versionAnnot varchar(4000) ,versionBranchID bigint NOT NULL,parentSimRef bigint REFERENCES vc_simulation(id),mathRef bigint NOT NULL REFERENCES vc_math(id),mathOverrides text ,mathOverridesLRG text ,mathOverridesSML varchar(4000) ,taskDesc varchar(4000) ,meshspecx bigint ,meshspecy bigint ,meshspecz bigint ,dataProcInstr varchar(4000) );
CREATE TABLE vc_simstat(id bigint PRIMARY KEY,simRef bigint NOT NULL REFERENCES vc_simulation(id) ON DELETE CASCADE,equiv bigint ,status varchar(255) ,curatorEquiv bigint ,comments varchar(255) );
CREATE TABLE vc_biomodel(id bigint PRIMARY KEY,name varchar(255) NOT NULL,ownerRef bigint NOT NULL REFERENCES vc_userinfo(id),privacy bigint NOT NULL,versionPRef bigint REFERENCES vc_biomodel(id),versionDate timestamp NOT NULL,versionFlag bigint NOT NULL,versionAnnot varchar(4000) ,versionBranchID bigint NOT NULL,modelRef bigint NOT NULL REFERENCES vc_model(id),childSummaryLRG text ,childSummarySML varchar(4000) );
CREATE TABLE vc_biomodelsimcontext(id bigint PRIMARY KEY,biomodelRef bigint NOT NULL REFERENCES vc_biomodel(id) ON DELETE CASCADE,simContextRef bigint NOT NULL REFERENCES vc_simcontext(id));
CREATE TABLE vc_biomodelsim(id bigint PRIMARY KEY,biomodelRef bigint NOT NULL REFERENCES vc_biomodel(id) ON DELETE CASCADE,simRef bigint NOT NULL REFERENCES vc_simulation(id));
CREATE TABLE vc_mathmodel(id bigint PRIMARY KEY,name varchar(255) NOT NULL,ownerRef bigint NOT NULL REFERENCES vc_userinfo(id),privacy bigint NOT NULL,versionPRef bigint REFERENCES vc_mathmodel(id),versionDate timestamp NOT NULL,versionFlag bigint NOT NULL,versionAnnot varchar(4000) ,versionBranchID bigint NOT NULL,mathRef bigint NOT NULL REFERENCES vc_math(id),childSummaryLRG text ,childSummarySML varchar(4000) );
CREATE TABLE vc_mathmodelsim(id bigint PRIMARY KEY,mathmodelRef bigint NOT NULL REFERENCES vc_mathmodel(id) ON DELETE CASCADE,simRef bigint NOT NULL REFERENCES vc_simulation(id));
CREATE TABLE vc_available(id bigint PRIMARY KEY,insertDate timestamp NOT NULL ,isAvailable varchar(5) NOT NULL ,letUserAskForCallback varchar(5) ,offlineMessage varchar(512) );
CREATE TABLE vc_userstat(id bigint PRIMARY KEY,userRef bigint UNIQUE NOT NULL REFERENCES vc_userinfo(id) ON DELETE CASCADE,loginCount bigint ,lastLogin timestamp ,emailLostPasswordOK varchar(5) ,wantsOnlineCallback varchar(5) ,userAgent varchar(255) ,useMac bigint ,useWin bigint ,useLin bigint );
CREATE TABLE vc_userlog(id bigint PRIMARY KEY,userRef bigint NOT NULL REFERENCES vc_userinfo(id) ON DELETE CASCADE,eventDate timestamp NOT NULL,logText varchar(255) NOT NULL,filePath varchar(255) ,eventType varchar(10) NOT NULL,swVersion varchar(10) ,ipAddress varchar(40) );
CREATE TABLE vc_simcontextstat(id bigint PRIMARY KEY,simContextRef bigint NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,hasDupReact bigint ,hasData bigint ,equiv bigint ,status varchar(255) ,oldMath text ,newMath text ,curatorEquiv bigint ,comments varchar(255) ,updatedMath bigint );
CREATE TABLE vc_simcontextstat2(id bigint PRIMARY KEY,simContextRef bigint NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,hasData bigint ,equiv bigint ,status varchar(255) ,curatorEquiv bigint ,comments varchar(255) ,equiv_4_8 bigint ,status_4_8 varchar(255) );
CREATE TABLE stochtest(id bigint PRIMARY KEY,simcontextref bigint NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,biomodelref bigint NOT NULL REFERENCES vc_biomodel(id) ON DELETE CASCADE,mathref bigint NOT NULL REFERENCES vc_math(id) ON DELETE CASCADE,dimension bigint NOT NULL,numcompartments bigint ,mathtype varchar(64) );
CREATE TABLE stochtestrun(id bigint PRIMARY KEY,stochtestref bigint NOT NULL REFERENCES stochtest(id) ON DELETE CASCADE,parentmathtype varchar(64) NOT NULL,mathtype varchar(64) NOT NULL,status varchar(32) NOT NULL,errmsg varchar(4000) ,conclusion varchar(4000) ,exclude varchar(4000) ,networkGenProbs varchar(4000) );
CREATE TABLE stochtestcompare(id bigint PRIMARY KEY,stochtestrunref1 bigint NOT NULL REFERENCES stochtestrun(id) ON DELETE CASCADE,stochtestrunref2 bigint NOT NULL REFERENCES stochtestrun(id) ON DELETE CASCADE,results varchar(4000) ,status varchar(32) ,errmsg varchar(4000) ,conclusion varchar(4000) ,smallest_pvalue numeric ,numexperiments bigint ,numfail_95 bigint ,numfail_99 bigint ,numfail_999 bigint );
CREATE TABLE vc_simulationjob(id bigint PRIMARY KEY,simRef bigint NOT NULL REFERENCES vc_simulation(id) ON DELETE CASCADE,submitDate timestamp NOT NULL,taskID bigint NOT NULL,schedulerStatus bigint NOT NULL,statusMsg varchar(4000) ,queueDate timestamp ,queuePriority bigint ,queueID bigint ,startDate timestamp ,computeHost varchar(255) ,latestUpdateDate timestamp NOT NULL,endDate timestamp ,hasData char(1) ,serverID varchar(20) NOT NULL,jobIndex bigint ,pbsJobID varchar(100) , CONSTRAINT sim_job_task_unique UNIQUE(simref,jobindex,taskid));
CREATE TABLE vc_biomodelxml(id bigint PRIMARY KEY,biomodelRef bigint UNIQUE NOT NULL REFERENCES vc_biomodel(id) ON DELETE CASCADE,bmxml text NOT NULL,changeDate timestamp NOT NULL);
CREATE TABLE vc_mathmodelxml(id bigint PRIMARY KEY,mathmodelRef bigint UNIQUE NOT NULL REFERENCES vc_mathmodel(id) ON DELETE CASCADE,mmxml text NOT NULL,changeDate timestamp NOT NULL);
CREATE TABLE vc_geometricregion(id bigint PRIMARY KEY,name varchar(255) NOT NULL,regiontype bigint NOT NULL,geometryRef bigint NOT NULL REFERENCES vc_geometry(id) ON DELETE CASCADE,regionSize numeric NOT NULL,sizeUnit varchar(50) NOT NULL,volRegion1 bigint REFERENCES vc_geometricregion(id) ON DELETE CASCADE,volRegion2 bigint REFERENCES vc_geometricregion(id) ON DELETE CASCADE,regionID bigint ,subvolumeRef bigint REFERENCES vc_subvolume(id) ON DELETE CASCADE);
CREATE TABLE vc_surfacedesc(id bigint PRIMARY KEY,geometryRef bigint NOT NULL REFERENCES vc_geometry(id) ON DELETE CASCADE,sampleSizeX bigint NOT NULL,sampleSizeY bigint NOT NULL,sampleSizeZ bigint NOT NULL,filterFreq numeric NOT NULL);
CREATE TABLE vc_userpref(id bigint PRIMARY KEY,userRef bigint NOT NULL REFERENCES vc_userinfo(id) ON DELETE CASCADE,userPrefKey varchar(128) NOT NULL,userPrefValue varchar(4000) NOT NULL);
CREATE TABLE vc_tftestsuite(id bigint PRIMARY KEY,tsVersion varchar(64) UNIQUE NOT NULL ,vcBuildVersion varchar(64) NOT NULL,vcNumericsVersion varchar(64) NOT NULL,creationDate timestamp NOT NULL,changeDate timestamp ,tsAnnotation varchar(512) ,isLocked bigint NOT NULL, CONSTRAINT ts_bld_num_unique UNIQUE(vcBuildVersion,vcNumericsVersion));
CREATE TABLE vc_tftestcase(id bigint PRIMARY KEY,testSuiteRef bigint NOT NULL REFERENCES vc_tftestsuite(id) ON DELETE CASCADE,mathModelRef bigint REFERENCES vc_mathmodel(id),tcSolutionType varchar(64) NOT NULL ,tcAnnotation varchar(512) ,creationDate timestamp NOT NULL,bmAppRef bigint REFERENCES vc_biomodelsimcontext(id), CONSTRAINT tc_tsr_mm_bm_unq UNIQUE (testSuiteRef,mathModelRef,bmappref), CONSTRAINT tc_tsr_must_mmbm CHECK (not (mathmodelref is null and bmappref is null)  and  not (mathmodelref is not null and bmappref is not null)));
CREATE TABLE vc_tftestcriteria(id bigint PRIMARY KEY,testCaseRef bigint NOT NULL REFERENCES vc_tftestcase(id) ON DELETE CASCADE,simulationRef bigint UNIQUE NOT NULL REFERENCES vc_simulation(id),simDataRef bigint ,regressionSimRef bigint REFERENCES vc_mathmodelsim(id),maxRelError numeric ,maxAbsError numeric ,regressionBMAPPRef bigint REFERENCES vc_biomodelsimcontext(id),regressionBMSimRef bigint REFERENCES vc_biomodelsim(id),reportStatus varchar(32) ,reportMessage varchar(512) , CONSTRAINT tcr_tcr_simr_unique UNIQUE(testCaseRef,simulationRef));
CREATE TABLE vc_tftestresult(id bigint PRIMARY KEY,testCriteriaRef bigint NOT NULL REFERENCES vc_tftestcriteria(id) ON DELETE CASCADE,varName varchar(128) NOT NULL,absError numeric NOT NULL,relError numeric NOT NULL,maxRef numeric NOT NULL,minRef numeric NOT NULL,meanSqrError numeric NOT NULL,timeAbsError numeric NOT NULL,indexAbsError bigint NOT NULL,timeRelError numeric NOT NULL,indexRelError bigint NOT NULL, CONSTRAINT tres_tcr_vn_unique UNIQUE(testCriteriaRef,varName));
CREATE TABLE vc_softwareversion(id bigint PRIMARY KEY,versionableRef bigint UNIQUE NOT NULL,softwareVersion varchar(64) NOT NULL);
CREATE TABLE vc_externaldata(id bigint PRIMARY KEY,ownerRef bigint NOT NULL REFERENCES vc_userinfo(id),externaldataname varchar(255) NOT NULL,annotation varchar(1024) , CONSTRAINT own_fdn_unique UNIQUE(ownerRef,externaldataname));
CREATE TABLE vc_mathdescextdata(id bigint PRIMARY KEY,mathDescRef bigint NOT NULL REFERENCES vc_math(id) ON DELETE CASCADE,extDataRef bigint NOT NULL REFERENCES vc_externaldata(id), CONSTRAINT md_ed_unq UNIQUE (MATHDESCREF, EXTDATAREF));
CREATE TABLE vc_miriam(id bigint PRIMARY KEY,bioModelRef bigint REFERENCES vc_biomodel(id) ON DELETE CASCADE,speciesRef bigint REFERENCES vc_species(id) ON DELETE CASCADE,structRef bigint REFERENCES vc_struct(id) ON DELETE CASCADE,reactStepRef bigint REFERENCES vc_reactstep(id) ON DELETE CASCADE,annotation varchar(4000) ,userNotes varchar(4000) , CONSTRAINT miriam_only_1 CHECK((CASE WHEN bioModelRef IS NULL THEN 0 ELSE 1 END)+(CASE WHEN speciesRef IS NULL THEN 0 ELSE 1 END)+(CASE WHEN structRef IS NULL THEN 0 ELSE 1 END)+(CASE WHEN reactStepRef IS NULL THEN 0 ELSE 1 END) = 1), CONSTRAINT miriam_info_not_null CHECK((CASE WHEN annotation IS NULL THEN 0 ELSE 1 END)+(CASE WHEN userNotes IS NULL THEN 0 ELSE 1 END) > 0));
CREATE TABLE vc_apiclient(id bigint PRIMARY KEY,clientname varchar(255) NOT NULL,clientId varchar(255) NOT NULL,clientSecret varchar(255) NOT NULL);
CREATE TABLE vc_apiaccesstoken(id bigint PRIMARY KEY,accesstoken varchar(4000) NOT NULL,clientRef bigint NOT NULL REFERENCES vc_apiclient(id),userRef bigint NOT NULL REFERENCES vc_userinfo(id),creationDate timestamp NOT NULL,expireDate timestamp NOT NULL,status varchar(20) );
CREATE TABLE vc_publication(id bigint PRIMARY KEY,title varchar(4000) ,authors varchar(4000) ,year bigint ,citation varchar(4000) ,pubmedid varchar(64) ,doi varchar(128) ,endnoteid bigint ,url varchar(128) ,wittid bigint ,pubDate timestamp );
CREATE TABLE vc_publicationmodellink(id bigint PRIMARY KEY,pubRef bigint NOT NULL REFERENCES vc_publication(id) ON DELETE CASCADE,biomodelRef bigint  REFERENCES vc_biomodel(id) ON DELETE CASCADE,mathmodelRef bigint  REFERENCES vc_mathmodel(id) ON DELETE CASCADE);
CREATE TABLE vc_applicationmath(id bigint PRIMARY KEY,simContextRef bigint REFERENCES vc_simcontext(id) ON DELETE CASCADE,outputFuncLRG text ,outputFuncSML varchar(4000) ,mathModelRef bigint REFERENCES vc_mathmodel(id) ON DELETE CASCADE, CONSTRAINT math_or_app CHECK((CASE WHEN simContextRef IS NULL THEN 0 ELSE 1 END)+(CASE WHEN mathModelRef IS NULL THEN 0 ELSE 1 END) = 1));
CREATE TABLE vc_datasymbol(id bigint PRIMARY KEY,dataSymbolName varchar(255) NOT NULL,dataSymbolType varchar(32) NOT NULL,dataSymbolVCUnitDef varchar(64) NOT NULL,simContextRef bigint NOT NULL REFERENCES vc_simcontext(id) ON DELETE CASCADE,fieldDataRef bigint REFERENCES vc_externaldata(id),fieldDataVarName varchar(255) ,fieldDataVarType varchar(255) ,fieldDataVarTime numeric );
CREATE TABLE vc_globalmodelparam(id bigint PRIMARY KEY,modelRef bigint NOT NULL REFERENCES vc_model(id) ON DELETE CASCADE,xmlFragment varchar(4000) NOT NULL);
CREATE TABLE loadmodelstat(id bigint PRIMARY KEY,bioModelRef bigint REFERENCES vc_biomodel(id) ON DELETE CASCADE,mathModelRef bigint REFERENCES vc_mathmodel(id) ON DELETE CASCADE,resultFlag bigint ,errorMessage varchar(255) ,timeStamp varchar(32) NOT NULL,loadTime bigint ,softwareVers varchar(32) NOT NULL,loadOriginalXMLTime bigint ,loadUnresolvedTime bigint ,bSameCachedAndNotCachedXML bigint ,bSameCachedAndNotCachedObj bigint ,bSameSelfXMLCachedRoundtrip bigint ,bSameCachedAndNotCachedXMLExc varchar(255) ,bSameCachedAndNotCachedObjExc varchar(255) ,bSameSelfXMLCachedRoundtripExc varchar(255) ,bIssuesErrors varchar(255) , CONSTRAINT ldmdlstat_only_1 CHECK((CASE WHEN bioModelRef IS NULL THEN 0 ELSE 1 END)+(CASE WHEN mathModelRef IS NULL THEN 0 ELSE 1 END) = 1));
CREATE TABLE vc_userlogininfo(id bigint PRIMARY KEY,userRef bigint NOT NULL REFERENCES vc_userinfo(id) ON DELETE CASCADE,loginCount bigint NOT NULL,lastLogin timestamp NOT NULL,osarch varchar(32) NOT NULL,osname varchar(32) NOT NULL,osvers varchar(32) NOT NULL,clientVers varchar(32) NOT NULL,serverVers varchar(32) NOT NULL,javavers varchar(32) NOT NULL, CONSTRAINT ulinfo_unique UNIQUE(userRef,osarch,osname,osvers,clientVers,serverVers,javavers));
CREATE TABLE vc_metadata(id bigint PRIMARY KEY,bioModelRef bigint NOT NULL REFERENCES vc_biomodel(id) ON DELETE CASCADE,vcMetaDataLarge text ,vcMetaDataSmall varchar(4000) );
CREATE TABLE vc_simdelfromdisk(deldate varchar(20) ,userid varchar(255) NOT NULL,userkey bigint ,simid bigint ,simpref bigint ,simdate varchar(20) ,simname varchar(255) NOT NULL,status varchar(10) ,numfiles bigint ,totalsize bigint );
CREATE TABLE vc_useridentity(id bigint PRIMARY KEY,userRef bigint NOT NULL REFERENCES vc_userinfo(id),auth0Subject varchar(128) ,keycloakSubject varchar(128) ,insertDate timestamp NOT NULL);

CREATE VIEW public.dual AS SELECT CAST('X' as varchar) AS dummy;

CREATE SEQUENCE newSeq;

CREATE INDEX grp_grpid ON vc_group(groupid);
CREATE INDEX browse_imgref ON vc_browsedata(imageRef);
CREATE INDEX geom_extentref ON vc_geometry(extentRef);
CREATE INDEX geom_imageref ON vc_geometry(imageRef);
CREATE INDEX mathdesc_geomref ON vc_math(geometryRef);
CREATE INDEX simcstat_simcref ON vc_simcontextstat(simContextRef);

INSERT INTO vc_userinfo VALUES ( 0,'void','1700596370242','empty','empty','empty','empty','empty','empty','empty','empty','empty','empty','empty','empty',CURRENT_TIMESTAMP,'B9BDD75BC5382CA83D5AB82172A98D869555899C' );
INSERT INTO vc_userinfo VALUES ( 2,'Administrator','1700596370260','empty','empty','empty','empty','empty','empty','empty','empty','empty','empty','empty','empty',CURRENT_TIMESTAMP,'CD181552B879A2F29D10434D8ACF692B6C8126F9' );
INSERT INTO vc_userinfo VALUES ( 3,'vcellNagios','1700596370261','empty','empty','empty','empty','empty','empty','empty','empty','empty','empty','empty','empty',CURRENT_TIMESTAMP,'A93453F7962799355608EC89D33D3249474E538F' );
INSERT INTO vc_useridentity VALUES ( 78, 2,'auth0|65cb6311365d79c2fb96a005', null, CURRENT_TIMESTAMP);
INSERT INTO vc_group VALUES (4,1,0,0,1);
INSERT INTO vc_group VALUES (5,0,0,0,0);
INSERT INTO vc_available VALUES (6,current_timestamp,'true',NULL,NULL);
INSERT INTO vc_apiclient VALUES (7,'defaultApiClient','85133f8d-26f7-4247-8356-d175399fc2e6','98d000d6-adff-4f8f-a00e-6c28dbd8c571');
