package org.vcell.sbml;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;


@Tag("Fast")
public class VcmlTestSuiteFiles {

    private final static String[] allTestFiles = new String[]{
            "lumped_reaction_no_size_in_rate.vcml",
            "lumped_reaction_proper_size_in_rate.vcml",
            "lumped_reaction_local_size_in_rate.vcml",
            "__export_adv_test.vcml",
            "biomodel_100596964.vcml",
            "biomodel_100961371.vcml",
            "biomodel_101962320.vcml",
            "biomodel_101963252.vcml",
            "biomodel_101981216.vcml",
            "biomodel_102061382.vcml",
            "biomodel_102802266.vcml",
            "biomodel_105608907.vcml",
            "biomodel_10829774.vcml",
            "biomodel_113655498.vcml",
            "biomodel_116704767.vcml",
            "biomodel_116898182.vcml",
            "biomodel_116898345.vcml",
            "biomodel_116929912.vcml",
            "biomodel_116929971.vcml",
            "biomodel_116930032.vcml",
            "biomodel_12119723.vcml",
            "biomodel_123269393.vcml",
            "biomodel_123269480.vcml",
            "biomodel_123465498.vcml",
            "biomodel_123465505.vcml",
            "biomodel_124562627.vcml",
            "biomodel_12522025.vcml",
            "biomodel_12522025_spatial.vcml",
            "biomodel_13714636.vcml",
            "biomodel_13717231.vcml",
            "biomodel_13717282.vcml",
            "biomodel_13736736.vcml",
            "biomodel_145545992.vcml",
            "biomodel_14647285.vcml",
            "biomodel_147699816.vcml",
            "biomodel_148700996.vcml",
            "biomodel_149491513.vcml",
            "biomodel_154208982.vcml",
            "biomodel_154210963.vcml",
            "biomodel_154961582.vcml",
            "biomodel_155016832.vcml",
            "biomodel_156134818.vcml",
            "biomodel_158495696.vcml",
            "biomodel_16404713.vcml",
            "biomodel_16763273.vcml",
            "biomodel_16804037.vcml",
            "biomodel_168717401.vcml",
            "biomodel_169993006.vcml",
            "biomodel_17028306.vcml",
            "biomodel_17098642.vcml",
            "biomodel_171423478.vcml",
            "biomodel_171423486.vcml",
            "biomodel_171423593.vcml",
            "biomodel_171423851.vcml",
            "biomodel_171423920.vcml",
            "biomodel_171423957.vcml",
            "biomodel_172076998.vcml",
            "biomodel_17257105.vcml",
            "biomodel_17263179.vcml",
            "biomodel_17326658.vcml",
            "biomodel_174341395.vcml",
            "biomodel_176334674.vcml",
            "biomodel_185577495.vcml",
            "biomodel_188880263.vcml",
            "biomodel_18894555.vcml",
            "biomodel_189321805.vcml",
            "biomodel_189512756.vcml",
            "biomodel_189513183.vcml",

            "biomodel_200301029.vcml",
            "biomodel_200301683.vcml",
            "biomodel_200965116.vcml",
            "biomodel_200999311.vcml",
            "biomodel_201022999.vcml",
            "biomodel_20253928.vcml",
            "biomodel_203052143.vcml",
            "biomodel_203656156.vcml",
            "biomodel_205406319.vcml",
            "biomodel_206022012.vcml",
            "biomodel_20754836.vcml",
            "biomodel_209284198.vcml",
            "biomodel_211839191.vcml",
            "biomodel_217669650.vcml",
            "biomodel_220138697.vcml",
            "biomodel_220138948.vcml",
            "biomodel_22403233.vcml",
            "biomodel_22403238.vcml",
            "biomodel_22403244.vcml",
            "biomodel_22403250.vcml",
            "biomodel_22403358.vcml",
            "biomodel_22403576.vcml",
            "biomodel_22523922.vcml",
            "biomodel_225440511.vcml",
            "biomodel_22681429.vcml",
            "biomodel_229605883.vcml",
            "biomodel_232498815.vcml",
            "biomodel_245335415.vcml", // new published model 2023
            "biomodel_247511065.vcml", // new published model 2023
            "biomodel_256364414.vcml", // new published model 2023
            "biomodel_259696124.vcml", // new published model 2023
            "biomodel_259882394.vcml", // new published model 2023
            "biomodel_26454052.vcml",
            "biomodel_26454463.vcml",
            "biomodel_26455186.vcml",
            "biomodel_26581203.vcml",
            "biomodel_26928347.vcml",
            "biomodel_27071354.vcml",
            "biomodel_27072412.vcml",
            "biomodel_27072419.vcml",
            "biomodel_27072426.vcml",
            "biomodel_27087758.vcml",
            "biomodel_27088050.vcml",
            "biomodel_27088120.vcml",
            "biomodel_27192647.vcml",
            "biomodel_27192717.vcml",
            "biomodel_28136576.vcml",
            "biomodel_28138132.vcml",
            "biomodel_28139443.vcml",
            "biomodel_28625786.vcml",
            "biomodel_28730491.vcml",
            "biomodel_2912851.vcml",
            "biomodel_2913730.vcml",
            "biomodel_2915537.vcml",
            "biomodel_2917738.vcml",
            "biomodel_2917788.vcml",
            "biomodel_2917999.vcml",
            "biomodel_2930915.vcml",
            "biomodel_2962862.vcml",
            "biomodel_29897263.vcml",

            "biomodel_31523791.vcml",
            "biomodel_31584491.vcml",
            "biomodel_32288619.vcml",
            "biomodel_32568171.vcml",
            "biomodel_32568356.vcml",
            "biomodel_32579611.vcml",
            "biomodel_34826524.vcml",
            "biomodel_34855932.vcml",
            "biomodel_35789302.vcml",
            "biomodel_36053554.vcml",
            "biomodel_36230715.vcml",
            "biomodel_36275161.vcml",
            "biomodel_38086434.vcml",
            "biomodel_40882931.vcml",
            "biomodel_40883478.vcml",
            "biomodel_40883509.vcml",
            "biomodel_43726934.vcml",
            "biomodel_47429473.vcml",
            "biomodel_49411430.vcml",

            "biomodel_50584157.vcml",
            "biomodel_55178308.vcml",
            "biomodel_55396830.vcml",
            "biomodel_59280306.vcml",
            "biomodel_59361239.vcml",
            "biomodel_60113862.vcml",
            "biomodel_60203358.vcml",
            "biomodel_60227051.vcml",
            "biomodel_60647264.vcml",
            "biomodel_60647373.vcml",
            "biomodel_60705749.vcml",
            "biomodel_60705777.vcml",
            "biomodel_60799209.vcml",
            "biomodel_61340695.vcml",
            "biomodel_61414583.vcml",
            "biomodel_61629922.vcml",
            "biomodel_61680876.vcml",
            "biomodel_61699798.vcml",
            "biomodel_62467093.vcml",
            "biomodel_62477836.vcml",
            "biomodel_62585003.vcml",
            "biomodel_62849940.vcml",
            "biomodel_63307133.vcml",
            "biomodel_6436213.vcml",
            "biomodel_65182838.vcml",
            "biomodel_65183024.vcml",
            "biomodel_65183094.vcml",
            "biomodel_65183128.vcml",
            "biomodel_65311813.vcml",
            "biomodel_66264206.vcml",
            "biomodel_66264973.vcml",
            "biomodel_66265579.vcml",

            "biomodel_74924130.vcml",
            "biomodel_7681482.vcml",
            "biomodel_77305266.vcml",
            "biomodel_7803961.vcml",
            "biomodel_7803976.vcml",
            "biomodel_81284732.vcml",
            "biomodel_81992349.vcml",
            "biomodel_82065439.vcml",
            "biomodel_82250339.vcml",
            "biomodel_82798486.vcml",
            "biomodel_82799056.vcml",
            "biomodel_82799247.vcml",
            "biomodel_82799266.vcml",
            "biomodel_83091496.vcml",
            "biomodel_83446023.vcml",
            "biomodel_83932776.vcml",
            "biomodel_83932806.vcml",
            "biomodel_84069156.vcml",
            "biomodel_84235320.vcml",
            "biomodel_84275910.vcml",
            "biomodel_84982474.vcml",
            "biomodel_84982814.vcml",
            "biomodel_84985561.vcml",
            "biomodel_89712092.vcml",
            "biomodel_89712092_nonspatial.vcml",

            "biomodel_52337206_nonspatial.vcml", // MassActionSolver

            "biomodel_91133993.vcml",
            "biomodel_91134220.vcml",
            "biomodel_91134296.vcml",
            "biomodel_91134339.vcml",
            "biomodel_91141200.vcml",
            "biomodel_91141358.vcml",
            "biomodel_91147280.vcml",
            "biomodel_91162809.vcml",
            "biomodel_91162818.vcml",
            "biomodel_91164078.vcml",
            "biomodel_91164682.vcml",
            "biomodel_91986407.vcml",
            "biomodel_92354366.vcml", // public, not published
            "biomodel_9254662.vcml",
            "biomodel_92705462.vcml",
            "biomodel_93313420.vcml",
            "biomodel_93386467.vcml",
            "biomodel_94538871.vcml",
            "biomodel_94891280.vcml",
            "biomodel_95094548.vcml",
            "biomodel_95177642.vcml",
            "biomodel_95674618.vcml",
            "biomodel_95675197.vcml",
            "biomodel_95675441.vcml",
            "biomodel_95676312.vcml",
            "biomodel_95682290.vcml",
            "biomodel_95686613.vcml",
            "biomodel_95693513.vcml",
            "biomodel_95693624.vcml",
            "biomodel_95706942.vcml",
            "biomodel_95707047.vcml",
            "biomodel_9590643.vcml",
            "biomodel_98139292.vcml",
            "biomodel_98139299.vcml",
            "biomodel_98147638.vcml",
            "biomodel_98150237.vcml",
            "biomodel_98174143.vcml",
            "biomodel_98296160.vcml",

            "biomodel_165181964.vcml",
            "biomodel_111113048_smaller.vcml",

            // more public models
            "biomodel_83462243.vcml",
            "biomodel_83651737.vcml",
            "biomodel_97075423.vcml",
            "biomodel_97705317.vcml",
            "biomodel_97786619.vcml",
            "biomodel_97786886.vcml",
            "biomodel_97787114.vcml",
            "biomodel_98730962.vcml",
            "biomodel_92383390.vcml",
            "biomodel_92830796.vcml",
            "biomodel_92839940.vcml",
            "biomodel_92845118.vcml",
            "biomodel_92847452.vcml",
            "biomodel_92908902.vcml",
            "biomodel_92932169.vcml",
            "biomodel_92942045.vcml",
            "biomodel_92944917.vcml",
            "biomodel_92946371.vcml",
            "biomodel_92951324.vcml",
            "biomodel_92952350.vcml",
            "biomodel_92955722.vcml",
            "biomodel_92967115.vcml",
            "biomodel_92968671.vcml",
            "biomodel_92981603.vcml",


//            // All biomodels with Fluxes which don't have Reactants or FluxCarriers defined
//            "biomodel_101052330.vcml",
//            "biomodel_101230530.vcml",
//            "biomodel_101230538.vcml",
//            "biomodel_101305617.vcml",
//            "biomodel_101310767.vcml",
//            "biomodel_102074302.vcml",
//            "biomodel_102074816.vcml",
//            "biomodel_102075066.vcml",
//            "biomodel_102080957.vcml",
//            "biomodel_102081471.vcml",
//            "biomodel_102081721.vcml",
//            "biomodel_102087849.vcml",
//            "biomodel_102088833.vcml",
//            "biomodel_102089083.vcml",
//            "biomodel_102265818.vcml",
//            "biomodel_102265919.vcml",
//            "biomodel_102266138.vcml",
//            "biomodel_102385603.vcml",
//            "biomodel_103048709.vcml",
//            "biomodel_105884784.vcml",
//            "biomodel_108461334.vcml",
//            "biomodel_108895282.vcml",
//            "biomodel_109434270.vcml",
//            "biomodel_109669158.vcml",
//            "biomodel_110286948.vcml",
//            "biomodel_110669984.vcml",
//            "biomodel_111558732.vcml",
//            "biomodel_117176616.vcml",
//            "biomodel_117177634.vcml",
//            "biomodel_117177884.vcml",
//            "biomodel_117256864.vcml",
//            "biomodel_117257838.vcml",
//            "biomodel_117258088.vcml",
//            "biomodel_117284028.vcml",
//            "biomodel_117285002.vcml",
//            "biomodel_117285252.vcml",
//            "biomodel_117294561.vcml",
//            "biomodel_117295535.vcml",
//            "biomodel_117295785.vcml",
//            "biomodel_117346294.vcml",
//            "biomodel_120405439.vcml",
//            "biomodel_120947698.vcml",
//            "biomodel_121231994.vcml",
//            "biomodel_125079955.vcml",
//            "biomodel_125080929.vcml",
//            "biomodel_125081179.vcml",
//            "biomodel_125659329.vcml",
//            "biomodel_125659474.vcml",
//            "biomodel_125659619.vcml",
//            "biomodel_125927195.vcml",
//            "biomodel_126127287.vcml",
//            "biomodel_126165785.vcml",
//            "biomodel_127398246.vcml",
//            "biomodel_128110076.vcml",
//            "biomodel_135426153.vcml",
//            "biomodel_136959142.vcml",
//            "biomodel_140481119.vcml",
//            "biomodel_140769337.vcml",
//            "biomodel_142283227.vcml",
//            "biomodel_143918437.vcml",
//            "biomodel_146849677.vcml",
//            "biomodel_152932270.vcml",
//            "biomodel_155144710.vcml",
//            "biomodel_158988094.vcml",
//            "biomodel_169118921.vcml",
//            "biomodel_169119895.vcml",
//            "biomodel_169120146.vcml",
//            "biomodel_169799548.vcml",
//            "biomodel_170409820.vcml",
//            "biomodel_170422121.vcml",
//            "biomodel_170423097.vcml",
//            "biomodel_170423349.vcml",
//            "biomodel_170434950.vcml",
//            "biomodel_170435982.vcml",
//            "biomodel_170436233.vcml",
//            "biomodel_171261350.vcml",
//            "biomodel_171261460.vcml",
//            "biomodel_171262690.vcml",
//            "biomodel_171262868.vcml",
//            "biomodel_171263814.vcml",
//            "biomodel_171263883.vcml",
//            "biomodel_173153978.vcml",
//            "biomodel_175111156.vcml",
//            "biomodel_175413163.vcml",
//            "biomodel_175517664.vcml",
//            "biomodel_175586166.vcml",
//            "biomodel_175587261.vcml",
//            "biomodel_176514783.vcml",
//            "biomodel_177411532.vcml",
//            "biomodel_177417023.vcml",
//            "biomodel_178019263.vcml",
//            "biomodel_178019619.vcml",
//            "biomodel_178019901.vcml",
//            "biomodel_185622899.vcml",
//            "biomodel_185948291.vcml",
//            "biomodel_188069821.vcml",
//            "biomodel_188070460.vcml",
//            "biomodel_189977263.vcml",
//            "biomodel_194378541.vcml",
//            "biomodel_194379515.vcml",
//            "biomodel_194379765.vcml",
//            "biomodel_194477672.vcml",
//            "biomodel_194478646.vcml",
//            "biomodel_194478896.vcml",
//            "biomodel_198666320.vcml",
//            "biomodel_199275581.vcml",
//            "biomodel_199554174.vcml",
//            "biomodel_200950079.vcml",
//            "biomodel_202424032.vcml",
//            "biomodel_202502703.vcml",
//            "biomodel_208522178.vcml",
//            "biomodel_209750091.vcml",
//            "biomodel_214467352.vcml",
//            "biomodel_214701759.vcml",
//            "biomodel_218859801.vcml",
//            "biomodel_219027432.vcml",
//            "biomodel_222145054.vcml",
//            "biomodel_227130217.vcml",
//            "biomodel_243821055.vcml",
//            "biomodel_247644606.vcml",
//            "biomodel_247645606.vcml",
//            "biomodel_247645875.vcml",
//            "biomodel_248140664.vcml",
//            "biomodel_248433769.vcml",
//            "biomodel_74628811.vcml",
//            "biomodel_74628870.vcml",
//            "biomodel_76605424.vcml",
//            "biomodel_76606842.vcml",
//            "biomodel_76606995.vcml",
//            "biomodel_76607277.vcml",
//            "biomodel_76647266.vcml",
//            "biomodel_76648743.vcml",
//            "biomodel_76648896.vcml",
//            "biomodel_76649178.vcml",
//            "biomodel_76659320.vcml",
//            "biomodel_76660789.vcml",
//            "biomodel_76660942.vcml",
//            "biomodel_76661224.vcml",
//            "biomodel_76700635.vcml",
//            "biomodel_76702104.vcml",
//            "biomodel_76702257.vcml",
//            "biomodel_76702539.vcml",
//            "biomodel_83349399.vcml",
//            "biomodel_83350520.vcml",
//            "biomodel_83350673.vcml",
//            "biomodel_83350955.vcml",
//            "biomodel_83544708.vcml",
//            "biomodel_83546177.vcml",
//            "biomodel_83546330.vcml",
//            "biomodel_83546612.vcml",
//            "biomodel_83860033.vcml",
//            "biomodel_83861104.vcml",
//            "biomodel_83861257.vcml",
//            "biomodel_83861525.vcml",
//            "biomodel_84000710.vcml",
//            "biomodel_84001794.vcml",
//            "biomodel_84002211.vcml",
//            "biomodel_84618047.vcml",
//            "biomodel_84619118.vcml",
//            "biomodel_84619539.vcml",
//            "biomodel_87515021.vcml",
//            "biomodel_87516092.vcml",
//            "biomodel_87516509.vcml",
//            "biomodel_90935642.vcml", // public archived, user schaff (regenerated bad cached XML 2/5/2023)
//            "biomodel_90982755.vcml",
//            "biomodel_90984254.vcml",
//            "biomodel_90984408.vcml",
//            "biomodel_90984690.vcml",
//            "biomodel_90995227.vcml",
//            "biomodel_90996696.vcml",
//            "biomodel_90996849.vcml",
//            "biomodel_90997131.vcml",
//            "biomodel_91030477.vcml",
//            "biomodel_91031946.vcml",
//            "biomodel_91032099.vcml",
//            "biomodel_91032381.vcml",
//            "biomodel_91036571.vcml",
//            "biomodel_91038056.vcml",
//            "biomodel_91038209.vcml",
//            "biomodel_91038325.vcml",
//            "biomodel_91038491.vcml",
//            "biomodel_91042570.vcml",
//            "biomodel_91044039.vcml",
//            "biomodel_91044192.vcml",
//            "biomodel_91044474.vcml",
//            "biomodel_91048005.vcml",
//            "biomodel_91049474.vcml",
//            "biomodel_91049627.vcml",
//            "biomodel_91049743.vcml",
//            "biomodel_91049909.vcml",
//            "biomodel_91053875.vcml",
//            "biomodel_91055455.vcml",
//            "biomodel_91055608.vcml",
//            "biomodel_91055890.vcml",
//            "biomodel_91335920.vcml",
//            "biomodel_91337389.vcml",
//            "biomodel_91337824.vcml",
//            "biomodel_91592658.vcml",
//            "biomodel_91594127.vcml",
//            "biomodel_91594562.vcml",
//            "biomodel_91707223.vcml",
//            "biomodel_91708344.vcml",
//            "biomodel_91708613.vcml",
//            "biomodel_91708779.vcml",
//            "biomodel_91745023.vcml",
//            "biomodel_91746492.vcml",
//            "biomodel_91746927.vcml",
//            "biomodel_91862166.vcml",
//            "biomodel_91863635.vcml",
//            "biomodel_91864070.vcml",
//            "biomodel_91873678.vcml",
//            "biomodel_91875147.vcml",
//            "biomodel_91875582.vcml",
//            "biomodel_92908726.vcml",
//            "biomodel_93387700.vcml",
//            "biomodel_93388821.vcml",
//            "biomodel_93389256.vcml",
//            "biomodel_93399233.vcml",
//            "biomodel_93400354.vcml",
//            "biomodel_93400789.vcml",
//            "biomodel_93426874.vcml",
//            "biomodel_93427995.vcml",
//            "biomodel_93428430.vcml",
//            "biomodel_93436819.vcml",
//            "biomodel_93437940.vcml",
//            "biomodel_93438375.vcml",
//            "biomodel_93447147.vcml",
//            "biomodel_93448287.vcml",
//            "biomodel_93448722.vcml",
//            "biomodel_93575969.vcml",
//            "biomodel_93576404.vcml",
//            "biomodel_93617333.vcml",
//            "biomodel_93805944.vcml",
//            "biomodel_93807233.vcml",
//            "biomodel_93807668.vcml",
//            "biomodel_94394807.vcml",
//            "biomodel_94396276.vcml",
//            "biomodel_94396711.vcml",
//            "biomodel_94571280.vcml",
//            "biomodel_94571548.vcml",
//            "biomodel_94909163.vcml",
//            "biomodel_94909431.vcml",
//            "biomodel_94992916.vcml",
//            "biomodel_95457092.vcml",
//            "biomodel_95867463.vcml",
//            "biomodel_95867719.vcml",
//            "biomodel_96716893.vcml",
//            "biomodel_97744467.vcml",
//            "biomodel_97749305.vcml",
//            "biomodel_97867317.vcml",
//            "biomodel_97868198.vcml",
//            "biomodel_97870177.vcml",
//            "biomodel_97873615.vcml",
//            "biomodel_97874686.vcml",
//            "biomodel_97874976.vcml",
//            "biomodel_97875150.vcml",
//            "biomodel_97875508.vcml",
//            "biomodel_97878334.vcml",
//            "biomodel_97883798.vcml",
//            "biomodel_97887626.vcml",
//            "biomodel_97891882.vcml",
//            "biomodel_97893015.vcml",
//            "biomodel_97898510.vcml",
//            "biomodel_97901261.vcml",
//            "biomodel_97901585.vcml",
//            "biomodel_97905600.vcml",
//            "biomodel_97977915.vcml",
//            "biomodel_97978943.vcml",
//            "biomodel_97979211.vcml",
//            "biomodel_97985100.vcml",
//            "biomodel_97986128.vcml",
//            "biomodel_97986396.vcml",
//            "biomodel_97992215.vcml",
//            "biomodel_97993684.vcml",
//            "biomodel_97994119.vcml",
//            "biomodel_98001585.vcml",
//            "biomodel_98002613.vcml",
//            "biomodel_98002881.vcml",
//            "biomodel_98005905.vcml",
//            "biomodel_98006933.vcml",
//            "biomodel_98007201.vcml",
//            "biomodel_98010559.vcml",
//            "biomodel_98011587.vcml",
//            "biomodel_98011855.vcml",
//            "biomodel_98018730.vcml",
//            "biomodel_98019704.vcml",
//            "biomodel_98019954.vcml",
//            "biomodel_98025195.vcml",
//            "biomodel_98026223.vcml",
//            "biomodel_98026491.vcml",
//            "biomodel_98031993.vcml",
//            "biomodel_98033021.vcml",
//            "biomodel_98033289.vcml",
//            "biomodel_98039846.vcml",
//            "biomodel_98040874.vcml",
//            "biomodel_98041142.vcml",
//            "biomodel_98064839.vcml",
//            "biomodel_98065035.vcml",
//            "biomodel_98065302.vcml",
//            "biomodel_98071268.vcml",
//            "biomodel_98072296.vcml",
//            "biomodel_98072564.vcml",
//            "biomodel_98084107.vcml",
//            "biomodel_98085135.vcml",
//            "biomodel_98085403.vcml",
//            "biomodel_98176018.vcml",
//            "biomodel_98177044.vcml",
//            "biomodel_98177312.vcml",
//            "biomodel_98469750.vcml",
//
//            // ALL biomodels in /vcell-core/src/test/resources/org/vcell/sbml/local/massaction/ (many are private)
//            "biomodel_100950012.vcml",
//            "biomodel_101106339.vcml",
//            "biomodel_101112525.vcml",
//            "biomodel_102661590.vcml",
//            "biomodel_105923905.vcml",
//            "biomodel_105923935.vcml",
//            "biomodel_106181298.vcml",
//            "biomodel_110339900.vcml",
//            "biomodel_110693704.vcml",
//            "biomodel_110875599.vcml",
//            "biomodel_110912005.vcml",
//            "biomodel_111127250.vcml",
//            "biomodel_111128660.vcml",
//            "biomodel_111128947.vcml",
//            "biomodel_111129726.vcml",
//            "biomodel_111134102.vcml",
//            "biomodel_111136876.vcml",
//            "biomodel_111195079.vcml",
//            "biomodel_111196455.vcml",
//            "biomodel_111366857.vcml",
//            "biomodel_111366982.vcml",
//            "biomodel_111367285.vcml",
//            "biomodel_111367855.vcml",
//            "biomodel_111368266.vcml",
//            "biomodel_111375407.vcml",
//            "biomodel_111406453.vcml",
//            "biomodel_111407404.vcml",
//            "biomodel_111420974.vcml",
//            "biomodel_111514614.vcml",
//            "biomodel_111514898.vcml",
//            "biomodel_111603975.vcml",
//            "biomodel_111604093.vcml",
//            "biomodel_111604503.vcml",
//            "biomodel_111605144.vcml",
//            "biomodel_111605317.vcml",
//            "biomodel_115999897.vcml",
//            "biomodel_122586175.vcml",
//            "biomodel_122586235.vcml",
//            "biomodel_122586277.vcml",
//            "biomodel_122586572.vcml",
//            "biomodel_122586652.vcml",
//            "biomodel_122588382.vcml",
//            "biomodel_122609044.vcml",
//            "biomodel_12848184.vcml",
//            "biomodel_131665490.vcml",
//            "biomodel_144659630.vcml",
//            "biomodel_147175216.vcml",
//            "biomodel_147945292.vcml",
//            "biomodel_147946596.vcml",
//            "biomodel_14932493.vcml",
//            "biomodel_14933564.vcml",
//            "biomodel_166890778.vcml",
//            "biomodel_166890855.vcml",
//            "biomodel_168676084.vcml",
//            "biomodel_168784637.vcml",
//            "biomodel_168785982.vcml",
//            "biomodel_171254911.vcml",
//            "biomodel_175517664.vcml",
//            "biomodel_175526470.vcml",
//            "biomodel_175745130.vcml",
//            "biomodel_185316278.vcml",
//            "biomodel_185317385.vcml",
//            "biomodel_188709535.vcml",
//            "biomodel_18978432.vcml",
//            "biomodel_19134724.vcml",
//            "biomodel_19168243.vcml",
//            "biomodel_196341655.vcml",
//            "biomodel_196348974.vcml",
//            "biomodel_196433861.vcml",
//            "biomodel_2000010.vcml",
//            "biomodel_2000018.vcml",
//            "biomodel_2000021.vcml",
//            "biomodel_20106855.vcml",
//            "biomodel_2022013.vcml",
//            "biomodel_2024264.vcml",
//            "biomodel_2024458.vcml",
//            "biomodel_2024689.vcml",
//            "biomodel_2024849.vcml",
//            "biomodel_2025449.vcml",
//            "biomodel_2025920.vcml",
//            "biomodel_2026127.vcml",
//            "biomodel_2027262.vcml",
//            "biomodel_2027455.vcml",
//            "biomodel_2027747.vcml",
//            "biomodel_2028176.vcml",
//            "biomodel_2028610.vcml",
//            "biomodel_2028855.vcml",
//            "biomodel_2030592.vcml",
//            "biomodel_2034941.vcml",
//            "biomodel_2035774.vcml",
//            "biomodel_20370142.vcml",
//            "biomodel_2037792.vcml",
//            "biomodel_203950881.vcml",
//            "biomodel_2040373.vcml",
//            "biomodel_2041093.vcml",
//            "biomodel_2044946.vcml",
//            "biomodel_2045527.vcml",
//            "biomodel_2045795.vcml",
//            "biomodel_20526839.vcml",
//            "biomodel_2061001.vcml",
//            "biomodel_2069112.vcml",
//            "biomodel_2071137.vcml",
//            "biomodel_2072397.vcml",
//            "biomodel_2073109.vcml",
//            "biomodel_2082195.vcml",
//            "biomodel_211132289.vcml",
//            "biomodel_211551763.vcml",
//            "biomodel_212471469.vcml",
//            "biomodel_214386898.vcml",
//            "biomodel_2155626.vcml",
//            "biomodel_217115750.vcml",
//            "biomodel_2177828.vcml",
//            "biomodel_2209906.vcml",
//            "biomodel_22332502.vcml",
//            "biomodel_2274967.vcml",
//            "biomodel_231459684.vcml",
//            "biomodel_231538392.vcml",
//            "biomodel_237013469.vcml",
//            "biomodel_237093711.vcml",
//            "biomodel_237313189.vcml",
//            "biomodel_24470582.vcml",
//            "biomodel_26817063.vcml",
//            "biomodel_2766960.vcml",
//            "biomodel_2845845.vcml",
//            "biomodel_28552229.vcml",
//            "biomodel_28555193.vcml",
//            "biomodel_28572365.vcml",
//            "biomodel_29136875.vcml",
//            "biomodel_29136972.vcml",
//            "biomodel_29476020.vcml",
//            "biomodel_30497750.vcml",
//            "biomodel_30510577.vcml",
//            "biomodel_33838068.vcml",
//            "biomodel_33862744.vcml",
//            "biomodel_33863932.vcml",
//            "biomodel_33863937.vcml",
//            "biomodel_33910317.vcml",
//            "biomodel_33910543.vcml",
//            "biomodel_33917485.vcml",
//            "biomodel_34398701.vcml",
//            "biomodel_34399436.vcml",
//            "biomodel_34540124.vcml",
//            "biomodel_34540163.vcml",
//            "biomodel_34860206.vcml",
//            "biomodel_35990212.vcml",
//            "biomodel_35990461.vcml",
//            "biomodel_35993899.vcml",
//            "biomodel_36310541.vcml",
//            "biomodel_36587627.vcml",
//            "biomodel_36588994.vcml",
//            "biomodel_36800083.vcml",
//            "biomodel_37345720.vcml",
//            "biomodel_37346296.vcml",
//            "biomodel_38770411.vcml",
//            "biomodel_39781155.vcml",
//            "biomodel_39781314.vcml",
//            "biomodel_40500269.vcml",
//            "biomodel_40917343.vcml",
//            "biomodel_40917768.vcml",
//            "biomodel_4123574.vcml",
//            "biomodel_41261123.vcml",
//            "biomodel_44582721.vcml",
//            "biomodel_45416823.vcml",
//            "biomodel_45488947.vcml",
//            "biomodel_46530867.vcml",
//            "biomodel_4722484.vcml",
//            "biomodel_4733342.vcml",
//            "biomodel_47468216.vcml",
//            "biomodel_47517979.vcml",
//            "biomodel_47520230.vcml",
//            "biomodel_4793687.vcml",
//            "biomodel_49074913.vcml",
//            "biomodel_49105516.vcml",
//            "biomodel_50908630.vcml",
//            "biomodel_50920720.vcml",
//            "biomodel_50946331.vcml",
//            "biomodel_51538868.vcml",
//            "biomodel_51594531.vcml",
//            "biomodel_51760975.vcml",
//            "biomodel_51959799.vcml",
//            "biomodel_52085206.vcml",
//            "biomodel_52235352.vcml",
//            "biomodel_52517558.vcml",
//            "biomodel_52699692.vcml",
//            "biomodel_52699794.vcml",
//            "biomodel_52699891.vcml",
//            "biomodel_52708463.vcml",
//            "biomodel_52710562.vcml",
//            "biomodel_55099663.vcml",
//            "biomodel_55554804.vcml",
//            "biomodel_5560175.vcml",
//            "biomodel_5569486.vcml",
//            "biomodel_56426191.vcml",
//            "biomodel_56588035.vcml",
//            "biomodel_56643975.vcml",
//            "biomodel_56658553.vcml",
//            "biomodel_56661708.vcml",
//            "biomodel_56760249.vcml",
//            "biomodel_5746758.vcml",
//            "biomodel_58132981.vcml",
//            "biomodel_58133018.vcml",
//            "biomodel_58133056.vcml",
//            "biomodel_58183740.vcml",
//            "biomodel_58723464.vcml",
//            "biomodel_60083893.vcml",
//            "biomodel_60104088.vcml",
//            "biomodel_61648741.vcml",
//            "biomodel_62181882.vcml",
//            "biomodel_63853150.vcml",
//            "biomodel_64127077.vcml",
//            "biomodel_66105071.vcml",
//            "biomodel_67074258.vcml",
//            "biomodel_67384832.vcml",
//            "biomodel_72498027.vcml",
//            "biomodel_72915381.vcml",
//            "biomodel_75098399.vcml",
//            "biomodel_75371432.vcml",
//            "biomodel_75374449.vcml",
//            "biomodel_77579660.vcml",
//            "biomodel_7824657.vcml",
//            "biomodel_80226984.vcml",
//            "biomodel_8111589.vcml",
//            "biomodel_8111616.vcml",
//            "biomodel_8183019.vcml",
//            "biomodel_8183059.vcml",
//            "biomodel_8209036.vcml",
//            "biomodel_82680211.vcml",
//            "biomodel_82708948.vcml",
//            "biomodel_82739668.vcml",
//            "biomodel_82748209.vcml",
//            "biomodel_82749999.vcml",
//            "biomodel_82890243.vcml",
//            "biomodel_84282778.vcml",
//            "biomodel_84282940.vcml",
//            "biomodel_84828274.vcml",
//            "biomodel_84891775.vcml",
//            "biomodel_85221354.vcml",
//            "biomodel_85241086.vcml",
//            "biomodel_85305461.vcml",
//            "biomodel_85305618.vcml",
//            "biomodel_85305764.vcml",
//            "biomodel_85305863.vcml",
//            "biomodel_85306257.vcml",
//            "biomodel_85306479.vcml",
//            "biomodel_85633295.vcml",
//            "biomodel_86917088.vcml",
//            "biomodel_87760173.vcml",
//            "biomodel_87853640.vcml",
//            "biomodel_87853970.vcml",
//            "biomodel_87864565.vcml",
//            "biomodel_87865323.vcml",
//            "biomodel_87866170.vcml",
//            "biomodel_87867732.vcml",
//            "biomodel_87868961.vcml",
//            "biomodel_87869297.vcml",
//            "biomodel_87893730.vcml",
//            "biomodel_88592639.vcml",
//            "biomodel_90359828.vcml",
//            "biomodel_90373208.vcml",
//            "biomodel_90401613.vcml",
//            "biomodel_90961594.vcml",
//            "biomodel_91024265.vcml",
//            "biomodel_91969953.vcml",
//            "biomodel_92019006.vcml",
//            "biomodel_92692049.vcml",
//            "biomodel_92972365.vcml",
//            "biomodel_92972560.vcml",
//            "biomodel_93070707.vcml",
//            "biomodel_93074445.vcml",
//            "biomodel_93074627.vcml",
//            "biomodel_94462536.vcml",
//            "biomodel_94794583.vcml",
//            "biomodel_94899206.vcml",
//            "biomodel_95070726.vcml",
//            "biomodel_95105284.vcml",
//            "biomodel_95234506.vcml",
//            "biomodel_95491173.vcml",
//            "biomodel_96750507.vcml",
//            "biomodel_97667827.vcml",
//            "biomodel_97765842.vcml",
//
            // ALL biomodels in /vcell-core/src/test/resources/org/vcell/sbml/local/hybrid/ (many are private)
//            "biomodel_100059482.vcml",
//            "biomodel_101082318.vcml",
//            "biomodel_101986247.vcml",
//            "biomodel_102052096.vcml",
//            "biomodel_102259769.vcml",
//            "biomodel_102370928.vcml",
//            "biomodel_103611108.vcml",
//            "biomodel_111277118.vcml",
//            "biomodel_118755792.vcml",
//            "biomodel_120827405.vcml",
//            "biomodel_125721200.vcml",
//            "biomodel_127499720.vcml",
//            "biomodel_127502522.vcml",
//            "biomodel_127507844.vcml",
//            "biomodel_127631214.vcml",
//            "biomodel_127635151.vcml",
//            "biomodel_127665331.vcml",
//            "biomodel_130732030.vcml",
//            "biomodel_136182636.vcml",
//            "biomodel_136233656.vcml",
//            "biomodel_137193174.vcml",
//            "biomodel_137462693.vcml",
//            "biomodel_137464451.vcml",
//            "biomodel_137465195.vcml",
//            "biomodel_137554146.vcml",
//            "biomodel_138076947.vcml",
//            "biomodel_138520565.vcml",
//            "biomodel_138520573.vcml",
//            "biomodel_138520743.vcml",
//            "biomodel_139080763.vcml",
//            "biomodel_139083987.vcml",
//            "biomodel_139089557.vcml",
//            "biomodel_139623598.vcml",
//            "biomodel_139625172.vcml",
//            "biomodel_139807652.vcml",
//            "biomodel_140388797.vcml",
//            "biomodel_140393657.vcml",
//            "biomodel_143188104.vcml",
//            "biomodel_143560664.vcml",
//            "biomodel_143882349.vcml",
//            "biomodel_172085066.vcml",
//            "biomodel_179548819.vcml",
//            "biomodel_200709201.vcml",
//            "biomodel_205139889.vcml",
//            "biomodel_205205766.vcml",
//            "biomodel_205251133.vcml",
//            "biomodel_205391030.vcml",
//            "biomodel_205480956.vcml",
//            "biomodel_219177571.vcml",
//            "biomodel_226733377.vcml",
//            "biomodel_229585346.vcml",
//            "biomodel_230248792.vcml",
//            "biomodel_232765165.vcml",
//            "biomodel_233873608.vcml",
//            "biomodel_235411089.vcml",
//            "biomodel_239947918.vcml",
//            "biomodel_251793686.vcml",
//            "biomodel_251795156.vcml",
//            "biomodel_251801083.vcml",
//            "biomodel_82161363.vcml",
//            "biomodel_82162188.vcml",
//            "biomodel_82456311.vcml",
//            "biomodel_82456701.vcml",
//            "biomodel_82457170.vcml",
//            "biomodel_82457836.vcml",
//            "biomodel_82790975.vcml",
//            "biomodel_82800592.vcml",
//            "biomodel_82805340.vcml",
//            "biomodel_82807862.vcml",
//            "biomodel_82808340.vcml",
//            "biomodel_82809548.vcml",
//            "biomodel_82809561.vcml",
//            "biomodel_83462193.vcml",
//            //"biomodel_83462243.vcml", // public
//            "biomodel_83651304.vcml",
//            //"biomodel_83651737.vcml", // public
//            "biomodel_84440330.vcml",
//            "biomodel_85831960.vcml",
//            "biomodel_88789981.vcml",
//            "biomodel_88820373.vcml",
//            "biomodel_88834881.vcml",
//            "biomodel_88856212.vcml",
//            "biomodel_89716975.vcml",
//            "biomodel_93521159.vcml",
//            "biomodel_93521456.vcml",
//            "biomodel_95401413.vcml",
//            "biomodel_95401686.vcml",
//            "biomodel_95401705.vcml",
//            "biomodel_95420572.vcml",
//            "biomodel_95439383.vcml",
//            "biomodel_95464694.vcml",
//            "biomodel_95478721.vcml",
//            "biomodel_97188386.vcml",
//            "biomodel_97210786.vcml",
//            "biomodel_97236290.vcml",
//            "biomodel_97236377.vcml",
//            "biomodel_97536525.vcml",
//            "biomodel_97553821.vcml",
//            "biomodel_97557776.vcml",
//            "biomodel_97785961.vcml",
//            //"biomodel_97786886.vcml", // public
//            //"biomodel_97787114.vcml", // public
//            "biomodel_98707721.vcml",
//            //"biomodel_98730962.vcml", // public
//            "biomodel_98745308.vcml",
    };

    public static String[] getVcmlTestCases() {
        Predicate<String> testFilter = t -> true;

        return Arrays.stream(allTestFiles).filter(testFilter).toArray(String[]::new);
    }

    public static InputStream getVcmlTestCase(String testFile) {
        if (!Arrays.stream(allTestFiles).anyMatch(file -> file.equals(testFile))) {
            throw new RuntimeException("file not found for VCell Published Test Suite test "+testFile);
        }
        List<String> pathPrefixes = Arrays.asList(
                "vcml_published/",
                "vcml_testmodels/",
                "local/massaction/",
                "local/hybrid/",
                "local/flux/"
        );
        try {
            return getFileFromResourceAsStream(pathPrefixes, testFile);
        }catch (FileNotFoundException e){
            throw new RuntimeException("failed to find test case file '"+testFile+"' in paths "+pathPrefixes+": " + e.getMessage(), e);
        }
    }

     private static InputStream getFileFromResourceAsStream(List<String> pathPrefixes, String fileName) throws FileNotFoundException {
        FileNotFoundException fileNotFoundException = null;
        for (String pathPrefix : pathPrefixes) {
            try {
                InputStream inputStream = VcmlTestSuiteFiles.class.getResourceAsStream(pathPrefix+fileName);
                if (inputStream == null) {
                    throw new FileNotFoundException("file not found! " + fileName);
                } else {
                    return inputStream;
                }
            } catch (FileNotFoundException e) {
                fileNotFoundException = e;
            }
        }
        if (fileNotFoundException != null) {
            throw fileNotFoundException;
        }else{
            throw new RuntimeException("unexpected exception");
        }
    }

    @Test
    public void test_read_sbmlFile() {
        InputStream inputStream = getVcmlTestCase(allTestFiles[0]);
        Assertions.assertTrue(inputStream != null);
    }

}
