/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.parser.gui;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;

import cbit.vcell.parser.Expression;
import cbit.vcell.parser.ExpressionException;
import cbit.vcell.parser.ExpressionPrintFormatter;
import cbit.vcell.parser.NameScope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * This class was generated by a SmartGuide.
 * 
 */
@SuppressWarnings("serial")
public class ExpressionCanvas extends JPanel implements Scrollable {
	private final static Logger lg = LogManager.getLogger(ExpressionCanvas.class);
	private Image offScreenImage = null;
	private Dimension offScreenImageSize = null;
	private boolean bImageDirty = true;
	private Expression[] fieldExpressions = null;
	private String fieldSuffixLabels[] = null;
	private String fieldPrefixLabels[] = null;
	private NameScope fieldNameScope = null;
	private String[] fieldStrings = null; //created Oct.2nd, 2006 for printing stochastic variables, actions, probabilities.

	/**
	 * Constructor
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	public ExpressionCanvas() {
		super();
		initialize();
	}


	//used by the publish package.
	public static void getExpressionAsImage (Expression expArray [], BufferedImage image, int scale) {    

		if (expArray == null || image == null) {
			throw new IllegalArgumentException("One or more invalid arguments for refreshGraphics()");
		}
		try {
			int width = image.getWidth();
			int height = image.getHeight();
			Graphics2D g = (Graphics2D)image.getGraphics();
			g.setClip(0,0,width,height);
			g.setBackground(Color.white);
			g.fillRect(0,0,width,height);	
			g.setFont(new Font("SansSerif", Font.ITALIC, 11));
			//g.scale(scale,scale);
			//java.awt.geom.Rectangle2D sizeHelloBeforeScale = g.getFontMetrics().getStringBounds("hello",g);
			//System.out.println("size of 'hello' before scale is ["+sizeHelloBeforeScale.getWidth()+","+sizeHelloBeforeScale.getHeight()+"]");
			//g.getTransform().scale(scale*10, scale*10);
			//System.out.println("newScaleX = "+g.getTransform().getScaleX());
			//java.awt.geom.Rectangle2D sizeHelloAfterScale = g.getFontMetrics().getStringBounds("hello",g);
			//System.out.println("size of 'hello' after scale is ["+sizeHelloAfterScale.getWidth()+","+sizeHelloAfterScale.getHeight()+"]");
			if (expArray != null){
				g.setColor(Color.black);
				Rectangle rect = g.getClipBounds();
				int posY = Math.max(10,(rect.height - height)/2);
				int posX = Math.max(10,(rect.width - width)/2);
				for (int i=0;i<expArray.length;i++){
					int prefixWidth = 0;
					ExpressionPrintFormatter expPrintFormatter = new ExpressionPrintFormatter(expArray[i]);
					Dimension expressionDim = expPrintFormatter.getSize(g);
					g.setClip(posX+prefixWidth,posY,expressionDim.width,expressionDim.height);
					expPrintFormatter.paint(g);
					posY += expressionDim.height+20;
				}
			}
		} catch (Exception e) {
			lg.error("exception in ExpressionCanvas.refreshGraphics()", e);
		}
	}


	public static Dimension getExpressionImageSize(Expression expArray [], Graphics2D g) throws ExpressionException {

		g.setFont(new Font("SansSerif", Font.ITALIC, 25));
		Dimension minSize = new Dimension(10,10);
		for (int i=0;i<expArray.length;i++){
			ExpressionPrintFormatter expPrintFormatter = new ExpressionPrintFormatter(expArray[i]);
			java.awt.Dimension expressionDim = expPrintFormatter.getSize(g);
			int labelWidth = 0;
			minSize.width = Math.max(minSize.width, expressionDim.width + 20 + labelWidth);
			minSize.height += expressionDim.height+20;
		}

		return minSize;
	}


	/**
	 * Gets the expressions property (cbit.vcell.parser.Expression[]) value.
	 * @return The expressions property value.
	 * @see #setExpressions
	 */
	public Expression[] getExpressions() {
		return fieldExpressions;
	}


	/**
	 * Gets the expressions index property (cbit.vcell.parser.Expression) value.
	 * @return The expressions property value.
	 * @param index The index value into the property array.
	 * @see #setExpressions
	 */
	public Expression getExpressions(int index) {
		return getExpressions()[index];
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (3/28/01 5:38:58 PM)
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getJScrollPaneParent() {
		if (getParent() instanceof javax.swing.JScrollPane){
			return (JScrollPane)getParent();
		}else if (getParent() instanceof JViewport && getParent().getParent() instanceof JScrollPane){
			return (JScrollPane)getParent().getParent();
		}else{
			return null;
		}
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (11/19/2002 11:26:26 AM)
	 * @return java.awt.Dimension
	 */
	public Dimension getMinimumSize() {
		Graphics2D g = (Graphics2D)getGraphics();
		if (g != null){
			g.setClip(0,0,getSize().width,getSize().height);
			Font canvasFont = new Font("SansSerif", Font.ITALIC, 11);
			g.setFont(canvasFont);
			FontMetrics fontMetrics = g.getFontMetrics();
			try {
				Dimension minSize = new Dimension(10,10);
				if (fieldExpressions != null)
				{
					for (int i=0;i<fieldExpressions.length;i++){
						ExpressionPrintFormatter expPrintFormatter = new ExpressionPrintFormatter(fieldExpressions[i]);
						Dimension expressionDim = expPrintFormatter.getSize(g);
						int labelWidth = 0;
						if (fieldPrefixLabels!=null){
							labelWidth += g.getFontMetrics().stringWidth(fieldPrefixLabels[i]) + 20;
						}
						if (fieldSuffixLabels!=null){
							labelWidth += g.getFontMetrics().stringWidth(fieldSuffixLabels[i]) + 20;
						}
						minSize.width = Math.max(minSize.width, expressionDim.width + 20 + labelWidth);
						minSize.height += expressionDim.height+20;
					}
				}else{
					for(String expString : fieldStrings)
					{
						int stringWidth = fontMetrics.stringWidth(expString);
						int stringHeight = fontMetrics.getHeight();
						minSize.width = Math.max(minSize.width, stringWidth);
						minSize.height += stringHeight+20;
					}
				}

				return minSize;
			}catch (ExpressionException e){
				lg.error(e);
				return super.getMinimumSize();
			}
		}else{
			return super.getMinimumSize();
		}
	}


	/**
	 * Gets the nameScope property (cbit.vcell.parser.NameScope) value.
	 * @return The nameScope property value.
	 * @see #setNameScope
	 */
	public NameScope getNameScope() {
		return fieldNameScope;
	}


	/**
	 * Returns the preferred size of the viewport for a view component.
	 * For example the preferredSize of a JList component is the size
	 * required to acommodate all of the cells in its list however the
	 * value of preferredScrollableViewportSize is the size required for
	 * JList.getVisibleRowCount() rows.   A component without any properties
	 * that would effect the viewport size should just return 
	 * getPreferredSize() here.
	 * 
	 * @return The preferredSize of a JViewport whose view is this Scrollable.
	 * @see JViewport#getPreferredSize
	 */
	public Dimension getPreferredScrollableViewportSize() {
		return getPreferredSize();
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (9/6/2002 12:17:16 PM)
	 * @return java.awt.Dimension
	 */
	public Dimension getPreferredSize() {
		if ((fieldExpressions!=null) || (fieldStrings!=null)){
			Dimension prefSize = getMinimumSize();
			//		if (getJScrollPaneParent()!=null){
			//			java.awt.Rectangle viewBorderBounds = getJScrollPaneParent().getViewportBorderBounds();
			//			prefSize = new Dimension(Math.max(viewBorderBounds.width,prefSize.width),Math.max(viewBorderBounds.height,prefSize.height));
			//		}
			return prefSize;
		}else{
			return super.getPreferredSize();
		}
	}


	/**
	 * Components that display logical rows or columns should compute
	 * the scroll increment that will completely expose one block
	 * of rows or columns, depending on the value of orientation. 
	 * <p>
	 * Scrolling containers, like JScrollPane, will use this method
	 * each time the user requests a block scroll.
	 * 
	 * @param visibleRect The view area visible within the viewport
	 * @param orientation Either SwingConstants.VERTICAL or SwingConstants.HORIZONTAL.
	 * @param direction Less than zero to scroll up/left, greater than zero for down/right.
	 * @return The "block" increment for scrolling in the specified direction.
	 * @see JScrollBar#setBlockIncrement
	 */
	public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
		if (SwingConstants.VERTICAL == orientation){
			return visibleRect.height/4;
		}else{
			return visibleRect.width/4;
		}
	}


	/**
	 * Return true if a viewport should always force the height of this 
	 * Scrollable to match the height of the viewport.  For example a 
	 * columnar text view that flowed text in left to right columns 
	 * could effectively disable vertical scrolling by returning
	 * true here.
	 * <p>
	 * Scrolling containers, like JViewport, will use this method each 
	 * time they are validated.  
	 * 
	 * @return True if a viewport should force the Scrollables height to match its own.
	 */
	public boolean getScrollableTracksViewportHeight() {
		return false;
	}


	/**
	 * Return true if a viewport should always force the width of this 
	 * Scrollable to match the width of the viewport.  For example a noraml 
	 * text view that supported line wrapping would return true here, since it
	 * would be undesirable for wrapped lines to disappear beyond the right
	 * edge of the viewport.  Note that returning true for a Scrollable
	 * whose ancestor is a JScrollPane effectively disables horizontal
	 * scrolling.
	 * <p>
	 * Scrolling containers, like JViewport, will use this method each 
	 * time they are validated.  
	 * 
	 * @return True if a viewport should force the Scrollables width to match its own.
	 */
	public boolean getScrollableTracksViewportWidth() {
		return false;
	}


	/**
	 * Components that display logical rows or columns should compute
	 * the scroll increment that will completely expose one new row
	 * or column, depending on the value of orientation.  Ideally, 
	 * components should handle a partially exposed row or column by 
	 * returning the distance required to completely expose the item.
	 * <p>
	 * Scrolling containers, like JScrollPane, will use this method
	 * each time the user requests a unit scroll.
	 * 
	 * @param visibleRect The view area visible within the viewport
	 * @param orientation Either SwingConstants.VERTICAL or SwingConstants.HORIZONTAL.
	 * @param direction Less than zero to scroll up/left, greater than zero for down/right.
	 * @return The "unit" increment for scrolling in the specified direction
	 * @see JScrollBar#setUnitIncrement
	 */
	public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
		return 1;
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (10/2/2006 11:51:09 AM)
	 * @return java.lang.String[]
	 */
	public String[] getStrings() {
		return fieldStrings;
	}


	/**
	 * Called whenever the part throws an exception.
	 * @param exception java.lang.Throwable
	 */
	private void handleException(Throwable exception) {

		/* Uncomment the following lines to print uncaught exceptions to stdout */
		// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
		// lg.error(e);
	}


	/**
	 * Initialize the class.
	 */
	/* WARNING: THIS METHOD WILL BE REGENERATED. */
	private void initialize() {
		try {
			// user code begin {1}
			// user code end
			setName("ExpressionCanvas");
			setLayout(null);
			setSize(160, 120);
		} catch (Throwable ivjExc) {
			handleException(ivjExc);
		}
		// user code begin {2}
		// user code end
	}


	/**
	 * main entrypoint - starts the part when it is run as an application
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		try {
			JFrame frame = new JFrame();
			ExpressionCanvas aExpressionCanvas;
			aExpressionCanvas = new ExpressionCanvas();
			frame.setContentPane(aExpressionCanvas);
			frame.setSize(aExpressionCanvas.getSize());
			frame.addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e) {
					System.exit(0);
				}; 
			});
			frame.setVisible(true);
			Insets insets = frame.getInsets();
			frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
			frame.setVisible(true);
		} catch (Throwable exception) {
			System.err.println("Exception occurred in main() of javax.swing.JPanel");
			exception.printStackTrace();
		}
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		if (bImageDirty){
			refreshGraphics();
		}
		if (offScreenImage != null){
			g.drawImage(offScreenImage,-1,-1,this);
		}	
		return;
	}

	private void refreshGraphics () {

		try {
			offScreenImageSize = new Dimension(getSize().width,getSize().height);
			offScreenImage = createImage(offScreenImageSize.width,offScreenImageSize.height);
			if (offScreenImage==null){
				return;
			}	

			Graphics2D g = (Graphics2D)offScreenImage.getGraphics();
			//		g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
			g.setClip(0,0,getSize().width,getSize().height);
			g.setFont(new Font("SansSerif", Font.ITALIC, 11));
			g.setColor(getBackground());
			g.fillRect(0,0,getSize().width,getSize().height);

			if (fieldExpressions!=null){
				g.setColor(getForeground());
				Rectangle rect = g.getClipBounds();
				int posY = Math.max(10,(rect.height - getSize().height)/2);
				int posX = Math.max(10,(rect.width - getSize().width)/2);
				for (int i=0;i<fieldExpressions.length;i++){
					int prefixWidth = 0;
					ExpressionPrintFormatter expPrintFormatter = new ExpressionPrintFormatter(fieldExpressions[i]);
					Dimension expressionDim = expPrintFormatter.getSize(g);
					if (fieldPrefixLabels!=null && fieldPrefixLabels[i]!=null){
						prefixWidth = g.getFontMetrics().stringWidth(fieldPrefixLabels[i]) + 10;
						g.setClip(posX,posY,getSize().width,getSize().height);
						g.setColor(Color.blue);
						g.drawString(fieldPrefixLabels[i],posX,posY+expressionDim.height/2+g.getFontMetrics().getDescent());
					}
					g.setColor(getForeground());
					g.setClip(posX+prefixWidth,posY,expressionDim.width,expressionDim.height);
					expPrintFormatter.paint(g);
					if (fieldSuffixLabels!=null && fieldSuffixLabels[i]!=null){
						g.setColor(Color.blue);
						g.setClip(posX,posY,getSize().width,getSize().height);
						g.drawString(fieldSuffixLabels[i],posX+expressionDim.width+prefixWidth+20,posY+expressionDim.height/2+g.getFontMetrics().getDescent());
					}
					posY += expressionDim.height+20;
				}
			}
			if (fieldStrings != null){ //added Oct 3rd, 2006 to display the stochastic stuff in expression canvas
				g.setColor(getForeground());
				Rectangle rect = g.getClipBounds();
				int posY = Math.max(10,(rect.height - getSize().height)/2);
				int posX = Math.max(10,(rect.width - getSize().width)/2);
				for (int i=0;i<fieldStrings.length;i++){
					g.setClip(posX,posY,getSize().width,getSize().height);
					g.setColor(getForeground());
					g.drawString(fieldStrings[i],posX,posY+10);
					posY += 40;
				}
			}	
		}catch (Exception e){
			offScreenImage = null;
			lg.error(e.getMessage(), e);
		}

		bImageDirty = false;
		return;
	}


	/**
	 * Insert the method's description here.
	 * Creation date: (11/19/2002 12:25:45 PM)
	 * @param x int
	 * @param y int
	 * @param w int
	 * @param h int
	 */
	public void reshape(int x, int y, int w, int h) {
		if (w!=getSize().width || h!=getHeight()){
			bImageDirty = true;
		}
		super.reshape(x,y,w,h);
	}


	/**
	 * This method was created by a SmartGuide.
	 * @param expression cbit.vcell.parser.Expression
	 */
	public void setExpression(Expression expression) {
		Expression expList[] = null;
		if (expression != null){
			expList = new Expression[1];
			expList[0] = expression;
		}		
		setExpressions(expList,null,null);
	}


	/**
	 * Sets the expressions property (cbit.vcell.parser.Expression[]) value.
	 * @param expressions The new value for the property.
	 * @see #getExpressions
	 */
	public void setExpressions(Expression[] expressions) {
		setExpressions(expressions,null,null);
	}


	/**
	 * Sets the expressions property (cbit.vcell.parser.Expression[]) value.
	 * @param expressions The new value for the property.
	 * @see #getExpressions
	 */
	public void setExpressions(Expression[] expressions, String prefixLabels[], String suffixLabels[]) {
		fieldExpressions = expressions;
		fieldPrefixLabels = prefixLabels;
		fieldSuffixLabels = suffixLabels;
		bImageDirty = true;
		updateAll();
	}


	/**
	 * Sets the nameScope property (cbit.vcell.parser.NameScope) value.
	 * @param nameScope The new value for the property.
	 * @see #getNameScope
	 */
	public void setNameScope(NameScope nameScope) {
		cbit.vcell.parser.NameScope oldValue = fieldNameScope;
		fieldNameScope = nameScope;
		firePropertyChange("nameScope", oldValue, nameScope);
	}


	/**
	 * Set stochastic expressions as strings and prepare to display them on canvas.
	 * Creation date: (10/2/2006 11:51:09 AM)
	 * @param newStrings java.lang.String[]
	 */
	public void setStrings(String[] newStrings) {
		fieldStrings = newStrings;
		fieldPrefixLabels = null;
		fieldSuffixLabels = null;
		bImageDirty = true;
		updateAll();
	}


	public void updateAll() {
		try {
			if ((fieldExpressions!=null) || (fieldStrings != null)){
				if (getJScrollPaneParent()!=null){
					invalidate();
					getJScrollPaneParent().revalidate();
				}
				setSize(getPreferredSize());
				repaint();
			}
		}catch (Exception e){
			handleException(e);
		}			
	}
}
