/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.math;
import java.util.Enumeration;
import java.util.List;

import org.vcell.util.CommentStringTokenizer;
import org.vcell.util.Compare;
import org.vcell.util.Matchable;

import cbit.vcell.parser.Expression;
import cbit.vcell.parser.ExpressionException;
/**
 * This class was generated by a SmartGuide.
 * 
 */
@SuppressWarnings("serial")
public class PointSubDomain extends SubDomain {
	
	@Override
	protected String startToken() {
		return VCML.PointSubDomain;
	}
	
	/**
	 * x component of point position
	 */
	private Expression positionX = null;
	/**
	 * y component of point position
	 */
	private Expression positionY = null;
	/**
	 * y component of point position
	 */
	private Expression positionZ = null;
	
	
public PointSubDomain(String name){
	super(name);
}

	public void getAllExpressions(List<Expression> expressionList, MathDescription mathDescription){
		super.getAllExpressions0(expressionList, mathDescription);
		if (this.positionX!=null) expressionList.add(this.positionX);
		if (this.positionY!=null) expressionList.add(this.positionY);
		if (this.positionZ!=null) expressionList.add(this.positionZ);
	}

@Override
protected void parse(MathDescription mathDesc, String tokenString, CommentStringTokenizer tokens) throws MathException, ExpressionException {
	if (tokenString.equalsIgnoreCase(VCML.OdeEquation)){
		tokenString = tokens.nextToken();
		Variable var = mathDesc.getVariable(tokenString);
		if (var == null){
			throw new MathFormatException("variable "+tokenString+" not defined");
		}	
		if (!(var instanceof PointVariable)){
			throw new MathFormatException("variable "+tokenString+" not a "+VCML.PointVariable);
		}	
		OdeEquation ode = new OdeEquation((PointVariable)var, null,null);
		ode.read(tokens, mathDesc);
		addEquation(ode);
		return;
	}			
	if (tokenString.equalsIgnoreCase(VCML.PositionX)){
		positionX = parseAndBind(mathDesc, tokens);
		return;
	}
	if (tokenString.equalsIgnoreCase(VCML.PositionY)){
		positionY = parseAndBind(mathDesc, tokens);
		return;
	}
	if (tokenString.equalsIgnoreCase(VCML.PositionZ)){
		positionZ = parseAndBind(mathDesc, tokens);
		return;
	}
	throw new MathFormatException("unexpected identifier "+tokenString);
}

/**
 * This method was created in VisualAge.
 * @return boolean
 * @param object java.lang.Object
 */
public boolean compareEqual(Matchable object) {
	if (object instanceof PointSubDomain){
		PointSubDomain other = (PointSubDomain)object;
		if (!super.compareEqual0(other)){
			return false;
		}
		if (!Compare.isEqualFields(this,other)) {
			return false;
		}
		return true;
	}
	return false;
}

public Expression getPositionX() {
	return positionX;
}

public Expression getPositionY() {
	return positionY;
}

public Expression getPositionZ() {
	return positionZ;
}

public void setPositionX(Expression positionX) {
	this.positionX = positionX;
}

public void setPositionY(Expression positionY) {
	this.positionY = positionY;
}

public void setPositionZ(Expression positionZ) {
	this.positionZ = positionZ;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getVCML(int spatialDimension) {
	StringBuilder buffer = new StringBuilder();
	buffer.append(VCML.PointSubDomain+" "+getName()+" {\n");
	if (spatialDimension>=1){
		addExpression(buffer, VCML.PositionX,positionX); 
	}
	if (spatialDimension>=2){
		addExpression(buffer, VCML.PositionY,positionY); 
	}
	if (spatialDimension==3){
		addExpression(buffer, VCML.PositionZ,positionZ); 
	}
	Enumeration<Equation> enum1 = getEquations();
	while (enum1.hasMoreElements()){
		Equation equ = enum1.nextElement();
		buffer.append(equ.getVCML());
	}	
	buffer.append("}\n");
	return buffer.toString();		
}

private static void addExpression(StringBuilder buffer, String keyword, Expression exp) {
	if (exp != null) {
		buffer.append('\t');
		buffer.append(keyword);
		buffer.append("\t\t");
		buffer.append(exp.infix());
		buffer.append(";\n");	
	}
}
}
