/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.math;
import java.util.Enumeration;
import java.util.List;

import org.vcell.util.CommentStringTokenizer;
import org.vcell.util.Compare;
import org.vcell.util.Matchable;
import org.vcell.util.Token;
import org.vcell.util.VCAssert;

import cbit.vcell.math.ComputeCentroidComponentEquation.CentroidComponent;
import cbit.vcell.math.ComputeMembraneMetricEquation.MembraneMetricComponent;
import cbit.vcell.parser.Expression;
import cbit.vcell.parser.ExpressionException;
/**
 * This class was generated by a SmartGuide.
 * 
 */
@SuppressWarnings("serial")
public class CompartmentSubDomain extends SubDomain implements SubDomain.DomainWithBoundaryConditions {
	public final static int NON_SPATIAL_PRIORITY = -1;
	
	private BoundaryConditionType boundaryConditionTypeXp = BoundaryConditionType.getDIRICHLET();
	private BoundaryConditionType boundaryConditionTypeXm = BoundaryConditionType.getDIRICHLET();
	private BoundaryConditionType boundaryConditionTypeYp = BoundaryConditionType.getDIRICHLET();
	private BoundaryConditionType boundaryConditionTypeYm = BoundaryConditionType.getDIRICHLET();
	private BoundaryConditionType boundaryConditionTypeZp = BoundaryConditionType.getDIRICHLET();
	private BoundaryConditionType boundaryConditionTypeZm = BoundaryConditionType.getDIRICHLET();

/**
 * This method was created by a SmartGuide.
 * @param name java.lang.String
 * @param unused -- ignored 
 */
public CompartmentSubDomain (String name, int unused) {
	super(name);
}


CompartmentSubDomain (Token token, MathDescription mathdesc, CommentStringTokenizer tokens) throws cbit.vcell.parser.ExpressionException, MathException {
	super(token,tokens);
	parseBlock(mathdesc, tokens);
}

	public void getAllExpressions(List<Expression> expressionList, MathDescription mathDescription){
		super.getAllExpressions0(expressionList, mathDescription);
	}

@Override
protected String startToken() {
	return VCML.CompartmentSubDomain;
}

/**
 * This method was created in VisualAge.
 * @return boolean
 * @param object java.lang.Object
 */
public boolean compareEqual(Matchable object) {
	if (!super.compareEqual0(object)){ //verifies object type
		return false;
	}
	VCAssert.ofType(object,CompartmentSubDomain.class);
	CompartmentSubDomain csd = (CompartmentSubDomain)object;
	//
	// compare boundaryConditions
	//
	if (!Compare.isEqual(boundaryConditionTypeXp,csd.boundaryConditionTypeXp)){
		return false;
	}
	if (!Compare.isEqual(boundaryConditionTypeXm,csd.boundaryConditionTypeXm)){
		return false;
	}
	if (!Compare.isEqual(boundaryConditionTypeYp,csd.boundaryConditionTypeYp)){
		return false;
	}
	if (!Compare.isEqual(boundaryConditionTypeYm,csd.boundaryConditionTypeYm)){
		return false;
	}
	if (!Compare.isEqual(boundaryConditionTypeZp,csd.boundaryConditionTypeZp)){
		return false;
	}
	if (!Compare.isEqual(boundaryConditionTypeZm,csd.boundaryConditionTypeZm)){
		return false;
	}

	return true;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public BoundaryConditionType getBoundaryConditionXm() {
	return boundaryConditionTypeXm;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public BoundaryConditionType getBoundaryConditionXp() {
	return boundaryConditionTypeXp;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public BoundaryConditionType getBoundaryConditionYm() {
	return boundaryConditionTypeYm;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public BoundaryConditionType getBoundaryConditionYp() {
	return boundaryConditionTypeYp;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public BoundaryConditionType getBoundaryConditionZm() {
	return boundaryConditionTypeZm;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public BoundaryConditionType getBoundaryConditionZp() {
	return boundaryConditionTypeZp;
}

/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public String getVCML(int spatialDimension) {
	StringBuffer buffer = new StringBuffer();
	buffer.append(VCML.CompartmentSubDomain+" "+getName()+" {\n");
	if (spatialDimension>=1){
		buffer.append("\t"+VCML.BoundaryXm+"\t "+boundaryConditionTypeXm.boundaryTypeStringValue()+"\n");
		buffer.append("\t"+VCML.BoundaryXp+"\t "+boundaryConditionTypeXp.boundaryTypeStringValue()+"\n");
	}
	if (spatialDimension>=2){
		buffer.append("\t"+VCML.BoundaryYm+"\t "+boundaryConditionTypeYm.boundaryTypeStringValue()+"\n");
		buffer.append("\t"+VCML.BoundaryYp+"\t "+boundaryConditionTypeYp.boundaryTypeStringValue()+"\n");
	}
	if (spatialDimension==3){
		buffer.append("\t"+VCML.BoundaryZm+"\t "+boundaryConditionTypeZm.boundaryTypeStringValue()+"\n");
		buffer.append("\t"+VCML.BoundaryZp+"\t "+boundaryConditionTypeZp.boundaryTypeStringValue()+"\n");
	}
	
	// BoundaryconditionSpecs
	if (getBoundaryconditionSpecs().size() > 0) {
		for (BoundaryConditionSpec bcs : getBoundaryconditionSpecs()) {
			buffer.append(bcs.getVCML());
		}
		buffer.append("\n");
	}
	
	Enumeration<Equation> enum1 = getEquations();
	while (enum1.hasMoreElements()){
		Equation equ = enum1.nextElement();
		buffer.append(equ.getVCML());
	}	
	if (getFastSystem()!=null){
		buffer.append(getFastSystem().getVCML());
	}
	//Var initial conditions
	if(getVarIniConditions().size()>0)
	{
		for(VarIniCondition vic : getVarIniConditions()){
			buffer.append(vic.getVCML());
		}
		buffer.append("\n");
	}
	//particle initial conditions
	for (ParticleProperties pp : getParticleProperties()){
		buffer.append(pp.getVCML(spatialDimension));
		buffer.append("\n");
	}
	//Jump processes
	for (ParticleJumpProcess particleJumpProcess : getParticleJumpProcesses()){
		buffer.append(particleJumpProcess.getVCML());
		buffer.append("\n");
	}
	//Jump processes
	if(getJumpProcesses().size()>0)
	{
		for(JumpProcess jp : getJumpProcesses()){
			buffer.append(jp.getVCML());
		}
	}	
	buffer.append("}\n");
	return buffer.toString();		
}


@Override
protected void parse(MathDescription mathDesc, String token, CommentStringTokenizer tokens) throws MathException, ExpressionException {
	if (token.equalsIgnoreCase(VCML.Handle)){
		//
		// throw away "handle information" deprecated
		//
		token = tokens.nextToken();
		//handle = Integer.valueOf(token).intValue();
		return;
	}
	if (token.equalsIgnoreCase(VCML.Priority)){ //legacy support; just ignore this token
		token = tokens.nextToken();
		return;
	}
	if (token.equalsIgnoreCase(VCML.BoundaryXm)){
		String type = tokens.nextToken();
		boundaryConditionTypeXm = new BoundaryConditionType(type);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.BoundaryXp)){
		String type = tokens.nextToken();
		boundaryConditionTypeXp = new BoundaryConditionType(type);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.BoundaryYm)){
		String type = tokens.nextToken();
		boundaryConditionTypeYm = new BoundaryConditionType(type);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.BoundaryYp)){
		String type = tokens.nextToken();
		boundaryConditionTypeYp = new BoundaryConditionType(type);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.BoundaryZm)){
		String type = tokens.nextToken();
		boundaryConditionTypeZm = new BoundaryConditionType(type);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.BoundaryZp)){
		String type = tokens.nextToken();
		boundaryConditionTypeZp = new BoundaryConditionType(type);
		return;
	}
	if (token.equalsIgnoreCase(VCML.BoundaryConditionSpec)) {
		String name = tokens.nextToken();
		String type = tokens.nextToken();
		BoundaryConditionSpec  bcs = new BoundaryConditionSpec(name, new BoundaryConditionType(type));
		addBoundaryConditionSpec(bcs);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.PdeEquation)){
		token = tokens.nextToken();
		boolean bSteady = false;
		if (token.equals(VCML.Steady)) {
			bSteady = true;
			token = tokens.nextToken();
		}
		Variable var = mathDesc.getVariable(token);
		if (var == null){
			throw new MathFormatException("variable "+token+" not defined");
		}	
		if (!(var instanceof VolVariable)){
			throw new MathFormatException("variable "+token+" not a VolumeVariable");
		}	
		PdeEquation pde = new PdeEquation((VolVariable)var, bSteady);
		pde.read(tokens, mathDesc);
		addEquation(pde);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.OdeEquation)){
		token = tokens.nextToken();
		Variable var = mathDesc.getVariable(token);
		if (var == null){
			throw new MathFormatException("variable "+token+" not defined");
		}	
		if (!(var instanceof VolVariable)){
			throw new MathFormatException("variable "+token+" not a VolumeVariable");
		}	
		OdeEquation ode = new OdeEquation((VolVariable)var,null,null);
		ode.read(tokens, mathDesc);
		addEquation(ode);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.VolumeRegionEquation)){
		token = tokens.nextToken();
		Variable var = mathDesc.getVariable(token);
		if (var == null){
			throw new MathFormatException("variable "+token+" not defined");
		}	
		if (!(var instanceof VolumeRegionVariable)){
			throw new MathFormatException("variable "+token+" not a VolumeRegionVariable");
		}	
		VolumeRegionEquation vre = new VolumeRegionEquation((VolumeRegionVariable)var,null);
		vre.read(tokens, mathDesc);
		addEquation(vre);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.ComputeCentroidX) || 
		token.equalsIgnoreCase(VCML.ComputeCentroidY) ||
		token.equalsIgnoreCase(VCML.ComputeCentroidZ)){
		CentroidComponent component = null;
		if (token.equalsIgnoreCase(VCML.ComputeCentroidX)){
			component = CentroidComponent.X;
		}else if (token.equalsIgnoreCase(VCML.ComputeCentroidY)){
			component = CentroidComponent.Y;
		}else if (token.equalsIgnoreCase(VCML.ComputeCentroidZ)){
			component = CentroidComponent.Z;
		}
		token = tokens.nextToken();
		Variable var = mathDesc.getVariable(token);
		if (var == null){
			throw new MathFormatException("variable "+token+" not defined");
		}	
		if (!(var instanceof VolumeRegionVariable)){
			throw new MathFormatException("variable "+token+" not a VolumeRegionVariable");
		}	
		ComputeCentroidComponentEquation computeCentroidEq = new ComputeCentroidComponentEquation((VolumeRegionVariable)var,component);
		computeCentroidEq.read(tokens, mathDesc);
		addEquation(computeCentroidEq);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.ComputeDistanceToMembrane) || 
		token.equalsIgnoreCase(VCML.ComputeDirectionToMembraneX) ||
		token.equalsIgnoreCase(VCML.ComputeDirectionToMembraneY) ||
		token.equalsIgnoreCase(VCML.ComputeDirectionToMembraneZ)){
		MembraneMetricComponent component = null;
		if (token.equalsIgnoreCase(VCML.ComputeDistanceToMembrane)){
			component = MembraneMetricComponent.distanceToMembrane;
		}else if (token.equalsIgnoreCase(VCML.ComputeDirectionToMembraneX)){
			component = MembraneMetricComponent.directionToMembraneX;
		}else if (token.equalsIgnoreCase(VCML.ComputeDirectionToMembraneY)){
			component = MembraneMetricComponent.directionToMembraneY;
		}else if (token.equalsIgnoreCase(VCML.ComputeDirectionToMembraneZ)){
			component = MembraneMetricComponent.directionToMembraneZ;
		}
		token = tokens.nextToken();
		Variable var = mathDesc.getVariable(token);
		if (var == null){
			throw new MathFormatException("variable "+token+" not defined");
		}	
		if (!(var instanceof VolVariable)){
			throw new MathFormatException("variable "+token+" not a VolumeVariable");
		}	
		ComputeMembraneMetricEquation computeMembraneMetricEq = new ComputeMembraneMetricEquation((VolVariable)var,component);
		computeMembraneMetricEq.read(tokens, mathDesc);
		addEquation(computeMembraneMetricEq);
		return;
	}			
	/**
	 * ParticleJumpProcess name A B {
	 *    MacroscopicRateConstant dkdkdk;
	 *    Action destroy A
	 *    Action destroy B
	 *    Action create C
	 * }
	 */
	if (token.equalsIgnoreCase(VCML.ParticleJumpProcess)){
		ParticleJumpProcess particleJumpProcess = ParticleJumpProcess.fromVCML(mathDesc, tokens);
		addParticleJumpProcess(particleJumpProcess);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.LangevinParticleJumpProcess)){
		ParticleJumpProcess particleJumpProcess = LangevinParticleJumpProcess.fromVCML(mathDesc, tokens);
		addParticleJumpProcess(particleJumpProcess);
		return;
	}			
	if (token.equalsIgnoreCase(VCML.ParticleProperties)){
		ParticleProperties pp = new ParticleProperties(mathDesc, tokens);
		if(pp.getVariable().getDomain().getName().equals(this.getName())){
			addParticleProperties(pp);
		}else{
			throw new MathException("Variable (" + pp.getVariable().getName() + ") is defined in domain " + pp.getVariable().getDomain().getName() +
					                 ". \nHowever the variable particle properties of " + pp.getVariable().getName() + " is defined in domain " + this.getName() + ". \nPlease check your model.");
		}
		return;
	}			
	if (token.equalsIgnoreCase(VCML.FastSystem)){
		FastSystem fs = new FastSystem(mathDesc);
		fs.read(tokens, mathDesc);
		setFastSystem(fs);
		return;
	}	
	//Variable initial conditions as count		
	if (token.equalsIgnoreCase(VCML.VarIniCount_Old) || token.equalsIgnoreCase(VCML.VarIniCount))
	{
		token = tokens.nextToken();
		Variable var = mathDesc.getVariable(token);
		if (var == null){
			throw new MathFormatException("variable "+token+" not defined");
		}	
		if (!(var instanceof StochVolVariable)){
			throw new MathFormatException("variable "+token+" not a Stochastic Volume Variable");
		}
		
		Expression varIniExp = parseAndBind(mathDesc, tokens) ;
		VarIniCount vic= new VarIniCount(var,varIniExp);
		addVarIniCondition(vic);
		
		return;
	}
	//Variable inital conditions as concentration
	if (token.equalsIgnoreCase(VCML.VarIniPoissonExpectedCount))
	{
		token = tokens.nextToken();
		Variable var = mathDesc.getVariable(token);
		if (var == null){
			throw new MathFormatException("variable "+token+" not defined");
		}	
		if (!(var instanceof StochVolVariable)){
			throw new MathFormatException("variable "+token+" not a Stochastic Volume Variable");
		}
		Expression varIniExp = parseAndBind(mathDesc, tokens) ;
		VarIniPoissonExpectedCount vic= new VarIniPoissonExpectedCount(var,varIniExp);
		addVarIniCondition(vic);
		
		return;
	}
	//Jump processes 
	if (token.equalsIgnoreCase(VCML.JumpProcess))
	{
		JumpProcess jump = null;
		token = tokens.nextToken();
		String name=token;
		token = tokens.nextToken();
		if(!token.equalsIgnoreCase(VCML.BeginBlock))
			throw new MathFormatException("unexpected token "+token+" expecting "+VCML.BeginBlock);
		token = tokens.nextToken();	
		if(token.equalsIgnoreCase(VCML.ProbabilityRate))
		{
			Expression probExp = MathFunctionDefinitions.fixFunctionSyntax(tokens);
			//check if probability functions contain "t", which is not allowed.
			Expression extProb = MathUtilities.substituteFunctions(probExp,mathDesc).flatten();
			String[] symbols = extProb.getSymbols();
			if(symbols != null)
			{
				for(int i=0; i<symbols.length; i++)
				{
					if(symbols[i].equals("t"))
					{
						throw new MathFormatException("Unexpected symbol \'t\'  in probability rate of jump process "+name+". Probability rate should not be a function of t.");
					}	
				}
			}
			probExp.bindExpression(mathDesc);
			jump = new JumpProcess(name,probExp);
			addJumpProcess(jump);
		}
		else {
			throw new MathFormatException("unexpected identifier "+token);
		}

		if(jump != null)
		{
			while (tokens.hasMoreTokens())
			{
				token = tokens.nextToken();
				if (token.equalsIgnoreCase(VCML.EndBlock)){
					break;
				}
				if (token.equalsIgnoreCase(VCML.Action))
				{
					token = tokens.nextToken();
					Variable var = mathDesc.getVariable(token);
					if (var == null){
						throw new MathFormatException("variable "+token+" not defined");
					}	
					if (!(var instanceof StochVolVariable)){
						throw new MathFormatException("variable "+token+" not a Stochastic Volume Variable");
					}
					String opera = tokens.nextToken();
					if (!opera.equals(Action.ACTION_INC)){
						throw new MathFormatException("expected 'INC' for action, found "+opera);
					}
					Expression exp = parseAndBind(mathDesc, tokens);
					Action action = Action.createIncrementAction(var,exp);
					jump.addAction(action);
				}
				else throw new MathFormatException("unexpected identifier "+token);
			}
		}
		
		return;
	}	
	
	throw new MathFormatException("unexpected identifier "+token);
}

/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public void setBoundaryConditionXm(BoundaryConditionType bc) {
	boundaryConditionTypeXm = bc;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public void setBoundaryConditionXp(BoundaryConditionType bc) {
	if (boundaryConditionTypeXm.isPERIODIC() && !bc.isPERIODIC()) {
		throw new RuntimeException("Xm and Xp must both have periodic boundary condition");
	}
	boundaryConditionTypeXp = bc;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public void setBoundaryConditionYm(BoundaryConditionType bc) {
	boundaryConditionTypeYm = bc;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public void setBoundaryConditionYp(BoundaryConditionType bc) {
	if (boundaryConditionTypeYm.isPERIODIC() && !bc.isPERIODIC()) {
		throw new RuntimeException("Ym and Yp must both have periodic boundary condition");
	}	
	boundaryConditionTypeYp = bc;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public void setBoundaryConditionZm(BoundaryConditionType bc) {
	boundaryConditionTypeZm = bc;
}


/**
 * This method was created by a SmartGuide.
 * @return java.lang.String
 */
public void setBoundaryConditionZp(BoundaryConditionType bc) {
	if (boundaryConditionTypeZm.isPERIODIC() && !bc.isPERIODIC()) {
		throw new RuntimeException("Zm and Zp must both have periodic boundary condition");
	}	
	boundaryConditionTypeZp = bc;
}

}
