/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.math;

import java.io.Serializable;

import org.vcell.util.Compare;
import org.vcell.util.Matchable;

import cbit.vcell.parser.Expression;
import cbit.vcell.parser.ExpressionBindingException;
import cbit.vcell.parser.SymbolTable;
/**
 * This class was generated by a SmartGuide.
 * 
 */
abstract public class BoundFunction implements Serializable, Matchable {
	protected Expression function = null;


/**
 * This method was created by a SmartGuide.
 * @param exp cbit.vcell.parser.Expression
 */
protected BoundFunction (Expression function) {
	this.function = function;
}
	protected boolean compareEqual0(Matchable obj) {

		BoundFunction bf = (BoundFunction)obj;
		if (!Compare.isEqualOrNull(this.getFunction(), bf.getFunction()))
			return false;
			
		return true;
	}
/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.parser.Expression
 */
public Expression getFunction() {
	return function;
}

public void bind(SymbolTable symbolTable) throws ExpressionBindingException {
	function.bindExpression(symbolTable);
}
}
