/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.mapping;

/**
 * This class was generated by a SmartGuide.
 * 
 */
public final class BoundaryLocation implements java.io.Serializable {
	
	public static final int FIRST = 0;
	public static final int LAST = FIRST + 5;
	
	public static final int BOUNDARY_XP	= FIRST + 0;
	public static final int BOUNDARY_XM	= FIRST + 1;
	public static final int BOUNDARY_YP	= FIRST + 2;
	public static final int BOUNDARY_YM	= FIRST + 3;
	public static final int BOUNDARY_ZP	= FIRST + 4;
	public static final int BOUNDARY_ZM	= LAST;
	
	private int boundary = BOUNDARY_XP;
/**
 * This method was created by a SmartGuide.
 * @param selection int
 */
private BoundaryLocation (int type) {
	this.boundary = type;
}
/**
 * Compares two Objects for equality.
 * Returns a boolean that indicates whether this Object is equivalent 
 * to the specified Object. This method is used when an Object is stored
 * in a hashtable.
 * @param	obj	the Object to compare with
 * @return	true if these Objects are equal; false otherwise.
 * @see		java.util.Hashtable
 */
public boolean equals(Object obj) {
	if (obj instanceof BoundaryLocation){
		return (boundary == ((BoundaryLocation)obj).boundary);
	}
	return false;
}
/**
 * This method was created in VisualAge.
 * @return cbit.vcell.mapping.BoundaryLocation
 * @param boundaryLocationString java.lang.String
 */
public static BoundaryLocation fromDirection(int directionNum) {
	switch (directionNum){
		case BOUNDARY_XM: return new BoundaryLocation(BOUNDARY_XM);
		case BOUNDARY_XP: return new BoundaryLocation(BOUNDARY_XP);		
		case BOUNDARY_YM: return new BoundaryLocation(BOUNDARY_YM);		
		case BOUNDARY_YP: return new BoundaryLocation(BOUNDARY_YP);		
		case BOUNDARY_ZM: return new BoundaryLocation(BOUNDARY_ZM);		
		case BOUNDARY_ZP: return new BoundaryLocation(BOUNDARY_ZP);
	}
	throw new IllegalArgumentException("invalid boudary location index "+directionNum);
}
/**
 * This method was created in VisualAge.
 * @return cbit.vcell.mapping.BoundaryLocation
 * @param boundaryLocationString java.lang.String
 */
public static BoundaryLocation fromString(String boundaryLocationString) {
	if ("Xm".equalsIgnoreCase(boundaryLocationString)){
		return new BoundaryLocation(BOUNDARY_XM);
	}else if ("Xp".equalsIgnoreCase(boundaryLocationString)){
		return new BoundaryLocation(BOUNDARY_XP);
	}else if ("Ym".equalsIgnoreCase(boundaryLocationString)){
		return new BoundaryLocation(BOUNDARY_YM);
	}else if ("Yp".equalsIgnoreCase(boundaryLocationString)){
		return new BoundaryLocation(BOUNDARY_YP);
	}else if ("Zm".equalsIgnoreCase(boundaryLocationString)){
		return new BoundaryLocation(BOUNDARY_ZM);
	}else if ("Zp".equalsIgnoreCase(boundaryLocationString)){
		return new BoundaryLocation(BOUNDARY_ZP);
	}else{
		throw new IllegalArgumentException("invalid boudary location "+boundaryLocationString);
	}		
}
/**
 * This method was created in VisualAge.
 * @return int
 */
public int getNum() {
	return boundary;
}
/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.mapping.BoundaryLocation
 */
public static BoundaryLocation getXM() {
	return new BoundaryLocation(BOUNDARY_XM);
}
/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.mapping.BoundaryLocation
 */
public static BoundaryLocation getXP() {
	return new BoundaryLocation(BOUNDARY_XP);
}
/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.mapping.BoundaryLocation
 */
public static BoundaryLocation getYM() {
	return new BoundaryLocation(BOUNDARY_YM);
}
/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.mapping.BoundaryLocation
 */
public static BoundaryLocation getYP() {
	return new BoundaryLocation(BOUNDARY_YP);
}
/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.mapping.BoundaryLocation
 */
public static BoundaryLocation getZM() {
	return new BoundaryLocation(BOUNDARY_ZM);
}
/**
 * This method was created by a SmartGuide.
 * @return cbit.vcell.mapping.BoundaryLocation
 */
public static BoundaryLocation getZP() {
	return new BoundaryLocation(BOUNDARY_ZP);
}
/**
 * Generates a hash code for the receiver.
 * This method is supported primarily for hash tables, such as those provided in java.util.
 * @return	an integer hash code for the receiver
 * @see		java.util.Hashtable
 */
public int hashCode() {
	// insert code to generate a hash code for the receiver here
	// this implementation simply forwards the message to super.  You may replace or supplement this.
	// NOTE: if two objects are equal (equals(Object) returns true) they must have the same hash code
	return super.hashCode();
}
/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
public boolean isXM() {
	return boundary == BOUNDARY_XM;
}
/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
public boolean isXP() {
	return boundary == BOUNDARY_XP;
}
/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
public boolean isYM() {
	return boundary == BOUNDARY_YM;
}
/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
public boolean isYP() {
	return boundary == BOUNDARY_YP;
}
/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
public boolean isZM() {
	return boundary == BOUNDARY_ZM;
}
/**
 * This method was created by a SmartGuide.
 * @return boolean
 */
public boolean isZP() {
	return boundary == BOUNDARY_ZP;
}
/**
 * Returns a String that represents the value of this object.
 */
public String toString() {
	if (isXM()){
		return "Xm";		
	}else if (isXP()){
		return "Xp";		
	}else if (isYM()){
		return "Ym";		
	}else if (isYP()){
		return "Yp";		
	}else if (isZM()){
		return "Zm";		
	}else if (isZP()){
		return "Zp";		
	}else{
		return "BAD_GEOMETRY_SELECTION";
	}		
}
}
