/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.geometry;
import org.vcell.util.Compare;
import org.vcell.util.Matchable;
import org.vcell.util.document.KeyValue;

import cbit.image.ImageException;
import cbit.image.VCPixelClass;

import java.util.function.BiPredicate;

/**
 * This class was generated by a SmartGuide.
 * 
 */
public class ImageSubVolume extends SubVolume {
	private VCPixelClass vcPixelClass = null;

/**
 * Geometry constructor comment.
 */
public ImageSubVolume(KeyValue key, VCPixelClass vcPixelClass, int handle) {
	super(key, vcPixelClass.getPixelClassName(), handle);
	this.vcPixelClass = vcPixelClass;
}
public ImageSubVolume(ImageSubVolume oldImagesuImageSubVolume) {
	super(oldImagesuImageSubVolume.getKey(), oldImagesuImageSubVolume.getName(), oldImagesuImageSubVolume.getHandle());
	this.vcPixelClass = new VCPixelClass(oldImagesuImageSubVolume.getPixelClass());
}

/**
 * This method was created in VisualAge.
 * @return boolean
 * @param obj java.lang.Object
 */
public boolean compareEqual(Matchable obj) {
	if (!compareEqual0(obj)){
		return false;
	}
	if (!(obj instanceof ImageSubVolume)){
		return false;
	}
	ImageSubVolume sv = (ImageSubVolume)obj;

	if (!Compare.isEqual(vcPixelClass,sv.vcPixelClass)){
		return false;
	}

	return true;
}

	public boolean compareEqual(Matchable obj, BiPredicate<VCPixelClass, VCPixelClass> pixelClassPredicate ) {
		if (!compareEqual0(obj)){
			return false;
		}
		if (!(obj instanceof ImageSubVolume)){
			return false;
		}
		ImageSubVolume sv = (ImageSubVolume)obj;

		if (!pixelClassPredicate.test(vcPixelClass,sv.vcPixelClass)){
			return false;
		}

		return true;
	}


	/**
 * This method was created in VisualAge.
 * @return cbit.image.VCImageRegion
 */
public VCPixelClass getPixelClass() {
	if (vcPixelClass==null){
		throw new RuntimeException("pixelClassIsNull");
	}
	return vcPixelClass;
}

void setPixelClass(VCPixelClass vcPixelClass){
	//During incremental saves the vcImage is saved first and populated with keys
	//and we want to replace the geometry's unsaved image with the saved image from the database
	//and we want to point to the right (new) pixelClasses (because pixelclasses have db keys).
	this.vcPixelClass = vcPixelClass;
}

/**
 * This method was created in VisualAge.
 * @return int
 */
public int getPixelValue() {
	return vcPixelClass.getPixel();
}


/**
 * This method was created in VisualAge.
 * @return boolean
 * @param x double
 * @param y double
 * @param z double
 */
public boolean isInside(double x,double y, double z, GeometrySpec geometrySpec) throws GeometryException, ImageException {

	if (geometrySpec.getImage()==null){
		throw new GeometryException("vcImage is null");
	}

	//
	// get pixel index
	//
	int index = geometrySpec.getImageIndex(x,y,z);

	//
	// get pixel value
	//
	int pix = 0xff&(int)geometrySpec.getUncompressedPixels()[index];

	//
	// see if pixel value is equal to this pixel
	//
	
	return pix==getPixelValue();
}
}
