/*
 * Copyright (C) 1999-2011 University of Connecticut Health Center
 *
 * Licensed under the MIT License (the "License").
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *  http://www.opensource.org/licenses/mit-license.php
 */

package cbit.vcell.math.gui;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.border.EtchedBorder;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import org.vcell.util.gui.ButtonGroupCivilized;

import cbit.vcell.desktop.BioModelNode;
import cbit.vcell.mapping.DiffEquMathMapping;
import cbit.vcell.math.Action;
import cbit.vcell.math.Constant;
import cbit.vcell.math.Equation;
import cbit.vcell.math.Function;
import cbit.vcell.math.MathDescription;
import cbit.vcell.math.VarIniCondition;
import cbit.vcell.parser.Expression;
import cbit.vcell.parser.ExpressionException;
import cbit.vcell.parser.gui.ExpressionCanvas;
/**
 * This class was generated by a SmartGuide.
 * 
 */
public class MathDescPanel extends javax.swing.JPanel implements java.beans.PropertyChangeListener, javax.swing.event.TreeSelectionListener {
	private ExpressionCanvas ivjExpressionCanvas1 = null;
	private javax.swing.JPanel ivjJPanel1 = null;
	private javax.swing.JScrollPane ivjJScrollPane1 = null;
	private ButtonGroupCivilized ivjButtonGroupCivilized1 = null;
	private javax.swing.JPanel ivjJPanel2 = null;
	private javax.swing.JRadioButton ivjJRadioButtonName = null;
	private javax.swing.JRadioButton ivjJRadioButtonValue = null;
	private javax.swing.JLabel ivjShowParametersLabel = null;
	private MathDescription fieldMathDescription = null;
	private boolean ivjConnPtoP1Aligning = false;
	private MathDescription ivjmathDescription1 = null;
	private javax.swing.JScrollPane ivjJScrollPane2 = null;
	private javax.swing.JTree ivjJTree1 = null;
	private MathDescriptionTreeModel ivjMathDescriptionTreeModel = null;
	private boolean ivjConnPtoP2Aligning = false;
	private TreeSelectionModel ivjselectionModel1 = null;

/**
 * Constructor
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public MathDescPanel() {
	super();
	initialize();
}


/**
 * connEtoC1:  (selectionModel1.treeSelection.valueChanged(javax.swing.event.TreeSelectionEvent) --> MathDescPanel.refreshEquations()V)
 * @param arg1 javax.swing.event.TreeSelectionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1(javax.swing.event.TreeSelectionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.refreshEquations();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoC2:  (ButtonGroupCivilized1.selection --> MathDescPanel.refreshEquations()V)
 * @param arg1 java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC2(java.beans.PropertyChangeEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.refreshEquations();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM1:  (MathDescPanel.initialize() --> JTree1.model)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM1() {
	try {
		// user code begin {1}
		// user code end
		getJTree1().setModel(getMathDescriptionTreeModel());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM2:  (mathDescription1.this --> MathDescriptionTreeModel.mathDescription)
 * @param value cbit.vcell.math.MathDescription
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM2(MathDescription value) {
	try {
		// user code begin {1}
		// user code end
		if ((getmathDescription1() != null)) {
			getMathDescriptionTreeModel().setMathDescription(getmathDescription1());
		}
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM4:  (MathDescPanel.initialize() --> ButtonGroupCivilized1.add(Ljavax.swing.AbstractButton;)V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM4() {
	try {
		// user code begin {1}
		// user code end
		getButtonGroupCivilized1().add(getJRadioButtonName());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connEtoM5:  (MathDescPanel.initialize() --> ButtonGroupCivilized1.add(Ljavax.swing.AbstractButton;)V)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM5() {
	try {
		// user code begin {1}
		// user code end
		getButtonGroupCivilized1().add(getJRadioButtonValue());
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connPtoP1SetSource:  (MathDescPanel.mathDescription <--> mathDescription1.this)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP1SetSource() {
	/* Set the source from the target */
	try {
		if (ivjConnPtoP1Aligning == false) {
			// user code begin {1}
			// user code end
			ivjConnPtoP1Aligning = true;
			if ((getmathDescription1() != null)) {
				this.setMathDescription(getmathDescription1());
			}
			// user code begin {2}
			// user code end
			ivjConnPtoP1Aligning = false;
		}
	} catch (java.lang.Throwable ivjExc) {
		ivjConnPtoP1Aligning = false;
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connPtoP1SetTarget:  (MathDescPanel.mathDescription <--> mathDescription1.this)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP1SetTarget() {
	/* Set the target from the source */
	try {
		if (ivjConnPtoP1Aligning == false) {
			// user code begin {1}
			// user code end
			ivjConnPtoP1Aligning = true;
			setmathDescription1(this.getMathDescription());
			// user code begin {2}
			// user code end
			ivjConnPtoP1Aligning = false;
		}
	} catch (java.lang.Throwable ivjExc) {
		ivjConnPtoP1Aligning = false;
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connPtoP2SetSource:  (JTree1.selectionModel <--> selectionModel1.this)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP2SetSource() {
	/* Set the source from the target */
	try {
		if (ivjConnPtoP2Aligning == false) {
			// user code begin {1}
			// user code end
			ivjConnPtoP2Aligning = true;
			if ((getselectionModel1() != null)) {
				getJTree1().setSelectionModel(getselectionModel1());
			}
			// user code begin {2}
			// user code end
			ivjConnPtoP2Aligning = false;
		}
	} catch (java.lang.Throwable ivjExc) {
		ivjConnPtoP2Aligning = false;
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * connPtoP2SetTarget:  (JTree1.selectionModel <--> selectionModel1.this)
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connPtoP2SetTarget() {
	/* Set the target from the source */
	try {
		if (ivjConnPtoP2Aligning == false) {
			// user code begin {1}
			// user code end
			ivjConnPtoP2Aligning = true;
			setselectionModel1(getJTree1().getSelectionModel());
			// user code begin {2}
			// user code end
			ivjConnPtoP2Aligning = false;
		}
	} catch (java.lang.Throwable ivjExc) {
		ivjConnPtoP2Aligning = false;
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}


/**
 * Return the ButtonGroupCivilized1 property value.
 * @return cbit.gui.ButtonGroupCivilized
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ButtonGroupCivilized getButtonGroupCivilized1() {
	if (ivjButtonGroupCivilized1 == null) {
		try {
			ivjButtonGroupCivilized1 = new ButtonGroupCivilized();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjButtonGroupCivilized1;
}


/**
 * Return the ExpressionCanvas1 property value.
 * @return cbit.vcell.math.ExpressionCanvas
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private ExpressionCanvas getExpressionCanvas1() {
	if (ivjExpressionCanvas1 == null) {
		try {
			ivjExpressionCanvas1 = new ExpressionCanvas();
			ivjExpressionCanvas1.setName("ExpressionCanvas1");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjExpressionCanvas1;
}

/**
 * Return the JPanel1 property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getJPanel1() {
	if (ivjJPanel1 == null) {
		try {
			ivjJPanel1 = new javax.swing.JPanel();
			ivjJPanel1.setName("JPanel1");
			ivjJPanel1.setPreferredSize(new java.awt.Dimension(600, 400));
			ivjJPanel1.setLayout(new java.awt.GridBagLayout());
			ivjJPanel1.setMinimumSize(new java.awt.Dimension(22, 22));

			java.awt.GridBagConstraints constraintsJScrollPane1 = new java.awt.GridBagConstraints();
			constraintsJScrollPane1.gridx = 0; constraintsJScrollPane1.gridy = 2;
			constraintsJScrollPane1.fill = java.awt.GridBagConstraints.BOTH;
			constraintsJScrollPane1.weightx = 1.0;
			constraintsJScrollPane1.weighty = 1.0;
			constraintsJScrollPane1.insets = new java.awt.Insets(4, 4, 4, 4);
			getJPanel1().add(getJScrollPane1(), constraintsJScrollPane1);

			java.awt.GridBagConstraints constraintsJPanel2 = new java.awt.GridBagConstraints();
			constraintsJPanel2.gridx = 0; constraintsJPanel2.gridy = 1;
			constraintsJPanel2.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsJPanel2.insets = new java.awt.Insets(4, 4, 4, 4);
			getJPanel1().add(getJPanel2(), constraintsJPanel2);

			java.awt.GridBagConstraints constraintsJScrollPane2 = new java.awt.GridBagConstraints();
			constraintsJScrollPane2.gridx = 0; constraintsJScrollPane2.gridy = 0;
			constraintsJScrollPane2.fill = java.awt.GridBagConstraints.BOTH;
			constraintsJScrollPane2.weightx = 1.0;
			constraintsJScrollPane2.weighty = 1.0;
			constraintsJScrollPane2.insets = new java.awt.Insets(4, 4, 4, 4);
			getJPanel1().add(getJScrollPane2(), constraintsJScrollPane2);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJPanel1;
}

/**
 * Return the JPanel2 property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getJPanel2() {
	if (ivjJPanel2 == null) {
		try {
			ivjJPanel2 = new javax.swing.JPanel();
			ivjJPanel2.setName("JPanel2");
			ivjJPanel2.setLayout(new java.awt.GridBagLayout());
			ivjJPanel2.setMinimumSize(new java.awt.Dimension(106, 30));

			java.awt.GridBagConstraints constraintsShowParametersLabel = new java.awt.GridBagConstraints();
			constraintsShowParametersLabel.gridx = 0; constraintsShowParametersLabel.gridy = 0;
			constraintsShowParametersLabel.insets = new java.awt.Insets(4, 4, 4, 4);
			getJPanel2().add(getShowParametersLabel(), constraintsShowParametersLabel);

			java.awt.GridBagConstraints constraintsJRadioButtonName = new java.awt.GridBagConstraints();
			constraintsJRadioButtonName.gridx = 1; constraintsJRadioButtonName.gridy = 0;
			constraintsJRadioButtonName.insets = new java.awt.Insets(4, 4, 4, 4);
			getJPanel2().add(getJRadioButtonName(), constraintsJRadioButtonName);

			java.awt.GridBagConstraints constraintsJRadioButtonValue = new java.awt.GridBagConstraints();
			constraintsJRadioButtonValue.gridx = 2; constraintsJRadioButtonValue.gridy = 0;
			constraintsJRadioButtonValue.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsJRadioButtonValue.weightx = 1.0;
			constraintsJRadioButtonValue.insets = new java.awt.Insets(4, 4, 4, 4);
			getJPanel2().add(getJRadioButtonValue(), constraintsJRadioButtonValue);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJPanel2;
}

/**
 * Return the JRadioButtonName property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getJRadioButtonName() {
	if (ivjJRadioButtonName == null) {
		try {
			ivjJRadioButtonName = new javax.swing.JRadioButton();
			ivjJRadioButtonName.setName("JRadioButtonName");
			ivjJRadioButtonName.setSelected(true);
			ivjJRadioButtonName.setText("name");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJRadioButtonName;
}


/**
 * Return the JRadioButtonValue property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getJRadioButtonValue() {
	if (ivjJRadioButtonValue == null) {
		try {
			ivjJRadioButtonValue = new javax.swing.JRadioButton();
			ivjJRadioButtonValue.setName("JRadioButtonValue");
			ivjJRadioButtonValue.setText("value");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJRadioButtonValue;
}


/**
 * Return the ExpressionCanvasPanel property value.
 * @return javax.swing.JScrollPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JScrollPane getJScrollPane1() {
	if (ivjJScrollPane1 == null) {
		try {
			ivjJScrollPane1 = new javax.swing.JScrollPane();
			ivjJScrollPane1.setName("JScrollPane1");
			ivjJScrollPane1.setPreferredSize(new java.awt.Dimension(700, 400));
			ivjJScrollPane1.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.RAISED));
			ivjJScrollPane1.setBackground(java.awt.Color.lightGray);
			ivjJScrollPane1.setMinimumSize(new java.awt.Dimension(22, 22));
			getJScrollPane1().setViewportView(getExpressionCanvas1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJScrollPane1;
}

/**
 * Return the JScrollPane2 property value.
 * @return javax.swing.JScrollPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JScrollPane getJScrollPane2() {
	if (ivjJScrollPane2 == null) {
		try {
			ivjJScrollPane2 = new javax.swing.JScrollPane();
			ivjJScrollPane2.setName("JScrollPane2");
			getJScrollPane2().setViewportView(getJTree1());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJScrollPane2;
}

/**
 * Return the JTree1 property value.
 * @return javax.swing.JTree
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JTree getJTree1() {
	if (ivjJTree1 == null) {
		try {
			ivjJTree1 = new javax.swing.JTree();
			ivjJTree1.setName("JTree1");
			ivjJTree1.setCellRenderer(new MathDescriptionCellRenderer());
			ivjJTree1.setBounds(0, 0, 78, 72);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjJTree1;
}

/**
 * Gets the mathDescription property (cbit.vcell.math.MathDescription) value.
 * @return The mathDescription property value.
 * @see #setMathDescription
 */
public MathDescription getMathDescription() {
	return fieldMathDescription;
}


/**
 * Return the mathDescription1 property value.
 * @return cbit.vcell.math.MathDescription
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private MathDescription getmathDescription1() {
	// user code begin {1}
	// user code end
	return ivjmathDescription1;
}


/**
 * Return the MathDescriptionTreeModel property value.
 * @return cbit.vcell.math.gui.MathDescriptionTreeModel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private MathDescriptionTreeModel getMathDescriptionTreeModel() {
	if (ivjMathDescriptionTreeModel == null) {
		try {
			ivjMathDescriptionTreeModel = new MathDescriptionTreeModel();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjMathDescriptionTreeModel;
}


/**
 * Return the selectionModel1 property value.
 * @return javax.swing.tree.TreeSelectionModel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.tree.TreeSelectionModel getselectionModel1() {
	// user code begin {1}
	// user code end
	return ivjselectionModel1;
}


/**
 * Return the ShowParametersLabel property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JLabel getShowParametersLabel() {
	if (ivjShowParametersLabel == null) {
		try {
			ivjShowParametersLabel = new javax.swing.JLabel();
			ivjShowParametersLabel.setName("ShowParametersLabel");
			ivjShowParametersLabel.setText("Show parameter:");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjShowParametersLabel;
}


/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	 System.out.println("--------- UNCAUGHT EXCEPTION ------- in MathDescPanel");
	 exception.printStackTrace(System.out);
}

/**
 * Initializes connections
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	// user code end
	getButtonGroupCivilized1().addPropertyChangeListener(this);
	this.addPropertyChangeListener(this);
	getJTree1().addPropertyChangeListener(this);
	connPtoP1SetTarget();
	connPtoP2SetTarget();
}

/**
 * Initialize class
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		// user code end
		setName("MathDescPanel");
		setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.X_AXIS));
		setSize(564, 475);
		add(getJPanel1(), getJPanel1().getName());
		initConnections();
		connEtoM5();
		connEtoM4();
		connEtoM1();
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {2}
	// user code end
}

/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		javax.swing.JFrame frame = new javax.swing.JFrame();
		MathDescPanel aMathDescPanel;
		aMathDescPanel = new MathDescPanel();
		frame.setContentPane(aMathDescPanel);
		frame.setSize(aMathDescPanel.getSize());
		frame.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				System.exit(0);
			};
		});
		frame.setVisible(true);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of javax.swing.JPanel");
		exception.printStackTrace(System.out);
	}
}


/**
 * Method to handle events for the PropertyChangeListener interface.
 * @param evt java.beans.PropertyChangeEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void propertyChange(java.beans.PropertyChangeEvent evt) {
	// user code begin {1}
	// user code end
	if (evt.getSource() == getButtonGroupCivilized1() && (evt.getPropertyName().equals("selection"))) 
		connEtoC2(evt);
	if (evt.getSource() == this && (evt.getPropertyName().equals("mathDescription"))) 
		connPtoP1SetTarget();
	if (evt.getSource() == getJTree1() && (evt.getPropertyName().equals("selectionModel"))) 
		connPtoP2SetTarget();
	// user code begin {2}
	// user code end
}

/**
 * This method was created by a SmartGuide.
 */
private void refreshEquations() throws ExpressionException {

	TreePath selectionPath = getselectionModel1().getSelectionPath();
	if (selectionPath!=null){
		BioModelNode node = (BioModelNode)selectionPath.getLastPathComponent();
		Object objectPath[] = node.getUserObjectPath();
		Object lastPathObject = objectPath[objectPath.length-1];
		Expression expArray[] = null; // for non-stochastic
		String expString[] = null; // for stochastic
		getExpressionCanvas1().setStrings(null);
		getExpressionCanvas1().setExpressions(null); 
		if (lastPathObject instanceof Function){
			Function function = (Function)lastPathObject;
			Expression exp = function.getExpression();
			if (getJRadioButtonValue().isSelected()){
				exp.bindExpression(getMathDescription());
			}else{
				exp.bindExpression(null);
			}
			exp = exp.flatten();
			//stochastic variable initial value must be an int, therefore we must make it here.
			if(getMathDescription().isNonSpatialStoch() && 
					function.getName().startsWith(DiffEquMathMapping.MATH_FUNC_SUFFIX_SPECIES_INIT_CONC_UNIT_PREFIX)) {
				try{
					double value = exp.evaluateConstant();
					expString = new String[] {function.getName()+" = "+Math.round(value)};
					getExpressionCanvas1().setStrings(expString);
				}catch (Exception e)
				{
					expArray = new Expression[] { Expression.assign(new Expression(function.getName()),	exp) };
					getExpressionCanvas1().setExpressions(expArray);
				}
			}
			else 
			{
				expArray = new Expression[] { Expression.assign(new Expression(function.getName()),	exp) };
				getExpressionCanvas1().setExpressions(expArray);
			}
		}else if (lastPathObject instanceof Constant){
			Constant constant = (Constant)lastPathObject;
			Expression exp = constant.getExpression();
			if (getJRadioButtonValue().isSelected()){
				exp.bindExpression(getMathDescription());
			}else{
				exp.bindExpression(null);
			}
			exp = exp.flatten();
			//stochastic variable initial value must be an int, therefore we must make it here.
			if(getMathDescription().isNonSpatialStoch() && 
					constant.getName().startsWith(DiffEquMathMapping.MATH_FUNC_SUFFIX_SPECIES_INIT_CONC_UNIT_PREFIX)) {
				try{
					double value = exp.evaluateConstant();
					expString = new String[] {constant.getName()+" = "+Math.round(value)};
					getExpressionCanvas1().setStrings(expString);
				}catch (Exception e)
				{
					expArray = new Expression[] { Expression.assign(new Expression(constant.getName()),	exp) };
					getExpressionCanvas1().setExpressions(expArray);
				}
			}
			else 
			{
				expArray = new Expression[] { Expression.assign(new Expression(constant.getName()),	exp) };
				getExpressionCanvas1().setExpressions(expArray);			
			}
		}else if (lastPathObject instanceof Equation){
			Equation equ = (Equation)lastPathObject;
			Enumeration<Expression> enum_equ = equ.getTotalExpressions();
			Vector<Expression> expList = new Vector<Expression>();
			while (enum_equ.hasMoreElements()){
				Expression exp = new Expression(enum_equ.nextElement());
				if (getJRadioButtonValue().isSelected()){
					exp.bindExpression(getMathDescription());
				}else{
					exp.bindExpression(null);
				}	
				expList.addElement(exp.flatten());
			}
			expArray = new Expression[expList.size()];
			expList.copyInto(expArray);
			getExpressionCanvas1().setExpressions(expArray);
		}
		else if (lastPathObject instanceof VarIniCondition) //added Sept 29, 2006
		{
			VarIniCondition varIni = (VarIniCondition)lastPathObject;
			expString = new String[] {varIni.toString()};
			getExpressionCanvas1().setStrings(expString);
		}
		else if (lastPathObject instanceof Action) //added Sept 29, 2006
		{
			Action action = (Action)lastPathObject;
			expString = new String[] {action.toString()};
			getExpressionCanvas1().setStrings(expString);
		}
		else if (lastPathObject instanceof String) //added Sept 29, 2006
		{
			// to check if the string is the probability string
			int index1 = ((String)lastPathObject).indexOf("probability_rate");
			int index2 = ((String)lastPathObject).indexOf("=");
			if((index1 == 0) && ((index2+2)< ((String)lastPathObject).length())) //has probability eqution,but don't calculate prob string, since it is not a constant value.
			{
				expString = new String[] {(String)lastPathObject};
				getExpressionCanvas1().setStrings(expString);
			}
		}
			
	}else{
		getExpressionCanvas1().setExpressions(null);
		getExpressionCanvas1().setStrings(null);
		getExpressionCanvas1().repaint();
	}
	
				//Variable var = getMathDescription().getVariable(varName);
				//SubDomain subDomain = getMathDescription().getSubDomain(subDomainName);
				//Equation equ = null;
				//if (var != null && subDomain != null){
					//equ = subDomain.getEquation(var);
				//}	
				//if (equ == null){
					//if (subDomain instanceof MembraneSubDomain && var instanceof VolVariable){
						//equ = ((MembraneSubDomain)subDomain).getJumpCondition((VolVariable)var);
					//}
				//}
				//if (equ == null){
					//Expression exp = null;
					//String title = "hello";
					//if (var instanceof Constant || var instanceof Function){
						//exp = var.getExpression();
						//title = "Expression for "+var.getName();
					//}
					//if (getJRadioButtonValue().isSelected()){
						//exp.bindExpression(getMathDescription());
					//}else{
						//exp.bindExpression(null);
					//}	
					//getExpressionCanvas1().setExpression(exp.flatten());
					//getEquationTitleLabel().setText(title);
				//}else{
					//Enumeration enum_equ = equ.getTotalExpressions();
					//Vector expList = new Vector();
					//while (enum_equ.hasMoreElements()){
						//Expression exp = new Expression((Expression)enum_equ.nextElement());
						//if (getJRadioButtonValue().isSelected()){
							//exp.bindExpression(getMathDescription());
						//}else{
							//exp.bindExpression(null);
						//}	
						//expList.addElement(exp.flatten());
					//}
					//Expression expArray[] = new Expression[expList.size()];
					//expList.copyInto(expArray);
					//getExpressionCanvas1().setExpressions(expArray);
					//getEquationTitleLabel().setText("Equations for "+var.getName()+" within "+subDomain.getName());
				//}	
			//} catch (java.lang.Throwable ivjExc) {
				//handleException(ivjExc);
				//getEquationTitleLabel().setText("Equations for "+varName+" within "+subDomainName+" *** "+ivjExc.getMessage());
			//}
		//}
	//}else{
		//getEquationTitleLabel().setText("no variable selected");
		//getExpressionCanvas1().setExpression((Expression)null);
	//}	
}


/**
 * Sets the mathDescription property (cbit.vcell.math.MathDescription) value.
 * @param mathDescription The new value for the property.
 * @see #getMathDescription
 */
public void setMathDescription(MathDescription mathDescription) {
	MathDescription oldValue = fieldMathDescription;
	fieldMathDescription = mathDescription;
	firePropertyChange("mathDescription", oldValue, mathDescription);
}


/**
 * Set the mathDescription1 to a new value.
 * @param newValue cbit.vcell.math.MathDescription
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void setmathDescription1(MathDescription newValue) {
	if (ivjmathDescription1 != newValue) {
		try {
			MathDescription oldValue = getmathDescription1();
			ivjmathDescription1 = newValue;
			connPtoP1SetSource();
			connEtoM2(ivjmathDescription1);
			firePropertyChange("mathDescription", oldValue, newValue);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	// user code begin {3}
	// user code end
}

/**
 * Set the selectionModel1 to a new value.
 * @param newValue javax.swing.tree.TreeSelectionModel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void setselectionModel1(javax.swing.tree.TreeSelectionModel newValue) {
	if (ivjselectionModel1 != newValue) {
		try {
			/* Stop listening for events from the current object */
			if (ivjselectionModel1 != null) {
				ivjselectionModel1.removeTreeSelectionListener(this);
			}
			ivjselectionModel1 = newValue;

			/* Listen for events from the new object */
			if (ivjselectionModel1 != null) {
				ivjselectionModel1.addTreeSelectionListener(this);
			}
			connPtoP2SetSource();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	// user code begin {3}
	// user code end
}

/**
 * Method to handle events for the TreeSelectionListener interface.
 * @param e javax.swing.event.TreeSelectionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void valueChanged(javax.swing.event.TreeSelectionEvent e) {
	// user code begin {1}
	// user code end
	if (e.getSource() == getselectionModel1()) 
		connEtoC1(e);
	// user code begin {2}
	// user code end
}

}
