#!/usr/bin/env bash

VCELL_ROOTDIR="$(cd "$(dirname "$0")"; cd ..; pwd)"

shopt -s -o nounset

if [ "$#" -ne 6 ]; then
    echo "usage: config.sh SITE (REPO/NAMESPACE | NAMESPACE) TAG VCELL_VERSION_NUMBER VCELL_BUILD_NUMBER OUTPUTFILE"
    exit 1
fi

_site=$1
_repo=$2
_tag=$3
_version_number=$4
_build_number=$5
_outputfile=$6

echo "args: | $1 | $2 | $3 | $4 | $5 | $6 |"

_site_lower=$(echo "$_site" | tr '[:upper:]' '[:lower:]')
_site_upper=$(echo "$_site" | tr '[:lower:]' '[:upper:]')
_site_camel="${_site_upper:0:1}${_site_lower:1:100}"


VCELL_SITE="${_site_upper}"
VCELL_REPO_NAMESPACE=$_repo
VCELL_TAG=$_tag
VCELL_VERSION_NUMBER=$_version_number
VCELL_BUILD_NUMBER=$_build_number
#SLURM parameter values
vcell_slurm_partition=vcell

VCELL_API_HOST_EXTERNAL=$(hostname)
DATABASE_HOST=$(hostname)

case $VCELL_SITE in
	REL)
		_site_port_offset=0
		_applicationId="1471-8022-1038-5553"
    VCELL_S3_EXPORT_BASEURL=https://vcellapi.cam.uchc.edu
		;;
	BETA)
		_site_port_offset=1
		_applicationId="1471-8022-1038-5552"
		VCELL_S3_EXPORT_BASEURL=https://vcellapi-beta.cam.uchc.edu
		;;
	ALPHA)
		_site_port_offset=2
		_applicationId="1471-8022-1038-5554"
		VCELL_S3_EXPORT_BASEURL=https://vcellapi-beta.cam.uchc.edu
		;;
	TEST)
		_site_port_offset=3
		_applicationId="1471-8022-1038-5555"
		VCELL_S3_EXPORT_BASEURL=https://localhost
		;;
	TEST2)
		_site_port_offset=4
		_applicationId="1471-8022-1038-5556"
		;;
	TEST3)
		_site_port_offset=5
		_applicationId="1471-8022-1038-5557"
		;;
	TEST4)
		_site_port_offset=6
		_applicationId="1471-8022-1038-5558"
		;;
	TEST5)
		_site_port_offset=7
		_applicationId="1471-8022-1038-5559"
		;;
	*)
		printf 'ERROR: Unknown site: %s\n' "$1" >&2
		;;
esac

VCELL_DEPLOY_ROOT_DIR=${VCELL_ROOTDIR}/docker/sandbox

if [ ! -e "$VCELL_DEPLOY_ROOT_DIR" ]; then mkdir "$VCELL_DEPLOY_ROOT_DIR"; fi
if [ ! -e "$VCELL_DEPLOY_ROOT_DIR/users" ]; then mkdir "$VCELL_DEPLOY_ROOT_DIR/users"; fi
if [ ! -e "$VCELL_DEPLOY_ROOT_DIR/htclogs" ]; then mkdir "$VCELL_DEPLOY_ROOT_DIR/htclogs"; fi
if [ ! -e "$VCELL_DEPLOY_ROOT_DIR/config" ]; then mkdir "$VCELL_DEPLOY_ROOT_DIR/config"; fi
if [ ! -e "$VCELL_DEPLOY_ROOT_DIR/singularity" ]; then mkdir "$VCELL_DEPLOY_ROOT_DIR/singularity"; fi

VCELL_DB_URL="jdbc:postgresql://${DATABASE_HOST}:5432/postgres"
VCELL_DB_DRIVER="org.postgresql.Driver"
VCELL_DB_USER="vcell"
VCELL_API_HOST_EXTERNAL=$(hostname)
VCELL_JMS_SIM_HOST_EXTERNAL=$(hostname)
VCELL_MONGO_HOST_EXTERNAL=$(hostname)
VCELL_BATCH_HOST=$(hostname)
VCELL_SLURM_CMD_SBATCH=${VCELL_ROOTDIR}/docker/mockslurm/sbatch_docker
VCELL_SLURM_CMD_SACCT=${VCELL_ROOTDIR}/docker/mockslurm/sacct
VCELL_SLURM_CMD_SQUEUE=${VCELL_ROOTDIR}/docker/mockslurm/squeue
VCELL_SLURM_CMD_SCANCEL=${VCELL_ROOTDIR}/docker/mockslurm/scancel
VCELL_SLURM_PARTITION=$vcell_slurm_partition
VCELL_SLURM_TMPDIR=/tmp
VCELL_SLURM_LOCAL_SINGULARITY_DIR=/state/partition1/singularityImages
VCELL_SLURM_CENTRAL_SINGULARITY_DIR=/share/apps/vcell3/singularityImages

VCELL_API_PORT_EXTERNAL=$((8080 + _site_port_offset))
VCELL_JMS_SIM_PORT_EXTERNAL=$((61616 + _site_port_offset))
VCELL_JMS_SIM_RESTPORT_EXTERNAL=$((8161 + _site_port_offset))
VCELL_MONGO_PORT_EXTERNAL=$((27017 + _site_port_offset))
VCELL_S3PROXY_PORT_EXTERNAL=$((8086 + _site_port_offset))
VCELL_HTC_NODELIST=
VCELL_BATCH_DOCKER_IMAGE="${VCELL_REPO_NAMESPACE}/vcell-batch:${VCELL_TAG}"
VCELL_BATCH_SINGULARITY_FILENAME="${VCELL_BATCH_DOCKER_IMAGE//[\/:]/_}.img"
VCELL_BATCH_SINGULARITY_IMAGE_EXTERNAL="${VCELL_ROOTDIR}/docker/singularity/${VCELL_BATCH_SINGULARITY_FILENAME}"
VCELL_OPT_DOCKER_IMAGE="${VCELL_REPO_NAMESPACE}/vcell-opt:${VCELL_TAG}"
VCELL_OPT_SINGULARITY_FILENAME="${VCELL_OPT_DOCKER_IMAGE//[\/:]/_}.img"
VCELL_OPT_SINGULARITY_IMAGE_EXTERNAL="${VCELL_ROOTDIR}/docker/singularity/${VCELL_OPT_SINGULARITY_FILENAME}"
VCELL_SMTP_HOSTNAME=vdsmtp.cam.uchc.edu
VCELL_SMTP_PORT=25
VCELL_SMTP_EMAILADDRESS=VCell_Support@uchc.edu
VCELL_EXPORT_BASEURL=http://vcell.org/export/
VCELL_EXPORTDIR_HOST=/Volumes/vcell/export/
VCELL_MAX_JOBS_PER_SCAN=100
VCELL_MAX_ODE_JOBS_PER_USER=100
VCELL_MAX_PDE_JOBS_PER_USER=40
VCELL_WEB_DATA_PORT=55556
VCELL_SSH_CMD_TIMEOUT=10000
VCELL_SSH_CMD_RESTORE_TIMEOUT=5

#
# write out the environment file to be for:
# 1. deployment actions (not applicable here because localconfig_mochslurm.sh is designed for local computation on a dev machine).
# 2. runtime environment for the docker stack run command
#
cat <<EOF >"$_outputfile"
VCELL_API_HOST_EXTERNAL=$VCELL_API_HOST_EXTERNAL
VCELL_API_PORT_EXTERNAL=$VCELL_API_PORT_EXTERNAL
VCELL_BATCH_DOCKER_IMAGE=$VCELL_BATCH_DOCKER_IMAGE
VCELL_BATCH_HOST=$VCELL_BATCH_HOST
VCELL_BATCH_SINGULARITY_FILENAME=$VCELL_BATCH_SINGULARITY_FILENAME
VCELL_BATCH_SINGULARITY_IMAGE_EXTERNAL=$VCELL_BATCH_SINGULARITY_IMAGE_EXTERNAL
VCELL_BATCH_USER=$(whoami)
VCELL_BIOFORMATS_JAR_FILE=vcell-bioformats-0.0.5-jar-with-dependencies.jar
VCELL_BIOFORMATS_JAR_URL=http://vcell.org/webstart/vcell-bioformats-0.0.5-jar-with-dependencies.jar
VCELL_BUILD_NUMBER=$VCELL_BUILD_NUMBER
VCELL_CLIENT_APPID=${_applicationId}
VCELL_DB_DRIVER=$VCELL_DB_DRIVER
VCELL_DB_URL=$VCELL_DB_URL
VCELL_DB_USER=$VCELL_DB_USER
VCELL_DEPLOY_SECRETS_DIR=${HOME}/vcellkeys
VCELL_EXPORT_BASEURL=$VCELL_EXPORT_BASEURL
VCELL_EXPORTDIR_HOST=$VCELL_EXPORTDIR_HOST
VCELL_HTC_NODELIST=$VCELL_HTC_NODELIST
VCELL_HTCLOGS_EXTERNAL=${VCELL_DEPLOY_ROOT_DIR}/htclogs
VCELL_HTCLOGS_HOST=${VCELL_DEPLOY_ROOT_DIR}/htclogs
VCELL_JMS_SIM_HOST_EXTERNAL=$VCELL_JMS_SIM_HOST_EXTERNAL
VCELL_JMS_SIM_PORT_EXTERNAL=$VCELL_JMS_SIM_PORT_EXTERNAL
VCELL_JMS_SIM_RESTPORT_EXTERNAL=$VCELL_JMS_SIM_RESTPORT_EXTERNAL
VCELL_MAX_JOBS_PER_SCAN=$VCELL_MAX_JOBS_PER_SCAN
VCELL_MAX_ODE_JOBS_PER_USER=$VCELL_MAX_ODE_JOBS_PER_USER
VCELL_MAX_PDE_JOBS_PER_USER=$VCELL_MAX_PDE_JOBS_PER_USER
VCELL_MONGO_HOST_EXTERNAL=$VCELL_MONGO_HOST_EXTERNAL
VCELL_MONGO_PORT_EXTERNAL=$VCELL_MONGO_PORT_EXTERNAL
VCELL_NATIVESOLVERDIR_EXTERNAL=${VCELL_DEPLOY_ROOT_DIR}/nativesolvers
VCELL_OPT_DOCKER_IMAGE=$VCELL_OPT_DOCKER_IMAGE
VCELL_OPT_SINGULARITY_FILENAME=$VCELL_OPT_SINGULARITY_FILENAME
VCELL_OPT_SINGULARITY_IMAGE_EXTERNAL=$VCELL_OPT_SINGULARITY_IMAGE_EXTERNAL
VCELL_REPO_NAMESPACE=$VCELL_REPO_NAMESPACE
VCELL_SECRETS_DIR=${HOME}/vcellkeys
VCELL_S3PROXY_PORT_EXTERNAL=$VCELL_S3PROXY_PORT_EXTERNAL
VCELL_S3_EXPORT_BASEURL=$VCELL_S3_EXPORT_BASEURL
VCELL_N5_DATADIR_HOST=/share/apps/vcell3/n5
VCELL_SIMDATADIR_EXTERNAL=${VCELL_DEPLOY_ROOT_DIR}/users
VCELL_SIMDATADIR_HOST=${VCELL_DEPLOY_ROOT_DIR}/users
VCELL_SIMDATADIR_SECONDARY_HOST=/Volumes/vcell/users
VCELL_SIMDATADIR_PARALLEL_EXTERNAL=${VCELL_DEPLOY_ROOT_DIR}/users
VCELL_SITE_CAMEL=${_site_camel}
VCELL_SITE=$VCELL_SITE
VCELL_SLURM_CENTRAL_SINGULARITY_DIR=$VCELL_SLURM_CENTRAL_SINGULARITY_DIR
VCELL_SLURM_CMD_SACCT=$VCELL_SLURM_CMD_SACCT
VCELL_SLURM_CMD_SBATCH=$VCELL_SLURM_CMD_SBATCH
VCELL_SLURM_CMD_SCANCEL=$VCELL_SLURM_CMD_SCANCEL
VCELL_SLURM_CMD_SQUEUE=$VCELL_SLURM_CMD_SQUEUE
VCELL_SLURM_LOCAL_SINGULARITY_DIR=$VCELL_SLURM_LOCAL_SINGULARITY_DIR
VCELL_SLURM_PARTITION=$VCELL_SLURM_PARTITION
VCELL_SLURM_TMPDIR=$VCELL_SLURM_TMPDIR
VCELL_SMTP_EMAILADDRESS=${VCELL_SMTP_EMAILADDRESS}
VCELL_SMTP_HOSTNAME=${VCELL_SMTP_HOSTNAME}
VCELL_SMTP_PORT=${VCELL_SMTP_PORT}
VCELL_SSH_CMD_RESTORE_TIMEOUT=$VCELL_SSH_CMD_RESTORE_TIMEOUT
VCELL_SSH_CMD_TIMEOUT=$VCELL_SSH_CMD_TIMEOUT
VCELL_SSL_IGNORE_CERT_PROBLEMS=false
VCELL_SSL_IGNORE_HOST_MISMATCH=true
VCELL_SUBMIT_SERVICE_HOST=submit
VCELL_TAG=$VCELL_TAG
VCELL_UPDATE_SITE=http://vcell.org/webstart/${_site_camel}
VCELL_VERSION_NUMBER=$VCELL_VERSION_NUMBER
VCELL_VERSION=${_site_camel}_Version_${VCELL_VERSION_NUMBER}_build_${VCELL_BUILD_NUMBER}
VCELL_WEB_DATA_PORT=$VCELL_WEB_DATA_PORT
EOF

