library(tidyverse)
library(readxl)
library(ggplot2)
library(scales)

data <- data.frame(
  mortality = c("nmr", "nmr", "nmr", "nmr", "pmr", "pmr", "pmr", "pmr", 
                "cmr", "cmr", "cmr", "cmr", "nmr", "nmr", "nmr", "nmr", 
                "nmr", "nmr", "pmr", "pmr", "pmr", "pmr", "pmr", "pmr", 
                "cmr", "cmr", "cmr", "cmr", "cmr", "cmr", "amr", "amr", 
                "amr", "amr", "amr", "amr", "amr", "amr", "amr", "amr"),
  variables = c("pm", "pm", "pm", "pm", "pm", "pm", "pm", "pm", 
                "pm", "pm", "pm", "pm", "fuel", "fuel", "kitchen", "kitchen", 
                "ventilation", "ventilation", "fuel", "fuel", "kitchen", "kitchen", 
                "ventilation", "ventilation", "fuel", "fuel", "kitchen", "kitchen", 
                "ventilation", "ventilation", "pm", "pm", "pm", "pm", 
                "fuel", "fuel", "kitchen", "kitchen", "ventilation", "ventilation"),
  categories = c("0-10", "10-25", "25-40", "40+", "0-10", "10-25", "25-40", "40+", 
                 "0-10", "10-25", "25-40", "40+", "f_clean", "f_unclean", "k_yes", "k_no", 
                 "v_has", "v_no", "f_clean", "f_unclean", "k_yes", "k_no", 
                 "v_has", "v_no", "f_clean", "f_unclean", "k_yes", "k_no", 
                 "v_has", "v_no", "0-10", "10-25", "25-40", "40+", 
                 "f_clean", "f_unclean", "k_yes", "k_no", "v_has", "v_no"),
  value = c(1.14, 1.91, 2.57, 3.02, 0.51, 0.79, 1.05, 1.11, 
            0.15, 0.23, 0.4, 0.38, 1.87, 3.02, 2.14, 3.33, 
            2.4, 3.35, 0.8, 1.14, 0.86, 1.22, 
            0.94, 1.21, 0.23, 0.42, 0.27, 0.45, 
            0.32, 0.39, 3.4, 3.16, 3.01, 3.47, 
            3.17, 3.34, 3.16, 3.53, 3.23, 3.39),
  ci_low = c(0.89, 1.8, 2.36, 2.86, 0.37, 0.72, 0.91, 1.02, 
             0.07, 0.19, 0.32, 0.33, 1.75, 2.89, 2.05, 3.14, 
             2.31, 3.01, 0.72, 1.07, 0.8, 1.11, 
             0.89, 1.02, 0.19, 0.38, 0.24, 0.38, 
             0.29, 0.3, 3.22, 3.11, 2.93, 3.41, 
             3.12, 3.29, 3.12, 3.45, 3.2, 3.26),
  ci_high = c(1.45, 2.03, 2.81, 3.18, 0.71, 0.86, 1.2, 1.21, 
              0.3, 0.27, 0.5, 0.44, 2, 3.15, 2.24, 3.54, 
              2.49, 3.73, 0.89, 1.23, 0.93, 1.34, 
              1, 1.43, 0.27, 0.47, 0.31, 0.52, 
              0.35, 0.52, 3.58, 3.21, 3.09, 3.53, 
              3.22, 3.39, 3.2, 3.6, 3.27, 3.53)
)



my_theme <- function() {
  theme_minimal() +
    theme(
      panel.background = element_rect(fill = "white"),
      panel.grid = element_blank()
    )
}

data$mortality <- factor(data$mortality, levels=c("nmr", "pmr", "cmr", "amr"))

# Renaming levels for the mortality factor
levels(data$mortality) <- c("Neonatal Death", "Post-Neonatal Death", "Child Death (1-4 years)", "Adult Death")

plot <- ggplot(data = data, aes(x=categories, y = value, fill=variables)) +
  geom_col(colour="black", position=position_dodge(0.5), width = 0.50) +
  scale_fill_manual(values = c("#00AFBB", "#E7B800", "#1D5D9B", "#0A192F"), 
                    labels = c("Level of PM2.5", "Have a separate kitchen", "Type of fuel", "Ventilation"), 
                    name="Variables") +
  my_theme() +
  facet_wrap(facet="mortality") +
  geom_errorbar(aes(ymin=ci_low, ymax=ci_high), position=position_dodge(0.5), width=.25) +
  scale_y_continuous(breaks=seq(0,4,by =1), limits = c(0,4), expand = c(0,0), 
                     name = "Death (%)") +
  scale_x_discrete(name="Categories")

plot




