# General information

This is a repository for assymmetric double barrier heterostructures that were simulated using the NEGF coupled with the heat equation described in [BESCOND:Phys. Rev. Applied:2020](https://doi.org/10.1103/PhysRevApplied.14.064022). An scheme of the potential profile of the device is shown in Fig. 1 

![img](Cooling_device.png)

**Fig.1:** Lb1, LQW, and Lb2, are the lengths of the first barrier (b1),  quantum well (QW), and the second barrier (b2), respectively. The height of the first barrier (hb1) is determined from the band offset between AlAs and the emitter, and the height of the second barrier (hb2) is proportional to  $\gamma$, which is the fraction of aluminium in the alloy. V is the bias between the Efe and the Efc, V=Efe-Efc. W1 is the energy interval between the Eo and Efe. The W2 is the energy interval between Eo and the Eb2.

- Relation between the csv columns and variables:



| Column  | Variable  |
| ------- | --------- |
| 1       | Lb1 [nm]  |
| 2       | LQW [nm]  |
| 3       | Lb2 [nm]  |
| 4       | $\gamma$  |
| 5       | V [V]     |
| 6       | CP [W/m²] |
| 7       | Te [K]    |
| 8       | W1 [eV]   |
| 9       | W2 [eV]   |
| 10-1525 | PP [eV]   |


These data was used to feed the machine learning workflow shared in [https://gitlab.citius.usc.es/modev/coolML](https://gitlab.citius.usc.es/modev/coolML).